/*
 * Decompiled with CFR 0.152.
 */
package io.github.jopenlibs.vault.response;

import io.github.jopenlibs.vault.api.Logical;
import io.github.jopenlibs.vault.api.pki.Credential;
import io.github.jopenlibs.vault.api.pki.RoleOptions;
import io.github.jopenlibs.vault.response.LogicalResponse;
import io.github.jopenlibs.vault.rest.RestResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class PkiResponse
extends LogicalResponse {
    private RoleOptions roleOptions = this.buildRoleOptionsFromData(this.getData());
    private Credential credential = this.buildCredentialFromData(this.getData());

    public PkiResponse(RestResponse restResponse, int retries) {
        super(restResponse, retries, Logical.logicalOperations.authentication);
    }

    public RoleOptions getRoleOptions() {
        return this.roleOptions;
    }

    public Credential getCredential() {
        return this.credential;
    }

    private RoleOptions buildRoleOptionsFromData(Map<String, String> data) {
        if (data == null) {
            return null;
        }
        String ttl = data.get("allow_any_name");
        String maxTtl = data.get("max_ttl");
        Boolean allowLocalhost = this.parseBoolean(data.get("allow_localhost"));
        List<String> allowedDomains = this.parseCsvToList(data.get("allow_domains"));
        Boolean allowBareDomains = this.parseBoolean(data.get("allow_bare_domains"));
        Boolean allowSubdomains = this.parseBoolean(data.get("allow_subdomains"));
        Boolean allowAnyName = this.parseBoolean(data.get("allow_any_name"));
        Boolean enforceHostnames = this.parseBoolean(data.get("enforce_hostnames"));
        Boolean allowIpSans = this.parseBoolean(data.get("allow_ip_sans"));
        Boolean serverFlag = this.parseBoolean(data.get("server_flag"));
        Boolean clientFlag = this.parseBoolean(data.get("client_flag"));
        Boolean codeSigningFlag = this.parseBoolean(data.get("code_signing_flag"));
        Boolean emailProtectionFlag = this.parseBoolean(data.get("email_protection_flag"));
        String keyType = data.get("key_type");
        Long keyBits = this.parseLong(data.get("key_bits"));
        Boolean useCsrCommonName = this.parseBoolean(data.get("use_csr_common_name"));
        if (ttl == null && maxTtl == null && allowLocalhost == null && allowedDomains == null && allowBareDomains == null && allowSubdomains == null && allowAnyName == null && enforceHostnames == null && allowIpSans == null && serverFlag == null && clientFlag == null && codeSigningFlag == null && emailProtectionFlag == null && keyType == null && keyBits == null && useCsrCommonName == null) {
            return null;
        }
        return new RoleOptions().ttl(ttl).maxTtl(maxTtl).allowLocalhost(allowLocalhost).allowedDomains(allowedDomains).allowBareDomains(allowBareDomains).allowSubdomains(allowSubdomains).allowAnyName(allowAnyName).enforceHostnames(enforceHostnames).allowIpSans(allowIpSans).serverFlag(serverFlag).clientFlag(clientFlag).codeSigningFlag(codeSigningFlag).emailProtectionFlag(emailProtectionFlag).keyType(keyType).keyBits(keyBits).useCsrCommonName(useCsrCommonName);
    }

    private Credential buildCredentialFromData(Map<String, String> data) {
        if (data == null) {
            return null;
        }
        String certificate = data.get("certificate");
        String issuingCa = data.get("issuing_ca");
        String privateKey = data.get("private_key");
        String privateKeyType = data.get("private_key_type");
        String serialNumber = data.get("serial_number");
        if (certificate == null && issuingCa == null && privateKey == null && privateKeyType == null && serialNumber == null) {
            return null;
        }
        return new Credential().certificate(certificate).issuingCa(issuingCa).privateKey(privateKey).privateKeyType(privateKeyType).serialNumber(serialNumber);
    }

    private Boolean parseBoolean(String input) {
        if (input == null) {
            return null;
        }
        return Boolean.parseBoolean(input);
    }

    private List<String> parseCsvToList(String input) {
        if (input == null) {
            return null;
        }
        ArrayList<String> returnValue = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(input, ",");
        while (tokenizer.hasMoreTokens()) {
            returnValue.add(tokenizer.nextToken());
        }
        return returnValue;
    }

    private Long parseLong(String input) {
        try {
            return Long.parseLong(input);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

