/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.jetty.initializer;

import io.confluent.common.security.jetty.CertificateAuthenticator;
import io.confluent.common.security.jetty.CertificateLoginService;
import io.confluent.rest.RestConfig;
import io.confluent.rest.auth.AuthUtil;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.security.ssl.SslPrincipalMapper;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.servlet.ServletContextHandler;

public class InstallCertificateSecurityHandler
implements Consumer<ServletContextHandler>,
Configurable {
    private SecurityHandlerConfig config;

    public void configure(Map<String, ?> originals) {
        this.config = new SecurityHandlerConfig(originals);
    }

    @Override
    public void accept(ServletContextHandler context) {
        context.setSecurityHandler((SecurityHandler)this.createSecurityHandler());
    }

    protected ConstraintSecurityHandler createSecurityHandler() {
        String realm = this.config.realm();
        ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
        securityHandler.addConstraintMapping(this.createGlobalAuthConstraint());
        securityHandler.setAuthenticator((Authenticator)this.createAuthenticator());
        securityHandler.setLoginService(this.createLoginService());
        securityHandler.setIdentityService(this.createIdentityService());
        securityHandler.setRealmName(realm);
        AuthUtil.createUnsecuredConstraints((RestConfig)this.config).forEach(arg_0 -> ((ConstraintSecurityHandler)securityHandler).addConstraintMapping(arg_0));
        return securityHandler;
    }

    protected ConstraintMapping createGlobalAuthConstraint() {
        return AuthUtil.createGlobalAuthConstraint((RestConfig)this.config);
    }

    protected LoginAuthenticator createAuthenticator() {
        return new CertificateAuthenticator();
    }

    protected LoginService createLoginService() {
        String rules = this.config.sslPrincipalMappingRules();
        SslPrincipalMapper principalMapper = SslPrincipalMapper.fromRules((String)rules);
        CertificateLoginService loginService = new CertificateLoginService();
        loginService.setSslPrincipalMapper(principalMapper);
        return loginService;
    }

    protected IdentityService createIdentityService() {
        return new DefaultIdentityService();
    }

    public static class SecurityHandlerConfig
    extends RestConfig {
        public static final String SSL_PRINCIPAL_MAPPING_RULES_PROP = "auth.ssl.principal.mapping.rules";
        public static final String SSL_PRINCIPAL_MAPPING_RULES_DEFAULT = "DEFAULT";
        public static final String SSL_PRINCIPAL_MAPPING_RULES_DOC = "Rules to execute the conversion from the certificate SN into principal name";
        private static final ConfigDef CONFIG = SecurityHandlerConfig.baseConfigDef().define("auth.ssl.principal.mapping.rules", ConfigDef.Type.STRING, (Object)"DEFAULT", ConfigDef.Importance.MEDIUM, "Rules to execute the conversion from the certificate SN into principal name");

        String sslPrincipalMappingRules() {
            return this.getString(SSL_PRINCIPAL_MAPPING_RULES_PROP);
        }

        String realm() {
            return this.getString("authentication.realm");
        }

        public SecurityHandlerConfig(Map<String, ?> originals) {
            super(CONFIG, originals);
        }
    }
}

