/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.parser;

import com.github.rvesse.airline.model.CommandGroupMetadata;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.GlobalMetadata;
import com.github.rvesse.airline.model.ParserMetadata;
import com.github.rvesse.airline.parser.ParseState;
import com.github.rvesse.airline.parser.ParserUtil;
import com.github.rvesse.airline.parser.errors.ParseException;
import com.github.rvesse.airline.utils.AirlineUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;

public class ParseResult<T> {
    private final ParseState<T> state;
    private final Collection<ParseException> errors;

    public ParseResult(ParseState<T> state, Collection<ParseException> errors) {
        if (state == null) {
            throw new NullPointerException("state cannot be null");
        }
        this.state = state;
        this.errors = errors != null ? Collections.unmodifiableCollection(errors) : Collections.emptyList();
    }

    public boolean wasSuccessful() {
        return this.errors.size() == 0;
    }

    public ParseState<T> getState() {
        return this.state;
    }

    public Collection<ParseException> getErrors() {
        return this.errors;
    }

    public T getCommand() {
        CommandMetadata command = this.state.getCommand();
        if (command == null) {
            return null;
        }
        HashMap<Class<?>, Object> bindings = new HashMap<Class, Object>();
        bindings.put(GlobalMetadata.class, this.state.getGlobal());
        if (this.state.getGroup() != null) {
            bindings.put(CommandGroupMetadata.class, this.state.getGroup());
        }
        if (this.state.getCommand() != null) {
            bindings.put(CommandMetadata.class, this.state.getCommand());
        }
        bindings.put(ParserMetadata.class, this.state.getParserConfiguration());
        bindings = AirlineUtils.unmodifiableMapCopy(bindings);
        if (this.state.getGlobal() != null) {
            return ParserUtil.createInstance(command.getType(), command.getAllOptions(), this.state.getParsedOptions(), command.getArguments(), this.state.getParsedArguments(), command.getMetadataInjections(), bindings, this.state.getParserConfiguration().getCommandFactory());
        }
        return ParserUtil.createInstance(command.getType(), command.getAllOptions(), this.state.getParsedOptions(), command.getArguments(), this.state.getParsedArguments(), command.getMetadataInjections(), bindings, this.state.getParserConfiguration().getCommandFactory());
    }
}

