/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.restrictions.options;

import com.github.rvesse.airline.help.sections.HelpFormat;
import com.github.rvesse.airline.help.sections.HelpHint;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.parser.ParseState;
import com.github.rvesse.airline.parser.errors.ParseOptionGroupException;
import com.github.rvesse.airline.restrictions.OptionRestriction;
import com.github.rvesse.airline.utils.predicates.parser.ParsedOptionFinder;
import com.github.rvesse.airline.utils.predicates.restrictions.MutuallyExclusiveWithFinder;
import com.github.rvesse.airline.utils.predicates.restrictions.MutuallyExclusiveWithOptionFinder;
import com.github.rvesse.airline.utils.predicates.restrictions.MutuallyExclusiveWithTagParsedOptionFinder;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;

public class MutuallyExclusiveRestriction
implements OptionRestriction,
HelpHint {
    private final String tag;

    public MutuallyExclusiveRestriction(String tag) {
        this.tag = tag;
    }

    @Override
    public <T> void finalValidate(ParseState<T> state, OptionMetadata option) {
        Collection parsedOptions = CollectionUtils.select(state.getParsedOptions(), (Predicate)new ParsedOptionFinder(option));
        Collection restrictions = CollectionUtils.select(option.getRestrictions(), (Predicate)new MutuallyExclusiveWithFinder(this.tag));
        for (OptionRestriction restriction : restrictions) {
            Collection otherParsedOptions = CollectionUtils.select(state.getParsedOptions(), (Predicate)new MutuallyExclusiveWithTagParsedOptionFinder(this.tag));
            if (otherParsedOptions.size() > 0 && otherParsedOptions.size() == parsedOptions.size() || parsedOptions.size() <= 0 || otherParsedOptions.size() <= parsedOptions.size()) continue;
            Collection<OptionMetadata> taggedOptions = this.getTaggedOptions(state);
            throw new ParseOptionGroupException("Only one of the following options may be specified but %d were found: %s", this.tag, taggedOptions, otherParsedOptions.size(), MutuallyExclusiveRestriction.toOptionsList(taggedOptions));
        }
    }

    private static String toOptionsList(Iterable<OptionMetadata> options) {
        StringBuilder builder = new StringBuilder();
        Iterator<OptionMetadata> ops = options.iterator();
        while (ops.hasNext()) {
            OptionMetadata option = ops.next();
            Iterator<String> names = option.getOptions().iterator();
            while (names.hasNext()) {
                builder.append(names.next());
                if (!names.hasNext() && !ops.hasNext()) continue;
                builder.append(", ");
            }
        }
        return builder.toString();
    }

    private <T> Collection<OptionMetadata> getTaggedOptions(ParseState<T> state) {
        List<OptionMetadata> options;
        List<OptionMetadata> list = options = state.getCommand() != null ? state.getCommand().getAllOptions() : null;
        if (options == null) {
            List<OptionMetadata> list2 = options = state.getGroup() != null ? state.getGroup().getOptions() : null;
        }
        if (options == null) {
            options = state.getGlobal() != null ? state.getGlobal().getOptions() : Collections.emptyList();
        }
        return CollectionUtils.select(options, (Predicate)new MutuallyExclusiveWithOptionFinder(this.tag));
    }

    public String getTag() {
        return this.tag;
    }

    @Override
    public String getPreamble() {
        return null;
    }

    @Override
    public HelpFormat getFormat() {
        return HelpFormat.PROSE;
    }

    @Override
    public int numContentBlocks() {
        return 1;
    }

    @Override
    public String[] getContentBlock(int blockNumber) {
        if (blockNumber != 0) {
            throw new IndexOutOfBoundsException();
        }
        return new String[]{String.format("This option is part of the group '%s' from which only one option may be specified", this.tag)};
    }

    @Override
    public <T> void preValidate(ParseState<T> state, OptionMetadata option, String value) {
    }

    @Override
    public <T> void postValidate(ParseState<T> state, OptionMetadata option, Object value) {
    }
}

