/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.security;

import io.confluent.common.security.auth.AuthenticationCleanupFilter;
import io.confluent.common.security.auth.AuthenticationFilter;
import io.confluent.common.security.license.LicenseValidatorFilter;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.rest.extensions.SchemaRegistryResourceExtension;
import io.confluent.kafka.schemaregistry.security.authorizer.AuthorizerException;
import io.confluent.kafka.schemaregistry.security.config.SecureSchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.security.filter.AuthorizationFilter;
import io.confluent.kafka.schemaregistry.security.permissions.PermissionsResource;
import io.confluent.kafka.schemaregistry.security.permissions.ScopeResource;
import io.confluent.kafka.schemaregistry.storage.KafkaStore;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import io.confluent.rest.RestConfigException;
import io.confluent.security.authorizer.Scope;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.ws.rs.core.Configurable;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.common.security.ssl.SslPrincipalMapper;

public class SchemaRegistrySecurityResourceExtension
implements SchemaRegistryResourceExtension {
    public static final String SCHEMA_REGISTRY_CLUSTER_TYPE = "schema-registry-cluster";
    private static final long CLUSTER_ID_TIMEOUT_MS = 10000L;
    private AuthorizationFilter authorizationFilter;

    public void register(Configurable<?> configurable, SchemaRegistryConfig schemaRegistryConfig, SchemaRegistry kafkaSchemaRegistry) throws SchemaRegistryException {
        Scope scope;
        SecureSchemaRegistryConfig confluentSecureSchemaRegistryConfig;
        try {
            confluentSecureSchemaRegistryConfig = new SecureSchemaRegistryConfig(schemaRegistryConfig.originalProperties());
        }
        catch (RestConfigException e) {
            throw new SchemaRegistryException((Throwable)e);
        }
        try {
            scope = SchemaRegistrySecurityResourceExtension.determineScope(kafkaSchemaRegistry);
        }
        catch (AuthorizerException e) {
            throw new SchemaRegistryException("Failed to determine RBAC scope", (Throwable)e);
        }
        this.registerResources(configurable, confluentSecureSchemaRegistryConfig, kafkaSchemaRegistry, scope);
    }

    public void close() {
        this.authorizationFilter.shutdown();
    }

    void registerResources(Configurable<?> configurable, SecureSchemaRegistryConfig confluentSecureSchemaRegistryConfig, SchemaRegistry kafkaSchemaRegistry, Scope scope) {
        String restAuthTypeConfig = confluentSecureSchemaRegistryConfig.getString("confluent.schema.registry.auth.mechanism");
        String sslMappingRules = confluentSecureSchemaRegistryConfig.getString("confluent.schema.registry.auth.ssl.principal.mapping.rules");
        Optional<Object> sslPrincipalMapperOpt = Optional.empty();
        if (sslMappingRules != null) {
            sslPrincipalMapperOpt = Optional.of(SslPrincipalMapper.fromRules((String)sslMappingRules));
        }
        configurable.register(AuthenticationCleanupFilter.class);
        configurable.register((Object)new AuthenticationFilter(restAuthTypeConfig, sslPrincipalMapperOpt, confluentSecureSchemaRegistryConfig.getBoolean("confluent.schema.registry.anonymous.principal").booleanValue()));
        this.authorizationFilter = new AuthorizationFilter(confluentSecureSchemaRegistryConfig, kafkaSchemaRegistry);
        configurable.register((Object)this.authorizationFilter);
        Map<String, Object> producerProps = confluentSecureSchemaRegistryConfig.licenseProducerConfigs();
        Map<String, Object> consumerProps = confluentSecureSchemaRegistryConfig.licenseConsumerConfigs();
        Map<String, Object> adminProps = confluentSecureSchemaRegistryConfig.licenseAdminConfigs();
        configurable.register((Object)new LicenseValidatorFilter(confluentSecureSchemaRegistryConfig.licenseTopic(), producerProps, consumerProps, adminProps, confluentSecureSchemaRegistryConfig.licenseString()));
        configurable.register((Object)new PermissionsResource(scope, kafkaSchemaRegistry, this.authorizationFilter.authorizer()));
        configurable.register((Object)new ScopeResource(scope));
    }

    public static Scope determineScope(SchemaRegistry schemaRegistry) throws AuthorizerException {
        String kafkaClusterId;
        SchemaRegistryConfig config = schemaRegistry.config();
        Properties adminClientProps = new Properties();
        KafkaStore.addSchemaRegistryConfigsToClientProperties((SchemaRegistryConfig)config, (Properties)adminClientProps);
        adminClientProps.put("bootstrap.servers", config.bootstrapBrokers());
        try (AdminClient adminClient = AdminClient.create((Properties)adminClientProps);){
            kafkaClusterId = (String)adminClient.describeCluster().clusterId().get(10000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new AuthorizerException("Failed to determine Kafka cluster ID", e);
        }
        String schemaRegistryGroupId = config.getString("schema.registry.group.id");
        return new Scope.Builder(new String[0]).withKafkaCluster(kafkaClusterId).withCluster(SCHEMA_REGISTRY_CLUSTER_TYPE, schemaRegistryGroupId).build();
    }
}

