/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.security.authorizer;

import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.security.authorizer.AuthorizeRequest;
import io.confluent.kafka.schemaregistry.security.authorizer.AuthorizerException;
import io.confluent.kafka.schemaregistry.security.authorizer.SchemaNotFoundAuthorizerException;
import io.confluent.kafka.schemaregistry.security.authorizer.SchemaRegistryAuthorizer;
import io.confluent.kafka.schemaregistry.security.authorizer.SchemaRegistryResourceOperation;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import io.confluent.kafka.schemaregistry.utils.QualifiedSubject;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSchemaRegistryAuthorizer
implements SchemaRegistryAuthorizer {
    private static final Logger log = LoggerFactory.getLogger(AbstractSchemaRegistryAuthorizer.class);
    private SchemaRegistry schemaRegistry;

    @Override
    public void configure(SchemaRegistryConfig config, SchemaRegistry schemaRegistry) throws AuthorizerException {
        this.schemaRegistry = schemaRegistry;
    }

    protected SchemaRegistry schemaRegistry() {
        return this.schemaRegistry;
    }

    @Override
    public final boolean authorize(AuthorizeRequest authorizeRequest) throws AuthorizerException {
        SchemaRegistryResourceOperation schemaRegistryResourceOperation = authorizeRequest.getSchemaRegistryResourceOperation();
        Principal principal = authorizeRequest.getUser();
        String user = principal.getName();
        if (SchemaRegistryResourceOperation.SCHEMA_READ.equals((Object)schemaRegistryResourceOperation)) {
            String subject = authorizeRequest.getResourceName();
            boolean result = this.authorizeSchemaIdLookup(principal, authorizeRequest);
            log.debug("Authorization of schema ID lookup {} for user {} and subject {}", new Object[]{result ? "SUCCESSFUL" : "FAILED", user != null ? user : "N/A", subject != null ? subject : "N/A"});
            return result;
        }
        if (SchemaRegistryResourceOperation.SUBJECT_RESOURCE_OPERATIONS.contains((Object)schemaRegistryResourceOperation)) {
            String subject = authorizeRequest.getResourceName();
            return this.authorizeSubjectOperation(user, subject, schemaRegistryResourceOperation, authorizeRequest);
        }
        if (SchemaRegistryResourceOperation.KEK_RESOURCE_OPERATIONS.contains((Object)schemaRegistryResourceOperation)) {
            String kekName = authorizeRequest.getResourceName();
            return this.authorizeKekOperation(user, kekName, schemaRegistryResourceOperation, authorizeRequest);
        }
        if (SchemaRegistryResourceOperation.GLOBAL_RESOURCE_OPERATIONS.contains((Object)schemaRegistryResourceOperation)) {
            return this.authorizeGlobalOperation(user, schemaRegistryResourceOperation, authorizeRequest);
        }
        if (SchemaRegistryResourceOperation.EXPORTER_ACCESS.equals((Object)schemaRegistryResourceOperation)) {
            return this.authorizeExporterOperation(principal, authorizeRequest);
        }
        return false;
    }

    @Override
    public void shutdown() {
    }

    public abstract boolean authorizeGlobalOperation(String var1, SchemaRegistryResourceOperation var2, AuthorizeRequest var3);

    public abstract boolean authorizeSubjectOperation(String var1, String var2, SchemaRegistryResourceOperation var3, AuthorizeRequest var4);

    public abstract boolean authorizeKekOperation(String var1, String var2, SchemaRegistryResourceOperation var3, AuthorizeRequest var4);

    private final boolean authorizeExporterOperation(Principal principal, AuthorizeRequest authorizeRequest) throws AuthorizerException {
        ArrayList<AuthorizeRequest> requests = new ArrayList<AuthorizeRequest>();
        for (SchemaRegistryResourceOperation operation : SchemaRegistryResourceOperation.SUBJECT_RESOURCE_OPERATIONS) {
            requests.add(new AuthorizeRequest(authorizeRequest.getUser(), "*", operation, authorizeRequest.getContainerRequestContext(), authorizeRequest.getHttpServletRequest()));
        }
        return this.bulkAuthorize(principal, requests).stream().allMatch(b -> b);
    }

    public final boolean authorizeSchemaIdLookup(Principal principal, AuthorizeRequest authorizeRequest) throws AuthorizerException {
        Set subjects;
        UriInfo uriInfo = authorizeRequest.getContainerRequestContext().getUriInfo();
        if ("schemas/types".equals(uriInfo.getPath())) {
            return true;
        }
        String schemaId = (String)uriInfo.getPathParameters().getFirst((Object)"id");
        String subjectParam = (String)uriInfo.getQueryParameters().getFirst((Object)"subject");
        try {
            subjects = this.schemaRegistry.listSubjectsForId(Integer.parseInt(schemaId), subjectParam, true);
            if (subjects == null || subjects.isEmpty()) {
                throw new SchemaNotFoundAuthorizerException("schema subject not found for id=" + schemaId);
            }
        }
        catch (SchemaRegistryException | NumberFormatException e) {
            log.warn("Failed to lookup up schemaId {} under subject {}", (Object)schemaId, (Object)subjectParam);
            return false;
        }
        List<AuthorizeRequest> authorizeRequests = subjects.stream().flatMap(subject -> this.subjectReadRequest((String)subject, authorizeRequest)).collect(Collectors.toList());
        return this.bulkAuthorize(principal, authorizeRequests).stream().anyMatch(b -> b);
    }

    public String getAuthorizationSubject(String subject) {
        return subject;
    }

    protected Stream<AuthorizeRequest> subjectReadRequest(String subject, AuthorizeRequest original) {
        ArrayList<AuthorizeRequest> requests = new ArrayList<AuthorizeRequest>();
        requests.add(new AuthorizeRequest(original.getUser(), subject, SchemaRegistryResourceOperation.SUBJECT_READ, original.getContainerRequestContext(), original.getHttpServletRequest()));
        QualifiedSubject qs = QualifiedSubject.create((String)this.schemaRegistry().tenant(), (String)subject);
        String context = qs.getContext();
        if (!".".equals(context)) {
            String normalizedContext = QualifiedSubject.normalizeContext((String)context);
            requests.add(new AuthorizeRequest(original.getUser(), normalizedContext, SchemaRegistryResourceOperation.SUBJECT_READ, original.getContainerRequestContext(), original.getHttpServletRequest()));
        }
        return requests.stream();
    }
}

