/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.security.authorizer.rbac;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.security.auth.client.provider.BasicAuthCredentialProvider;
import io.confluent.security.auth.client.provider.HttpBasicCredentialProvider;
import io.confluent.security.auth.client.provider.HttpBearerCredentialProvider;
import io.confluent.security.auth.client.provider.HttpCredentialProvider;
import io.confluent.security.auth.client.rest.RestClient;
import io.confluent.security.authorizer.utils.ThreadUtils;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import joptsimple.internal.Strings;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MdsBasicAuthProvider
implements BasicAuthCredentialProvider {
    private static final Logger log = LoggerFactory.getLogger(MdsBasicAuthProvider.class);
    private static final double TOKEN_REFRESH_RATE = 0.8;
    private static final long FAILED_TOKEN_REFRESH_RETRY_DELAY_MS = 10000L;
    private RestClient restClient;
    private HttpCredentialProvider httpBasicCredentialProvider;
    private ScheduledExecutorService tokenRefreshScheduler;
    private OAuthBearerToken currentToken;
    private HttpCredentialProvider httpBearerCredentialProvider;
    private boolean tokenRefreshFailed;

    public MdsBasicAuthProvider() {
    }

    public MdsBasicAuthProvider(RestClient restClient) {
        this.restClient = restClient;
    }

    public void configure(Map<String, ?> configs) {
        if (this.restClient == null) {
            this.restClient = new RestClient(configs);
        }
        this.httpBasicCredentialProvider = new HttpBasicCredentialProvider();
        this.httpBasicCredentialProvider.configure(configs);
        this.httpBearerCredentialProvider = new HttpBearerCredentialProvider();
        this.tokenRefreshScheduler = Executors.newSingleThreadScheduledExecutor(ThreadUtils.createThreadFactory((String)"token-refresher", (boolean)true));
        this.scheduleNextTokenRefresh();
    }

    public void close() {
        if (this.tokenRefreshScheduler != null) {
            this.tokenRefreshScheduler.shutdown();
        }
        if (this.restClient != null) {
            this.restClient.close();
        }
    }

    public HttpCredentialProvider getCredentialProvider() {
        if (!Strings.isNullOrEmpty((String)this.httpBearerCredentialProvider.getCredentials()) && System.currentTimeMillis() < this.currentToken.lifetimeMs()) {
            return this.httpBearerCredentialProvider;
        }
        log.warn("Token is invalid. Falling back to Basic credential provider.");
        return this.httpBasicCredentialProvider;
    }

    private void refreshToken() {
        try {
            this.currentToken = this.restClient.login();
            this.httpBearerCredentialProvider.configure(Collections.singletonMap("confluent.metadata.token.auth.credential", this.currentToken.value()));
            this.tokenRefreshFailed = false;
        }
        catch (Throwable t) {
            log.error("Failed to refresh token.", t);
            this.tokenRefreshFailed = true;
        }
    }

    private void scheduleNextTokenRefresh() {
        long refreshDelay = this.getTokenRefreshDelay();
        this.tokenRefreshScheduler.schedule(() -> {
            this.refreshToken();
            this.scheduleNextTokenRefresh();
        }, refreshDelay, TimeUnit.MILLISECONDS);
    }

    private long getTokenRefreshDelay() {
        if (this.tokenRefreshFailed) {
            return 10000L;
        }
        if (this.currentToken == null) {
            return 0L;
        }
        long nextRefreshTimeMs = this.currentToken.startTimeMs() + (long)((double)(this.currentToken.lifetimeMs() - this.currentToken.startTimeMs()) * 0.8);
        log.info("[Principal={}]: MDS auth token valid from {} to {}", new Object[]{this.currentToken.principalName(), new Date(this.currentToken.startTimeMs()), new Date(this.currentToken.lifetimeMs())});
        log.info("[Principal={}]: MDS auth token re-login sleeping until: {}", (Object)this.currentToken.principalName(), (Object)new Date(nextRefreshTimeMs));
        return nextRefreshTimeMs - this.currentToken.startTimeMs();
    }

    @VisibleForTesting
    String getBearerToken() {
        return this.httpBearerCredentialProvider.getCredentials();
    }

    public String providerName() {
        return "SR_MDS";
    }

    public String getUserInfo() {
        return this.httpBasicCredentialProvider.getCredentials();
    }
}

