/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.security.authorizer.schemaregistryacl;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.confluent.kafka.schemaregistry.security.authorizer.SchemaRegistryResourceOperation;
import io.confluent.kafka.schemaregistry.security.authorizer.schemaregistryacl.SchemaRegistryAclValue;
import io.confluent.kafka.schemaregistry.security.authorizer.schemaregistryacl.ValidSchemaRegistryOperation;
import java.util.Collections;
import java.util.Set;

@JsonPropertyOrder(value={"magic", "principal", "allowedoperations"})
public class GlobalAclValue
extends SchemaRegistryAclValue {
    private static final int MAGIC_BYTE = 0;
    @ValidSchemaRegistryOperation(value=ValidSchemaRegistryOperation.SchemaRegistryOperationType.GLOBAL)
    private Set<SchemaRegistryResourceOperation> authorizedOperations;

    public GlobalAclValue(@JsonProperty(value="principal") String principal, @JsonProperty(value="allowedoperations") Set<SchemaRegistryResourceOperation> authorizedOperations) {
        super(0, principal);
        this.authorizedOperations = Collections.unmodifiableSet(authorizedOperations);
    }

    @JsonProperty(value="allowedoperations")
    public Set<SchemaRegistryResourceOperation> getAuthorizedOperations() {
        return this.authorizedOperations;
    }

    @JsonProperty(value="allowedoperations")
    public void setAuthorizedOperations(Set<SchemaRegistryResourceOperation> authorizedOperations) {
        this.authorizedOperations = Collections.unmodifiableSet(authorizedOperations);
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        GlobalAclValue that = (GlobalAclValue)o;
        return this.authorizedOperations.equals(that.authorizedOperations);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.authorizedOperations.hashCode();
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{magic=" + this.magicByte + ",");
        sb.append("principal=" + this.principal + ",");
        sb.append("allowedoperations=" + this.authorizedOperations + "}");
        return sb.toString();
    }
}

