/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.security.authorizer.schemaregistryacl;

import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.security.authorizer.schemaregistryacl.AclMessageSerializer;
import io.confluent.kafka.schemaregistry.security.authorizer.schemaregistryacl.NoopKey;
import io.confluent.kafka.schemaregistry.storage.KafkaStore;
import io.confluent.kafka.schemaregistry.storage.exceptions.SerializationException;
import io.confluent.kafka.schemaregistry.storage.exceptions.StoreException;
import io.confluent.kafka.schemaregistry.storage.exceptions.StoreInitializationException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaRegistryAclAuthorizerUtils {
    private static final Logger log = LoggerFactory.getLogger(SchemaRegistryAclAuthorizerUtils.class);
    private final NoopKey noopKey;
    private final SchemaRegistryConfig config;
    private final String topic;
    private final int initTimeout;
    private final String bootStrapBrokers;
    private final AclMessageSerializer aclMessageSerializer;
    private final KafkaProducer producer;

    public SchemaRegistryAclAuthorizerUtils(SchemaRegistryConfig config, String topic, int initTimeout, String bootStrapBrokers, AclMessageSerializer aclMessageSerializer, NoopKey noopKey) {
        this.config = config;
        this.topic = topic;
        this.initTimeout = initTimeout;
        this.bootStrapBrokers = bootStrapBrokers;
        this.aclMessageSerializer = aclMessageSerializer;
        this.noopKey = noopKey;
        Properties props = new Properties();
        KafkaStore.addSchemaRegistryConfigsToClientProperties((SchemaRegistryConfig)config, (Properties)props);
        props.put("bootstrap.servers", bootStrapBrokers);
        props.put("acks", "-1");
        props.put("key.serializer", ByteArraySerializer.class);
        props.put("value.serializer", ByteArraySerializer.class);
        props.put("retries", (Object)0);
        props.put("enable.idempotence", (Object)false);
        props.put("security.protocol", config.getString("kafkastore.security.protocol"));
        this.producer = new KafkaProducer(props);
    }

    public long getLatestOffset(int timeoutMs) throws StoreException {
        ProducerRecord producerRecord;
        try {
            producerRecord = new ProducerRecord(this.topic, Integer.valueOf(0), (Object)this.aclMessageSerializer.serializeSchemaRegistryAclKey(this.noopKey), null);
        }
        catch (SerializationException e) {
            throw new StoreException("Failed to serialize noop key.", (Throwable)e);
        }
        try {
            log.trace("Sending Noop record to schema registry ACL topic to find last offset.");
            Future ack = this.producer.send(producerRecord);
            RecordMetadata metadata = (RecordMetadata)ack.get(timeoutMs, TimeUnit.MILLISECONDS);
            log.trace("Noop record's offset is " + metadata.offset());
            return metadata.offset();
        }
        catch (Exception e) {
            throw new StoreException("Failed to write Noop record to schema registry ACL topic.", (Throwable)e);
        }
    }

    public void createOrVerifySchemaTopic() throws StoreInitializationException {
        int desiredReplicationFactor = this.config.getInt("kafkastore.topic.replication.factor");
        Properties props = new Properties();
        KafkaStore.addSchemaRegistryConfigsToClientProperties((SchemaRegistryConfig)this.config, (Properties)props);
        props.put("bootstrap.servers", this.bootStrapBrokers);
        props.put("security.protocol", this.config.getString("kafkastore.security.protocol"));
        try (AdminClient admin = AdminClient.create((Properties)props);){
            Set allTopics = (Set)admin.listTopics().names().get((long)this.initTimeout, TimeUnit.MILLISECONDS);
            if (allTopics.contains(this.topic)) {
                this.verifySchemaTopic(admin, this.topic, this.initTimeout, desiredReplicationFactor);
            } else {
                this.createSchemaTopic(admin, this.topic, this.initTimeout, desiredReplicationFactor);
            }
        }
        catch (TimeoutException e) {
            throw new StoreInitializationException("Timed out trying to create or validate schema topic configuration", (Throwable)e);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new StoreInitializationException("Failed trying to create or validate schema topic configuration", (Throwable)e);
        }
    }

    private void createSchemaTopic(AdminClient admin, String topic, int initTimeout, int desiredReplicationFactor) throws StoreInitializationException, InterruptedException, ExecutionException, TimeoutException {
        block4: {
            log.info("Creating schemas topic {}", (Object)topic);
            int numLiveBrokers = ((Collection)admin.describeCluster().nodes().get((long)initTimeout, TimeUnit.MILLISECONDS)).size();
            if (numLiveBrokers <= 0) {
                throw new StoreInitializationException("No live Kafka brokers");
            }
            int schemaTopicReplicationFactor = Math.min(numLiveBrokers, desiredReplicationFactor);
            if (schemaTopicReplicationFactor < desiredReplicationFactor) {
                log.warn("Creating the schema topic " + topic + " using a replication factor of " + schemaTopicReplicationFactor + ", which is less than the desired one of " + desiredReplicationFactor + ". If this is a production environment, it's crucial to add more brokers and increase the replication factor of the topic.");
            }
            NewTopic schemaTopicRequest = new NewTopic(topic, 1, (short)schemaTopicReplicationFactor);
            schemaTopicRequest.configs(Collections.singletonMap("cleanup.policy", "compact"));
            try {
                admin.createTopics(Collections.singleton(schemaTopicRequest)).all().get((long)initTimeout, TimeUnit.MILLISECONDS);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof TopicExistsException) break block4;
                throw e;
            }
        }
    }

    private void verifySchemaTopic(AdminClient admin, String topic, int initTimeout, int desiredReplicationFactor) throws StoreInitializationException, InterruptedException, ExecutionException, TimeoutException {
        ConfigResource topicResource;
        Map configs;
        Config topicConfigs;
        String retentionPolicy;
        log.info("Validating ACL topic {}", (Object)topic);
        Set<String> topics = Collections.singleton(topic);
        Map topicDescription = (Map)admin.describeTopics(topics).all().get((long)initTimeout, TimeUnit.MILLISECONDS);
        TopicDescription description = (TopicDescription)topicDescription.get(topic);
        int numPartitions = description.partitions().size();
        if (numPartitions != 1) {
            throw new StoreInitializationException("The schema topic " + topic + " should have only 1 partition but has " + numPartitions);
        }
        if (((TopicPartitionInfo)description.partitions().get(0)).replicas().size() < desiredReplicationFactor) {
            log.warn("The replication factor of the ACL topic " + topic + " is less than the desired one of " + desiredReplicationFactor + ". If this is a production environment, it's crucial to add more brokers and increase the replication factor of the topic.");
        }
        if ((retentionPolicy = (topicConfigs = (Config)(configs = (Map)admin.describeConfigs(Collections.singleton(topicResource = new ConfigResource(ConfigResource.Type.TOPIC, topic))).all().get((long)initTimeout, TimeUnit.MILLISECONDS)).get(topicResource)).get("cleanup.policy").value()) == null || !"compact".equals(retentionPolicy)) {
            log.error("The retention policy of the ACL topic " + topic + " is incorrect. You must configure the topic to 'compact' cleanup policy to avoid Kafka deleting your ACL after a week. Refer to Kafka documentation for more details on cleanup policies");
            throw new StoreInitializationException("The retention policy of the ACL topic " + topic + " is incorrect. Expected cleanup.policy to be 'compact' but it is " + retentionPolicy);
        }
    }

    public void shutdown() {
        this.producer.close();
    }
}

