/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.security.authorizer.schemaregistryacl;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import javax.validation.constraints.Min;
import org.hibernate.validator.constraints.NotEmpty;

@JsonPropertyOrder(value={"keytype", "magic"})
public abstract class SchemaRegistryAclKey {
    @Min(value=0L)
    protected @Min(value=0L) int magicByte;
    @NotEmpty
    protected SchemaRegistryAclKeyType keyType;

    public SchemaRegistryAclKey(SchemaRegistryAclKeyType keyType, int magicByte) {
        this.keyType = keyType;
        this.magicByte = magicByte;
    }

    @JsonProperty(value="magic")
    public int getMagicByte() {
        return this.magicByte;
    }

    @JsonProperty(value="magic")
    public void setMagicByte(int magicByte) {
        this.magicByte = magicByte;
    }

    @JsonProperty(value="keytype")
    public SchemaRegistryAclKeyType getKeyType() {
        return this.keyType;
    }

    @JsonProperty(value="keytype")
    public void setKeyType(SchemaRegistryAclKeyType keyType) {
        this.keyType = keyType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaRegistryAclKey that = (SchemaRegistryAclKey)o;
        if (this.magicByte != that.magicByte) {
            return false;
        }
        return this.keyType.equals((Object)that.keyType);
    }

    public int hashCode() {
        int result = 31 * this.magicByte;
        result = 31 * result + this.keyType.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{magic=" + this.magicByte + ",");
        sb.append("keytype=" + (Object)((Object)this.keyType) + "}");
        return sb.toString();
    }

    public static enum SchemaRegistryAclKeyType {
        NOOP,
        SUBJECT_ACL,
        GLOBAL_ACL;

    }
}

