/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.mqtt;

import io.confluent.mqtt.AbstractBaseConfig;
import io.confluent.mqtt.network.NetworkConfig;
import io.confluent.mqtt.protocol.ProtocolConfig;
import io.confluent.mqtt.stream.StreamConfig;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;

public class MqttConfig
extends AbstractBaseConfig
implements NetworkConfig,
StreamConfig,
ProtocolConfig {
    public static final String KAFKA_MQTT_NAME = "Kafka-MQTT";
    public static final String CONFLUENT_LICENSE_CONFIG = "confluent.license";
    public static final String CONFLUENT_LICENSE_DISPLAY = "License";
    public static final String CONFLUENT_LICENSE_DEFAULT = "";
    public static final String CONFLUENT_LICENSE_DOC = "Confluent will issue a license key to each subscriber. The license key will be a short snippet of text that you can copy and paste. Without the license key, you can use Kafka-MQTT for a 30-day trial period. If you are a subscriber, please contact Confluent Support for more information.";
    public static final String CONFLUENT_TOPIC_CONFIG = "confluent.topic";
    public static final String CONFLUENT_TOPIC_DISPLAY = "Confluent Topic";
    public static final String CONFLUENT_TOPIC_DEFAULT = "_confluent-command";
    public static final String CONFLUENT_TOPIC_DOC = "Name of the Kafka topic used for Confluent Platform configuration, including licensing information.";
    public static final String CONFLUENT_TOPIC_PREFIX = "confluent.topic.";
    public static final String CONFLUENT_TOPIC_PRODUCER_PREFIX = "confluent.topic.producer.";
    public static final String CONFLUENT_TOPIC_CONSUMER_PREFIX = "confluent.topic.consumer.";
    public static final String CONFLUENT_TOPIC_BOOTSTRAP_SERVERS_CONFIG = "confluent.topic.bootstrap.servers";
    public static final String CONFLUENT_TOPIC_BOOTSTRAP_SERVERS_DISPLAY = "Confluent Topic Servers";
    public static final String CONFLUENT_TOPIC_BOOTSTRAP_SERVERS_DOC = "A list of host/port pairs to use for establishing the initial connection to the Kafka cluster used for licensing. All servers in the cluster will be discovered from the initial connection. This list should be in the form <code>host1:port1,host2:port2,...</code>. Since these servers are just used for the initial connection to discover the full cluster membership (which may change dynamically), this list need not contain the full set of servers (you may want more than one, though, in case a server is down).";
    public static final String CONFLUENT_TOPIC_REPLICATION_FACTOR_CONFIG = "confluent.topic.replication.factor";
    public static final String CONFLUENT_TOPIC_REPLICATION_FACTOR_DISPLAY = "Confluent Topic Replication Factor";
    public static final int CONFLUENT_TOPIC_REPLICATION_FACTOR_DEFAULT = 3;
    public static final String CONFLUENT_TOPIC_REPLICATION_FACTOR_DOC = "The replication factor for the Kafka topic used for Confluent Platform configuration, including licensing information. This is used only if the topic does not already exist, and the default of 3 is appropriate for production use. If you are using a development environment with less than 3 brokers, you must set this to the number of brokers (often 1).";

    public MqttConfig(Map<String, String> props) {
        this.init(this.newConfigDef(), MqttConfig.withDefaultProperties(props));
    }

    public ConfigDef newConfigDef() {
        ConfigDef configDef = this.assembleNetworkConfig(null);
        configDef = this.assembleProtocolConfig(configDef);
        configDef = this.assembleStreamConfig(configDef);
        configDef = this.assembleSecurityConfig(configDef);
        return configDef;
    }

    public static ConfigDef getConfig() {
        ConfigDef configDef = NetworkConfig.networkConfig(null);
        configDef = ProtocolConfig.protocolConfig(configDef);
        configDef = StreamConfig.streamConfig(configDef);
        configDef = MqttConfig.securityConfig(configDef);
        return configDef;
    }

    public ConfigDef assembleSecurityConfig(ConfigDef configDef) {
        return MqttConfig.securityConfig(configDef);
    }

    static ConfigDef securityConfig(ConfigDef configDef) {
        String group = CONFLUENT_LICENSE_DISPLAY;
        int orderInGroup = 0;
        configDef.define(CONFLUENT_LICENSE_CONFIG, ConfigDef.Type.PASSWORD, (Object)CONFLUENT_LICENSE_DEFAULT, ConfigDef.Importance.HIGH, CONFLUENT_LICENSE_DOC, CONFLUENT_LICENSE_DISPLAY, ++orderInGroup, ConfigDef.Width.NONE, CONFLUENT_LICENSE_DISPLAY);
        configDef.define(CONFLUENT_TOPIC_BOOTSTRAP_SERVERS_CONFIG, ConfigDef.Type.LIST, (Object)"The value of bootstrap.servers property", ConfigDef.Importance.HIGH, CONFLUENT_TOPIC_BOOTSTRAP_SERVERS_DOC, CONFLUENT_LICENSE_DISPLAY, ++orderInGroup, ConfigDef.Width.LONG, CONFLUENT_TOPIC_BOOTSTRAP_SERVERS_DISPLAY);
        configDef.define(CONFLUENT_TOPIC_CONFIG, ConfigDef.Type.STRING, (Object)CONFLUENT_TOPIC_DEFAULT, ConfigDef.Importance.LOW, CONFLUENT_TOPIC_DOC, CONFLUENT_LICENSE_DISPLAY, ++orderInGroup, ConfigDef.Width.MEDIUM, CONFLUENT_TOPIC_DISPLAY);
        configDef.define(CONFLUENT_TOPIC_REPLICATION_FACTOR_CONFIG, ConfigDef.Type.INT, (Object)3, ConfigDef.Importance.LOW, CONFLUENT_TOPIC_REPLICATION_FACTOR_DOC, CONFLUENT_LICENSE_DISPLAY, ++orderInGroup, ConfigDef.Width.MEDIUM, CONFLUENT_TOPIC_REPLICATION_FACTOR_DISPLAY);
        return configDef;
    }

    protected static Map<String, String> withDefaultProperties(Map<String, String> props) {
        Map<String, String> propsWithDefaults = props;
        propsWithDefaults = MqttConfig.defaultLicenseProperties(propsWithDefaults);
        return propsWithDefaults;
    }

    protected static Map<String, String> defaultLicenseProperties(Map<String, String> props) {
        if (props != null && !props.containsKey(CONFLUENT_TOPIC_BOOTSTRAP_SERVERS_CONFIG)) {
            props.put(CONFLUENT_TOPIC_BOOTSTRAP_SERVERS_CONFIG, props.get("bootstrap.servers"));
        }
        return props;
    }

    protected Map<String, Object> licenseProducerConfig() {
        HashMap<String, Object> unifiedConfig = new HashMap<String, Object>();
        unifiedConfig.putAll(MqttConfig.filterOutNonLicensePropertiesInPlace(this.originalsWithPrefix("producer.")));
        unifiedConfig.putAll(MqttConfig.filterOutNonLicensePropertiesInPlace(this.originalsWithPrefix(CONFLUENT_TOPIC_PREFIX)));
        unifiedConfig.putAll(MqttConfig.filterOutNonLicensePropertiesInPlace(this.originalsWithPrefix(CONFLUENT_TOPIC_PRODUCER_PREFIX)));
        return unifiedConfig;
    }

    protected Map<String, Object> licenseConsumerConfig() {
        HashMap<String, Object> unifiedConfig = new HashMap<String, Object>();
        unifiedConfig.putAll(MqttConfig.filterOutNonLicensePropertiesInPlace(this.originalsWithPrefix("producer.")));
        unifiedConfig.putAll(MqttConfig.filterOutNonLicensePropertiesInPlace(this.originalsWithPrefix(CONFLUENT_TOPIC_PREFIX)));
        unifiedConfig.putAll(MqttConfig.filterOutNonLicensePropertiesInPlace(this.originalsWithPrefix(CONFLUENT_TOPIC_CONSUMER_PREFIX)));
        return unifiedConfig;
    }

    protected Map<String, Object> licenseTopicAdminConfig() {
        HashMap<String, Object> unifiedConfig = new HashMap<String, Object>();
        unifiedConfig.putAll(MqttConfig.filterOutNonLicensePropertiesInPlace(this.originalsWithPrefix("producer.")));
        unifiedConfig.putAll(MqttConfig.filterOutNonLicensePropertiesInPlace(this.originalsWithPrefix(CONFLUENT_TOPIC_PREFIX)));
        unifiedConfig.putAll(MqttConfig.filterOutNonLicensePropertiesInPlace(this.originalsWithPrefix(CONFLUENT_TOPIC_PRODUCER_PREFIX)));
        unifiedConfig.putAll(MqttConfig.filterOutNonLicensePropertiesInPlace(this.originalsWithPrefix(CONFLUENT_TOPIC_CONSUMER_PREFIX)));
        return unifiedConfig;
    }

    protected String licenseTopicName() {
        return this.getString(CONFLUENT_TOPIC_CONFIG);
    }

    protected String license() {
        return this.getPassword(CONFLUENT_LICENSE_CONFIG).value();
    }

    public static <T> Map<String, T> filterOutNonLicensePropertiesInPlace(Map<String, T> originals) {
        Iterator<String> propIt = originals.keySet().iterator();
        while (propIt.hasNext()) {
            String next = propIt.next();
            if (!next.contains("interceptor") && !next.contains("metric.reporters") && !next.contains("confluent.telemetry")) continue;
            propIt.remove();
        }
        return originals;
    }

    public Map<String, Object> adminClientConfig() {
        HashMap<String, Object> unifiedConfig = new HashMap<String, Object>();
        unifiedConfig.putAll(MqttConfig.filterOutNonLicensePropertiesInPlace(this.originalsWithPrefix("producer.")));
        unifiedConfig.putAll(this.originalsWithPrefix("bootstrap.", false));
        return unifiedConfig;
    }

    public static void main(String[] args) {
        System.out.println(MqttConfig.getConfig().toEnrichedRst());
    }
}

