/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.mqtt.network;

import io.confluent.mqtt.BaseConfig;
import io.confluent.mqtt.util.ConfigUtils;
import io.netty.channel.epoll.Epoll;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

public interface NetworkConfig
extends BaseConfig {
    public static final String LISTENERS_CONFIG = "listeners";
    public static final String LISTENERS_DOC = "List of listeners. Each listener must include the hostname and the port. For example: tcp://myhost:1883, https://0.0.0.0:8081";
    public static final String LISTENERS_DEFAULT = "0.0.0.0:1883";
    public static final String EPOLL_CONFIG = "network.epoll.enabled";
    public static final String EPOLL_DOC = "Use epoll for incoming connections on Linux instead of standard NIO. Enabling this property when epoll is not available will result in configuration error.";
    public static final boolean EPOLL_DEFAULT = false;
    public static final String NETWORK_THREADS_CONFIG = "network.threads.num";
    public static final String NETWORK_THREADS_DOC = "Number of threads deployed by Kafka-MQTT to handle network IO.";
    public static final int NETWORK_THREADS_DEFAULT = 1;
    public static final String NETWORK_THREADS_PREFIX = "kafka-mqtt-network-thread";

    public static ConfigDef networkConfig(ConfigDef configDef) {
        BaseConfig.GroupAndOrder group = new BaseConfig.GroupAndOrder("Network", 0);
        ConfigDef newConfig = configDef == null ? new ConfigDef() : configDef;
        newConfig = NetworkConfig.proxyListeners(newConfig, group);
        newConfig = NetworkConfig.networkThreads(newConfig, group);
        newConfig = NetworkConfig.epoll(newConfig, group);
        return newConfig;
    }

    public static ConfigDef proxyListeners(ConfigDef config, BaseConfig.GroupAndOrder group) {
        return config.define(LISTENERS_CONFIG, ConfigDef.Type.STRING, (Object)LISTENERS_DEFAULT, (ConfigDef.Validator)new ConfigUtils.GenericValidator((name, value) -> {
            if (value instanceof String && ((String)value).split(":").length == 2) {
                return;
            }
            throw new ConfigException(name, value, "Invalid format for listeners");
        }, () -> "A list of host/port pairs in the form host1:port1, host2:port2, ..."), ConfigDef.Importance.HIGH, LISTENERS_DOC, group.name, ++group.order, ConfigDef.Width.LONG, "Proxy Listeners");
    }

    public static ConfigDef networkThreads(ConfigDef config, BaseConfig.GroupAndOrder group) {
        return config.define(NETWORK_THREADS_CONFIG, ConfigDef.Type.INT, (Object)1, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, NETWORK_THREADS_DOC, group.name, ++group.order, ConfigDef.Width.LONG, "Network Threads Number");
    }

    default public int networkThreads() {
        return this.getInt(NETWORK_THREADS_CONFIG);
    }

    public static ConfigDef epoll(ConfigDef config, BaseConfig.GroupAndOrder group) {
        return config.define(EPOLL_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, (ConfigDef.Validator)new ConfigUtils.GenericValidator((name, value) -> {
            if (((Boolean)value).booleanValue() && !Epoll.isAvailable()) {
                throw new ConfigException(name, value, "Epoll is not available.");
            }
        }, () -> "[false, true]"), ConfigDef.Importance.HIGH, EPOLL_DOC, group.name, ++group.order, ConfigDef.Width.LONG, "Use epoll on Incoming Connections");
    }

    default public ConfigDef assembleNetworkConfig(ConfigDef configDef) {
        return NetworkConfig.networkConfig(configDef);
    }

    default public boolean epollEnabled() {
        return this.getBoolean(EPOLL_CONFIG);
    }

    default public String protocol() {
        return "tcp";
    }

    default public String host() {
        String listeners = this.getString(LISTENERS_CONFIG);
        return listeners.split(":")[0];
    }

    default public int port() {
        String listeners = this.getString(LISTENERS_CONFIG);
        return Integer.parseInt(listeners.split(":")[1]);
    }
}

