/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.mqtt.stream;

import io.netty.handler.codec.mqtt.MqttQoS;
import java.util.EnumMap;
import java.util.Map;

public enum DeliveryGuarantee {
    AT_MOST_ONCE,
    AT_LEAST_ONCE,
    EXACTLY_ONCE;

    private static final Map<MqttQoS, DeliveryGuarantee> reverseLookup;

    public static DeliveryGuarantee valueOf(MqttQoS mqttQoS) {
        DeliveryGuarantee deliveryGuarantee = reverseLookup.get(mqttQoS);
        if (deliveryGuarantee == null) {
            throw new IllegalArgumentException("No delivery guarantee defined for: " + mqttQoS);
        }
        return deliveryGuarantee;
    }

    static {
        reverseLookup = new EnumMap<MqttQoS, DeliveryGuarantee>(MqttQoS.class);
        reverseLookup.put(MqttQoS.AT_MOST_ONCE, AT_MOST_ONCE);
        reverseLookup.put(MqttQoS.AT_LEAST_ONCE, AT_LEAST_ONCE);
        reverseLookup.put(MqttQoS.EXACTLY_ONCE, EXACTLY_ONCE);
    }
}

