/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.mqtt.stream;

import io.confluent.mqtt.stream.DeliveryGuarantee;
import io.confluent.mqtt.stream.MqttRecord;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttQoS;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.header.ConnectHeaders;
import org.apache.kafka.connect.header.Header;
import org.apache.kafka.connect.header.Headers;

public class PublishMqttRecord
extends ConnectRecord<PublishMqttRecord>
implements MqttRecord {
    private final String mqttTopic;
    private final DeliveryGuarantee deliveryGuarantee;

    protected PublishMqttRecord(String kafkaTopic, int kafkaPartition, String mqttTopic, Headers headers, byte[] payload, DeliveryGuarantee deliveryGuarantee, Long timestamp) {
        super(kafkaTopic, Integer.valueOf(kafkaPartition), PublishMqttRecord.mqttKeySchema(), (Object)mqttTopic, PublishMqttRecord.mqttValueSchema(), (Object)payload, timestamp, (Iterable)headers);
        this.mqttTopic = mqttTopic;
        this.deliveryGuarantee = deliveryGuarantee;
    }

    public PublishMqttRecord newRecord(String kafkaTopic, Integer kafkaPartition, Schema keySchema, Object key, Schema valueSchema, Object value, Long timestamp) {
        return this.newRecord(kafkaTopic, kafkaPartition, keySchema, key, valueSchema, value, timestamp, (Iterable)Collections.emptyList());
    }

    public PublishMqttRecord newRecord(String kafkaTopic, Integer kafkaPartition, Schema keySchema, Object key, Schema valueSchema, Object value, Long timestamp, Iterable<Header> headers) {
        if (!(key instanceof String)) {
            throw new DataException("Invalid key type. MQTT topic must be " + String.class.getSimpleName());
        }
        if (!(value instanceof byte[])) {
            throw new DataException("Invalid value type. MQTT topic must be " + byte[].class.getSimpleName());
        }
        if (!(headers instanceof ConnectHeaders)) {
            throw new DataException("Invalid headers type. MQTT headers must be " + ConnectHeaders.class.getSimpleName());
        }
        DeliveryGuarantee qos = null;
        if (headers != null) {
            for (Header header : headers) {
                if (!"kafka.mqtt.qos.level".equals(header.key())) continue;
                qos = DeliveryGuarantee.valueOf(MqttQoS.valueOf((int)((Integer)header.value())));
            }
        }
        qos = qos == null ? DeliveryGuarantee.AT_MOST_ONCE : qos;
        return PublishMqttRecord.newRecord(kafkaTopic, kafkaPartition, (String)key, (Headers)((ConnectHeaders)headers), (byte[])value, qos, timestamp);
    }

    public static PublishMqttRecord newRecord(TopicPartition kafkaTopicPartition, MqttPublishMessage mqttMessage) {
        return PublishMqttRecord.newRecord(kafkaTopicPartition.topic(), kafkaTopicPartition.partition(), mqttMessage);
    }

    public static PublishMqttRecord newRecord(String kafkaTopic, Integer kafkaPartition, MqttPublishMessage mqttMessage) {
        ByteBuf payloadBuffer = mqttMessage.payload();
        byte[] payloadBytes = new byte[payloadBuffer.writerIndex()];
        payloadBuffer.readBytes(payloadBytes);
        return PublishMqttRecord.newRecord(kafkaTopic, kafkaPartition, mqttMessage.variableHeader().topicName(), PublishMqttRecord.newHeaders(mqttMessage), payloadBytes, DeliveryGuarantee.valueOf(mqttMessage.fixedHeader().qosLevel()), null);
    }

    public static PublishMqttRecord newRecord(String kafkaTopic, Integer kafkaPartition, String mqttTopic, Headers headers, byte[] payload, DeliveryGuarantee deliveryGuarantee, Long timestamp) {
        return new PublishMqttRecord(kafkaTopic, kafkaPartition, mqttTopic, headers, payload, deliveryGuarantee, timestamp);
    }

    private static Headers newHeaders(MqttPublishMessage mqttMessage) {
        MqttFixedHeader fixedHeader = mqttMessage.fixedHeader();
        return new ConnectHeaders().addBoolean("kafka.mqtt.dup", fixedHeader.isDup()).addInt("kafka.mqtt.qos.level", fixedHeader.qosLevel().value()).addBoolean("kafka.mqtt.retain", fixedHeader.isRetain()).addInt("kafka.mqtt.packet.id", mqttMessage.variableHeader().packetId());
    }

    protected static Schema mqttKeySchema() {
        return Schema.STRING_SCHEMA;
    }

    protected static Schema mqttValueSchema() {
        return Schema.BYTES_SCHEMA;
    }

    public DeliveryGuarantee deliveryGuarantee() {
        return this.deliveryGuarantee;
    }

    public String key() {
        return (String)super.key();
    }

    public byte[] value() {
        return (byte[])super.value();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PublishMqttRecord)) {
            return false;
        }
        PublishMqttRecord that = (PublishMqttRecord)o;
        if (this.kafkaPartition() != null ? !this.kafkaPartition().equals(that.kafkaPartition()) : that.kafkaPartition() != null) {
            return false;
        }
        if (this.topic() != null ? !this.topic().equals(that.topic()) : that.topic() != null) {
            return false;
        }
        if (this.keySchema() != null ? !this.keySchema().equals(that.keySchema()) : that.keySchema() != null) {
            return false;
        }
        if (this.key() != null ? !this.key().equals(that.key()) : that.key() != null) {
            return false;
        }
        if (this.valueSchema() != null ? !this.valueSchema().equals(that.valueSchema()) : that.valueSchema() != null) {
            return false;
        }
        if (!Arrays.equals(this.value(), that.value())) {
            return false;
        }
        if (this.timestamp() != null ? !this.timestamp().equals(that.timestamp()) : that.timestamp() != null) {
            return false;
        }
        return Objects.equals(this.headers(), that.headers());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.topic(), this.kafkaPartition(), this.keySchema(), this.key(), this.valueSchema(), Arrays.hashCode(this.value()), this.timestamp(), this.headers(), this.mqttTopic, this.deliveryGuarantee});
    }

    public String toString() {
        return "PublishMqttRecord{mqttTopic=" + this.mqttTopic + ", deliverGuarantee=" + (Object)((Object)this.deliveryGuarantee) + "} " + super.toString();
    }
}

