/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import com.google.errorprone.annotations.Immutable;
import java.util.Objects;

@Immutable
public class HostStatus {
    private final boolean hostAlive;
    private final long lastStatusUpdateMs;

    public HostStatus(boolean hostAlive, long lastStatusUpdateMs) {
        this.hostAlive = hostAlive;
        this.lastStatusUpdateMs = lastStatusUpdateMs;
    }

    public HostStatus withHostAlive(boolean hostAlive) {
        return new HostStatus(hostAlive, this.lastStatusUpdateMs);
    }

    public HostStatus withLastStatusUpdateMs(long lastStatusUpdateMs) {
        return new HostStatus(this.hostAlive, lastStatusUpdateMs);
    }

    public long getLastStatusUpdateMs() {
        return this.lastStatusUpdateMs;
    }

    public boolean isHostAlive() {
        return this.hostAlive;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostStatus that = (HostStatus)o;
        return this.hostAlive == that.hostAlive && this.lastStatusUpdateMs == that.lastStatusUpdateMs;
    }

    public int hashCode() {
        return Objects.hash(this.hostAlive, this.lastStatusUpdateMs);
    }

    public String toString() {
        return "HostStatus{hostAlive=" + this.hostAlive + ", lastStatusUpdateMs=" + this.lastStatusUpdateMs + '}';
    }
}

