/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import com.google.common.base.Preconditions;
import io.confluent.ksql.util.KeyValue;
import io.confluent.ksql.util.RowMetadata;
import java.util.Objects;
import java.util.Optional;

public class KeyValueMetadata<K, V> {
    private final Optional<KeyValue<K, V>> keyValue;
    private final Optional<RowMetadata> rowMetadata;

    public KeyValueMetadata(KeyValue<K, V> keyValue) {
        this.keyValue = Optional.of(keyValue);
        this.rowMetadata = Optional.empty();
    }

    public KeyValueMetadata(KeyValue<K, V> keyValue, Optional<RowMetadata> rowMetadata) {
        this.keyValue = Optional.of(keyValue);
        this.rowMetadata = rowMetadata;
    }

    public KeyValueMetadata(RowMetadata rowMetadata) {
        this.keyValue = Optional.empty();
        this.rowMetadata = Optional.of(rowMetadata);
    }

    public Optional<KeyValue<K, V>> getKeyValueOptional() {
        return this.keyValue;
    }

    public KeyValue<K, V> getKeyValue() {
        Preconditions.checkState((boolean)this.keyValue.isPresent(), (Object)"This code path assumes there's a keyvalue");
        return this.keyValue.get();
    }

    public Optional<RowMetadata> getRowMetadata() {
        return this.rowMetadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyValueMetadata keyValueMetadata = (KeyValueMetadata)o;
        return Objects.equals(this.keyValue, keyValueMetadata.keyValue) && Objects.equals(this.rowMetadata, keyValueMetadata.rowMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.keyValue, this.rowMetadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("KeyValueMetadata{");
        sb.append("keyValue=").append(this.keyValue);
        sb.append(", rowMetadata=").append(this.rowMetadata);
        sb.append('}');
        return sb.toString();
    }
}

