/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.dekregistry.storage;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.dekregistry.client.rest.entities.KeyType;
import io.confluent.dekregistry.storage.EncryptionKeyId;
import io.confluent.kafka.schemaregistry.encryption.tink.DekFormat;
import io.confluent.kafka.schemaregistry.utils.QualifiedSubject;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class DataEncryptionKeyId
extends EncryptionKeyId {
    private final String kekName;
    private final String subject;
    private final DekFormat algorithm;
    private final int version;

    @JsonCreator
    public DataEncryptionKeyId(@JsonProperty(value="tenant") String tenant, @JsonProperty(value="kekName") String kekName, @JsonProperty(value="subject") String subject, @JsonProperty(value="algorithm") DekFormat algorithm, @JsonProperty(value="version") int version) {
        super(tenant, KeyType.DEK);
        this.kekName = kekName;
        this.subject = subject;
        this.algorithm = algorithm;
        this.version = version;
    }

    @JsonProperty(value="kekName")
    public String getKekName() {
        return this.kekName;
    }

    @JsonProperty(value="subject")
    public String getSubject() {
        return this.subject;
    }

    @JsonProperty(value="algorithm")
    public DekFormat getAlgorithm() {
        return this.algorithm;
    }

    @JsonProperty(value="version")
    public int getVersion() {
        return this.version;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DataEncryptionKeyId that = (DataEncryptionKeyId)o;
        return Objects.equals(this.kekName, that.kekName) && Objects.equals(this.subject, that.subject) && this.algorithm == that.algorithm && this.version == that.version;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.kekName, this.subject, this.algorithm, this.version);
    }

    @Override
    public int compareTo(EncryptionKeyId o) {
        int compare = super.compareTo(o);
        if (compare != 0) {
            return compare;
        }
        DataEncryptionKeyId that = (DataEncryptionKeyId)o;
        if (this.getKekName() != null || that.getKekName() != null) {
            if (this.getKekName() == null) {
                return -1;
            }
            if (that.getKekName() == null) {
                return 1;
            }
            int kekNameComparison = this.getKekName().compareTo(that.getKekName());
            if (kekNameComparison != 0) {
                return kekNameComparison < 0 ? -1 : 1;
            }
        }
        if (this.getSubject() != null || that.getSubject() != null) {
            QualifiedSubject qs2;
            if (this.getSubject() == null) {
                return -1;
            }
            if (that.getSubject() == null) {
                return 1;
            }
            QualifiedSubject qs1 = QualifiedSubject.createFromUnqualified((String)this.getTenant(), (String)this.getSubject());
            int subjectComparison = qs1.compareTo(qs2 = QualifiedSubject.createFromUnqualified((String)that.getTenant(), (String)that.getSubject()));
            if (subjectComparison != 0) {
                return subjectComparison < 0 ? -1 : 1;
            }
        }
        if (this.getAlgorithm() != null || that.getAlgorithm() != null) {
            if (this.getAlgorithm() == null) {
                return -1;
            }
            if (that.getAlgorithm() == null) {
                return 1;
            }
            int algorithmComparison = this.getAlgorithm().compareTo((Enum)that.getAlgorithm());
            if (algorithmComparison != 0) {
                return algorithmComparison < 0 ? -1 : 1;
            }
        }
        if (this.getVersion() != that.getVersion()) {
            return this.getVersion() < that.getVersion() ? -1 : 1;
        }
        return 0;
    }
}

