/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.authentication.oauthbearer;

import java.security.Key;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jose4j.http.SimpleGet;
import org.jose4j.jwk.HttpsJwks;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.keys.resolvers.HttpsJwksVerificationKeyResolver;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.jose4j.lang.UnresolvableKeyException;

final class JkuVerificationKeyResolver
implements VerificationKeyResolver {
    private final Map<String, HttpsJwksVerificationKeyResolver> jkuKeyResolverCache = new ConcurrentHashMap<String, HttpsJwksVerificationKeyResolver>();
    private final SimpleGet simpleGet;

    JkuVerificationKeyResolver(SimpleGet simpleGet) {
        this.simpleGet = simpleGet;
    }

    public Key resolveKey(JsonWebSignature jws, List<JsonWebStructure> nestingContext) throws UnresolvableKeyException {
        String jku = jws.getHeaders().getStringHeaderValue("jku");
        HttpsJwksVerificationKeyResolver httpsJwksKeyResolver = this.jkuKeyResolverCache.computeIfAbsent(jku, this::newKeyResolver);
        try {
            return httpsJwksKeyResolver.resolveKey(jws, nestingContext);
        }
        catch (NullPointerException e) {
            throw new UnresolvableKeyException("Failed to resolve key");
        }
    }

    private HttpsJwksVerificationKeyResolver newKeyResolver(String jku) {
        HttpsJwks httpsJwks = new HttpsJwks(jku);
        httpsJwks.setSimpleHttpGet(this.simpleGet);
        HttpsJwksVerificationKeyResolver httpsJwksVerificationKeyResolver = new HttpsJwksVerificationKeyResolver(httpsJwks);
        httpsJwksVerificationKeyResolver.setDisambiguateWithVerifySignature(true);
        return httpsJwksVerificationKeyResolver;
    }
}

