/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.consumer;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatRequestData;
import org.apache.kafka.coordinator.group.consumer.Assignment;
import org.apache.kafka.coordinator.group.consumer.ConsumerGroupMember;

public class CurrentAssignmentBuilder {
    private final ConsumerGroupMember member;
    private int targetAssignmentEpoch;
    private Assignment targetAssignment;
    private BiFunction<Uuid, Integer, Integer> currentPartitionEpoch;
    private List<ConsumerGroupHeartbeatRequestData.TopicPartitions> ownedTopicPartitions;

    public CurrentAssignmentBuilder(ConsumerGroupMember member) {
        this.member = Objects.requireNonNull(member);
    }

    public CurrentAssignmentBuilder withTargetAssignment(int targetAssignmentEpoch, Assignment targetAssignment) {
        this.targetAssignmentEpoch = targetAssignmentEpoch;
        this.targetAssignment = Objects.requireNonNull(targetAssignment);
        return this;
    }

    public CurrentAssignmentBuilder withCurrentPartitionEpoch(BiFunction<Uuid, Integer, Integer> currentPartitionEpoch) {
        this.currentPartitionEpoch = Objects.requireNonNull(currentPartitionEpoch);
        return this;
    }

    public CurrentAssignmentBuilder withOwnedTopicPartitions(List<ConsumerGroupHeartbeatRequestData.TopicPartitions> ownedTopicPartitions) {
        this.ownedTopicPartitions = ownedTopicPartitions;
        return this;
    }

    public ConsumerGroupMember build() {
        if (this.targetAssignmentEpoch != this.member.nextMemberEpoch()) {
            return this.transitionToNewTargetAssignmentState();
        }
        switch (this.member.state()) {
            case REVOKING: {
                return this.maybeTransitionFromRevokingToAssigningOrStable();
            }
            case ASSIGNING: {
                return this.maybeTransitionFromAssigningToAssigningOrStable();
            }
            case STABLE: {
                return this.member;
            }
        }
        return this.member;
    }

    private ConsumerGroupMember transitionToNewTargetAssignmentState() {
        HashMap<Uuid, Set<Integer>> newAssignedPartitions = new HashMap<Uuid, Set<Integer>>();
        HashMap<Uuid, Set<Integer>> newPartitionsPendingRevocation = new HashMap<Uuid, Set<Integer>>();
        HashMap<Uuid, Set<Integer>> newPartitionsPendingAssignment = new HashMap<Uuid, Set<Integer>>();
        HashSet<Uuid> allTopicIds = new HashSet<Uuid>(this.targetAssignment.partitions().keySet());
        allTopicIds.addAll(this.member.assignedPartitions().keySet());
        allTopicIds.addAll(this.member.partitionsPendingRevocation().keySet());
        allTopicIds.addAll(this.member.partitionsPendingAssignment().keySet());
        for (Uuid topicId : allTopicIds) {
            Set target = this.targetAssignment.partitions().getOrDefault(topicId, Collections.emptySet());
            Set currentAssignedPartitions = this.member.assignedPartitions().getOrDefault(topicId, Collections.emptySet());
            Set currentRevokingPartitions = this.member.partitionsPendingRevocation().getOrDefault(topicId, Collections.emptySet());
            HashSet assignedPartitions = new HashSet(currentAssignedPartitions);
            assignedPartitions.addAll(currentRevokingPartitions);
            assignedPartitions.retainAll(target);
            HashSet partitionsPendingRevocation = new HashSet(currentAssignedPartitions);
            partitionsPendingRevocation.addAll(currentRevokingPartitions);
            partitionsPendingRevocation.removeAll(assignedPartitions);
            HashSet partitionsPendingAssignment = new HashSet(target);
            partitionsPendingAssignment.removeAll(assignedPartitions);
            if (!assignedPartitions.isEmpty()) {
                newAssignedPartitions.put(topicId, assignedPartitions);
            }
            if (!partitionsPendingRevocation.isEmpty()) {
                newPartitionsPendingRevocation.put(topicId, partitionsPendingRevocation);
            }
            if (partitionsPendingAssignment.isEmpty()) continue;
            newPartitionsPendingAssignment.put(topicId, partitionsPendingAssignment);
        }
        if (!newPartitionsPendingRevocation.isEmpty()) {
            return new ConsumerGroupMember.Builder(this.member).setAssignedPartitions(newAssignedPartitions).setPartitionsPendingRevocation(newPartitionsPendingRevocation).setPartitionsPendingAssignment(newPartitionsPendingAssignment).setNextMemberEpoch(this.targetAssignmentEpoch).build();
        }
        if (!newPartitionsPendingAssignment.isEmpty()) {
            this.maybeAssignPendingPartitions(newAssignedPartitions, newPartitionsPendingAssignment);
        }
        return new ConsumerGroupMember.Builder(this.member).setAssignedPartitions(newAssignedPartitions).setPartitionsPendingRevocation(Collections.emptyMap()).setPartitionsPendingAssignment(newPartitionsPendingAssignment).setPreviousMemberEpoch(this.member.memberEpoch()).setMemberEpoch(this.targetAssignmentEpoch).setNextMemberEpoch(this.targetAssignmentEpoch).build();
    }

    private ConsumerGroupMember maybeTransitionFromRevokingToAssigningOrStable() {
        if (this.member.partitionsPendingRevocation().isEmpty() || this.matchesAssignedPartitions(this.ownedTopicPartitions)) {
            Map<Uuid, Set<Integer>> newAssignedPartitions = this.deepCopy(this.member.assignedPartitions());
            Map<Uuid, Set<Integer>> newPartitionsPendingAssignment = this.deepCopy(this.member.partitionsPendingAssignment());
            if (!newPartitionsPendingAssignment.isEmpty()) {
                this.maybeAssignPendingPartitions(newAssignedPartitions, newPartitionsPendingAssignment);
            }
            return new ConsumerGroupMember.Builder(this.member).setAssignedPartitions(newAssignedPartitions).setPartitionsPendingRevocation(Collections.emptyMap()).setPartitionsPendingAssignment(newPartitionsPendingAssignment).setPreviousMemberEpoch(this.member.memberEpoch()).setMemberEpoch(this.targetAssignmentEpoch).setNextMemberEpoch(this.targetAssignmentEpoch).build();
        }
        return this.member;
    }

    private ConsumerGroupMember maybeTransitionFromAssigningToAssigningOrStable() {
        Map<Uuid, Set<Integer>> newPartitionsPendingAssignment;
        Map<Uuid, Set<Integer>> newAssignedPartitions = this.deepCopy(this.member.assignedPartitions());
        if (this.maybeAssignPendingPartitions(newAssignedPartitions, newPartitionsPendingAssignment = this.deepCopy(this.member.partitionsPendingAssignment()))) {
            return new ConsumerGroupMember.Builder(this.member).setAssignedPartitions(newAssignedPartitions).setPartitionsPendingRevocation(Collections.emptyMap()).setPartitionsPendingAssignment(newPartitionsPendingAssignment).setPreviousMemberEpoch(this.member.memberEpoch()).setMemberEpoch(this.targetAssignmentEpoch).setNextMemberEpoch(this.targetAssignmentEpoch).build();
        }
        return this.member;
    }

    private boolean maybeAssignPendingPartitions(Map<Uuid, Set<Integer>> newAssignedPartitions, Map<Uuid, Set<Integer>> newPartitionsPendingAssignment) {
        boolean changed = false;
        Iterator<Map.Entry<Uuid, Set<Integer>>> assigningSetIterator = newPartitionsPendingAssignment.entrySet().iterator();
        while (assigningSetIterator.hasNext()) {
            Map.Entry<Uuid, Set<Integer>> pair = assigningSetIterator.next();
            Uuid topicId = pair.getKey();
            Set<Integer> assigning = pair.getValue();
            Iterator<Integer> assigningIterator = assigning.iterator();
            while (assigningIterator.hasNext()) {
                Integer partitionId = assigningIterator.next();
                Integer partitionEpoch = this.currentPartitionEpoch.apply(topicId, partitionId);
                if (partitionEpoch != -1) continue;
                assigningIterator.remove();
                this.put(newAssignedPartitions, topicId, partitionId);
                changed = true;
            }
            if (!assigning.isEmpty()) continue;
            assigningSetIterator.remove();
        }
        return changed;
    }

    private boolean matchesAssignedPartitions(List<ConsumerGroupHeartbeatRequestData.TopicPartitions> ownedTopicPartitions) {
        if (ownedTopicPartitions == null) {
            return false;
        }
        if (ownedTopicPartitions.size() != this.member.assignedPartitions().size()) {
            return false;
        }
        for (ConsumerGroupHeartbeatRequestData.TopicPartitions topicPartitions : ownedTopicPartitions) {
            Set<Integer> partitions = this.member.assignedPartitions().get(topicPartitions.topicId());
            if (partitions == null) {
                return false;
            }
            for (Integer partitionId : topicPartitions.partitions()) {
                if (partitions.contains(partitionId)) continue;
                return false;
            }
        }
        return true;
    }

    private Map<Uuid, Set<Integer>> deepCopy(Map<Uuid, Set<Integer>> map) {
        HashMap<Uuid, Set<Integer>> copy = new HashMap<Uuid, Set<Integer>>();
        map.forEach((topicId, partitions) -> {
            Set cfr_ignored_0 = copy.put((Uuid)topicId, new HashSet(partitions));
        });
        return copy;
    }

    private void put(Map<Uuid, Set<Integer>> map, Uuid topicId, Integer partitionId) {
        map.compute(topicId, (__, partitionsOrNull) -> {
            if (partitionsOrNull == null) {
                partitionsOrNull = new HashSet<Integer>();
            }
            partitionsOrNull.add(partitionId);
            return partitionsOrNull;
        });
    }
}

