/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.generic;

import java.util.Arrays;
import java.util.Objects;

public class Protocol {
    public static final byte[] EMPTY_METADATA = new byte[0];
    private final String name;
    private final byte[] metadata;

    public Protocol(String name, byte[] metadata) {
        this.name = Objects.requireNonNull(name);
        this.metadata = metadata;
    }

    public String name() {
        return this.name;
    }

    public byte[] metadata() {
        return this.metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Protocol protocol = (Protocol)o;
        if (!this.name.equals(protocol.name)) {
            return false;
        }
        return Arrays.equals(this.metadata, protocol.metadata);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + Arrays.hashCode(this.metadata);
        return result;
    }

    public String toString() {
        return "Protocol(name=" + this.name + ", metadata=" + Arrays.toString(this.metadata) + ")";
    }
}

