/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.dekregistry.client.rest.entities;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafka.schemaregistry.encryption.tink.DekFormat;
import io.confluent.kafka.schemaregistry.utils.JacksonMapper;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@Schema(description="Create dek request")
public class CreateDekRequest {
    private String subject;
    private Integer version;
    private DekFormat algorithm;
    private String encryptedKeyMaterial;
    private boolean deleted;

    public static CreateDekRequest fromJson(String json) throws IOException {
        return (CreateDekRequest)JacksonMapper.INSTANCE.readValue(json, CreateDekRequest.class);
    }

    @Schema(description="Subject of the dek")
    @JsonProperty(value="subject")
    public String getSubject() {
        return this.subject;
    }

    @JsonProperty(value="subject")
    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Schema(description="Version of the dek")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    public void setVersion(Integer version) {
        this.version = version;
    }

    @Schema(description="Algorithm of the dek")
    @JsonProperty(value="algorithm")
    public DekFormat getAlgorithm() {
        return this.algorithm;
    }

    @JsonProperty(value="algorithm")
    public void setAlgorithm(DekFormat algorithm) {
        this.algorithm = algorithm;
    }

    @Schema(description="Encrypted key material of the dek")
    @JsonProperty(value="encryptedKeyMaterial")
    public String getEncryptedKeyMaterial() {
        return this.encryptedKeyMaterial;
    }

    @JsonProperty(value="encryptedKeyMaterial")
    public void setEncryptedKeyMaterial(String encryptedKeyMaterial) {
        this.encryptedKeyMaterial = encryptedKeyMaterial;
    }

    @Schema(description="Whether the dek is deleted")
    @JsonProperty(value="deleted")
    public boolean isDeleted() {
        return this.deleted;
    }

    @JsonProperty(value="deleted")
    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateDekRequest dek = (CreateDekRequest)o;
        return Objects.equals(this.subject, dek.subject) && Objects.equals(this.version, dek.version) && Objects.equals(this.algorithm, dek.algorithm) && Objects.equals(this.encryptedKeyMaterial, dek.encryptedKeyMaterial) && this.deleted == dek.deleted;
    }

    public int hashCode() {
        return Objects.hash(this.subject, this.version, this.algorithm, this.encryptedKeyMaterial, this.deleted);
    }

    public String toString() {
        try {
            return this.toJson();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toJson() throws IOException {
        return JacksonMapper.INSTANCE.writeValueAsString((Object)this);
    }
}

