/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.oidc.config;

import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;

public class OidcConfig
extends AbstractConfig {
    public static final String CONFIG_PREFIX = "confluent.oidc";
    public static final String OIDC_SUB_CLAIM_NAME = "confluent.oidc.idp.sub.claim.name";
    public static final String DEFAULT_OIDC_SUB_CLAIM_NAME = "sub";
    public static final String OIDC_SUB_CLAIM_NAME_DOC = "The claim for the subject is often named \"sub\", but this (optional) setting can provide a different name to use for the subject included in the JWT payload's claims if the OIDC provider uses a different name for that claim.";
    public static final String OIDC_GROUPS_CLAIM_NAME = "confluent.oidc.idp.groups.claim.name";
    public static final String DEFAULT_OIDC_GROUPS_CLAIM_NAME = "groups";
    public static final String OIDC_GROUPS_CLAIM_NAME_DOC = "The claim for the groups is a custom claim and this (optional) setting can provide the name to use for identifying the groups of subject in the JWT payload.";
    public static final String OIDC_GROUPS_CLAIM_SCOPE = "confluent.oidc.idp.groups.claim.scope";
    public static final String DEFAULT_OIDC_GROUPS_CLAIM_SCOPE = "";
    public static final String OIDC_GROUPS_CLAIM_SCOPE_DOC = "This setting specifies the scope parameter that is required to request a token that contains the groups claim, which is a claim that lists the groups that the user belongs to in IDP.";
    public static final String OIDC_CLIENT_ID = "confluent.oidc.idp.client.id";
    public static final String OIDC_CLIENT_ID_DOC = "The client ID is a parameter that identifies the client application that is requesting user authorization from an authorization server (IDP). It is required in the OIDC authorization request, which is a URL that initiates the authorization flow.";
    public static final String OIDC_CLIENT_SECRET = "confluent.oidc.idp.client.secret";
    public static final String OIDC_CLIENT_SECRET_DOC = "The client secret is a parameter that identifies the client application that is requesting user authorization from an authorization server (IDP). It is required in the OIDC token request, which is a URL that provides id, access and refresh tokens.";
    public static final String OIDC_IDP_ISSUER = "confluent.oidc.idp.issuer";
    public static final String OIDC_IDP_ISSUER_DOC = "The issuer claim is an important aspect of JWTs and a way for receivers to verify the authenticity and trustworthiness of the token. The value of the issuer is a string that is a unique identifier for the entity that issued the token, and it is a standard claim defined in the JWT specification (RFC 7519). The issuer URL can be any unique identifier that the receiver of the token can use to verify token's authenticity. In the case of OAuth2, the issuer URL would typically be the authorization server's URL.";
    public static final String OIDC_JWKS_LOCATION = "confluent.oidc.idp.jwks.endpoint.uri";
    public static final String OIDC_JWKS_LOCATION_DOC = "This setting configures the uri for the JSON Web Key Set (JWKS), which is a set of public keys used to verify any JSON Web Token (JWT) issued by the IDP. This allows MDS to dynamically obtain the public keys for verifying JWTs, without having to hard-code them or store them locally. This way, customer can easily rotate the keys or update them in case of a security breach.";
    public static final String OIDC_AUTHORIZE_ENDPOINT_BASE_URI = "confluent.oidc.idp.authorize.base.endpoint.uri";
    public static final String OIDC_AUTHORIZE_ENDPOINT_BASE_URI_DOC = "This setting configures base uri for authorize endpoint, e.g. https://idp.com/oauth2/v1/authorize. The authorization endpoint is a URL that initiates an OIDC authorization request. It is used by clients (such as apps) to request user authorization and obtain an authorization code from an authorization server (IDP). The authorization endpoint accepts various parameters that specify the type of response, the scope of access, the client ID, the redirect URI, and other information defined by RFC-6749 (https://www.rfc-editor.org/rfc/rfc6749). The authorization server validates the request and redirects the user to a login page or a consent page, depending on the config and the user's session status.";
    public static final String OIDC_TOKEN_ENDPOINT_BASE_URI = "confluent.oidc.idp.token.base.endpoint.uri";
    public static final String OIDC_TOKEN_ENDPOINT_BASE_URI_DOC = "This setting configures base uri for token endpoint, e.g. https://idp.com/oauth2/v1/token. The token endpoint is a URL that issues access tokens to clients after successfully authenticating the client and obtaining authorization. The token endpoint is used by the client to obtain an access token by presenting its authorization grant or refresh token. The client sends a POST request to the token endpoint with the appropriate params, depending on the type of grant being used. The server responds with an access token and, optionally, a refresh token. The access token can then be used by the client to access protected resources on behalf of the resource owner. The refresh token can be used to obtain a new access token when the current one expires.";
    public static final String OIDC_IDP_REFRESH_TOKEN_ENABLED = "confluent.oidc.idp.refresh.token.enabled";
    public static final Boolean DEFAULT_OIDC_IDP_REFRESH_TOKEN_ENABLED = true;
    public static final String OIDC_IDP_REFRESH_TOKEN_ENABLED_DOC = "This setting configures whether offline_access scope should be requested in the authorization URI. When this setting is set to true, the offline_access scope will be requested in the authorization URI. This will allow the Confluent to obtain a refresh token, which can be used to obtain access tokens after auth token expires. When this setting is set to false, the offline_access scope will not be requested in the authorization URI. This will prevent Confluent from obtaining a refresh token. Set this to false if offline tokens are not allowed for the user or client in IdP";
    public static final String SESSION_TOKEN_LIFETIME_MS = "confluent.oidc.session.token.expiry.ms";
    public static final long DEFAULT_SESSION_TOKEN_LIFETIME_MS = 900000L;
    public static final String SESSION_TOKEN_LIFETIME_MS_DOC = "This setting determines the validity of the JWT session token issued by Confluent in exchange for IDP token. The value of this setting is an integer that represents the lifetime of the JWT session token in milliseconds. After this time, the session token needs to be renewed for session to remain active. The actual validity of session token would be minimum of id token lifetime and the value of this setting. For example, if this setting is set to 3600000, and the expiry of id token is more than one hr, then the JWT session token will expire after one hour. The default value of this setting is 900000, which means the JWT session token will expire after 15 minutes. A very large or very small value should not be used for this setting, as they may affect the security and performance of the app. A very large value may increase the risk of token theft or misuse, while a very small value may cause frequent re-authentication and inconvenience for the users.";
    public static final String SESSION_TOKEN_MAX_TIMEOUT_MS = "confluent.oidc.session.max.timeout.ms";
    public static final long DEFAULT_SESSION_TOKEN_MAX_TIMEOUT_MS = 21600000L;
    public static final String SESSION_TOKEN_MAX_TIMEOUT_MS_DOC = "This setting determines the maximum time duration for which the JWT session token can be prolonged. By default, the session token can only be extended until the expiration of the ID token or value of confluent.oidc.session.token.expiry.ms whichever is minimum. However, if a refresh token is also issued, it can be prolonged for a longer duration, up to the limit specified by this setting.";
    private static final ConfigDef oidcConfig = OidcConfig.oidcConfigDef();

    public OidcConfig(Map<?, ?> originals) {
        super(oidcConfig, originals);
    }

    private static ConfigDef oidcConfigDef() {
        return new ConfigDef().define(OIDC_SUB_CLAIM_NAME, ConfigDef.Type.STRING, (Object)DEFAULT_OIDC_SUB_CLAIM_NAME, ConfigDef.Importance.LOW, OIDC_SUB_CLAIM_NAME_DOC).define(OIDC_GROUPS_CLAIM_NAME, ConfigDef.Type.STRING, (Object)DEFAULT_OIDC_GROUPS_CLAIM_NAME, ConfigDef.Importance.MEDIUM, OIDC_GROUPS_CLAIM_NAME_DOC).define(OIDC_GROUPS_CLAIM_SCOPE, ConfigDef.Type.STRING, (Object)DEFAULT_OIDC_GROUPS_CLAIM_SCOPE, ConfigDef.Importance.LOW, OIDC_GROUPS_CLAIM_SCOPE_DOC).define(OIDC_JWKS_LOCATION, ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, OIDC_JWKS_LOCATION_DOC).define(OIDC_IDP_ISSUER, ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, OIDC_IDP_ISSUER_DOC).define(OIDC_AUTHORIZE_ENDPOINT_BASE_URI, ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, OIDC_AUTHORIZE_ENDPOINT_BASE_URI_DOC).define(OIDC_TOKEN_ENDPOINT_BASE_URI, ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, OIDC_TOKEN_ENDPOINT_BASE_URI_DOC).define(OIDC_CLIENT_ID, ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, OIDC_CLIENT_ID_DOC).define(OIDC_CLIENT_SECRET, ConfigDef.Type.PASSWORD, ConfigDef.Importance.HIGH, OIDC_CLIENT_SECRET_DOC).define(OIDC_IDP_REFRESH_TOKEN_ENABLED, ConfigDef.Type.BOOLEAN, (Object)DEFAULT_OIDC_IDP_REFRESH_TOKEN_ENABLED, ConfigDef.Importance.LOW, OIDC_IDP_REFRESH_TOKEN_ENABLED_DOC).define(SESSION_TOKEN_LIFETIME_MS, ConfigDef.Type.LONG, (Object)900000L, ConfigDef.Importance.LOW, SESSION_TOKEN_LIFETIME_MS_DOC).define(SESSION_TOKEN_MAX_TIMEOUT_MS, ConfigDef.Type.LONG, (Object)21600000L, ConfigDef.Importance.LOW, SESSION_TOKEN_MAX_TIMEOUT_MS_DOC);
    }
}

