/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="CustomResourceColumnDefinition specifies a column for server side printing.")
public class V1CustomResourceColumnDefinition {
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_FORMAT = "format";
    @SerializedName(value="format")
    private String format;
    public static final String SERIALIZED_NAME_JSON_PATH = "jsonPath";
    @SerializedName(value="jsonPath")
    private String jsonPath;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_PRIORITY = "priority";
    @SerializedName(value="priority")
    private Integer priority;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;

    public V1CustomResourceColumnDefinition description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="description is a human readable description of this column.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public V1CustomResourceColumnDefinition format(String format) {
        this.format = format;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="format is an optional OpenAPI type definition for this column. The 'name' format is applied to the primary identifier column to assist in clients identifying column is the resource name. See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types for details.")
    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public V1CustomResourceColumnDefinition jsonPath(String jsonPath) {
        this.jsonPath = jsonPath;
        return this;
    }

    @ApiModelProperty(required=true, value="jsonPath is a simple JSON path (i.e. with array notation) which is evaluated against each custom resource to produce the value for this column.")
    public String getJsonPath() {
        return this.jsonPath;
    }

    public void setJsonPath(String jsonPath) {
        this.jsonPath = jsonPath;
    }

    public V1CustomResourceColumnDefinition name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="name is a human readable name for the column.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1CustomResourceColumnDefinition priority(Integer priority) {
        this.priority = priority;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="priority is an integer defining the relative importance of this column compared to others. Lower numbers are considered higher priority. Columns that may be omitted in limited space scenarios should be given a priority greater than 0.")
    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public V1CustomResourceColumnDefinition type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="type is an OpenAPI type definition for this column. See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types for details.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1CustomResourceColumnDefinition v1CustomResourceColumnDefinition = (V1CustomResourceColumnDefinition)o;
        return Objects.equals(this.description, v1CustomResourceColumnDefinition.description) && Objects.equals(this.format, v1CustomResourceColumnDefinition.format) && Objects.equals(this.jsonPath, v1CustomResourceColumnDefinition.jsonPath) && Objects.equals(this.name, v1CustomResourceColumnDefinition.name) && Objects.equals(this.priority, v1CustomResourceColumnDefinition.priority) && Objects.equals(this.type, v1CustomResourceColumnDefinition.type);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.format, this.jsonPath, this.name, this.priority, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1CustomResourceColumnDefinition {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    format: ").append(this.toIndentedString(this.format)).append("\n");
        sb.append("    jsonPath: ").append(this.toIndentedString(this.jsonPath)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

