/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.custom.Quantity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ContainerResourceMetricStatus indicates the current value of a resource metric known to Kubernetes, as specified in requests and limits, describing a single container in each pod in the current scale target (e.g. CPU or memory).  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.")
public class V2beta1ContainerResourceMetricStatus {
    public static final String SERIALIZED_NAME_CONTAINER = "container";
    @SerializedName(value="container")
    private String container;
    public static final String SERIALIZED_NAME_CURRENT_AVERAGE_UTILIZATION = "currentAverageUtilization";
    @SerializedName(value="currentAverageUtilization")
    private Integer currentAverageUtilization;
    public static final String SERIALIZED_NAME_CURRENT_AVERAGE_VALUE = "currentAverageValue";
    @SerializedName(value="currentAverageValue")
    private Quantity currentAverageValue;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;

    public V2beta1ContainerResourceMetricStatus container(String container) {
        this.container = container;
        return this;
    }

    @ApiModelProperty(required=true, value="container is the name of the container in the pods of the scaling target")
    public String getContainer() {
        return this.container;
    }

    public void setContainer(String container) {
        this.container = container;
    }

    public V2beta1ContainerResourceMetricStatus currentAverageUtilization(Integer currentAverageUtilization) {
        this.currentAverageUtilization = currentAverageUtilization;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="currentAverageUtilization is the current value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods.  It will only be present if `targetAverageValue` was set in the corresponding metric specification.")
    public Integer getCurrentAverageUtilization() {
        return this.currentAverageUtilization;
    }

    public void setCurrentAverageUtilization(Integer currentAverageUtilization) {
        this.currentAverageUtilization = currentAverageUtilization;
    }

    public V2beta1ContainerResourceMetricStatus currentAverageValue(Quantity currentAverageValue) {
        this.currentAverageValue = currentAverageValue;
        return this;
    }

    @ApiModelProperty(required=true, value="Quantity is a fixed-point representation of a number. It provides convenient marshaling/unmarshaling in JSON and YAML, in addition to String() and AsInt64() accessors.  The serialization format is:  <quantity>        ::= <signedNumber><suffix>   (Note that <suffix> may be empty, from the \"\" case in <decimalSI>.) <digit>           ::= 0 | 1 | ... | 9 <digits>          ::= <digit> | <digit><digits> <number>          ::= <digits> | <digits>.<digits> | <digits>. | .<digits> <sign>            ::= \"+\" | \"-\" <signedNumber>    ::= <number> | <sign><number> <suffix>          ::= <binarySI> | <decimalExponent> | <decimalSI> <binarySI>        ::= Ki | Mi | Gi | Ti | Pi | Ei   (International System of units; See: http://physics.nist.gov/cuu/Units/binary.html) <decimalSI>       ::= m | \"\" | k | M | G | T | P | E   (Note that 1024 = 1Ki but 1000 = 1k; I didn't choose the capitalization.) <decimalExponent> ::= \"e\" <signedNumber> | \"E\" <signedNumber>  No matter which of the three exponent forms is used, no quantity may represent a number greater than 2^63-1 in magnitude, nor may it have more than 3 decimal places. Numbers larger or more precise will be capped or rounded up. (E.g.: 0.1m will rounded up to 1m.) This may be extended in the future if we require larger or smaller quantities.  When a Quantity is parsed from a string, it will remember the type of suffix it had, and will use the same type again when it is serialized.  Before serializing, Quantity will be put in \"canonical form\". This means that Exponent/suffix will be adjusted up or down (with a corresponding increase or decrease in Mantissa) such that:   a. No precision is lost   b. No fractional digits will be emitted   c. The exponent (or suffix) is as large as possible. The sign will be omitted unless the number is negative.  Examples:   1.5 will be serialized as \"1500m\"   1.5Gi will be serialized as \"1536Mi\"  Note that the quantity will NEVER be internally represented by a floating point number. That is the whole point of this exercise.  Non-canonical values will still parse as long as they are well formed, but will be re-emitted in their canonical form. (So always use canonical form, or don't diff.)  This format is intended to make it difficult to use these numbers without writing some sort of special handling code in the hopes that that will cause implementors to also use a fixed point implementation.")
    public Quantity getCurrentAverageValue() {
        return this.currentAverageValue;
    }

    public void setCurrentAverageValue(Quantity currentAverageValue) {
        this.currentAverageValue = currentAverageValue;
    }

    public V2beta1ContainerResourceMetricStatus name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="name is the name of the resource in question.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V2beta1ContainerResourceMetricStatus v2beta1ContainerResourceMetricStatus = (V2beta1ContainerResourceMetricStatus)o;
        return Objects.equals(this.container, v2beta1ContainerResourceMetricStatus.container) && Objects.equals(this.currentAverageUtilization, v2beta1ContainerResourceMetricStatus.currentAverageUtilization) && Objects.equals(this.currentAverageValue, v2beta1ContainerResourceMetricStatus.currentAverageValue) && Objects.equals(this.name, v2beta1ContainerResourceMetricStatus.name);
    }

    public int hashCode() {
        return Objects.hash(this.container, this.currentAverageUtilization, this.currentAverageValue, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V2beta1ContainerResourceMetricStatus {\n");
        sb.append("    container: ").append(this.toIndentedString(this.container)).append("\n");
        sb.append("    currentAverageUtilization: ").append(this.toIndentedString(this.currentAverageUtilization)).append("\n");
        sb.append("    currentAverageValue: ").append(this.toIndentedString(this.currentAverageValue)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

