/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.oidc.encryption;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class AESGCMEncryption {
    private static final String ENCRYPT_ALGO = "AES/GCM/NoPadding";
    private static final int TAG_LENGTH_BIT = 128;
    private static final int KEY_LENGTH = 256;
    private static final int SALT_LENGTH_BYTE = 16;
    private static final int KDF_ITERATIONS = 10000;
    private static final int IV_LENGTH_BYTE = 12;
    private static final Charset UTF_8 = StandardCharsets.UTF_8;
    private final SecureRandom secureRandom = new SecureRandom();

    private synchronized byte[] getRandomNonce(int numBytes) {
        byte[] nonce = new byte[numBytes];
        this.secureRandom.nextBytes(nonce);
        return nonce;
    }

    private SecretKey getAESKey(PrivateKey privateKey, byte[] salt) throws NoSuchAlgorithmException, InvalidKeySpecException {
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
        PBEKeySpec spec = new PBEKeySpec(Arrays.toString(privateKey.getEncoded()).toCharArray(), salt, 10000, 256);
        return new SecretKeySpec(factory.generateSecret(spec).getEncoded(), "AES");
    }

    public String encrypt(String original, PrivateKey privateKey) throws NoSuchPaddingException, InvalidAlgorithmParameterException, InvalidKeyException, NoSuchAlgorithmException, IllegalBlockSizeException, BadPaddingException, InvalidKeySpecException, ShortBufferException {
        byte[] iv = this.getRandomNonce(12);
        byte[] salt = this.getRandomNonce(16);
        SecretKey secretKey = this.getAESKey(privateKey, salt);
        Cipher cipher = Cipher.getInstance(ENCRYPT_ALGO);
        cipher.init(1, (Key)secretKey, new GCMParameterSpec(128, iv));
        cipher.updateAAD(iv);
        byte[] cipherText = cipher.doFinal(original.getBytes(UTF_8));
        return Base64.getEncoder().encodeToString(ByteBuffer.allocate(iv.length + salt.length + cipherText.length).put(iv).put(salt).put(cipherText).array());
    }

    public String decrypt(String encrypted, PrivateKey privateKey) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeySpecException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, InvalidKeyException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(Base64.getDecoder().decode(encrypted));
        byte[] iv = new byte[12];
        byte[] salt = new byte[16];
        byteBuffer.get(iv);
        byteBuffer.get(salt);
        byte[] cipherText = new byte[byteBuffer.remaining()];
        byteBuffer.get(cipherText);
        SecretKey secretKey = this.getAESKey(privateKey, salt);
        Cipher cipher = Cipher.getInstance(ENCRYPT_ALGO);
        cipher.init(2, (Key)secretKey, new GCMParameterSpec(128, iv));
        cipher.updateAAD(iv);
        return new String(cipher.doFinal(cipherText), StandardCharsets.UTF_8);
    }
}

