/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.oidc.encryption;

import io.confluent.common.Configurable;
import io.confluent.oidc.encryption.AESGCMEncryption;
import io.confluent.oidc.exceptions.EncryptionFailedException;
import io.confluent.tokenapi.jwt.JwsConfig;
import io.confluent.tokenapi.jwt.KeyPairHandler;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptionHandler
implements Configurable {
    private static final Logger log = LoggerFactory.getLogger(EncryptionHandler.class);
    private PrivateKey privateKey;
    private AESGCMEncryption aesgcmEncryption;

    public void configure(Map<String, ?> props) {
        JwsConfig jwsConfig = new JwsConfig(props);
        String tokenKeyPath = jwsConfig.getString("token.key.path");
        Path keyPairPath = Paths.get(tokenKeyPath, new String[0]);
        KeyPairHandler keyHandler = new KeyPairHandler(keyPairPath);
        this.privateKey = ((KeyPair)keyHandler.getKeyPairs().get(0)).getPrivate();
        this.aesgcmEncryption = new AESGCMEncryption();
    }

    public String encrypt(String payload) {
        try {
            return this.aesgcmEncryption.encrypt(payload, this.privateKey);
        }
        catch (Exception e) {
            log.error("Failed to encrypt given payload", (Throwable)e);
            throw new EncryptionFailedException("Failed to encrypt", e);
        }
    }

    public String decrypt(String cipherText) {
        try {
            return this.aesgcmEncryption.decrypt(cipherText, this.privateKey);
        }
        catch (Exception e) {
            log.error("Failed to decrypt given payload", (Throwable)e);
            throw new EncryptionFailedException("Failed to decrypt", e);
        }
    }
}

