/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.tools.recovery;

import io.confluent.kafka.tools.recovery.CheckpointConvertCommand;
import io.confluent.kafka.tools.recovery.CommandException;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.apache.kafka.common.utils.Exit;

final class MetadataRecoveryTool {
    private static final String COMMAND_POSITIONAL = "command";

    MetadataRecoveryTool() {
    }

    public static void main(String[] args) {
        Exit.exit((int)MetadataRecoveryTool.execute(args));
    }

    static int execute(String ... args) {
        Namespace namespace;
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"kafka-metadata-recovery").defaultHelp(true).description("this tool generates a KRaft checkpoint file from metadata records");
        Subparsers subparsers = parser.addSubparsers().dest(COMMAND_POSITIONAL).help("sub-command help");
        CheckpointConvertCommand.addCommand(subparsers);
        try {
            namespace = parser.parseArgs(args);
            if (namespace.getString(COMMAND_POSITIONAL).equals("checkpoint")) {
                return CheckpointConvertCommand.execute(namespace);
            }
        }
        catch (ArgumentParserException e) {
            parser.handleError(e);
            return 1;
        }
        catch (CommandException e) {
            System.err.println(e.getMessage());
            return e.statusCode();
        }
        throw new IllegalArgumentException(String.format("unknown command: %s", namespace));
    }
}

