/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.cellsadmincmd;

import io.confluent.kafka.clients.CloudAdmin;
import io.confluent.kafka.clients.DescribeCellsResult;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.apache.kafka.common.CellState;
import org.apache.kafka.common.message.DescribeCellsResponseData;
import org.apache.kafka.server.util.ToolsUtils;
import org.apache.kafka.tools.CloudAdminCommand;
import org.apache.kafka.tools.cellsadmincmd.CellsAdminCommand;

public class DescribeCellsCommand
implements CloudAdminCommand {
    public static final String[] OUTPUT_HEADERS = new String[]{"CellId", "State", "Brokers"};

    @Override
    public String name() {
        return "describe-cells";
    }

    @Override
    public void addSubparser(Subparsers subparsers) {
        Subparser parser = subparsers.addParser(this.name()).help("Describe the cells information in the cluster");
        parser.addArgument(new String[]{"--cell-ids"}).help("cell ids to describe separated by commas, an empty list describes all the cells in the cluster").action((ArgumentAction)Arguments.store()).type(String.class).required(false);
    }

    @Override
    public void execute(CloudAdmin admin, Namespace ns, PrintStream out) throws Exception {
        List cells;
        List<Integer> cellIds = CellsAdminCommand.getCellIdsFromArgs(ns);
        try {
            DescribeCellsResult result = admin.describeCells(cellIds);
            cells = ((DescribeCellsResponseData)result.value().get()).cells();
        }
        catch (ExecutionException e) {
            CellsAdminCommand.printErrorAndExit("Failed to describe cells", e.getCause());
            return;
        }
        ArrayList<String[]> rows = new ArrayList<String[]>();
        for (DescribeCellsResponseData.Cell cell : cells) {
            rows.add(new String[]{Integer.toString(cell.cellId()), CellState.toEnum((byte)cell.state()).name(), String.join((CharSequence)",", cell.brokers().stream().map(String::valueOf).collect(Collectors.toList()))});
        }
        ToolsUtils.prettyPrintTable((String[])OUTPUT_HEADERS, rows, (PrintStream)out);
    }
}

