"use strict";(self.wpJsonpConfluentControlCenter=self.wpJsonpConfluentControlCenter||[]).push([[208],{59787:(e,n,o)=>{o.r(n),o.d(n,{getDynamicProto:()=>i});const t={"google/type/calendar_period.proto":'// Copyright 2021 Google LLC\n//\n// Licensed under the Apache License, Version 2.0 (the "License");\n// you may not use this file except in compliance with the License.\n// You may obtain a copy of the License at\n//\n//     http://www.apache.org/licenses/LICENSE-2.0\n//\n// Unless required by applicable law or agreed to in writing, software\n// distributed under the License is distributed on an "AS IS" BASIS,\n// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n// See the License for the specific language governing permissions and\n// limitations under the License.\nsyntax = "proto3";\npackage google.type;\noption go_package = "google.golang.org/genproto/googleapis/type/calendarperiod;calendarperiod";\noption java_multiple_files = true;\noption java_outer_classname = "CalendarPeriodProto";\noption java_package = "com.google.type";\noption objc_class_prefix = "GTP";\nenum CalendarPeriod {\n  // Undefined period, raises an error.\n  CALENDAR_PERIOD_UNSPECIFIED = 0;\n  // A day.\n  DAY = 1;\n  // A week. Weeks begin on Monday, following\n  // [ISO 8601](https://en.wikipedia.org/wiki/ISO_week_date).\n  WEEK = 2;\n  // A fortnight. The first calendar fortnight of the year begins at the start\n  // of week 1 according to\n  // [ISO 8601](https://en.wikipedia.org/wiki/ISO_week_date).\n  FORTNIGHT = 3;\n  // A month.\n  MONTH = 4;\n  // A quarter. Quarters start on dates 1-Jan, 1-Apr, 1-Jul, and 1-Oct of each\n  // year.\n  QUARTER = 5;\n  // A half-year. Half-years start on dates 1-Jan and 1-Jul.\n  HALF = 6;\n  // A year.\n  YEAR = 7;\n}',"google/type/color.proto":'// Copyright 2021 Google LLC\n//\n// Licensed under the Apache License, Version 2.0 (the "License");\n// you may not use this file except in compliance with the License.\n// You may obtain a copy of the License at\n//\n//     http://www.apache.org/licenses/LICENSE-2.0\n//\n// Unless required by applicable law or agreed to in writing, software\n// distributed under the License is distributed on an "AS IS" BASIS,\n// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n// See the License for the specific language governing permissions and\n// limitations under the License.\nsyntax = "proto3";\npackage google.type;\nimport "google/protobuf/wrappers.proto";\noption cc_enable_arenas = true;\noption go_package = "google.golang.org/genproto/googleapis/type/color;color";\noption java_multiple_files = true;\noption java_outer_classname = "ColorProto";\noption java_package = "com.google.type";\noption objc_class_prefix = "GTP";\nmessage Color {\n  // The amount of red in the color as a value in the interval [0, 1].\n  float red = 1;\n  // The amount of green in the color as a value in the interval [0, 1].\n  float green = 2;\n  // The amount of blue in the color as a value in the interval [0, 1].\n  float blue = 3;\n  // The fraction of this color that should be applied to the pixel. That is,\n  // the final pixel color is defined by the equation:\n  //\n  //   `pixel color = alpha * (this color) + (1.0 - alpha) * (background color)`\n  //\n  // This means that a value of 1.0 corresponds to a solid color, whereas\n  // a value of 0.0 corresponds to a completely transparent color. This\n  // uses a wrapper message rather than a simple float scalar so that it is\n  // possible to distinguish between a default value and the value being unset.\n  // If omitted, this color object is rendered as a solid color\n  // (as if the alpha value had been explicitly given a value of 1.0).\n  google.protobuf.FloatValue alpha = 4;\n}',"google/type/date.proto":'// Copyright 2021 Google LLC\n//\n// Licensed under the Apache License, Version 2.0 (the "License");\n// you may not use this file except in compliance with the License.\n// You may obtain a copy of the License at\n//\n//     http://www.apache.org/licenses/LICENSE-2.0\n//\n// Unless required by applicable law or agreed to in writing, software\n// distributed under the License is distributed on an "AS IS" BASIS,\n// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n// See the License for the specific language governing permissions and\n// limitations under the License.\nsyntax = "proto3";\npackage google.type;\noption cc_enable_arenas = true;\noption go_package = "google.golang.org/genproto/googleapis/type/date;date";\noption java_multiple_files = true;\noption java_outer_classname = "DateProto";\noption java_package = "com.google.type";\noption objc_class_prefix = "GTP";\nmessage Date {\n  // Year of the date. Must be from 1 to 9999, or 0 to specify a date without\n  // a year.\n  int32 year = 1;\n  // Month of a year. Must be from 1 to 12, or 0 to specify a year without a\n  // month and day.\n  int32 month = 2;\n  // Day of a month. Must be from 1 to 31 and valid for the year and month, or 0\n  // to specify a year by itself or a year and month where the day isn\'t\n  // significant.\n  int32 day = 3;\n}',"google/type/datetime.proto":'// Copyright 2021 Google LLC\n//\n// Licensed under the Apache License, Version 2.0 (the "License");\n// you may not use this file except in compliance with the License.\n// You may obtain a copy of the License at\n//\n//     http://www.apache.org/licenses/LICENSE-2.0\n//\n// Unless required by applicable law or agreed to in writing, software\n// distributed under the License is distributed on an "AS IS" BASIS,\n// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n// See the License for the specific language governing permissions and\n// limitations under the License.\nsyntax = "proto3";\npackage google.type;\nimport "google/protobuf/duration.proto";\noption cc_enable_arenas = true;\noption go_package = "google.golang.org/genproto/googleapis/type/datetime;datetime";\noption java_multiple_files = true;\noption java_outer_classname = "DateTimeProto";\noption java_package = "com.google.type";\noption objc_class_prefix = "GTP";\nmessage DateTime {\n  // Optional. Year of date. Must be from 1 to 9999, or 0 if specifying a\n  // datetime without a year.\n  int32 year = 1;\n  // Required. Month of year. Must be from 1 to 12.\n  int32 month = 2;\n  // Required. Day of month. Must be from 1 to 31 and valid for the year and\n  // month.\n  int32 day = 3;\n  // Required. Hours of day in 24 hour format. Should be from 0 to 23. An API\n  // may choose to allow the value "24:00:00" for scenarios like business\n  // closing time.\n  int32 hours = 4;\n  // Required. Minutes of hour of day. Must be from 0 to 59.\n  int32 minutes = 5;\n  // Required. Seconds of minutes of the time. Must normally be from 0 to 59. An\n  // API may allow the value 60 if it allows leap-seconds.\n  int32 seconds = 6;\n  // Required. Fractions of seconds in nanoseconds. Must be from 0 to\n  // 999,999,999.\n  int32 nanos = 7;\n  // Optional. Specifies either the UTC offset or the time zone of the DateTime.\n  // Choose carefully between them, considering that time zone data may change\n  // in the future (for example, a country modifies their DST start/end dates,\n  // and future DateTimes in the affected range had already been stored).\n  // If omitted, the DateTime is considered to be in local time.\n  oneof time_offset {\n    // UTC offset. Must be whole seconds, between -18 hours and +18 hours.\n    // For example, a UTC offset of -4:00 would be represented as\n    // { seconds: -14400 }.\n    google.protobuf.Duration utc_offset = 8;\n    // Time zone.\n    TimeZone time_zone = 9;\n  }\n}\nmessage TimeZone {\n  // IANA Time Zone Database time zone, e.g. "America/New_York".\n  string id = 1;\n  // Optional. IANA Time Zone Database version number, e.g. "2019a".\n  string version = 2;\n}',"google/type/dayofweek.proto":'// Copyright 2021 Google LLC\n//\n// Licensed under the Apache License, Version 2.0 (the "License");\n// you may not use this file except in compliance with the License.\n// You may obtain a copy of the License at\n//\n//     http://www.apache.org/licenses/LICENSE-2.0\n//\n// Unless required by applicable law or agreed to in writing, software\n// distributed under the License is distributed on an "AS IS" BASIS,\n// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n// See the License for the specific language governing permissions and\n// limitations under the License.\nsyntax = "proto3";\npackage google.type;\noption go_package = "google.golang.org/genproto/googleapis/type/dayofweek;dayofweek";\noption java_multiple_files = true;\noption java_outer_classname = "DayOfWeekProto";\noption java_package = "com.google.type";\noption objc_class_prefix = "GTP";\nenum DayOfWeek {\n  // The day of the week is unspecified.\n  DAY_OF_WEEK_UNSPECIFIED = 0;\n  // Monday\n  MONDAY = 1;\n  // Tuesday\n  TUESDAY = 2;\n  // Wednesday\n  WEDNESDAY = 3;\n  // Thursday\n  THURSDAY = 4;\n  // Friday\n  FRIDAY = 5;\n  // Saturday\n  SATURDAY = 6;\n  // Sunday\n  SUNDAY = 7;\n}',"google/type/decimal.proto":"// Copyright 2021 Google LLC\n//\n// Licensed under the Apache License, Version 2.0 (the \"License\");\n// you may not use this file except in compliance with the License.\n// You may obtain a copy of the License at\n//\n//     http://www.apache.org/licenses/LICENSE-2.0\n//\n// Unless required by applicable law or agreed to in writing, software\n// distributed under the License is distributed on an \"AS IS\" BASIS,\n// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n// See the License for the specific language governing permissions and\n// limitations under the License.\nsyntax = \"proto3\";\npackage google.type;\noption cc_enable_arenas = true;\noption go_package = \"google.golang.org/genproto/googleapis/type/decimal;decimal\";\noption java_multiple_files = true;\noption java_outer_classname = \"DecimalProto\";\noption java_package = \"com.google.type\";\noption objc_class_prefix = \"GTP\";\nmessage Decimal {\n  // The decimal value, as a string.\n  //\n  // The string representation consists of an optional sign, `+` (`U+002B`)\n  // or `-` (`U+002D`), followed by a sequence of zero or more decimal digits\n  // (\"the integer\"), optionally followed by a fraction, optionally followed\n  // by an exponent.\n  //\n  // The fraction consists of a decimal point followed by zero or more decimal\n  // digits. The string must contain at least one digit in either the integer\n  // or the fraction. The number formed by the sign, the integer and the\n  // fraction is referred to as the significand.\n  //\n  // The exponent consists of the character `e` (`U+0065`) or `E` (`U+0045`)\n  // followed by one or more decimal digits.\n  //\n  // Services **should** normalize decimal values before storing them by:\n  //\n  //   - Removing an explicitly-provided `+` sign (`+2.5` -> `2.5`).\n  //   - Replacing a zero-length integer value with `0` (`.5` -> `0.5`).\n  //   - Coercing the exponent character to lower-case (`2.5E8` -> `2.5e8`).\n  //   - Removing an explicitly-provided zero exponent (`2.5e0` -> `2.5`).\n  //\n  // Services **may** perform additional normalization based on its own needs\n  // and the internal decimal implementation selected, such as shifting the\n  // decimal point and exponent value together (example: `2.5e-1` <-> `0.25`).\n  // Additionally, services **may** preserve trailing zeroes in the fraction\n  // to indicate increased precision, but are not required to do so.\n  //\n  // Note that only the `.` character is supported to divide the integer\n  // and the fraction; `,` **should not** be supported regardless of locale.\n  // Additionally, thousand separators **should not** be supported. If a\n  // service does support them, values **must** be normalized.\n  //\n  // The ENBF grammar is:\n  //\n  //     DecimalString =\n  //       [Sign] Significand [Exponent];\n  //\n  //     Sign = '+' | '-';\n  //\n  //     Significand =\n  //       Digits ['.'] [Digits] | [Digits] '.' Digits;\n  //\n  //     Exponent = ('e' | 'E') [Sign] Digits;\n  //\n  //     Digits = { '0' | '1' | '2' | '3' | '4' | '5' | '6' | '7' | '8' | '9' };\n  //\n  // Services **should** clearly document the range of supported values, the\n  // maximum supported precision (total number of digits), and, if applicable,\n  // the scale (number of digits after the decimal point), as well as how it\n  // behaves when receiving out-of-bounds values.\n  //\n  // Services **may** choose to accept values passed as input even when the\n  // value has a higher precision or scale than the service supports, and\n  // **should** round the value to fit the supported scale. Alternatively, the\n  // service **may** error with `400 Bad Request` (`INVALID_ARGUMENT` in gRPC)\n  // if precision would be lost.\n  //\n  // Services **should** error with `400 Bad Request` (`INVALID_ARGUMENT` in\n  // gRPC) if the service receives a value outside of the supported range.\n  string value = 1;\n}","google/type/expr.proto":'// Copyright 2021 Google LLC\n//\n// Licensed under the Apache License, Version 2.0 (the "License");\n// you may not use this file except in compliance with the License.\n// You may obtain a copy of the License at\n//\n//     http://www.apache.org/licenses/LICENSE-2.0\n//\n// Unless required by applicable law or agreed to in writing, software\n// distributed under the License is distributed on an "AS IS" BASIS,\n// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n// See the License for the specific language governing permissions and\n// limitations under the License.\nsyntax = "proto3";\npackage google.type;\noption go_package = "google.golang.org/genproto/googleapis/type/expr;expr";\noption java_multiple_files = true;\noption java_outer_classname = "ExprProto";\noption java_package = "com.google.type";\noption objc_class_prefix = "GTP";\nmessage Expr {\n  // Textual representation of an expression in Common Expression Language\n  // syntax.\n  string expression = 1;\n  // Optional. Title for the expression, i.e. a short string describing\n  // its purpose. This can be used e.g. in UIs which allow to enter the\n  // expression.\n  string title = 2;\n  // Optional. Description of the expression. This is a longer text which\n  // describes the expression, e.g. when hovered over it in a UI.\n  string description = 3;\n  // Optional. String indicating the location of the expression for error\n  // reporting, e.g. a file name and a position in the file.\n  string location = 4;\n}',"google/type/fraction.proto":'// Copyright 2021 Google LLC\n//\n// Licensed under the Apache License, Version 2.0 (the "License");\n// you may not use this file except in compliance with the License.\n// You may obtain a copy of the License at\n//\n//     http://www.apache.org/licenses/LICENSE-2.0\n//\n// Unless required by applicable law or agreed to in writing, software\n// distributed under the License is distributed on an "AS IS" BASIS,\n// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n// See the License for the specific language governing permissions and\n// limitations under the License.\nsyntax = "proto3";\npackage google.type;\noption go_package = "google.golang.org/genproto/googleapis/type/fraction;fraction";\noption java_multiple_files = true;\noption java_outer_classname = "FractionProto";\noption java_package = "com.google.type";\noption objc_class_prefix = "GTP";\nmessage Fraction {\n  // The numerator in the fraction, e.g. 2 in 2/3.\n  int64 numerator = 1;\n  // The value by which the numerator is divided, e.g. 3 in 2/3. Must be\n  // positive.\n  int64 denominator = 2;\n}',"google/type/interval.proto":'// Copyright 2021 Google LLC\n//\n// Licensed under the Apache License, Version 2.0 (the "License");\n// you may not use this file except in compliance with the License.\n// You may obtain a copy of the License at\n//\n//     http://www.apache.org/licenses/LICENSE-2.0\n//\n// Unless required by applicable law or agreed to in writing, software\n// distributed under the License is distributed on an "AS IS" BASIS,\n// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n// See the License for the specific language governing permissions and\n// limitations under the License.\nsyntax = "proto3";\npackage google.type;\nimport "google/protobuf/timestamp.proto";\noption cc_enable_arenas = true;\noption go_package = "google.golang.org/genproto/googleapis/type/interval;interval";\noption java_multiple_files = true;\noption java_outer_classname = "IntervalProto";\noption java_package = "com.google.type";\noption objc_class_prefix = "GTP";\nmessage Interval {\n  // Optional. Inclusive start of the interval.\n  //\n  // If specified, a Timestamp matching this interval will have to be the same\n  // or after the start.\n  google.protobuf.Timestamp start_time = 1;\n  // Optional. Exclusive end of the interval.\n  //\n  // If specified, a Timestamp matching this interval will have to be before the\n  // end.\n  google.protobuf.Timestamp end_time = 2;\n}',"google/type/latlng.proto":'// Copyright 2021 Google LLC\n//\n// Licensed under the Apache License, Version 2.0 (the "License");\n// you may not use this file except in compliance with the License.\n// You may obtain a copy of the License at\n//\n//     http://www.apache.org/licenses/LICENSE-2.0\n//\n// Unless required by applicable law or agreed to in writing, software\n// distributed under the License is distributed on an "AS IS" BASIS,\n// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n// See the License for the specific language governing permissions and\n// limitations under the License.\nsyntax = "proto3";\npackage google.type;\noption cc_enable_arenas = true;\noption go_package = "google.golang.org/genproto/googleapis/type/latlng;latlng";\noption java_multiple_files = true;\noption java_outer_classname = "LatLngProto";\noption java_package = "com.google.type";\noption objc_class_prefix = "GTP";\nmessage LatLng {\n  // The latitude in degrees. It must be in the range [-90.0, +90.0].\n  double latitude = 1;\n  // The longitude in degrees. It must be in the range [-180.0, +180.0].\n  double longitude = 2;\n}',"google/type/money.proto":'// Copyright 2021 Google LLC\n//\n// Licensed under the Apache License, Version 2.0 (the "License");\n// you may not use this file except in compliance with the License.\n// You may obtain a copy of the License at\n//\n//     http://www.apache.org/licenses/LICENSE-2.0\n//\n// Unless required by applicable law or agreed to in writing, software\n// distributed under the License is distributed on an "AS IS" BASIS,\n// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n// See the License for the specific language governing permissions and\n// limitations under the License.\nsyntax = "proto3";\npackage google.type;\noption cc_enable_arenas = true;\noption go_package = "google.golang.org/genproto/googleapis/type/money;money";\noption java_multiple_files = true;\noption java_outer_classname = "MoneyProto";\noption java_package = "com.google.type";\noption objc_class_prefix = "GTP";\nmessage Money {\n  // The three-letter currency code defined in ISO 4217.\n  string currency_code = 1;\n  // The whole units of the amount.\n  // For example if `currencyCode` is `"USD"`, then 1 unit is one US dollar.\n  int64 units = 2;\n  // Number of nano (10^-9) units of the amount.\n  // The value must be between -999,999,999 and +999,999,999 inclusive.\n  // If `units` is positive, `nanos` must be positive or zero.\n  // If `units` is zero, `nanos` can be positive, zero, or negative.\n  // If `units` is negative, `nanos` must be negative or zero.\n  // For example $-1.75 is represented as `units`=-1 and `nanos`=-750,000,000.\n  int32 nanos = 3;\n}',"google/type/month.proto":'// Copyright 2021 Google LLC\n//\n// Licensed under the Apache License, Version 2.0 (the "License");\n// you may not use this file except in compliance with the License.\n// You may obtain a copy of the License at\n//\n//     http://www.apache.org/licenses/LICENSE-2.0\n//\n// Unless required by applicable law or agreed to in writing, software\n// distributed under the License is distributed on an "AS IS" BASIS,\n// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n// See the License for the specific language governing permissions and\n// limitations under the License.\nsyntax = "proto3";\npackage google.type;\noption go_package = "google.golang.org/genproto/googleapis/type/month;month";\noption java_multiple_files = true;\noption java_outer_classname = "MonthProto";\noption java_package = "com.google.type";\noption objc_class_prefix = "GTP";\nenum Month {\n  // The unspecified month.\n  MONTH_UNSPECIFIED = 0;\n  // The month of January.\n  JANUARY = 1;\n  // The month of February.\n  FEBRUARY = 2;\n  // The month of March.\n  MARCH = 3;\n  // The month of April.\n  APRIL = 4;\n  // The month of May.\n  MAY = 5;\n  // The month of June.\n  JUNE = 6;\n  // The month of July.\n  JULY = 7;\n  // The month of August.\n  AUGUST = 8;\n  // The month of September.\n  SEPTEMBER = 9;\n  // The month of October.\n  OCTOBER = 10;\n  // The month of November.\n  NOVEMBER = 11;\n  // The month of December.\n  DECEMBER = 12;\n}',"google/type/phone_number.proto":'// Copyright 2021 Google LLC\n//\n// Licensed under the Apache License, Version 2.0 (the "License");\n// you may not use this file except in compliance with the License.\n// You may obtain a copy of the License at\n//\n//     http://www.apache.org/licenses/LICENSE-2.0\n//\n// Unless required by applicable law or agreed to in writing, software\n// distributed under the License is distributed on an "AS IS" BASIS,\n// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n// See the License for the specific language governing permissions and\n// limitations under the License.\nsyntax = "proto3";\npackage google.type;\noption cc_enable_arenas = true;\noption go_package = "google.golang.org/genproto/googleapis/type/phone_number;phone_number";\noption java_multiple_files = true;\noption java_outer_classname = "PhoneNumberProto";\noption java_package = "com.google.type";\noption objc_class_prefix = "GTP";\nmessage PhoneNumber {\n  // An object representing a short code, which is a phone number that is\n  // typically much shorter than regular phone numbers and can be used to\n  // address messages in MMS and SMS systems, as well as for abbreviated dialing\n  // (e.g. "Text 611 to see how many minutes you have remaining on your plan.").\n  //\n  // Short codes are restricted to a region and are not internationally\n  // dialable, which means the same short code can exist in different regions,\n  // with different usage and pricing, even if those regions share the same\n  // country calling code (e.g. US and CA).\n  message ShortCode {\n    // Required. The BCP-47 region code of the location where calls to this\n    // short code can be made, such as "US" and "BB".\n    //\n    // Reference(s):\n    //  - http://www.unicode.org/reports/tr35/#unicode_region_subtag\n    string region_code = 1;\n    // Required. The short code digits, without a leading plus (\'+\') or country\n    // calling code, e.g. "611".\n    string number = 2;\n  }\n  // Required.  Either a regular number, or a short code.  New fields may be\n  // added to the oneof below in the future, so clients should ignore phone\n  // numbers for which none of the fields they coded against are set.\n  oneof kind {\n    // The phone number, represented as a leading plus sign (\'+\'), followed by a\n    // phone number that uses a relaxed ITU E.164 format consisting of the\n    // country calling code (1 to 3 digits) and the subscriber number, with no\n    // additional spaces or formatting, e.g.:\n    //  - correct: "+15552220123"\n    //  - incorrect: "+1 (555) 222-01234 x123".\n    //\n    // The ITU E.164 format limits the latter to 12 digits, but in practice not\n    // all countries respect that, so we relax that restriction here.\n    // National-only numbers are not allowed.\n    //\n    // References:\n    //  - https://www.itu.int/rec/T-REC-E.164-201011-I\n    //  - https://en.wikipedia.org/wiki/E.164.\n    //  - https://en.wikipedia.org/wiki/List_of_country_calling_codes\n    string e164_number = 1;\n    // A short code.\n    //\n    // Reference(s):\n    //  - https://en.wikipedia.org/wiki/Short_code\n    ShortCode short_code = 2;\n  }\n  // The phone number\'s extension. The extension is not standardized in ITU\n  // recommendations, except for being defined as a series of numbers with a\n  // maximum length of 40 digits. Other than digits, some other dialing\n  // characters such as \',\' (indicating a wait) or \'#\' may be stored here.\n  //\n  // Note that no regions currently use extensions with short codes, so this\n  // field is normally only set in conjunction with an E.164 number. It is held\n  // separately from the E.164 number to allow for short code extensions in the\n  // future.\n  string extension = 3;\n}',"google/type/postal_address.proto":'// Copyright 2021 Google LLC\n//\n// Licensed under the Apache License, Version 2.0 (the "License");\n// you may not use this file except in compliance with the License.\n// You may obtain a copy of the License at\n//\n//     http://www.apache.org/licenses/LICENSE-2.0\n//\n// Unless required by applicable law or agreed to in writing, software\n// distributed under the License is distributed on an "AS IS" BASIS,\n// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n// See the License for the specific language governing permissions and\n// limitations under the License.\nsyntax = "proto3";\npackage google.type;\noption cc_enable_arenas = true;\noption go_package = "google.golang.org/genproto/googleapis/type/postaladdress;postaladdress";\noption java_multiple_files = true;\noption java_outer_classname = "PostalAddressProto";\noption java_package = "com.google.type";\noption objc_class_prefix = "GTP";\nmessage PostalAddress {\n  // The schema revision of the `PostalAddress`. This must be set to 0, which is\n  // the latest revision.\n  //\n  // All new revisions **must** be backward compatible with old revisions.\n  int32 revision = 1;\n  // Required. CLDR region code of the country/region of the address. This\n  // is never inferred and it is up to the user to ensure the value is\n  // correct. See http://cldr.unicode.org/ and\n  // http://www.unicode.org/cldr/charts/30/supplemental/territory_information.html\n  // for details. Example: "CH" for Switzerland.\n  string region_code = 2;\n  // Optional. BCP-47 language code of the contents of this address (if\n  // known). This is often the UI language of the input form or is expected\n  // to match one of the languages used in the address\' country/region, or their\n  // transliterated equivalents.\n  // This can affect formatting in certain countries, but is not critical\n  // to the correctness of the data and will never affect any validation or\n  // other non-formatting related operations.\n  //\n  // If this value is not known, it should be omitted (rather than specifying a\n  // possibly incorrect default).\n  //\n  // Examples: "zh-Hant", "ja", "ja-Latn", "en".\n  string language_code = 3;\n  // Optional. Postal code of the address. Not all countries use or require\n  // postal codes to be present, but where they are used, they may trigger\n  // additional validation with other parts of the address (e.g. state/zip\n  // validation in the U.S.A.).\n  string postal_code = 4;\n  // Optional. Additional, country-specific, sorting code. This is not used\n  // in most regions. Where it is used, the value is either a string like\n  // "CEDEX", optionally followed by a number (e.g. "CEDEX 7"), or just a number\n  // alone, representing the "sector code" (Jamaica), "delivery area indicator"\n  // (Malawi) or "post office indicator" (e.g. Côte d\'Ivoire).\n  string sorting_code = 5;\n  // Optional. Highest administrative subdivision which is used for postal\n  // addresses of a country or region.\n  // For example, this can be a state, a province, an oblast, or a prefecture.\n  // Specifically, for Spain this is the province and not the autonomous\n  // community (e.g. "Barcelona" and not "Catalonia").\n  // Many countries don\'t use an administrative area in postal addresses. E.g.\n  // in Switzerland this should be left unpopulated.\n  string administrative_area = 6;\n  // Optional. Generally refers to the city/town portion of the address.\n  // Examples: US city, IT comune, UK post town.\n  // In regions of the world where localities are not well defined or do not fit\n  // into this structure well, leave locality empty and use address_lines.\n  string locality = 7;\n  // Optional. Sublocality of the address.\n  // For example, this can be neighborhoods, boroughs, districts.\n  string sublocality = 8;\n  // Unstructured address lines describing the lower levels of an address.\n  //\n  // Because values in address_lines do not have type information and may\n  // sometimes contain multiple values in a single field (e.g.\n  // "Austin, TX"), it is important that the line order is clear. The order of\n  // address lines should be "envelope order" for the country/region of the\n  // address. In places where this can vary (e.g. Japan), address_language is\n  // used to make it explicit (e.g. "ja" for large-to-small ordering and\n  // "ja-Latn" or "en" for small-to-large). This way, the most specific line of\n  // an address can be selected based on the language.\n  //\n  // The minimum permitted structural representation of an address consists\n  // of a region_code with all remaining information placed in the\n  // address_lines. It would be possible to format such an address very\n  // approximately without geocoding, but no semantic reasoning could be\n  // made about any of the address components until it was at least\n  // partially resolved.\n  //\n  // Creating an address only containing a region_code and address_lines, and\n  // then geocoding is the recommended way to handle completely unstructured\n  // addresses (as opposed to guessing which parts of the address should be\n  // localities or administrative areas).\n  repeated string address_lines = 9;\n  // Optional. The recipient at the address.\n  // This field may, under certain circumstances, contain multiline information.\n  // For example, it might contain "care of" information.\n  repeated string recipients = 10;\n  // Optional. The name of the organization at the address.\n  string organization = 11;\n}',"google/type/quaternion.proto":'// Copyright 2021 Google LLC\n//\n// Licensed under the Apache License, Version 2.0 (the "License");\n// you may not use this file except in compliance with the License.\n// You may obtain a copy of the License at\n//\n//     http://www.apache.org/licenses/LICENSE-2.0\n//\n// Unless required by applicable law or agreed to in writing, software\n// distributed under the License is distributed on an "AS IS" BASIS,\n// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n// See the License for the specific language governing permissions and\n// limitations under the License.\nsyntax = "proto3";\npackage google.type;\noption cc_enable_arenas = true;\noption go_package = "google.golang.org/genproto/googleapis/type/quaternion;quaternion";\noption java_multiple_files = true;\noption java_outer_classname = "QuaternionProto";\noption java_package = "com.google.type";\noption objc_class_prefix = "GTP";\nmessage Quaternion {\n  // The x component.\n  double x = 1;\n  // The y component.\n  double y = 2;\n  // The z component.\n  double z = 3;\n  // The scalar component.\n  double w = 4;\n}',"google/type/timeofday.proto":'// Copyright 2021 Google LLC\n//\n// Licensed under the Apache License, Version 2.0 (the "License");\n// you may not use this file except in compliance with the License.\n// You may obtain a copy of the License at\n//\n//     http://www.apache.org/licenses/LICENSE-2.0\n//\n// Unless required by applicable law or agreed to in writing, software\n// distributed under the License is distributed on an "AS IS" BASIS,\n// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n// See the License for the specific language governing permissions and\n// limitations under the License.\nsyntax = "proto3";\npackage google.type;\noption cc_enable_arenas = true;\noption go_package = "google.golang.org/genproto/googleapis/type/timeofday;timeofday";\noption java_multiple_files = true;\noption java_outer_classname = "TimeOfDayProto";\noption java_package = "com.google.type";\noption objc_class_prefix = "GTP";\nmessage TimeOfDay {\n  // Hours of day in 24 hour format. Should be from 0 to 23. An API may choose\n  // to allow the value "24:00:00" for scenarios like business closing time.\n  int32 hours = 1;\n  // Minutes of hour of day. Must be from 0 to 59.\n  int32 minutes = 2;\n  // Seconds of minutes of the time. Must normally be from 0 to 59. An API may\n  // allow the value 60 if it allows leap-seconds.\n  int32 seconds = 3;\n  // Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.\n  int32 nanos = 4;\n}',"google/protobuf/any.proto":'// Protocol Buffers - Google\'s data interchange format\n// Copyright 2008 Google Inc.  All rights reserved.\n// https://developers.google.com/protocol-buffers/\n//\n// Redistribution and use in source and binary forms, with or without\n// modification, are permitted provided that the following conditions are\n// met:\n//\n//     * Redistributions of source code must retain the above copyright\n// notice, this list of conditions and the following disclaimer.\n//     * Redistributions in binary form must reproduce the above\n// copyright notice, this list of conditions and the following disclaimer\n// in the documentation and/or other materials provided with the\n// distribution.\n//     * Neither the name of Google Inc. nor the names of its\n// contributors may be used to endorse or promote products derived from\n// this software without specific prior written permission.\n//\n// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS\n// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT\n// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\n// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT\n// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,\n// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT\n// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\n// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\n// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\n// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\nsyntax = "proto3";\npackage google.protobuf;\noption csharp_namespace = "Google.Protobuf.WellKnownTypes";\noption go_package = "google.golang.org/protobuf/types/known/anypb";\noption java_package = "com.google.protobuf";\noption java_outer_classname = "AnyProto";\noption java_multiple_files = true;\noption objc_class_prefix = "GPB";\nmessage Any {\n  // A URL/resource name that uniquely identifies the type of the serialized\n  // protocol buffer message. This string must contain at least\n  // one "/" character. The last segment of the URL\'s path must represent\n  // the fully qualified name of the type (as in\n  // `path/google.protobuf.Duration`). The name should be in a canonical form\n  // (e.g., leading "." is not accepted).\n  //\n  // In practice, teams usually precompile into the binary all types that they\n  // expect it to use in the context of Any. However, for URLs which use the\n  // scheme `http`, `https`, or no scheme, one can optionally set up a type\n  // server that maps type URLs to message definitions as follows:\n  //\n  // * If no scheme is provided, `https` is assumed.\n  // * An HTTP GET on the URL must yield a [google.protobuf.Type][]\n  //   value in binary format, or produce an error.\n  // * Applications are allowed to cache lookup results based on the\n  //   URL, or have them precompiled into a binary to avoid any\n  //   lookup. Therefore, binary compatibility needs to be preserved\n  //   on changes to types. (Use versioned type names to manage\n  //   breaking changes.)\n  //\n  // Note: this functionality is not currently available in the official\n  // protobuf release, and it is not used for type URLs beginning with\n  // type.googleapis.com.\n  //\n  // Schemes other than `http`, `https` (or the empty scheme) might be\n  // used with implementation specific semantics.\n  //\n  string type_url = 1;\n  // Must be a valid serialized protocol buffer of the above specified type.\n  bytes value = 2;\n}',"google/protobuf/api.proto":'// Protocol Buffers - Google\'s data interchange format\n// Copyright 2008 Google Inc.  All rights reserved.\n// https://developers.google.com/protocol-buffers/\n//\n// Redistribution and use in source and binary forms, with or without\n// modification, are permitted provided that the following conditions are\n// met:\n//\n//     * Redistributions of source code must retain the above copyright\n// notice, this list of conditions and the following disclaimer.\n//     * Redistributions in binary form must reproduce the above\n// copyright notice, this list of conditions and the following disclaimer\n// in the documentation and/or other materials provided with the\n// distribution.\n//     * Neither the name of Google Inc. nor the names of its\n// contributors may be used to endorse or promote products derived from\n// this software without specific prior written permission.\n//\n// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS\n// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT\n// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\n// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT\n// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,\n// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT\n// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\n// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\n// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\n// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\nsyntax = "proto3";\npackage google.protobuf;\nimport "google/protobuf/source_context.proto";\nimport "google/protobuf/type.proto";\noption csharp_namespace = "Google.Protobuf.WellKnownTypes";\noption java_package = "com.google.protobuf";\noption java_outer_classname = "ApiProto";\noption java_multiple_files = true;\noption objc_class_prefix = "GPB";\noption go_package = "google.golang.org/protobuf/types/known/apipb";\nmessage Api {\n  // The fully qualified name of this interface, including package name\n  // followed by the interface\'s simple name.\n  string name = 1;\n  // The methods of this interface, in unspecified order.\n  repeated Method methods = 2;\n  // Any metadata attached to the interface.\n  repeated Option options = 3;\n  // A version string for this interface. If specified, must have the form\n  // `major-version.minor-version`, as in `1.10`. If the minor version is\n  // omitted, it defaults to zero. If the entire version field is empty, the\n  // major version is derived from the package name, as outlined below. If the\n  // field is not empty, the version in the package name will be verified to be\n  // consistent with what is provided here.\n  //\n  // The versioning schema uses [semantic\n  // versioning](http://semver.org) where the major version number\n  // indicates a breaking change and the minor version an additive,\n  // non-breaking change. Both version numbers are signals to users\n  // what to expect from different versions, and should be carefully\n  // chosen based on the product plan.\n  //\n  // The major version is also reflected in the package name of the\n  // interface, which must end in `v<major-version>`, as in\n  // `google.feature.v1`. For major versions 0 and 1, the suffix can\n  // be omitted. Zero major versions must only be used for\n  // experimental, non-GA interfaces.\n  //\n  //\n  string version = 4;\n  // Source context for the protocol buffer service represented by this\n  // message.\n  SourceContext source_context = 5;\n  // Included interfaces. See [Mixin][].\n  repeated Mixin mixins = 6;\n  // The source syntax of the service.\n  Syntax syntax = 7;\n}\nmessage Method {\n  // The simple name of this method.\n  string name = 1;\n  // A URL of the input message type.\n  string request_type_url = 2;\n  // If true, the request is streamed.\n  bool request_streaming = 3;\n  // The URL of the output message type.\n  string response_type_url = 4;\n  // If true, the response is streamed.\n  bool response_streaming = 5;\n  // Any metadata attached to the method.\n  repeated Option options = 6;\n  // The source syntax of this method.\n  Syntax syntax = 7;\n}\nmessage Mixin {\n  // The fully qualified name of the interface which is included.\n  string name = 1;\n  // If non-empty specifies a path under which inherited HTTP paths\n  // are rooted.\n  string root = 2;\n}',"google/protobuf/descriptor.proto":'// Protocol Buffers - Google\'s data interchange format\n// Copyright 2008 Google Inc.  All rights reserved.\n// https://developers.google.com/protocol-buffers/\n//\n// Redistribution and use in source and binary forms, with or without\n// modification, are permitted provided that the following conditions are\n// met:\n//\n//     * Redistributions of source code must retain the above copyright\n// notice, this list of conditions and the following disclaimer.\n//     * Redistributions in binary form must reproduce the above\n// copyright notice, this list of conditions and the following disclaimer\n// in the documentation and/or other materials provided with the\n// distribution.\n//     * Neither the name of Google Inc. nor the names of its\n// contributors may be used to endorse or promote products derived from\n// this software without specific prior written permission.\n//\n// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS\n// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT\n// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\n// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT\n// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,\n// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT\n// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\n// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\n// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\n// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n// Author: kenton@google.com (Kenton Varda)\n//  Based on original Protocol Buffers design by\n//  Sanjay Ghemawat, Jeff Dean, and others.\n//\n// The messages in this file describe the definitions found in .proto files.\n// A valid .proto file can be translated directly to a FileDescriptorProto\n// without any other information (e.g. without reading its imports).\nsyntax = "proto2";\npackage google.protobuf;\noption go_package = "google.golang.org/protobuf/types/descriptorpb";\noption java_package = "com.google.protobuf";\noption java_outer_classname = "DescriptorProtos";\noption csharp_namespace = "Google.Protobuf.Reflection";\noption objc_class_prefix = "GPB";\noption cc_enable_arenas = true;\noption optimize_for = SPEED;\nmessage FileDescriptorSet {\n  repeated FileDescriptorProto file = 1;\n}\nmessage FileDescriptorProto {\n  optional string name = 1;     // file name, relative to root of source tree\n  optional string package = 2;  // e.g. "foo", "foo.bar", etc.\n  // Names of files imported by this file.\n  repeated string dependency = 3;\n  // Indexes of the public imported files in the dependency list above.\n  repeated int32 public_dependency = 10;\n  // Indexes of the weak imported files in the dependency list.\n  // For Google-internal migration only. Do not use.\n  repeated int32 weak_dependency = 11;\n  // All top-level definitions in this file.\n  repeated DescriptorProto message_type = 4;\n  repeated EnumDescriptorProto enum_type = 5;\n  repeated ServiceDescriptorProto service = 6;\n  repeated FieldDescriptorProto extension = 7;\n  optional FileOptions options = 8;\n  // This field contains optional information about the original source code.\n  // You may safely remove this entire field without harming runtime\n  // functionality of the descriptors -- the information is needed only by\n  // development tools.\n  optional SourceCodeInfo source_code_info = 9;\n  // The syntax of the proto file.\n  // The supported values are "proto2", "proto3", and "editions".\n  //\n  // If `edition` is present, this value must be "editions".\n  optional string syntax = 12;\n  // The edition of the proto file, which is an opaque string.\n  optional string edition = 13;\n}\nmessage DescriptorProto {\n  optional string name = 1;\n  repeated FieldDescriptorProto field = 2;\n  repeated FieldDescriptorProto extension = 6;\n  repeated DescriptorProto nested_type = 3;\n  repeated EnumDescriptorProto enum_type = 4;\n  message ExtensionRange {\n    optional int32 start = 1;  // Inclusive.\n    optional int32 end = 2;    // Exclusive.\n    optional ExtensionRangeOptions options = 3;\n  }\n  repeated ExtensionRange extension_range = 5;\n  repeated OneofDescriptorProto oneof_decl = 8;\n  optional MessageOptions options = 7;\n  // Range of reserved tag numbers. Reserved tag numbers may not be used by\n  // fields or extension ranges in the same message. Reserved ranges may\n  // not overlap.\n  message ReservedRange {\n    optional int32 start = 1;  // Inclusive.\n    optional int32 end = 2;    // Exclusive.\n  }\n  repeated ReservedRange reserved_range = 9;\n  // Reserved field names, which may not be used by fields in the same message.\n  // A given name may only be reserved once.\n  repeated string reserved_name = 10;\n}\nmessage ExtensionRangeOptions {\n  // The parser stores options it doesn\'t recognize here. See above.\n  repeated UninterpretedOption uninterpreted_option = 999;\n  // Clients can define custom options in extensions of this message. See above.\n  extensions 1000 to max;\n}\nmessage FieldDescriptorProto {\n  enum Type {\n    // 0 is reserved for errors.\n    // Order is weird for historical reasons.\n    TYPE_DOUBLE = 1;\n    TYPE_FLOAT = 2;\n    // Not ZigZag encoded.  Negative numbers take 10 bytes.  Use TYPE_SINT64 if\n    // negative values are likely.\n    TYPE_INT64 = 3;\n    TYPE_UINT64 = 4;\n    // Not ZigZag encoded.  Negative numbers take 10 bytes.  Use TYPE_SINT32 if\n    // negative values are likely.\n    TYPE_INT32 = 5;\n    TYPE_FIXED64 = 6;\n    TYPE_FIXED32 = 7;\n    TYPE_BOOL = 8;\n    TYPE_STRING = 9;\n    // Tag-delimited aggregate.\n    // Group type is deprecated and not supported in proto3. However, Proto3\n    // implementations should still be able to parse the group wire format and\n    // treat group fields as unknown fields.\n    TYPE_GROUP = 10;\n    TYPE_MESSAGE = 11;  // Length-delimited aggregate.\n    // New in version 2.\n    TYPE_BYTES = 12;\n    TYPE_UINT32 = 13;\n    TYPE_ENUM = 14;\n    TYPE_SFIXED32 = 15;\n    TYPE_SFIXED64 = 16;\n    TYPE_SINT32 = 17;  // Uses ZigZag encoding.\n    TYPE_SINT64 = 18;  // Uses ZigZag encoding.\n  }\n  enum Label {\n    // 0 is reserved for errors\n    LABEL_OPTIONAL = 1;\n    LABEL_REQUIRED = 2;\n    LABEL_REPEATED = 3;\n  }\n  optional string name = 1;\n  optional int32 number = 3;\n  optional Label label = 4;\n  // If type_name is set, this need not be set.  If both this and type_name\n  // are set, this must be one of TYPE_ENUM, TYPE_MESSAGE or TYPE_GROUP.\n  optional Type type = 5;\n  // For message and enum types, this is the name of the type.  If the name\n  // starts with a \'.\', it is fully-qualified.  Otherwise, C++-like scoping\n  // rules are used to find the type (i.e. first the nested types within this\n  // message are searched, then within the parent, on up to the root\n  // namespace).\n  optional string type_name = 6;\n  // For extensions, this is the name of the type being extended.  It is\n  // resolved in the same manner as type_name.\n  optional string extendee = 2;\n  // For numeric types, contains the original text representation of the value.\n  // For booleans, "true" or "false".\n  // For strings, contains the default text contents (not escaped in any way).\n  // For bytes, contains the C escaped value.  All bytes >= 128 are escaped.\n  optional string default_value = 7;\n  // If set, gives the index of a oneof in the containing type\'s oneof_decl\n  // list.  This field is a member of that oneof.\n  optional int32 oneof_index = 9;\n  // JSON name of this field. The value is set by protocol compiler. If the\n  // user has set a "json_name" option on this field, that option\'s value\n  // will be used. Otherwise, it\'s deduced from the field\'s name by converting\n  // it to camelCase.\n  optional string json_name = 10;\n  optional FieldOptions options = 8;\n  // If true, this is a proto3 "optional". When a proto3 field is optional, it\n  // tracks presence regardless of field type.\n  //\n  // When proto3_optional is true, this field must be belong to a oneof to\n  // signal to old proto3 clients that presence is tracked for this field. This\n  // oneof is known as a "synthetic" oneof, and this field must be its sole\n  // member (each proto3 optional field gets its own synthetic oneof). Synthetic\n  // oneofs exist in the descriptor only, and do not generate any API. Synthetic\n  // oneofs must be ordered after all "real" oneofs.\n  //\n  // For message fields, proto3_optional doesn\'t create any semantic change,\n  // since non-repeated message fields always track presence. However it still\n  // indicates the semantic detail of whether the user wrote "optional" or not.\n  // This can be useful for round-tripping the .proto file. For consistency we\n  // give message fields a synthetic oneof also, even though it is not required\n  // to track presence. This is especially important because the parser can\'t\n  // tell if a field is a message or an enum, so it must always create a\n  // synthetic oneof.\n  //\n  // Proto2 optional fields do not set this flag, because they already indicate\n  // optional with `LABEL_OPTIONAL`.\n  optional bool proto3_optional = 17;\n}\nmessage OneofDescriptorProto {\n  optional string name = 1;\n  optional OneofOptions options = 2;\n}\nmessage EnumDescriptorProto {\n  optional string name = 1;\n  repeated EnumValueDescriptorProto value = 2;\n  optional EnumOptions options = 3;\n  // Range of reserved numeric values. Reserved values may not be used by\n  // entries in the same enum. Reserved ranges may not overlap.\n  //\n  // Note that this is distinct from DescriptorProto.ReservedRange in that it\n  // is inclusive such that it can appropriately represent the entire int32\n  // domain.\n  message EnumReservedRange {\n    optional int32 start = 1;  // Inclusive.\n    optional int32 end = 2;    // Inclusive.\n  }\n  // Range of reserved numeric values. Reserved numeric values may not be used\n  // by enum values in the same enum declaration. Reserved ranges may not\n  // overlap.\n  repeated EnumReservedRange reserved_range = 4;\n  // Reserved enum value names, which may not be reused. A given name may only\n  // be reserved once.\n  repeated string reserved_name = 5;\n}\nmessage EnumValueDescriptorProto {\n  optional string name = 1;\n  optional int32 number = 2;\n  optional EnumValueOptions options = 3;\n}\nmessage ServiceDescriptorProto {\n  optional string name = 1;\n  repeated MethodDescriptorProto method = 2;\n  optional ServiceOptions options = 3;\n}\nmessage MethodDescriptorProto {\n  optional string name = 1;\n  // Input and output type names.  These are resolved in the same way as\n  // FieldDescriptorProto.type_name, but must refer to a message type.\n  optional string input_type = 2;\n  optional string output_type = 3;\n  optional MethodOptions options = 4;\n  // Identifies if client streams multiple client messages\n  optional bool client_streaming = 5 [default = false];\n  // Identifies if server streams multiple server messages\n  optional bool server_streaming = 6 [default = false];\n}\nmessage FileOptions {\n  // Sets the Java package where classes generated from this .proto will be\n  // placed.  By default, the proto package is used, but this is often\n  // inappropriate because proto packages do not normally start with backwards\n  // domain names.\n  optional string java_package = 1;\n  // Controls the name of the wrapper Java class generated for the .proto file.\n  // That class will always contain the .proto file\'s getDescriptor() method as\n  // well as any top-level extensions defined in the .proto file.\n  // If java_multiple_files is disabled, then all the other classes from the\n  // .proto file will be nested inside the single wrapper outer class.\n  optional string java_outer_classname = 8;\n  // If enabled, then the Java code generator will generate a separate .java\n  // file for each top-level message, enum, and service defined in the .proto\n  // file.  Thus, these types will *not* be nested inside the wrapper class\n  // named by java_outer_classname.  However, the wrapper class will still be\n  // generated to contain the file\'s getDescriptor() method as well as any\n  // top-level extensions defined in the file.\n  optional bool java_multiple_files = 10 [default = false];\n  // This option does nothing.\n  optional bool java_generate_equals_and_hash = 20 [deprecated=true];\n  // If set true, then the Java2 code generator will generate code that\n  // throws an exception whenever an attempt is made to assign a non-UTF-8\n  // byte sequence to a string field.\n  // Message reflection will do the same.\n  // However, an extension field still accepts non-UTF-8 byte sequences.\n  // This option has no effect on when used with the lite runtime.\n  optional bool java_string_check_utf8 = 27 [default = false];\n  // Generated classes can be optimized for speed or code size.\n  enum OptimizeMode {\n    SPEED = 1;         // Generate complete code for parsing, serialization,\n                       // etc.\n    CODE_SIZE = 2;     // Use ReflectionOps to implement these methods.\n    LITE_RUNTIME = 3;  // Generate code using MessageLite and the lite runtime.\n  }\n  optional OptimizeMode optimize_for = 9 [default = SPEED];\n  // Sets the Go package where structs generated from this .proto will be\n  // placed. If omitted, the Go package will be derived from the following:\n  //   - The basename of the package import path, if provided.\n  //   - Otherwise, the package statement in the .proto file, if present.\n  //   - Otherwise, the basename of the .proto file, without extension.\n  optional string go_package = 11;\n  // Should generic services be generated in each language?  "Generic" services\n  // are not specific to any particular RPC system.  They are generated by the\n  // main code generators in each language (without additional plugins).\n  // Generic services were the only kind of service generation supported by\n  // early versions of google.protobuf.\n  //\n  // Generic services are now considered deprecated in favor of using plugins\n  // that generate code specific to your particular RPC system.  Therefore,\n  // these default to false.  Old code which depends on generic services should\n  // explicitly set them to true.\n  optional bool cc_generic_services = 16 [default = false];\n  optional bool java_generic_services = 17 [default = false];\n  optional bool py_generic_services = 18 [default = false];\n  optional bool php_generic_services = 42 [default = false];\n  // Is this file deprecated?\n  // Depending on the target platform, this can emit Deprecated annotations\n  // for everything in the file, or it will be completely ignored; in the very\n  // least, this is a formalization for deprecating files.\n  optional bool deprecated = 23 [default = false];\n  // Enables the use of arenas for the proto messages in this file. This applies\n  // only to generated classes for C++.\n  optional bool cc_enable_arenas = 31 [default = true];\n  // Sets the objective c class prefix which is prepended to all objective c\n  // generated classes from this .proto. There is no default.\n  optional string objc_class_prefix = 36;\n  // Namespace for generated classes; defaults to the package.\n  optional string csharp_namespace = 37;\n  // By default Swift generators will take the proto package and CamelCase it\n  // replacing \'.\' with underscore and use that to prefix the types/symbols\n  // defined. When this options is provided, they will use this value instead\n  // to prefix the types/symbols defined.\n  optional string swift_prefix = 39;\n  // Sets the php class prefix which is prepended to all php generated classes\n  // from this .proto. Default is empty.\n  optional string php_class_prefix = 40;\n  // Use this option to change the namespace of php generated classes. Default\n  // is empty. When this option is empty, the package name will be used for\n  // determining the namespace.\n  optional string php_namespace = 41;\n  // Use this option to change the namespace of php generated metadata classes.\n  // Default is empty. When this option is empty, the proto file name will be\n  // used for determining the namespace.\n  optional string php_metadata_namespace = 44;\n  // Use this option to change the package of ruby generated classes. Default\n  // is empty. When this option is not set, the package name will be used for\n  // determining the ruby package.\n  optional string ruby_package = 45;\n  // The parser stores options it doesn\'t recognize here.\n  // See the documentation for the "Options" section above.\n  repeated UninterpretedOption uninterpreted_option = 999;\n  // Clients can define custom options in extensions of this message.\n  // See the documentation for the "Options" section above.\n  extensions 1000 to max;\n  reserved 38;\n}\nmessage MessageOptions {\n  // Set true to use the old proto1 MessageSet wire format for extensions.\n  // This is provided for backwards-compatibility with the MessageSet wire\n  // format.  You should not use this for any other reason:  It\'s less\n  // efficient, has fewer features, and is more complicated.\n  //\n  // The message must be defined exactly as follows:\n  //   message Foo {\n  //     option message_set_wire_format = true;\n  //     extensions 4 to max;\n  //   }\n  // Note that the message cannot have any defined fields; MessageSets only\n  // have extensions.\n  //\n  // All extensions of your type must be singular messages; e.g. they cannot\n  // be int32s, enums, or repeated messages.\n  //\n  // Because this is an option, the above two restrictions are not enforced by\n  // the protocol compiler.\n  optional bool message_set_wire_format = 1 [default = false];\n  // Disables the generation of the standard "descriptor()" accessor, which can\n  // conflict with a field of the same name.  This is meant to make migration\n  // from proto1 easier; new code should avoid fields named "descriptor".\n  optional bool no_standard_descriptor_accessor = 2 [default = false];\n  // Is this message deprecated?\n  // Depending on the target platform, this can emit Deprecated annotations\n  // for the message, or it will be completely ignored; in the very least,\n  // this is a formalization for deprecating messages.\n  optional bool deprecated = 3 [default = false];\n  reserved 4, 5, 6;\n  // Whether the message is an automatically generated map entry type for the\n  // maps field.\n  //\n  // For maps fields:\n  //     map<KeyType, ValueType> map_field = 1;\n  // The parsed descriptor looks like:\n  //     message MapFieldEntry {\n  //         option map_entry = true;\n  //         optional KeyType key = 1;\n  //         optional ValueType value = 2;\n  //     }\n  //     repeated MapFieldEntry map_field = 1;\n  //\n  // Implementations may choose not to generate the map_entry=true message, but\n  // use a native map in the target language to hold the keys and values.\n  // The reflection APIs in such implementations still need to work as\n  // if the field is a repeated message field.\n  //\n  // NOTE: Do not set the option in .proto files. Always use the maps syntax\n  // instead. The option should only be implicitly set by the proto compiler\n  // parser.\n  optional bool map_entry = 7;\n  reserved 8;  // javalite_serializable\n  reserved 9;  // javanano_as_lite\n  // The parser stores options it doesn\'t recognize here. See above.\n  repeated UninterpretedOption uninterpreted_option = 999;\n  // Clients can define custom options in extensions of this message. See above.\n  extensions 1000 to max;\n}\nmessage FieldOptions {\n  // The ctype option instructs the C++ code generator to use a different\n  // representation of the field than it normally would.  See the specific\n  // options below.  This option is not yet implemented in the open source\n  // release -- sorry, we\'ll try to include it in a future version!\n  optional CType ctype = 1 [default = STRING];\n  enum CType {\n    // Default mode.\n    STRING = 0;\n    CORD = 1;\n    STRING_PIECE = 2;\n  }\n  // The packed option can be enabled for repeated primitive fields to enable\n  // a more efficient representation on the wire. Rather than repeatedly\n  // writing the tag and type for each element, the entire array is encoded as\n  // a single length-delimited blob. In proto3, only explicit setting it to\n  // false will avoid using packed encoding.\n  optional bool packed = 2;\n  // The jstype option determines the JavaScript type used for values of the\n  // field.  The option is permitted only for 64 bit integral and fixed types\n  // (int64, uint64, sint64, fixed64, sfixed64).  A field with jstype JS_STRING\n  // is represented as JavaScript string, which avoids loss of precision that\n  // can happen when a large value is converted to a floating point JavaScript.\n  // Specifying JS_NUMBER for the jstype causes the generated JavaScript code to\n  // use the JavaScript "number" type.  The behavior of the default option\n  // JS_NORMAL is implementation dependent.\n  //\n  // This option is an enum to permit additional types to be added, e.g.\n  // goog.math.Integer.\n  optional JSType jstype = 6 [default = JS_NORMAL];\n  enum JSType {\n    // Use the default type.\n    JS_NORMAL = 0;\n    // Use JavaScript strings.\n    JS_STRING = 1;\n    // Use JavaScript numbers.\n    JS_NUMBER = 2;\n  }\n  // Should this field be parsed lazily?  Lazy applies only to message-type\n  // fields.  It means that when the outer message is initially parsed, the\n  // inner message\'s contents will not be parsed but instead stored in encoded\n  // form.  The inner message will actually be parsed when it is first accessed.\n  //\n  // This is only a hint.  Implementations are free to choose whether to use\n  // eager or lazy parsing regardless of the value of this option.  However,\n  // setting this option true suggests that the protocol author believes that\n  // using lazy parsing on this field is worth the additional bookkeeping\n  // overhead typically needed to implement it.\n  //\n  // This option does not affect the public interface of any generated code;\n  // all method signatures remain the same.  Furthermore, thread-safety of the\n  // interface is not affected by this option; const methods remain safe to\n  // call from multiple threads concurrently, while non-const methods continue\n  // to require exclusive access.\n  //\n  //\n  // Note that implementations may choose not to check required fields within\n  // a lazy sub-message.  That is, calling IsInitialized() on the outer message\n  // may return true even if the inner message has missing required fields.\n  // This is necessary because otherwise the inner message would have to be\n  // parsed in order to perform the check, defeating the purpose of lazy\n  // parsing.  An implementation which chooses not to check required fields\n  // must be consistent about it.  That is, for any particular sub-message, the\n  // implementation must either *always* check its required fields, or *never*\n  // check its required fields, regardless of whether or not the message has\n  // been parsed.\n  //\n  // As of May 2022, lazy verifies the contents of the byte stream during\n  // parsing.  An invalid byte stream will cause the overall parsing to fail.\n  optional bool lazy = 5 [default = false];\n  // unverified_lazy does no correctness checks on the byte stream. This should\n  // only be used where lazy with verification is prohibitive for performance\n  // reasons.\n  optional bool unverified_lazy = 15 [default = false];\n  // Is this field deprecated?\n  // Depending on the target platform, this can emit Deprecated annotations\n  // for accessors, or it will be completely ignored; in the very least, this\n  // is a formalization for deprecating fields.\n  optional bool deprecated = 3 [default = false];\n  // For Google-internal migration only. Do not use.\n  optional bool weak = 10 [default = false];\n  // The parser stores options it doesn\'t recognize here. See above.\n  repeated UninterpretedOption uninterpreted_option = 999;\n  // Clients can define custom options in extensions of this message. See above.\n  extensions 1000 to max;\n  reserved 4;  // removed jtype\n}\nmessage OneofOptions {\n  // The parser stores options it doesn\'t recognize here. See above.\n  repeated UninterpretedOption uninterpreted_option = 999;\n  // Clients can define custom options in extensions of this message. See above.\n  extensions 1000 to max;\n}\nmessage EnumOptions {\n  // Set this option to true to allow mapping different tag names to the same\n  // value.\n  optional bool allow_alias = 2;\n  // Is this enum deprecated?\n  // Depending on the target platform, this can emit Deprecated annotations\n  // for the enum, or it will be completely ignored; in the very least, this\n  // is a formalization for deprecating enums.\n  optional bool deprecated = 3 [default = false];\n  reserved 5;  // javanano_as_lite\n  // The parser stores options it doesn\'t recognize here. See above.\n  repeated UninterpretedOption uninterpreted_option = 999;\n  // Clients can define custom options in extensions of this message. See above.\n  extensions 1000 to max;\n}\nmessage EnumValueOptions {\n  // Is this enum value deprecated?\n  // Depending on the target platform, this can emit Deprecated annotations\n  // for the enum value, or it will be completely ignored; in the very least,\n  // this is a formalization for deprecating enum values.\n  optional bool deprecated = 1 [default = false];\n  // The parser stores options it doesn\'t recognize here. See above.\n  repeated UninterpretedOption uninterpreted_option = 999;\n  // Clients can define custom options in extensions of this message. See above.\n  extensions 1000 to max;\n}\nmessage ServiceOptions {\n  // Note:  Field numbers 1 through 32 are reserved for Google\'s internal RPC\n  //   framework.  We apologize for hoarding these numbers to ourselves, but\n  //   we were already using them long before we decided to release Protocol\n  //   Buffers.\n  // Is this service deprecated?\n  // Depending on the target platform, this can emit Deprecated annotations\n  // for the service, or it will be completely ignored; in the very least,\n  // this is a formalization for deprecating services.\n  optional bool deprecated = 33 [default = false];\n  // The parser stores options it doesn\'t recognize here. See above.\n  repeated UninterpretedOption uninterpreted_option = 999;\n  // Clients can define custom options in extensions of this message. See above.\n  extensions 1000 to max;\n}\nmessage MethodOptions {\n  // Note:  Field numbers 1 through 32 are reserved for Google\'s internal RPC\n  //   framework.  We apologize for hoarding these numbers to ourselves, but\n  //   we were already using them long before we decided to release Protocol\n  //   Buffers.\n  // Is this method deprecated?\n  // Depending on the target platform, this can emit Deprecated annotations\n  // for the method, or it will be completely ignored; in the very least,\n  // this is a formalization for deprecating methods.\n  optional bool deprecated = 33 [default = false];\n  // Is this method side-effect-free (or safe in HTTP parlance), or idempotent,\n  // or neither? HTTP based RPC implementation may choose GET verb for safe\n  // methods, and PUT verb for idempotent methods instead of the default POST.\n  enum IdempotencyLevel {\n    IDEMPOTENCY_UNKNOWN = 0;\n    NO_SIDE_EFFECTS = 1;  // implies idempotent\n    IDEMPOTENT = 2;       // idempotent, but may have side effects\n  }\n  optional IdempotencyLevel idempotency_level = 34\n      [default = IDEMPOTENCY_UNKNOWN];\n  // The parser stores options it doesn\'t recognize here. See above.\n  repeated UninterpretedOption uninterpreted_option = 999;\n  // Clients can define custom options in extensions of this message. See above.\n  extensions 1000 to max;\n}\nmessage UninterpretedOption {\n  // The name of the uninterpreted option.  Each string represents a segment in\n  // a dot-separated name.  is_extension is true iff a segment represents an\n  // extension (denoted with parentheses in options specs in .proto files).\n  // E.g.,{ ["foo", false], ["bar.baz", true], ["moo", false] } represents\n  // "foo.(bar.baz).moo".\n  message NamePart {\n    required string name_part = 1;\n    required bool is_extension = 2;\n  }\n  repeated NamePart name = 2;\n  // The value of the uninterpreted option, in whatever type the tokenizer\n  // identified it as during parsing. Exactly one of these should be set.\n  optional string identifier_value = 3;\n  optional uint64 positive_int_value = 4;\n  optional int64 negative_int_value = 5;\n  optional double double_value = 6;\n  optional bytes string_value = 7;\n  optional string aggregate_value = 8;\n}\nmessage SourceCodeInfo {\n  // A Location identifies a piece of source code in a .proto file which\n  // corresponds to a particular definition.  This information is intended\n  // to be useful to IDEs, code indexers, documentation generators, and similar\n  // tools.\n  //\n  // For example, say we have a file like:\n  //   message Foo {\n  //     optional string foo = 1;\n  //   }\n  // Let\'s look at just the field definition:\n  //   optional string foo = 1;\n  //   ^       ^^     ^^  ^  ^^^\n  //   a       bc     de  f  ghi\n  // We have the following locations:\n  //   span   path               represents\n  //   [a,i)  [ 4, 0, 2, 0 ]     The whole field definition.\n  //   [a,b)  [ 4, 0, 2, 0, 4 ]  The label (optional).\n  //   [c,d)  [ 4, 0, 2, 0, 5 ]  The type (string).\n  //   [e,f)  [ 4, 0, 2, 0, 1 ]  The name (foo).\n  //   [g,h)  [ 4, 0, 2, 0, 3 ]  The number (1).\n  //\n  // Notes:\n  // - A location may refer to a repeated field itself (i.e. not to any\n  //   particular index within it).  This is used whenever a set of elements are\n  //   logically enclosed in a single code segment.  For example, an entire\n  //   extend block (possibly containing multiple extension definitions) will\n  //   have an outer location whose path refers to the "extensions" repeated\n  //   field without an index.\n  // - Multiple locations may have the same path.  This happens when a single\n  //   logical declaration is spread out across multiple places.  The most\n  //   obvious example is the "extend" block again -- there may be multiple\n  //   extend blocks in the same scope, each of which will have the same path.\n  // - A location\'s span is not always a subset of its parent\'s span.  For\n  //   example, the "extendee" of an extension declaration appears at the\n  //   beginning of the "extend" block and is shared by all extensions within\n  //   the block.\n  // - Just because a location\'s span is a subset of some other location\'s span\n  //   does not mean that it is a descendant.  For example, a "group" defines\n  //   both a type and a field in a single declaration.  Thus, the locations\n  //   corresponding to the type and field and their components will overlap.\n  // - Code which tries to interpret locations should probably be designed to\n  //   ignore those that it doesn\'t understand, as more types of locations could\n  //   be recorded in the future.\n  repeated Location location = 1;\n  message Location {\n    // Identifies which part of the FileDescriptorProto was defined at this\n    // location.\n    //\n    // Each element is a field number or an index.  They form a path from\n    // the root FileDescriptorProto to the place where the definition occurs.\n    // For example, this path:\n    //   [ 4, 3, 2, 7, 1 ]\n    // refers to:\n    //   file.message_type(3)  // 4, 3\n    //       .field(7)         // 2, 7\n    //       .name()           // 1\n    // This is because FileDescriptorProto.message_type has field number 4:\n    //   repeated DescriptorProto message_type = 4;\n    // and DescriptorProto.field has field number 2:\n    //   repeated FieldDescriptorProto field = 2;\n    // and FieldDescriptorProto.name has field number 1:\n    //   optional string name = 1;\n    //\n    // Thus, the above path gives the location of a field name.  If we removed\n    // the last element:\n    //   [ 4, 3, 2, 7 ]\n    // this path refers to the whole field declaration (from the beginning\n    // of the label to the terminating semicolon).\n    repeated int32 path = 1 [packed = true];\n    // Always has exactly three or four elements: start line, start column,\n    // end line (optional, otherwise assumed same as start line), end column.\n    // These are packed into a single field for efficiency.  Note that line\n    // and column numbers are zero-based -- typically you will want to add\n    // 1 to each before displaying to a user.\n    repeated int32 span = 2 [packed = true];\n    // If this SourceCodeInfo represents a complete declaration, these are any\n    // comments appearing before and after the declaration which appear to be\n    // attached to the declaration.\n    //\n    // A series of line comments appearing on consecutive lines, with no other\n    // tokens appearing on those lines, will be treated as a single comment.\n    //\n    // leading_detached_comments will keep paragraphs of comments that appear\n    // before (but not connected to) the current element. Each paragraph,\n    // separated by empty lines, will be one comment element in the repeated\n    // field.\n    //\n    // Only the comment content is provided; comment markers (e.g. //) are\n    // stripped out.  For block comments, leading whitespace and an asterisk\n    // will be stripped from the beginning of each line other than the first.\n    // Newlines are included in the output.\n    //\n    // Examples:\n    //\n    //   optional int32 foo = 1;  // Comment attached to foo.\n    //   // Comment attached to bar.\n    //   optional int32 bar = 2;\n    //\n    //   optional string baz = 3;\n    //   // Comment attached to baz.\n    //   // Another line attached to baz.\n    //\n    //   // Comment attached to moo.\n    //   //\n    //   // Another line attached to moo.\n    //   optional double moo = 4;\n    //\n    //   // Detached comment for corge. This is not leading or trailing comments\n    //   // to moo or corge because there are blank lines separating it from\n    //   // both.\n    //\n    //   // Detached comment for corge paragraph 2.\n    //\n    //   optional string corge = 5;\n    //   /* Block comment attached\n    //    * to corge.  Leading asterisks\n    //    * will be removed. */\n    //   /* Block comment attached to\n    //    * grault. */\n    //   optional int32 grault = 6;\n    //\n    //   // ignored detached comments.\n    optional string leading_comments = 3;\n    optional string trailing_comments = 4;\n    repeated string leading_detached_comments = 6;\n  }\n}\nmessage GeneratedCodeInfo {\n  // An Annotation connects some span of text in generated code to an element\n  // of its generating .proto file.\n  repeated Annotation annotation = 1;\n  message Annotation {\n    // Identifies the element in the original source .proto file. This field\n    // is formatted the same as SourceCodeInfo.Location.path.\n    repeated int32 path = 1 [packed = true];\n    // Identifies the filesystem path to the original source .proto.\n    optional string source_file = 2;\n    // Identifies the starting offset in bytes in the generated code\n    // that relates to the identified object.\n    optional int32 begin = 3;\n    // Identifies the ending offset in bytes in the generated code that\n    // relates to the identified object. The end offset should be one past\n    // the last relevant byte (so the length of the text = end - begin).\n    optional int32 end = 4;\n    // Represents the identified object\'s effect on the element in the original\n    // .proto file.\n    enum Semantic {\n      // There is no effect or the effect is indescribable.\n      NONE = 0;\n      // The element is set or otherwise mutated.\n      SET = 1;\n      // An alias to the element is returned.\n      ALIAS = 2;\n    }\n    optional Semantic semantic = 5;\n  }\n}',"google/protobuf/duration.proto":'// Protocol Buffers - Google\'s data interchange format\n// Copyright 2008 Google Inc.  All rights reserved.\n// https://developers.google.com/protocol-buffers/\n//\n// Redistribution and use in source and binary forms, with or without\n// modification, are permitted provided that the following conditions are\n// met:\n//\n//     * Redistributions of source code must retain the above copyright\n// notice, this list of conditions and the following disclaimer.\n//     * Redistributions in binary form must reproduce the above\n// copyright notice, this list of conditions and the following disclaimer\n// in the documentation and/or other materials provided with the\n// distribution.\n//     * Neither the name of Google Inc. nor the names of its\n// contributors may be used to endorse or promote products derived from\n// this software without specific prior written permission.\n//\n// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS\n// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT\n// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\n// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT\n// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,\n// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT\n// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\n// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\n// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\n// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\nsyntax = "proto3";\npackage google.protobuf;\noption csharp_namespace = "Google.Protobuf.WellKnownTypes";\noption cc_enable_arenas = true;\noption go_package = "google.golang.org/protobuf/types/known/durationpb";\noption java_package = "com.google.protobuf";\noption java_outer_classname = "DurationProto";\noption java_multiple_files = true;\noption objc_class_prefix = "GPB";\nmessage Duration {\n  // Signed seconds of the span of time. Must be from -315,576,000,000\n  // to +315,576,000,000 inclusive. Note: these bounds are computed from:\n  // 60 sec/min * 60 min/hr * 24 hr/day * 365.25 days/year * 10000 years\n  int64 seconds = 1;\n  // Signed fractions of a second at nanosecond resolution of the span\n  // of time. Durations less than one second are represented with a 0\n  // `seconds` field and a positive or negative `nanos` field. For durations\n  // of one second or more, a non-zero value for the `nanos` field must be\n  // of the same sign as the `seconds` field. Must be from -999,999,999\n  // to +999,999,999 inclusive.\n  int32 nanos = 2;\n}',"google/protobuf/empty.proto":'// Protocol Buffers - Google\'s data interchange format\n// Copyright 2008 Google Inc.  All rights reserved.\n// https://developers.google.com/protocol-buffers/\n//\n// Redistribution and use in source and binary forms, with or without\n// modification, are permitted provided that the following conditions are\n// met:\n//\n//     * Redistributions of source code must retain the above copyright\n// notice, this list of conditions and the following disclaimer.\n//     * Redistributions in binary form must reproduce the above\n// copyright notice, this list of conditions and the following disclaimer\n// in the documentation and/or other materials provided with the\n// distribution.\n//     * Neither the name of Google Inc. nor the names of its\n// contributors may be used to endorse or promote products derived from\n// this software without specific prior written permission.\n//\n// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS\n// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT\n// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\n// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT\n// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,\n// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT\n// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\n// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\n// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\n// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\nsyntax = "proto3";\npackage google.protobuf;\noption csharp_namespace = "Google.Protobuf.WellKnownTypes";\noption go_package = "google.golang.org/protobuf/types/known/emptypb";\noption java_package = "com.google.protobuf";\noption java_outer_classname = "EmptyProto";\noption java_multiple_files = true;\noption objc_class_prefix = "GPB";\noption cc_enable_arenas = true;\nmessage Empty {}',"google/protobuf/field_mask.proto":'// Protocol Buffers - Google\'s data interchange format\n// Copyright 2008 Google Inc.  All rights reserved.\n// https://developers.google.com/protocol-buffers/\n//\n// Redistribution and use in source and binary forms, with or without\n// modification, are permitted provided that the following conditions are\n// met:\n//\n//     * Redistributions of source code must retain the above copyright\n// notice, this list of conditions and the following disclaimer.\n//     * Redistributions in binary form must reproduce the above\n// copyright notice, this list of conditions and the following disclaimer\n// in the documentation and/or other materials provided with the\n// distribution.\n//     * Neither the name of Google Inc. nor the names of its\n// contributors may be used to endorse or promote products derived from\n// this software without specific prior written permission.\n//\n// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS\n// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT\n// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\n// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT\n// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,\n// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT\n// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\n// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\n// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\n// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\nsyntax = "proto3";\npackage google.protobuf;\noption csharp_namespace = "Google.Protobuf.WellKnownTypes";\noption java_package = "com.google.protobuf";\noption java_outer_classname = "FieldMaskProto";\noption java_multiple_files = true;\noption objc_class_prefix = "GPB";\noption go_package = "google.golang.org/protobuf/types/known/fieldmaskpb";\noption cc_enable_arenas = true;\nmessage FieldMask {\n  // The set of field mask paths.\n  repeated string paths = 1;\n}',"google/protobuf/source_context.proto":'// Protocol Buffers - Google\'s data interchange format\n// Copyright 2008 Google Inc.  All rights reserved.\n// https://developers.google.com/protocol-buffers/\n//\n// Redistribution and use in source and binary forms, with or without\n// modification, are permitted provided that the following conditions are\n// met:\n//\n//     * Redistributions of source code must retain the above copyright\n// notice, this list of conditions and the following disclaimer.\n//     * Redistributions in binary form must reproduce the above\n// copyright notice, this list of conditions and the following disclaimer\n// in the documentation and/or other materials provided with the\n// distribution.\n//     * Neither the name of Google Inc. nor the names of its\n// contributors may be used to endorse or promote products derived from\n// this software without specific prior written permission.\n//\n// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS\n// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT\n// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\n// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT\n// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,\n// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT\n// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\n// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\n// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\n// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\nsyntax = "proto3";\npackage google.protobuf;\noption csharp_namespace = "Google.Protobuf.WellKnownTypes";\noption java_package = "com.google.protobuf";\noption java_outer_classname = "SourceContextProto";\noption java_multiple_files = true;\noption objc_class_prefix = "GPB";\noption go_package = "google.golang.org/protobuf/types/known/sourcecontextpb";\nmessage SourceContext {\n  // The path-qualified name of the .proto file that contained the associated\n  // protobuf element.  For example: `"google/protobuf/source_context.proto"`.\n  string file_name = 1;\n}',"google/protobuf/struct.proto":'// Protocol Buffers - Google\'s data interchange format\n// Copyright 2008 Google Inc.  All rights reserved.\n// https://developers.google.com/protocol-buffers/\n//\n// Redistribution and use in source and binary forms, with or without\n// modification, are permitted provided that the following conditions are\n// met:\n//\n//     * Redistributions of source code must retain the above copyright\n// notice, this list of conditions and the following disclaimer.\n//     * Redistributions in binary form must reproduce the above\n// copyright notice, this list of conditions and the following disclaimer\n// in the documentation and/or other materials provided with the\n// distribution.\n//     * Neither the name of Google Inc. nor the names of its\n// contributors may be used to endorse or promote products derived from\n// this software without specific prior written permission.\n//\n// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS\n// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT\n// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\n// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT\n// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,\n// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT\n// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\n// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\n// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\n// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\nsyntax = "proto3";\npackage google.protobuf;\noption csharp_namespace = "Google.Protobuf.WellKnownTypes";\noption cc_enable_arenas = true;\noption go_package = "google.golang.org/protobuf/types/known/structpb";\noption java_package = "com.google.protobuf";\noption java_outer_classname = "StructProto";\noption java_multiple_files = true;\noption objc_class_prefix = "GPB";\nmessage Struct {\n  // Unordered map of dynamically typed values.\n  map<string, Value> fields = 1;\n}\nmessage Value {\n  // The kind of value.\n  oneof kind {\n    // Represents a null value.\n    NullValue null_value = 1;\n    // Represents a double value.\n    double number_value = 2;\n    // Represents a string value.\n    string string_value = 3;\n    // Represents a boolean value.\n    bool bool_value = 4;\n    // Represents a structured value.\n    Struct struct_value = 5;\n    // Represents a repeated `Value`.\n    ListValue list_value = 6;\n  }\n}\nenum NullValue {\n  // Null value.\n  NULL_VALUE = 0;\n}\nmessage ListValue {\n  // Repeated field of dynamically typed values.\n  repeated Value values = 1;\n}',"google/protobuf/timestamp.proto":'// Protocol Buffers - Google\'s data interchange format\n// Copyright 2008 Google Inc.  All rights reserved.\n// https://developers.google.com/protocol-buffers/\n//\n// Redistribution and use in source and binary forms, with or without\n// modification, are permitted provided that the following conditions are\n// met:\n//\n//     * Redistributions of source code must retain the above copyright\n// notice, this list of conditions and the following disclaimer.\n//     * Redistributions in binary form must reproduce the above\n// copyright notice, this list of conditions and the following disclaimer\n// in the documentation and/or other materials provided with the\n// distribution.\n//     * Neither the name of Google Inc. nor the names of its\n// contributors may be used to endorse or promote products derived from\n// this software without specific prior written permission.\n//\n// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS\n// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT\n// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\n// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT\n// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,\n// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT\n// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\n// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\n// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\n// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\nsyntax = "proto3";\npackage google.protobuf;\noption csharp_namespace = "Google.Protobuf.WellKnownTypes";\noption cc_enable_arenas = true;\noption go_package = "google.golang.org/protobuf/types/known/timestamppb";\noption java_package = "com.google.protobuf";\noption java_outer_classname = "TimestampProto";\noption java_multiple_files = true;\noption objc_class_prefix = "GPB";\nmessage Timestamp {\n  // Represents seconds of UTC time since Unix epoch\n  // 1970-01-01T00:00:00Z. Must be from 0001-01-01T00:00:00Z to\n  // 9999-12-31T23:59:59Z inclusive.\n  int64 seconds = 1;\n  // Non-negative fractions of a second at nanosecond resolution. Negative\n  // second values with fractions must still have non-negative nanos values\n  // that count forward in time. Must be from 0 to 999,999,999\n  // inclusive.\n  int32 nanos = 2;\n}',"google/protobuf/type.proto":'// Protocol Buffers - Google\'s data interchange format\n// Copyright 2008 Google Inc.  All rights reserved.\n// https://developers.google.com/protocol-buffers/\n//\n// Redistribution and use in source and binary forms, with or without\n// modification, are permitted provided that the following conditions are\n// met:\n//\n//     * Redistributions of source code must retain the above copyright\n// notice, this list of conditions and the following disclaimer.\n//     * Redistributions in binary form must reproduce the above\n// copyright notice, this list of conditions and the following disclaimer\n// in the documentation and/or other materials provided with the\n// distribution.\n//     * Neither the name of Google Inc. nor the names of its\n// contributors may be used to endorse or promote products derived from\n// this software without specific prior written permission.\n//\n// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS\n// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT\n// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\n// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT\n// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,\n// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT\n// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\n// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\n// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\n// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\nsyntax = "proto3";\npackage google.protobuf;\nimport "google/protobuf/any.proto";\nimport "google/protobuf/source_context.proto";\noption csharp_namespace = "Google.Protobuf.WellKnownTypes";\noption cc_enable_arenas = true;\noption java_package = "com.google.protobuf";\noption java_outer_classname = "TypeProto";\noption java_multiple_files = true;\noption objc_class_prefix = "GPB";\noption go_package = "google.golang.org/protobuf/types/known/typepb";\nmessage Type {\n  // The fully qualified message name.\n  string name = 1;\n  // The list of fields.\n  repeated Field fields = 2;\n  // The list of types appearing in `oneof` definitions in this type.\n  repeated string oneofs = 3;\n  // The protocol buffer options.\n  repeated Option options = 4;\n  // The source context.\n  SourceContext source_context = 5;\n  // The source syntax.\n  Syntax syntax = 6;\n}\nmessage Field {\n  // Basic field types.\n  enum Kind {\n    // Field type unknown.\n    TYPE_UNKNOWN = 0;\n    // Field type double.\n    TYPE_DOUBLE = 1;\n    // Field type float.\n    TYPE_FLOAT = 2;\n    // Field type int64.\n    TYPE_INT64 = 3;\n    // Field type uint64.\n    TYPE_UINT64 = 4;\n    // Field type int32.\n    TYPE_INT32 = 5;\n    // Field type fixed64.\n    TYPE_FIXED64 = 6;\n    // Field type fixed32.\n    TYPE_FIXED32 = 7;\n    // Field type bool.\n    TYPE_BOOL = 8;\n    // Field type string.\n    TYPE_STRING = 9;\n    // Field type group. Proto2 syntax only, and deprecated.\n    TYPE_GROUP = 10;\n    // Field type message.\n    TYPE_MESSAGE = 11;\n    // Field type bytes.\n    TYPE_BYTES = 12;\n    // Field type uint32.\n    TYPE_UINT32 = 13;\n    // Field type enum.\n    TYPE_ENUM = 14;\n    // Field type sfixed32.\n    TYPE_SFIXED32 = 15;\n    // Field type sfixed64.\n    TYPE_SFIXED64 = 16;\n    // Field type sint32.\n    TYPE_SINT32 = 17;\n    // Field type sint64.\n    TYPE_SINT64 = 18;\n  }\n  // Whether a field is optional, required, or repeated.\n  enum Cardinality {\n    // For fields with unknown cardinality.\n    CARDINALITY_UNKNOWN = 0;\n    // For optional fields.\n    CARDINALITY_OPTIONAL = 1;\n    // For required fields. Proto2 syntax only.\n    CARDINALITY_REQUIRED = 2;\n    // For repeated fields.\n    CARDINALITY_REPEATED = 3;\n  }\n  // The field type.\n  Kind kind = 1;\n  // The field cardinality.\n  Cardinality cardinality = 2;\n  // The field number.\n  int32 number = 3;\n  // The field name.\n  string name = 4;\n  // The field type URL, without the scheme, for message or enumeration\n  // types. Example: `"type.googleapis.com/google.protobuf.Timestamp"`.\n  string type_url = 6;\n  // The index of the field type in `Type.oneofs`, for message or enumeration\n  // types. The first type has index 1; zero means the type is not in the list.\n  int32 oneof_index = 7;\n  // Whether to use alternative packed wire representation.\n  bool packed = 8;\n  // The protocol buffer options.\n  repeated Option options = 9;\n  // The field JSON name.\n  string json_name = 10;\n  // The string value of the default value of this field. Proto2 syntax only.\n  string default_value = 11;\n}\nmessage Enum {\n  // Enum type name.\n  string name = 1;\n  // Enum value definitions.\n  repeated EnumValue enumvalue = 2;\n  // Protocol buffer options.\n  repeated Option options = 3;\n  // The source context.\n  SourceContext source_context = 4;\n  // The source syntax.\n  Syntax syntax = 5;\n}\nmessage EnumValue {\n  // Enum value name.\n  string name = 1;\n  // Enum value number.\n  int32 number = 2;\n  // Protocol buffer options.\n  repeated Option options = 3;\n}\nmessage Option {\n  // The option\'s name. For protobuf built-in options (options defined in\n  // descriptor.proto), this is the short name. For example, `"map_entry"`.\n  // For custom options, it should be the fully-qualified name. For example,\n  // `"google.api.http"`.\n  string name = 1;\n  // The option\'s value packed in an Any message. If the value is a primitive,\n  // the corresponding wrapper type defined in google/protobuf/wrappers.proto\n  // should be used. If the value is an enum, it should be stored as an int32\n  // value using the google.protobuf.Int32Value type.\n  Any value = 2;\n}\nenum Syntax {\n  // Syntax `proto2`.\n  SYNTAX_PROTO2 = 0;\n  // Syntax `proto3`.\n  SYNTAX_PROTO3 = 1;\n}',"google/protobuf/wrappers.proto":'// Protocol Buffers - Google\'s data interchange format\n// Copyright 2008 Google Inc.  All rights reserved.\n// https://developers.google.com/protocol-buffers/\n//\n// Redistribution and use in source and binary forms, with or without\n// modification, are permitted provided that the following conditions are\n// met:\n//\n//     * Redistributions of source code must retain the above copyright\n// notice, this list of conditions and the following disclaimer.\n//     * Redistributions in binary form must reproduce the above\n// copyright notice, this list of conditions and the following disclaimer\n// in the documentation and/or other materials provided with the\n// distribution.\n//     * Neither the name of Google Inc. nor the names of its\n// contributors may be used to endorse or promote products derived from\n// this software without specific prior written permission.\n//\n// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS\n// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT\n// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR\n// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT\n// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,\n// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT\n// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\n// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\n// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\n// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n// Wrappers for primitive (non-message) types. These types are useful\n// for embedding primitives in the `google.protobuf.Any` type and for places\n// where we need to distinguish between the absence of a primitive\n// typed field and its default value.\n//\n// These wrappers have no meaningful use within repeated fields as they lack\n// the ability to detect presence on individual elements.\n// These wrappers have no meaningful use within a map or a oneof since\n// individual entries of a map or fields of a oneof can already detect presence.\nsyntax = "proto3";\npackage google.protobuf;\noption csharp_namespace = "Google.Protobuf.WellKnownTypes";\noption cc_enable_arenas = true;\noption go_package = "google.golang.org/protobuf/types/known/wrapperspb";\noption java_package = "com.google.protobuf";\noption java_outer_classname = "WrappersProto";\noption java_multiple_files = true;\noption objc_class_prefix = "GPB";\nmessage DoubleValue {\n  // The double value.\n  double value = 1;\n}\nmessage FloatValue {\n  // The float value.\n  float value = 1;\n}\nmessage Int64Value {\n  // The int64 value.\n  int64 value = 1;\n}\nmessage UInt64Value {\n  // The uint64 value.\n  uint64 value = 1;\n}\nmessage Int32Value {\n  // The int32 value.\n  int32 value = 1;\n}\nmessage UInt32Value {\n  // The uint32 value.\n  uint32 value = 1;\n}\nmessage BoolValue {\n  // The bool value.\n  bool value = 1;\n}\nmessage StringValue {\n  // The string value.\n  string value = 1;\n}\nmessage BytesValue {\n  // The bytes value.\n  bytes value = 1;\n}',"confluent/meta.proto":'syntax = "proto3";\npackage confluent;\nimport "google/protobuf/descriptor.proto";\noption java_package = "io.confluent.protobuf";\noption java_outer_classname = "MetaProto";\nmessage Meta {\n  string doc = 1;\n  map<string, string> params = 2;\n  repeated string annotation = 3;\n}\nextend google.protobuf.FileOptions {\n  Meta file_meta = 1088;\n}\nextend google.protobuf.MessageOptions {\n  Meta message_meta = 1088;\n}\nextend google.protobuf.FieldOptions {\n  Meta field_meta = 1088;\n}\nextend google.protobuf.EnumOptions {\n  Meta enum_meta = 1088;\n}\nextend google.protobuf.EnumValueOptions {\n  Meta enum_value_meta = 1088;\n}',"confluent/type/decimal.proto":'syntax = "proto3";\npackage confluent.type;\noption java_package = "io.confluent.protobuf.type";\noption java_multiple_files = true;\noption java_outer_classname = "DecimalProto";\nmessage Decimal {\n  // The two\'s-complement representation of the unscaled integer value in big-endian byte order\n  bytes value = 1;\n  // The precision\n  uint32 precision = 2;\n  // The scale\n  int32 scale = 3;\n}'},i=e=>t[e]}}]);