/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.auditlog.emitter.translator;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.Message;
import io.confluent.auditlog.emitter.auditlogger.EventParams;
import io.confluent.auditlog.emitter.errormappers.SubjectBuilderException;
import io.confluent.auditlog.emitter.errormappers.TranslatorException;
import io.confluent.auditlog.emitter.errormappers.ValidatorException;
import io.confluent.auditlog.emitter.translator.SubjectBuilder;
import io.confluent.auditlog.emitter.translator.Validator;
import io.confluent.auditlog.emitter.utils.LogOptions;
import io.confluent.auditlog.emitter.utils.ServiceIdentity;
import io.confluent.crn.CrnSyntaxException;
import io.confluent.protobuf.events.auditlog.v2.AuditLog;
import io.confluent.telemetry.api.events.Event;
import io.confluent.telemetry.events.EventUtils;
import java.net.URI;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Translator {
    private static final Logger log = LoggerFactory.getLogger(Translator.class);
    public static final String CONTROL_PLANE_EVENT_SOURCE = "crn://confluent.cloud/";
    public static final String EVENT_TYPE = "io.confluent.cloud/request";
    public static final String AUDIT_LOG_SCHEMA_URI = "https://confluent.io/internal/events/AuditLog.v2";

    @VisibleForTesting
    protected static AuditLog addServiceNameAndIdentity(AuditLog auditLog, ServiceIdentity identity) {
        if (identity == null) {
            throw new TranslatorException("unknown ServiceIdentity");
        }
        AuditLog.Builder auditLogBuilder = auditLog.toBuilder().setInternalServiceName(identity.getInternalServiceNameCrn()).setServiceLocation(identity.getServiceLocation());
        if (StringUtils.isBlank((CharSequence)auditLogBuilder.getServiceName())) {
            auditLogBuilder.setServiceName(identity.getServiceNameCrn());
        }
        return auditLogBuilder.build();
    }

    @VisibleForTesting
    protected static Event createEvent(AuditLog auditLog, String uuid, EventParams params) {
        try {
            log.debug(String.format("[createEvent]: Wrapping AuditLog [id = %s] inside an Event", uuid));
            return new Event().setId(uuid).setSource(CONTROL_PLANE_EVENT_SOURCE).setSubject(SubjectBuilder.buildSubjectCrn(auditLog.getCloudResourcesList())).setType(params.getEventType().toString()).setData("application/protobuf", URI.create(AUDIT_LOG_SCHEMA_URI), EventUtils.protoToBytes((Message)auditLog, (String)"application/protobuf"));
        }
        catch (SubjectBuilderException | CrnSyntaxException | IllegalArgumentException | NullPointerException e) {
            throw new TranslatorException("Got an error while creating Event: " + e.getMessage(), e);
        }
    }

    public static Event auditEntryToEvent(AuditLog auditLog, ServiceIdentity serviceIdentity, LogOptions options, EventParams eventParams) {
        String uuid = UUID.randomUUID().toString();
        try {
            log.debug(String.format("[auditEntryToCloudEvent]: Validating AuditLog [id = %s]", uuid));
            Validator.validateAuditEntry(auditLog, options);
        }
        catch (ValidatorException | NullPointerException e) {
            log.error("Validation failure ", (Throwable)e);
            String msg = String.format("Got an error while performing Validation. error:%s, serviceName:%s", e.getMessage(), serviceIdentity.getServiceNameCrn());
            throw new TranslatorException(msg, e);
        }
        log.debug(String.format("[auditEntryToCloudEvent]: Successfully validated AuditLog [id = %s]", uuid));
        log.debug(String.format("[auditEntryToCloudEvent]: Adding ServiceIdentity to AuditLog [id = %s]", uuid));
        auditLog = Translator.addServiceNameAndIdentity(auditLog, serviceIdentity);
        log.debug(String.format("[auditEntryToCloudEvent]: Successfully added ServiceIdentity to AuditLog [id = %s]", uuid));
        return Translator.createEvent(auditLog, uuid, eventParams);
    }
}

