/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.cli.console.cmd;

import io.confluent.ksql.cli.console.cmd.CliCmdUtil;
import io.confluent.ksql.cli.console.cmd.CliSpecificCommand;
import java.io.PrintWriter;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class RequestPipeliningCommand
implements CliSpecificCommand {
    public static final String NAME = "request-pipelining";
    private static final String HELP = "request-pipelining:" + System.lineSeparator() + "\tView the current setting. If 'ON', commands will be executed without waiting for previous commands to finish. If 'OFF', newly issued commands will wait until all prior commands have finished. Defaults to 'OFF'." + System.lineSeparator() + "\n" + "request-pipelining" + " <ON/OFF>:" + System.lineSeparator() + "\tUpdate the setting as specified." + System.lineSeparator() + "\tFor example: \"" + "request-pipelining" + " OFF;\"";
    private final Supplier<Boolean> requestPipeliningSupplier;
    private final Consumer<Boolean> requestPipeliningConsumer;

    public static RequestPipeliningCommand create(Supplier<Boolean> requestPipeliningSupplier, Consumer<Boolean> requestPipeliningConsumer) {
        return new RequestPipeliningCommand(requestPipeliningSupplier, requestPipeliningConsumer);
    }

    private RequestPipeliningCommand(Supplier<Boolean> requestPipeliningSupplier, Consumer<Boolean> requestPipeliningConsumer) {
        this.requestPipeliningSupplier = Objects.requireNonNull(requestPipeliningSupplier, "requestPipeliningSupplier");
        this.requestPipeliningConsumer = Objects.requireNonNull(requestPipeliningConsumer, "requestPipeliningConsumer");
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getHelpMessage() {
        return HELP;
    }

    @Override
    public void execute(List<String> args, PrintWriter terminal) {
        CliCmdUtil.ensureArgCountBounds(args, 0, 1, HELP);
        if (args.isEmpty()) {
            String setting = this.requestPipeliningSupplier.get() != false ? "ON" : "OFF";
            terminal.printf("Current %s configuration: %s%n", NAME, setting);
        } else {
            String newSetting = args.get(0);
            switch (newSetting.toUpperCase()) {
                case "ON": {
                    this.requestPipeliningConsumer.accept(true);
                    break;
                }
                case "OFF": {
                    this.requestPipeliningConsumer.accept(false);
                    break;
                }
                default: {
                    terminal.printf("Invalid %s setting: %s. ", NAME, newSetting);
                    terminal.println("Valid options are 'ON' and 'OFF'.");
                    return;
                }
            }
            terminal.println("request-pipelining configuration is now " + newSetting.toUpperCase());
        }
    }
}

