/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.cli.console.table.builder;

import com.google.common.collect.ImmutableList;
import io.confluent.ksql.cli.console.table.Table;
import io.confluent.ksql.cli.console.table.builder.TableBuilder;
import io.confluent.ksql.rest.entity.FunctionNameList;
import io.confluent.ksql.rest.entity.SimpleFunctionInfo;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FunctionNameListTableBuilder
implements TableBuilder<FunctionNameList> {
    private static final List<String> HEADERS = ImmutableList.of((Object)"Function Name", (Object)"Category");
    private static final List<String> EMPTY_ROW = ImmutableList.of((Object)" ", (Object)" ");

    @Override
    public Table buildTable(FunctionNameList functionNameList) {
        Table.Builder builder = new Table.Builder().withColumnHeaders(HEADERS);
        Iterator funcs = functionNameList.getFunctions().iterator();
        if (!funcs.hasNext() || ((SimpleFunctionInfo)funcs.next()).getCategory().isEmpty()) {
            Stream<List<String>> rows = functionNameList.getFunctions().stream().sorted(Comparator.comparing(SimpleFunctionInfo::getName)).map(func -> ImmutableList.of((Object)func.getName(), (Object)func.getType().name().toUpperCase()));
            builder.withRows(rows);
        } else {
            List sortedFunctions = functionNameList.getFunctions().stream().sorted(Comparator.comparing(SimpleFunctionInfo::getCategory).thenComparing(SimpleFunctionInfo::getName)).collect(Collectors.toList());
            String prevCategory = ((SimpleFunctionInfo)sortedFunctions.get(0)).getCategory();
            for (SimpleFunctionInfo fn : sortedFunctions) {
                if (!fn.getCategory().equals(prevCategory)) {
                    builder.withRow(EMPTY_ROW);
                }
                builder.withRow(fn.getName(), fn.getCategory());
                prevCategory = fn.getCategory();
            }
        }
        builder.withFooterLine("For detailed information about a function, run: DESCRIBE FUNCTION <Function Name>;");
        return builder.build();
    }
}

