/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.cli.console.table.builder;

import com.google.common.collect.ImmutableList;
import io.confluent.ksql.cli.console.table.Table;
import io.confluent.ksql.cli.console.table.builder.TableBuilder;
import io.confluent.ksql.rest.entity.Queries;
import java.util.List;
import java.util.stream.Stream;

public class QueriesTableBuilder
implements TableBuilder<Queries> {
    private static final List<String> HEADERS = ImmutableList.of((Object)"Query ID", (Object)"Query Type", (Object)"Status", (Object)"Sink Name", (Object)"Sink Kafka Topic", (Object)"Query String");

    @Override
    public Table buildTable(Queries entity) {
        Stream<List<String>> rows = entity.getQueries().stream().map(r -> ImmutableList.of((Object)r.getId().toString(), (Object)r.getQueryType().toString(), (Object)r.getStatusCount().toString(), (Object)String.join((CharSequence)",", r.getSinks()), (Object)String.join((CharSequence)",", r.getSinkKafkaTopics()), (Object)r.getQuerySingleLine()));
        return new Table.Builder().withColumnHeaders(HEADERS).withRows(rows).withFooterLine("For detailed information on a Query run: EXPLAIN <Query ID>;").build();
    }
}

