/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.common.security.auth;

import io.confluent.common.security.auth.AuthenticationModule;
import io.confluent.common.security.auth.AuthenticationModuleFactory;
import io.confluent.common.security.auth.JwtPrincipal;
import io.confluent.common.security.auth.RestAuthType;
import io.confluent.common.security.auth.RestSecurityContext;
import java.security.Principal;
import java.util.Optional;
import javax.annotation.Priority;
import javax.security.auth.login.LoginException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.ssl.SslPrincipalMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=1000)
public final class AuthenticationFilter
implements ContainerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationFilter.class);
    private final AuthenticationModule authenticationModule;
    private final boolean anonymousPrincipalEnabled;

    public AuthenticationFilter(String restAuthTypeConfig, Optional<SslPrincipalMapper> principalMapper, boolean anonymousPrincipalEnabled) {
        this.authenticationModule = AuthenticationModuleFactory.getInstance().getAuthenticationModule(RestAuthType.valueOf(restAuthTypeConfig), principalMapper);
        this.anonymousPrincipalEnabled = anonymousPrincipalEnabled;
    }

    public AuthenticationFilter(String restAuthTypeConfig, Optional<SslPrincipalMapper> principalMapper) {
        this(restAuthTypeConfig, principalMapper, false);
    }

    public void filter(ContainerRequestContext requestContext) {
        String authScheme = null;
        Principal userPrincipal = requestContext.getSecurityContext().getUserPrincipal();
        if (userPrincipal instanceof JwtPrincipal) {
            authScheme = RestAuthType.JETTY_AUTH.name();
        } else if (this.authenticationModule != null) {
            block10: {
                try {
                    userPrincipal = this.authenticationModule.authenticate(requestContext);
                    if (!AuthenticationFilter.isAnonymous(userPrincipal)) break block10;
                    if (this.anonymousPrincipalEnabled) {
                        log.warn("Error attempting to authenticate the user; will authenticate as anonymous user");
                        userPrincipal = KafkaPrincipal.ANONYMOUS;
                        break block10;
                    }
                    AuthenticationFilter.handleAuthenticationFailure(new LoginException("Error attempting to authenticate the user; user cannot be anonymous"), requestContext);
                    return;
                }
                catch (LoginException e) {
                    if (this.anonymousPrincipalEnabled) {
                        log.warn("Error attempting to authenticate the user; will authenticate as anonymous user", (Throwable)e);
                        userPrincipal = KafkaPrincipal.ANONYMOUS;
                    }
                    AuthenticationFilter.handleAuthenticationFailure(e, requestContext);
                    return;
                }
            }
            authScheme = this.authenticationModule.getAuthScheme();
        }
        if (authScheme != null) {
            RestSecurityContext securityContext;
            try {
                securityContext = new RestSecurityContext(userPrincipal, authScheme);
            }
            catch (LoginException e) {
                AuthenticationFilter.handleAuthenticationFailure(e, requestContext);
                return;
            }
            requestContext.setSecurityContext((SecurityContext)securityContext);
            String userPrincipalName = userPrincipal.getName();
            log.debug("The principal is {} for {}", (Object)userPrincipalName, (Object)Thread.currentThread().getName());
        }
    }

    protected static boolean isAnonymous(Principal principal) {
        return principal == null || principal.getName() == null;
    }

    protected static void handleAuthenticationFailure(LoginException e, ContainerRequestContext requestContext) {
        Principal principal = requestContext.getSecurityContext().getUserPrincipal();
        log.error("Error attempting to authenticate the user: {} ", (Object)(principal != null ? principal.getName() : "N/A"), (Object)e);
        requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"User cannot access the resource").build());
    }
}

