/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest.exceptions;

import io.confluent.rest.RestConfig;
import io.confluent.rest.exceptions.DebuggableExceptionMapper;
import io.confluent.rest.exceptions.RestException;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class WebApplicationExceptionMapper
extends DebuggableExceptionMapper<WebApplicationException> {
    @Context
    HttpHeaders headers;

    public WebApplicationExceptionMapper(RestConfig restConfig) {
        super(restConfig);
    }

    public Response toResponse(WebApplicationException exc) {
        Response.Status status = Response.Status.fromStatusCode((int)exc.getResponse().getStatus());
        int errorCode = exc instanceof RestException ? ((RestException)exc).getErrorCode() : status.getStatusCode();
        Response.ResponseBuilder response = this.createResponse((Throwable)exc, errorCode, (Response.StatusType)(status != null ? status : new DebuggableExceptionMapper.HttpStatus(exc.getResponse().getStatus(), exc.getMessage())), exc.getMessage());
        if (status == Response.Status.UNSUPPORTED_MEDIA_TYPE) {
            response.type(this.negotiateContentType());
        }
        return response.build();
    }

    private String negotiateContentType() {
        List acceptable = this.headers.getAcceptableMediaTypes();
        for (MediaType mt : acceptable) {
            for (String providable : this.restConfig.getList("response.mediatype.preferred")) {
                if (!mt.toString().equals(providable)) continue;
                return providable;
            }
        }
        return this.restConfig.getString("response.mediatype.default");
    }
}

