/*
 * Decompiled with CFR 0.152.
 */
package kafka.catalog.event;

import java.util.OptionalLong;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import kafka.catalog.MetadataEventUtils;
import kafka.catalog.ZKMetadataCollector;
import kafka.catalog.ZKMetadataCollectorContext;
import kafka.catalog.ZkMetadataEventProvider;
import kafka.catalog.event.MetadataCollectorEvent;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.queue.EventQueue;

public class SnapshotEvent
extends MetadataCollectorEvent {
    public SnapshotEvent(ZKMetadataCollector collector, Time time) {
        super(collector, time);
    }

    public void run() throws Exception {
        ZKMetadataCollectorContext context = this.context();
        int maxBytes = context.config().maxBytesInSnapshot;
        for (String logicalCluster : context.localStore().logicalClusters()) {
            ZkMetadataEventProvider provider = new ZkMetadataEventProvider(context.localStore(), logicalCluster);
            MetadataEventUtils.buildAndEmitSnapshot(logicalCluster, provider, maxBytes, context.epoch(), context.config().destTopic, context.eventEmitter(), context.catalogMetrics(), LOG);
        }
        long currNs = this.time.nanoseconds();
        context.catalogMetrics().snapshotEmittingDelayMsMetric.update(TimeUnit.MILLISECONDS.convert(currNs - context.lastSnapshotNs(), TimeUnit.NANOSECONDS));
        context.setLastSnapshotNs(currNs);
        context.eventQueue().scheduleDeferred("SNAPSHOT_EVENT", (Function<OptionalLong, OptionalLong>)new EventQueue.DeadlineFunction(currNs + TimeUnit.NANOSECONDS.convert(context.config().snapshotIntervalSec, TimeUnit.SECONDS)), new SnapshotEvent(this.collector, this.time));
    }
}

