/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.quota;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import kafka.coordinator.quota.QuotaConsumption;
import kafka.coordinator.quota.QuotaCoordinator$;
import kafka.coordinator.quota.QuotaCoordinatorConfig;
import kafka.coordinator.quota.QuotaDescription;
import kafka.coordinator.quota.QuotaEntity;
import kafka.coordinator.quota.QuotaEntityAndConsumptions;
import kafka.coordinator.quota.QuotaEntry;
import kafka.coordinator.quota.QuotaStateManager;
import kafka.coordinator.quota.QuotaValue;
import kafka.coordinator.quota.ReportQuotaResult;
import kafka.server.BrokerReconfigurable;
import kafka.server.InternalAdmin;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaManager;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.quota.ClientQuotaType;
import org.apache.kafka.server.quota.ClusterLevelQuotaCallback;
import org.apache.kafka.server.record.BrokerCompressionType;
import org.apache.kafka.server.util.Scheduler;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\tUv!\u0002\u00180\u0011\u00031d!\u0002\u001d0\u0011\u0003I\u0004\"\u0002!\u0002\t\u0003\t\u0005b\u0002\"\u0002\u0005\u0004%\ta\u0011\u0005\u0007+\u0006\u0001\u000b\u0011\u0002#\t\u000bY\u000bA\u0011A,\t\u000f\t=\u0016\u0001\"\u0003\u00032\u001a!\u0001h\f\u0001Z\u0011!1wA!b\u0001\n\u00039\u0007\u0002C6\b\u0005\u0003\u0005\u000b\u0011\u00025\t\u00111<!Q1A\u0005\u00025D\u0001\"]\u0004\u0003\u0002\u0003\u0006IA\u001c\u0005\te\u001e\u0011)\u0019!C\u0001g\"Aqo\u0002B\u0001B\u0003%A\u000f\u0003\u0005y\u000f\t\u0015\r\u0011\"\u0001z\u0011%\tia\u0002B\u0001B\u0003%!\u0010\u0003\u0006\u0002\u0010\u001d\u0011)\u0019!C\u0001\u0003#A!\"a\u000b\b\u0005\u0003\u0005\u000b\u0011BA\n\u0011)\tic\u0002BC\u0002\u0013\u0005\u0011q\u0006\u0005\u000b\u0003w9!\u0011!Q\u0001\n\u0005E\u0002BCA\u001f\u000f\t\u0015\r\u0011\"\u0001\u0002@!Q\u0011qJ\u0004\u0003\u0002\u0003\u0006I!!\u0011\t\r\u0001;A\u0011AA)\u0011%\t\tg\u0002b\u0001\n\u0003\t\u0019\u0007\u0003\u0005\u0002v\u001d\u0001\u000b\u0011BA3\u0011%\t9h\u0002a\u0001\n\u0003\tI\bC\u0005\u0002\u0002\u001e\u0001\r\u0011\"\u0001\u0002\u0004\"A\u0011qR\u0004!B\u0013\tY\bC\u0005\u0002\u001a\u001e\u0001\r\u0011\"\u0001\u0002z!I\u00111T\u0004A\u0002\u0013\u0005\u0011Q\u0014\u0005\t\u0003C;\u0001\u0015)\u0003\u0002|!9\u0011QU\u0004\u0005\u0002\u0005\u001d\u0006bBAZ\u000f\u0011\u0005\u0011Q\u0017\u0005\b\u0003\u000f<A\u0011AAe\u0011\u001d\t\u0019n\u0002C\u0001\u0003+DqA!\u0002\b\t\u0003\u00119\u0001C\u0004\u0003,\u001d!\tA!\f\t\u000f\t]r\u0001\"\u0001\u0003:!9!QH\u0004\u0005\u0002\t}\u0002b\u0002B%\u000f\u0011\u0005!1\n\u0005\b\u0005+:A\u0011\u0001B,\u0011\u001d\u0011yf\u0002C\u0001\u0005CBqA!\u001c\b\t\u0003\u0011y\u0007\u0003\u0004\u0003r\u001d!\te\u0011\u0005\b\u0005g:A\u0011\tB;\u0011\u001d\u0011\ti\u0002C\u0001\u0005\u0007\u000b\u0001#U;pi\u0006\u001cun\u001c:eS:\fGo\u001c:\u000b\u0005A\n\u0014!B9v_R\f'B\u0001\u001a4\u0003-\u0019wn\u001c:eS:\fGo\u001c:\u000b\u0003Q\nQa[1gW\u0006\u001c\u0001\u0001\u0005\u00028\u00035\tqF\u0001\tRk>$\u0018mQ8pe\u0012Lg.\u0019;peN\u0011\u0011A\u000f\t\u0003wyj\u0011\u0001\u0010\u0006\u0002{\u0005)1oY1mC&\u0011q\b\u0010\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u00051\u0014!\u0006*fG>tg-[4ve\u0006\u0014G.Z\"p]\u001aLwm]\u000b\u0002\tB\u0019Q\t\u0013&\u000e\u0003\u0019S!a\u0012\u001f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002J\r\n\u00191+\u001a;\u0011\u0005-\u0013fB\u0001'Q!\tiE(D\u0001O\u0015\tyU'\u0001\u0004=e>|GOP\u0005\u0003#r\na\u0001\u0015:fI\u00164\u0017BA*U\u0005\u0019\u0019FO]5oO*\u0011\u0011\u000bP\u0001\u0017%\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007>tg-[4tA\u0005)\u0011\r\u001d9msRy\u0001La#\u0003\u0010\nE%1\u0014BO\u0005?\u0013i\u000b\u0005\u00028\u000fM!qA\u000f.a!\tYf,D\u0001]\u0015\ti6'A\u0003vi&d7/\u0003\u0002`9\n9Aj\\4hS:<\u0007CA1e\u001b\u0005\u0011'BA24\u0003\u0019\u0019XM\u001d<fe&\u0011QM\u0019\u0002\u0015\u0005J|7.\u001a:SK\u000e|gNZ5hkJ\f'\r\\3\u0002\u0011\t\u0014xn[3s\u0013\u0012,\u0012\u0001\u001b\t\u0003w%L!A\u001b\u001f\u0003\u0007%sG/A\u0005ce>\\WM]%eA\u0005Y\u0011/^8uC\u000e{gNZ5h+\u0005q\u0007CA\u001cp\u0013\t\u0001xF\u0001\fRk>$\u0018mQ8pe\u0012Lg.\u0019;pe\u000e{gNZ5h\u00031\tXo\u001c;b\u0007>tg-[4!\u0003E\tXo\u001c;b'R\fG/Z'b]\u0006<WM]\u000b\u0002iB\u0011q'^\u0005\u0003m>\u0012\u0011#U;pi\u0006\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s\u0003I\tXo\u001c;b'R\fG/Z'b]\u0006<WM\u001d\u0011\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014X#\u0001>\u0011\u0007m\fI!D\u0001}\u0015\tih0\u0001\u0003vi&d'BA2\u0000\u0015\r!\u0014\u0011\u0001\u0006\u0005\u0003\u0007\t)!\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003\u000f\t1a\u001c:h\u0013\r\tY\u0001 \u0002\n'\u000eDW\rZ;mKJ\f!b]2iK\u0012,H.\u001a:!\u0003UIg\u000e^3s]\u0006d\u0017\tZ7j]N+\b\u000f\u001d7jKJ,\"!a\u0005\u0011\r\u0005U\u0011\u0011EA\u0013\u001b\t\t9B\u0003\u0003\u0002\u001a\u0005m\u0011\u0001\u00034v]\u000e$\u0018n\u001c8\u000b\u0007u\fiB\u0003\u0002\u0002 \u0005!!.\u0019<b\u0013\u0011\t\u0019#a\u0006\u0003\u0011M+\b\u000f\u001d7jKJ\u00042!YA\u0014\u0013\r\tIC\u0019\u0002\u000e\u0013:$XM\u001d8bY\u0006#W.\u001b8\u0002-%tG/\u001a:oC2\fE-\\5o'V\u0004\b\u000f\\5fe\u0002\n\u0011d\u00197vgR,'\u000fT3wK2\fVo\u001c;b\u0007\u0006dGNY1dWV\u0011\u0011\u0011\u0007\t\u0005\u0003g\t9$\u0004\u0002\u00026)\u0011\u0001G`\u0005\u0005\u0003s\t)DA\rDYV\u001cH/\u001a:MKZ,G.U;pi\u0006\u001c\u0015\r\u001c7cC\u000e\\\u0017AG2mkN$XM\u001d'fm\u0016d\u0017+^8uC\u000e\u000bG\u000e\u001c2bG.\u0004\u0013\u0001\u0002;j[\u0016,\"!!\u0011\u0011\t\u0005\r\u00131J\u0007\u0003\u0003\u000bR1!XA$\u0015\r\tIe`\u0001\u0007G>lWn\u001c8\n\t\u00055\u0013Q\t\u0002\u0005)&lW-A\u0003uS6,\u0007\u0005F\bY\u0003'\n)&a\u0016\u0002Z\u0005m\u0013QLA0\u0011\u00151g\u00031\u0001i\u0011\u0015ag\u00031\u0001o\u0011\u0015\u0011h\u00031\u0001u\u0011\u0015Ah\u00031\u0001{\u0011\u001d\tyA\u0006a\u0001\u0003'Aq!!\f\u0017\u0001\u0004\t\t\u0004C\u0004\u0002>Y\u0001\r!!\u0011\u0002\u0011%\u001c\u0018i\u0019;jm\u0016,\"!!\u001a\u0011\t\u0005\u001d\u0014\u0011O\u0007\u0003\u0003SRA!a\u001b\u0002n\u00051\u0011\r^8nS\u000eTA!a\u001c\u0002\u001c\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005M\u0014\u0011\u000e\u0002\u000e\u0003R|W.[2C_>dW-\u00198\u0002\u0013%\u001c\u0018i\u0019;jm\u0016\u0004\u0013A\b2s_.,'\u000fV3oC:$H*[7jiB\u0013x\u000eZ;dKJ\fVo\u001c;b+\t\tY\bE\u0002<\u0003{J1!a =\u0005\u0011auN\\4\u0002E\t\u0014xn[3s)\u0016t\u0017M\u001c;MS6LG\u000f\u0015:pIV\u001cWM])v_R\fw\fJ3r)\u0011\t))a#\u0011\u0007m\n9)C\u0002\u0002\nr\u0012A!\u00168ji\"I\u0011Q\u0012\u000e\u0002\u0002\u0003\u0007\u00111P\u0001\u0004q\u0012\n\u0014a\b2s_.,'\u000fV3oC:$H*[7jiB\u0013x\u000eZ;dKJ\fVo\u001c;bA!\u001a1$a%\u0011\u0007m\n)*C\u0002\u0002\u0018r\u0012\u0001B^8mCRLG.Z\u0001\u001fEJ|7.\u001a:UK:\fg\u000e\u001e'j[&$8i\u001c8tk6,'/U;pi\u0006\f!E\u0019:pW\u0016\u0014H+\u001a8b]Rd\u0015.\\5u\u0007>t7/^7feF+x\u000e^1`I\u0015\fH\u0003BAC\u0003?C\u0011\"!$\u001e\u0003\u0003\u0005\r!a\u001f\u0002?\t\u0014xn[3s)\u0016t\u0017M\u001c;MS6LGoQ8ogVlWM])v_R\f\u0007\u0005K\u0002\u001f\u0003'\u000b\u0011b]3u\u0003\u000e$\u0018N^3\u0015\t\u0005\u0015\u0015\u0011\u0016\u0005\b\u0003W{\u0002\u0019AAW\u0003\u0019\t7\r^5wKB\u00191(a,\n\u0007\u0005EFHA\u0004C_>dW-\u00198\u0002'\u001d,GO\u0011:pW\u0016\u0014\u0018+^8uC2KW.\u001b;\u0015\t\u0005]\u0016Q\u0018\t\u0004w\u0005e\u0016bAA^y\t1Ai\\;cY\u0016Dq!a0!\u0001\u0004\t\t-A\u0005rk>$\u0018\rV=qKB!\u00111GAb\u0013\u0011\t)-!\u000e\u0003\u001f\rc\u0017.\u001a8u#V|G/\u0019+za\u0016\fA$\u001e9eCR,'I]8lKJ$VM\\1oiF+x\u000e^1MS6LG\u000f\u0006\u0004\u0002\u0006\u0006-\u0017q\u001a\u0005\b\u0003\u001b\f\u0003\u0019AA>\u00035\u0001(o\u001c3vG\u0016\u0014\u0018+^8uC\"9\u0011\u0011[\u0011A\u0002\u0005m\u0014!D2p]N,X.\u001a:Rk>$\u0018-A\u0007d_6\u0004X\u000f^3Rk>$\u0018m\u001d\u000b\t\u0003\u000b\u000b9.!7\u0002v\")aM\ta\u0001Q\"9\u00111\u001c\u0012A\u0002\u0005u\u0017\u0001D9v_R\fWI\u001c;sS\u0016\u001c\bCBAp\u0003S\fyO\u0004\u0003\u0002b\u0006\u0015hbA'\u0002d&\tQ(C\u0002\u0002hr\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002l\u00065(\u0001C%uKJ\f'\r\\3\u000b\u0007\u0005\u001dH\bE\u00028\u0003cL1!a=0\u0005i\tVo\u001c;b\u000b:$\u0018\u000e^=B]\u0012\u001cuN\\:v[B$\u0018n\u001c8t\u0011\u001d\t9P\ta\u0001\u0003s\f\u0001C]3ta>t7/Z\"bY2\u0014\u0017mY6\u0011\u000fm\nY0a@\u0002\u0006&\u0019\u0011Q \u001f\u0003\u0013\u0019+hn\u0019;j_:\f\u0004cA\u001c\u0003\u0002%\u0019!1A\u0018\u0003#I+\u0007o\u001c:u#V|G/\u0019*fgVdG/A\u0007eKN\u001c'/\u001b2f#V|G/\u0019\u000b\u0005\u0005\u0013\u0011\t\u0003E\u0004<\u0005\u0017\u0011yAa\u0007\n\u0007\t5AH\u0001\u0004UkBdWM\r\t\u0005\u0005#\u00119\"\u0004\u0002\u0003\u0014)!!QCA$\u0003!\u0001(o\u001c;pG>d\u0017\u0002\u0002B\r\u0005'\u0011a!\u0012:s_J\u001c\bcA\u001c\u0003\u001e%\u0019!qD\u0018\u0003!E+x\u000e^1EKN\u001c'/\u001b9uS>t\u0007b\u0002B\u0012G\u0001\u0007!QE\u0001\fcV|G/Y#oi&$\u0018\u0010E\u00028\u0005OI1A!\u000b0\u0005-\tVo\u001c;b\u000b:$\u0018\u000e^=\u0002%E,x\u000e^1t)>\u0004\u0018nY\"p]\u001aLwm]\u000b\u0003\u0005_\u0001BA!\r\u000345\u0011\u00111D\u0005\u0005\u0005k\tYB\u0001\u0006Qe>\u0004XM\u001d;jKN\fA\u0002]1si&$\u0018n\u001c8G_J$2\u0001\u001bB\u001e\u0011\u001d\u0011\u0019#\na\u0001\u0005K\t1C^1mS\u0012\fG/Z)v_R\fWI\u001c;jif$BA!\u0011\u0003HA)1Ha\u0011\u0003\u0010%\u0019!Q\t\u001f\u0003\r=\u0003H/[8o\u0011\u001d\u0011\u0019C\na\u0001\u0005K\t!b\u001c8FY\u0016\u001cG/[8o)\u0019\t)I!\u0014\u0003R!1!qJ\u0014A\u0002!\fQ#];pi\u0006$v\u000e]5d!\u0006\u0014H/\u001b;j_:LE\r\u0003\u0004\u0003T\u001d\u0002\r\u0001[\u0001\u0011G>|'\u000fZ5oCR|'/\u00129pG\"\fQb\u001c8SKNLwM\\1uS>tGCBAC\u00053\u0012Y\u0006\u0003\u0004\u0003P!\u0002\r\u0001\u001b\u0005\b\u0005'B\u0003\u0019\u0001B/!\u0011Y$1\t5\u0002\u000fM$\u0018M\u001d;vaR!\u0011Q\u0011B2\u0011\u001d\u0011)'\u000ba\u0001\u0005O\n\u0001E]3ue&,g/Z)v_R\fGk\u001c9jGB\u000b'\u000f^5uS>t7i\\;oiB!1H!\u001bi\u0013\r\u0011Y\u0007\u0010\u0002\n\rVt7\r^5p]B\n\u0001b\u001d5vi\u0012|wO\u001c\u000b\u0003\u0003\u000b\u000bQC]3d_:4\u0017nZ;sC\ndWmQ8oM&<7/A\fwC2LG-\u0019;f%\u0016\u001cwN\u001c4jOV\u0014\u0018\r^5p]R!\u0011Q\u0011B<\u0011\u001d\u0011I\b\fa\u0001\u0005w\n\u0011B\\3x\u0007>tg-[4\u0011\u0007\u0005\u0014i(C\u0002\u0003\u0000\t\u00141bS1gW\u0006\u001cuN\u001c4jO\u0006Y!/Z2p]\u001aLw-\u001e:f)\u0019\t)I!\"\u0003\n\"9!qQ\u0017A\u0002\tm\u0014!C8mI\u000e{gNZ5h\u0011\u001d\u0011I(\fa\u0001\u0005wBqA!$\u0006\u0001\u0004\u0011Y(\u0001\u0004d_:4\u0017n\u001a\u0005\u0006q\u0016\u0001\rA\u001f\u0005\b\u0005'+\u0001\u0019\u0001BK\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u00042!\u0019BL\u0013\r\u0011IJ\u0019\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0011\u001d\ty!\u0002a\u0001\u0003'Aq!!\f\u0006\u0001\u0004\t\t\u0004C\u0004\u0003\"\u0016\u0001\rAa)\u0002\u000f5,GO]5dgB!!Q\u0015BU\u001b\t\u00119K\u0003\u0003\u0003\"\u0006\u001d\u0013\u0002\u0002BV\u0005O\u0013q!T3ue&\u001c7\u000fC\u0004\u0002>\u0015\u0001\r!!\u0011\u0002-E,x\u000e^1D_>\u0014H-\u001b8bi>\u00148i\u001c8gS\u001e$2A\u001cBZ\u0011\u001d\u0011iI\u0002a\u0001\u0005w\u0002")
public class QuotaCoordinator
implements Logging,
BrokerReconfigurable {
    private final int brokerId;
    private final QuotaCoordinatorConfig quotaConfig;
    private final QuotaStateManager quotaStateManager;
    private final Scheduler scheduler;
    private final Supplier<InternalAdmin> internalAdminSupplier;
    private final ClusterLevelQuotaCallback clusterLevelQuotaCallback;
    private final Time time;
    private final AtomicBoolean isActive;
    private volatile long brokerTenantLimitProducerQuota;
    private volatile long brokerTenantLimitConsumerQuota;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static QuotaCoordinator apply(KafkaConfig config, Scheduler scheduler, ReplicaManager replicaManager, Supplier<InternalAdmin> internalAdminSupplier, ClusterLevelQuotaCallback clusterLevelQuotaCallback, Metrics metrics, Time time) {
        QuotaCoordinatorConfig apply_quotaConfig = QuotaCoordinator$.MODULE$.kafka$coordinator$quota$QuotaCoordinator$$quotaCoordinatorConfig(config);
        QuotaStateManager apply_quotaStateManager = new QuotaStateManager(apply_quotaConfig, scheduler, replicaManager, metrics, time);
        return new QuotaCoordinator(config.brokerId(), apply_quotaConfig, apply_quotaStateManager, scheduler, internalAdminSupplier, clusterLevelQuotaCallback, time);
    }

    public static Set<String> ReconfigurableConfigs() {
        return QuotaCoordinator$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public QuotaCoordinatorConfig quotaConfig() {
        return this.quotaConfig;
    }

    public QuotaStateManager quotaStateManager() {
        return this.quotaStateManager;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public Supplier<InternalAdmin> internalAdminSupplier() {
        return this.internalAdminSupplier;
    }

    public ClusterLevelQuotaCallback clusterLevelQuotaCallback() {
        return this.clusterLevelQuotaCallback;
    }

    public Time time() {
        return this.time;
    }

    public AtomicBoolean isActive() {
        return this.isActive;
    }

    public long brokerTenantLimitProducerQuota() {
        return this.brokerTenantLimitProducerQuota;
    }

    public void brokerTenantLimitProducerQuota_$eq(long x$1) {
        this.brokerTenantLimitProducerQuota = x$1;
    }

    public long brokerTenantLimitConsumerQuota() {
        return this.brokerTenantLimitConsumerQuota;
    }

    public void brokerTenantLimitConsumerQuota_$eq(long x$1) {
        this.brokerTenantLimitConsumerQuota = x$1;
    }

    public void setActive(boolean active) {
        this.isActive().set(active);
    }

    public double getBrokerQuotaLimit(ClientQuotaType quotaType) {
        if (ClientQuotaType.FETCH.equals(quotaType)) {
            return this.brokerTenantLimitConsumerQuota();
        }
        if (ClientQuotaType.PRODUCE.equals(quotaType)) {
            return this.brokerTenantLimitProducerQuota();
        }
        throw new IllegalArgumentException(new StringBuilder(25).append("Not a client quota type: ").append(quotaType).toString());
    }

    public void updateBrokerTenantQuotaLimit(long producerQuota, long consumerQuota) {
        this.brokerTenantLimitProducerQuota_$eq(producerQuota);
        this.brokerTenantLimitConsumerQuota_$eq(consumerQuota);
    }

    public void computeQuotas(int brokerId, Iterable<QuotaEntityAndConsumptions> quotaEntries, Function1<ReportQuotaResult, BoxedUnit> responseCallback) {
        if (!this.isActive().get()) {
            responseCallback.apply((Object)new ReportQuotaResult((Map<QuotaEntity, Errors>)((IterableOnceOps)quotaEntries.map((Function1 & Serializable)quotaEntityAndConsumptions -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)quotaEntityAndConsumptions.entity()), (Object)Errors.COORDINATOR_NOT_AVAILABLE))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())));
            return;
        }
        scala.collection.mutable.Map invalidQuotaEntries = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        Buffer validQuotaEntries = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        quotaEntries.foreach((Function1 & Serializable)quotaEntityAndConsumptions -> {
            this.processQuotaEntry$1(quotaEntityAndConsumptions, invalidQuotaEntries, brokerId, validQuotaEntries);
            return BoxedUnit.UNIT;
        });
        if (invalidQuotaEntries.nonEmpty()) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(76).append("Skipping quota computation for ").append(invalidQuotaEntries.size()).append(" quota entries because they failed validation").toString());
        }
        scala.collection.immutable.Map quotaEntriesPerPartition = validQuotaEntries.groupBy((Function1 & Serializable)quotaEntry -> new TopicPartition("_confluent-quotas", this.partitionFor(quotaEntry.quotaEntity())));
        this.quotaStateManager().storeQuotas((Map<TopicPartition, Iterable<QuotaEntry>>)quotaEntriesPerPartition, (Function1<Map<Object, Errors>, BoxedUnit>)(Function1 & Serializable)responseStatus -> {
            this.storeQuotaCallback$1(responseStatus, quotaEntries, responseCallback, invalidQuotaEntries);
            return BoxedUnit.UNIT;
        }, this.quotaStateManager().storeQuotas$default$3());
    }

    public Tuple2<Errors, QuotaDescription> describeQuota(QuotaEntity quotaEntity) {
        if (!this.isActive().get()) {
            return new Tuple2((Object)Errors.COORDINATOR_NOT_AVAILABLE, (Object)new QuotaDescription((Map<Object, Map<String, Object>>)((Map)scala.collection.Map$.MODULE$.empty())));
        }
        Option<Errors> option = this.validateQuotaEntity(quotaEntity);
        if (option instanceof Some) {
            Errors error = (Errors)((Some)option).value();
            return new Tuple2((Object)error, (Object)new QuotaDescription((Map<Object, Map<String, Object>>)((Map)scala.collection.Map$.MODULE$.empty())));
        }
        if (None$.MODULE$.equals(option)) {
            Option<QuotaEntry> option2 = this.quotaStateManager().getQuota(quotaEntity);
            if (option2 instanceof Some) {
                QuotaEntry quotaEntry = (QuotaEntry)((Some)option2).value();
                return new Tuple2((Object)Errors.NONE, (Object)new QuotaDescription((Map<Object, Map<String, Object>>)((IterableOnceOps)((IterableOps)quotaEntry.computedQuotas().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)QuotaCoordinator.$anonfun$describeQuota$1(x$1)))).map((Function1 & Serializable)x0$1 -> {
                    if (x0$1 != null) {
                        int brokerId = x0$1._1$mcI$sp();
                        scala.collection.mutable.Map perBrokerQuotas = (scala.collection.mutable.Map)x0$1._2();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)brokerId)), (Object)perBrokerQuotas.map((Function1 & Serializable)x0$2 -> {
                            if (x0$2 != null) {
                                String quotaType = (String)x0$2._1();
                                QuotaValue quotaValue = (QuotaValue)x0$2._2();
                                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)quotaType), (Object)BoxesRunTime.boxToDouble((double)quotaValue.quota()));
                            }
                            throw new MatchError(null);
                        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                    }
                    throw new MatchError(null);
                })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())));
            }
            if (None$.MODULE$.equals(option2)) {
                return new Tuple2((Object)Errors.QUOTA_ENTITY_NOT_FOUND, (Object)new QuotaDescription((Map<Object, Map<String, Object>>)((Map)scala.collection.Map$.MODULE$.empty())));
            }
            throw new MatchError(option2);
        }
        throw new MatchError(option);
    }

    public Properties quotasTopicConfigs() {
        Properties props = new Properties();
        props.put("cleanup.policy", "compact");
        props.put("segment.bytes", Integer.toString(this.quotaConfig().quotasTopicSegmentBytes()));
        props.put("compression.type", BrokerCompressionType.PRODUCER.name);
        props.put("confluent.placement.constraints", this.quotaConfig().quotasTopicPlacementConstraints());
        return props;
    }

    public int partitionFor(QuotaEntity quotaEntity) {
        return this.quotaStateManager().partitionFor(quotaEntity);
    }

    public Option<Errors> validateQuotaEntity(QuotaEntity quotaEntity) {
        if (this.quotaStateManager().isLoadingQuotaEntity(quotaEntity)) {
            return new Some((Object)Errors.COORDINATOR_LOAD_IN_PROGRESS);
        }
        if (!this.quotaStateManager().ownsQuotaEntity(quotaEntity)) {
            return new Some((Object)Errors.NOT_COORDINATOR);
        }
        return None$.MODULE$;
    }

    public void onElection(int quotaTopicPartitionId, int coordinatorEpoch) {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(57).append("Elected as the quota coordinator for partition ").append(quotaTopicPartitionId).append(" at epoch ").append(coordinatorEpoch).toString());
        this.quotaStateManager().loadQuotaState(quotaTopicPartitionId, coordinatorEpoch);
    }

    public void onResignation(int quotaTopicPartitionId, Option<Object> coordinatorEpoch) {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(58).append("Resigned as the quota coordinator for partition ").append(quotaTopicPartitionId).append(" at epoch ").append(coordinatorEpoch).toString());
        this.quotaStateManager().unloadQuotaState(quotaTopicPartitionId, coordinatorEpoch);
    }

    public void startup(Function0<Object> retrieveQuotaTopicPartitionCount) {
        this.info((Function0<String>)(Function0 & Serializable)() -> "Starting up.");
        this.scheduler().startup();
        this.quotaStateManager().startup(retrieveQuotaTopicPartitionCount, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.maybeCreateQuotaTopic$1());
        this.info((Function0<String>)(Function0 & Serializable)() -> "Startup complete.");
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable)() -> "Shutting down.");
        this.isActive().set(false);
        this.quotaStateManager().shutdown();
        this.scheduler().shutdown();
        this.info((Function0<String>)(Function0 & Serializable)() -> "Shutdown complete.");
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return QuotaCoordinator$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        if (Predef$.MODULE$.Long2long(newConfig.confluentConfig().maxBrokerTenantProducerByteRate()) < 0L) {
            throw new ConfigException("Updating client bandwidth throttle config require 'confluent.quota.tenant.broker.max.producer.rate' to be positive");
        }
        if (Predef$.MODULE$.Long2long(newConfig.confluentConfig().maxBrokerTenantConsumerByteRate()) < 0L) {
            throw new ConfigException("Updating client bandwidth throttle config require 'confluent.quota.tenant.broker.max.consumer.rate'  to be positive");
        }
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        block5: {
            block4: {
                Integer n = newConfig.confluentConfig().quotasExpirationTimeMs();
                Integer n2 = oldConfig.confluentConfig().quotasExpirationTimeMs();
                if (n == null ? n2 != null : !((Object)n).equals(n2)) {
                    this.quotaStateManager().reconfigure(QuotaCoordinator$.MODULE$.kafka$coordinator$quota$QuotaCoordinator$$quotaCoordinatorConfig(newConfig));
                }
                Long l = newConfig.confluentConfig().maxBrokerTenantConsumerByteRate();
                Long l2 = oldConfig.confluentConfig().maxBrokerTenantConsumerByteRate();
                if (l != null ? !((Object)l).equals(l2) : l2 != null) break block4;
                Long l3 = newConfig.confluentConfig().maxBrokerTenantProducerByteRate();
                Long l4 = oldConfig.confluentConfig().maxBrokerTenantProducerByteRate();
                if (!(l3 == null ? l4 != null : !((Object)l3).equals(l4))) break block5;
            }
            this.updateBrokerTenantQuotaLimit(Predef$.MODULE$.Long2long(newConfig.confluentConfig().maxBrokerTenantProducerByteRate()), Predef$.MODULE$.Long2long(newConfig.confluentConfig().maxBrokerTenantConsumerByteRate()));
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$computeQuotas$3(QuotaCoordinator $this, QuotaEntry quotaEntry$1, int brokerId$1, QuotaConsumption quotaConsumption) {
        String valueOf_name = quotaConsumption.quotaType();
        Object var6_4 = null;
        ClientQuotaType clientQuotaType = Enum.valueOf(ClientQuotaType.class, valueOf_name);
        Double clusterQuotaLimit = $this.clusterLevelQuotaCallback().clusterQuotaLimit(clientQuotaType, CollectionConverters$.MODULE$.MapHasAsJava(quotaEntry$1.quotaEntity().entityTypes()).asJava());
        quotaEntry$1.updateConsumptionAndRecomputeQuotas(brokerId$1, quotaConsumption, Predef$.MODULE$.Double2double(clusterQuotaLimit), $this.getBrokerQuotaLimit(clientQuotaType), $this.time().milliseconds(), $this.quotaConfig().quotasConsumptionExpirationTimeMs(), $this.quotaConfig().quotasRecomputeIntervalMs(), $this.quotaConfig().quotasLazyEvaluationThreshold());
    }

    private final void processQuotaEntry$1(QuotaEntityAndConsumptions quotaEntityAndConsumptions, scala.collection.mutable.Map invalidQuotaEntries$1, int brokerId$1, Buffer validQuotaEntries$1) {
        Option<Errors> option = this.validateQuotaEntity(quotaEntityAndConsumptions.entity());
        if (option instanceof Some) {
            Errors error = (Errors)((Some)option).value();
            invalidQuotaEntries$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)quotaEntityAndConsumptions.entity()), (Object)error));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            QuotaEntry quotaEntry = this.quotaStateManager().getAndMaybePutQuota(quotaEntityAndConsumptions.entity());
            quotaEntry.inLock((JFunction0.mcV.sp & Serializable)() -> quotaEntityAndConsumptions.consumptions().foreach((Function1 & Serializable)quotaConsumption -> {
                QuotaCoordinator.$anonfun$computeQuotas$3(this, quotaEntry, brokerId$1, quotaConsumption);
                return BoxedUnit.UNIT;
            }));
            validQuotaEntries$1.$plus$eq((Object)quotaEntry);
            return;
        }
        throw new MatchError(option);
    }

    private final void storeQuotaCallback$1(Map responseStatus, Iterable quotaEntries$1, Function1 responseCallback$1, scala.collection.mutable.Map invalidQuotaEntries$1) {
        scala.collection.immutable.Map entityResults = ((IterableOnceOps)quotaEntries$1.map((Function1 & Serializable)quotaEntry -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)quotaEntry.entity()), responseStatus.getOrElse((Object)BoxesRunTime.boxToInteger((int)this.partitionFor(quotaEntry.entity())), (Function0 & Serializable)() -> Errors.UNKNOWN_SERVER_ERROR)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        responseCallback$1.apply((Object)new ReportQuotaResult((Map<QuotaEntity, Errors>)((Map)entityResults.$plus$plus((IterableOnce)invalidQuotaEntries$1))));
    }

    public static final /* synthetic */ boolean $anonfun$describeQuota$1(Tuple2 x$1) {
        return ((IterableOnceOps)x$1._2()).nonEmpty();
    }

    private final void maybeCreateQuotaTopic$1() {
        boolean topicCreated = false;
        while (!topicCreated) {
            try {
                this.internalAdminSupplier().get().ensureTopic("_confluent-quotas", this.quotaConfig().quotasTopicPartitions(), this.quotaConfig().quotasTopicReplicationFactor(), this.quotasTopicConfigs());
                topicCreated = true;
                this.isActive().set(true);
            }
            catch (Throwable t) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(78).append("Failed to create topic ").append("_confluent-quotas").append(" with error ").append(t).append(", retrying after 5 seconds").toString());
                Thread.sleep(5000L);
            }
        }
    }

    public QuotaCoordinator(int brokerId, QuotaCoordinatorConfig quotaConfig, QuotaStateManager quotaStateManager, Scheduler scheduler, Supplier<InternalAdmin> internalAdminSupplier, ClusterLevelQuotaCallback clusterLevelQuotaCallback, Time time) {
        this.brokerId = brokerId;
        this.quotaConfig = quotaConfig;
        this.quotaStateManager = quotaStateManager;
        this.scheduler = scheduler;
        this.internalAdminSupplier = internalAdminSupplier;
        this.clusterLevelQuotaCallback = clusterLevelQuotaCallback;
        this.time = time;
        this.isActive = new AtomicBoolean(false);
        this.logIdent_$eq(new StringBuilder(30).append("[QuotaCoordinator brokerId=").append(brokerId).append("]: ").toString());
        this.brokerTenantLimitProducerQuota = quotaConfig.quotasBrokerLimitProducer();
        this.brokerTenantLimitConsumerQuota = quotaConfig.quotasBrokerLimitConsumer();
    }
}

