/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.availability.FilesWrapper;
import io.confluent.kafka.storage.checksum.E2EChecksumStore;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kafka.common.LogSegmentOffsetOverflowException;
import kafka.log.LocalLog$;
import kafka.log.LogLoader$;
import kafka.log.LogSegment;
import kafka.log.LogSegment$;
import kafka.log.LogSegments;
import kafka.log.MergedLog$;
import kafka.log.SplitSegmentResult;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidOffsetException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.snapshot.Snapshots;
import org.apache.kafka.storage.internals.epoch.LeaderEpochFileCache;
import org.apache.kafka.storage.internals.log.CorruptIndexException;
import org.apache.kafka.storage.internals.log.LoadedLogOffsets;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogFileUtils;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.ProducerStateManager;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t5r!\u0002\u0011\"\u0011\u00031c!\u0002\u0015\"\u0011\u0003I\u0003\"\u0002\u001c\u0002\t\u00039\u0004b\u0002\u001d\u0002\u0005\u0004%\t!\u000f\u0005\u0007\u0005\u0006\u0001\u000b\u0011\u0002\u001e\t\u000f\r\u000b\u0011\u0013!C\u0001\t\"9A-AI\u0001\n\u0003)g\u0001\u0002\u0015\"\u0001)D\u0001b[\u0004\u0003\u0002\u0003\u0006I\u0001\u001c\u0005\te\u001e\u0011\t\u0011)A\u0005g\"Aap\u0002B\u0001B\u0003%q\u0010\u0003\u0006\u0002\u0012\u001d\u0011\t\u0011)A\u0005\u0003'A!\"!\t\b\u0005\u0003\u0005\u000b\u0011BA\u0012\u0011)\tic\u0002B\u0001B\u0003%\u0011q\u0006\u0005\n\u0003k9!\u0011!Q\u0001\n\u001dD!\"a\u000e\b\u0005\u0003\u0005\u000b\u0011BA\u001d\u0011)\tyd\u0002B\u0001B\u0003%\u0011\u0011\t\u0005\u000b\u0003\u000f:!\u0011!Q\u0001\n\u0005\u0005\u0003BCA%\u000f\t\u0005\t\u0015!\u0003\u0002L!Q\u0011QL\u0004\u0003\u0002\u0003\u0006I!a\u0018\t\u0013\u0005\u0015tA!A!\u0002\u00131\u0005BCA4\u000f\t\u0005\t\u0015!\u0003\u0002j!I\u0011qQ\u0004\u0003\u0002\u0003\u0006Ia\u001a\u0005\u0007m\u001d!\t!!#\t\u000f\u0005-v\u0001\"\u0001\u0002.\"9\u0011QW\u0004\u0005\n\u0005]\u0006bBAc\u000f\u0011%\u0011q\u0019\u0005\b\u0003W<A\u0011BAw\u0011\u001d\t)p\u0002C\u0005\u0003oD\u0001Ba\u0001\b\t\u0003\t#Q\u0001\u0005\b\u0005\u001b9A\u0011\u0002B\b\u0011\u001d\u00119c\u0002C\u0005\u0005S\t\u0011\u0002T8h\u0019>\fG-\u001a:\u000b\u0005\t\u001a\u0013a\u00017pO*\tA%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005\u001d\nQ\"A\u0011\u0003\u00131{w\rT8bI\u0016\u00148cA\u0001+aA\u00111FL\u0007\u0002Y)\tQ&A\u0003tG\u0006d\u0017-\u0003\u00020Y\t1\u0011I\\=SK\u001a\u0004\"!\r\u001b\u000e\u0003IR!aM\u0012\u0002\u000bU$\u0018\u000e\\:\n\u0005U\u0012$a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0019\n\u0011c\u00117fC:\u001c\u0006.\u001e;e_^tg)\u001b7f+\u0005Q\u0004CA\u001eA\u001b\u0005a$BA\u001f?\u0003\u0011a\u0017M\\4\u000b\u0003}\nAA[1wC&\u0011\u0011\t\u0010\u0002\u0007'R\u0014\u0018N\\4\u0002%\rcW-\u00198TQV$Hm\\<o\r&dW\rI\u0001\u001dI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u00194+\u0005)%F\u0001$\\!\u00119EJ\u0014-\u000e\u0003!S!!\u0013&\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002L}\u0005!Q\u000f^5m\u0013\ti\u0005JA\u0007D_:\u001cWO\u001d:f]Rl\u0015\r\u001d\t\u0003\u001fZs!\u0001\u0015+\u0011\u0005EcS\"\u0001*\u000b\u0005M+\u0013A\u0002\u001fs_>$h(\u0003\u0002VY\u00051\u0001K]3eK\u001aL!!Q,\u000b\u0005Uc\u0003CA\u0016Z\u0013\tQFFA\u0002J]R\\\u0013\u0001\u0018\t\u0003;\nl\u0011A\u0018\u0006\u0003?\u0002\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005\u0005d\u0013AC1o]>$\u0018\r^5p]&\u00111M\u0018\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001\b\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013'N\u000b\u0002M*\u0012qm\u0017\t\u0003W!L!!\u001b\u0017\u0003\u000f\t{w\u000e\\3b]N\u0019qA\u000b\u0019\u0002\u0007\u0011L'\u000f\u0005\u0002na6\taN\u0003\u0002p}\u0005\u0011\u0011n\\\u0005\u0003c:\u0014AAR5mK\u0006qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007C\u0001;}\u001b\u0005)(B\u0001<x\u0003\u0019\u0019w.\\7p]*\u0011A\u0005\u001f\u0006\u0003sj\fa!\u00199bG\",'\"A>\u0002\u0007=\u0014x-\u0003\u0002~k\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017AB2p]\u001aLw\r\u0005\u0003\u0002\u0002\u00055QBAA\u0002\u0015\r\u0011\u0013Q\u0001\u0006\u0005\u0003\u000f\tI!A\u0005j]R,'O\\1mg*\u0019\u00111B<\u0002\u000fM$xN]1hK&!\u0011qBA\u0002\u0005%aunZ\"p]\u001aLw-A\u0005tG\",G-\u001e7feB!\u0011QCA\u000f\u001b\t\t9BC\u0002L\u00033Q1!a\u0007x\u0003\u0019\u0019XM\u001d<fe&!\u0011qDA\f\u0005%\u00196\r[3ek2,'/\u0001\u0003uS6,\u0007\u0003BA\u0013\u0003Si!!a\n\u000b\u0005M*\u0018\u0002BA\u0016\u0003O\u0011A\u0001V5nK\u0006!Bn\\4ESJ4\u0015-\u001b7ve\u0016\u001c\u0005.\u00198oK2\u0004B!!\u0001\u00022%!\u00111GA\u0002\u0005Qaun\u001a#je\u001a\u000b\u0017\u000e\\;sK\u000eC\u0017M\u001c8fY\u0006\u0001\u0002.\u00193DY\u0016\fgn\u00155vi\u0012|wO\\\u0001\tg\u0016<W.\u001a8ugB\u0019q%a\u000f\n\u0007\u0005u\u0012EA\u0006M_\u001e\u001cVmZ7f]R\u001c\u0018\u0001\u00077pON#\u0018M\u001d;PM\u001a\u001cX\r^\"iK\u000e\\\u0007o\\5oiB\u00191&a\u0011\n\u0007\u0005\u0015CF\u0001\u0003M_:<\u0017a\u0006:fG>4XM]=Q_&tGo\u00115fG.\u0004x.\u001b8u\u0003AaW-\u00193fe\u0016\u0003xn\u00195DC\u000eDW\rE\u0003,\u0003\u001b\n\t&C\u0002\u0002P1\u0012aa\u00149uS>t\u0007\u0003BA*\u00033j!!!\u0016\u000b\t\u0005]\u0013QA\u0001\u0006KB|7\r[\u0005\u0005\u00037\n)F\u0001\u000bMK\u0006$WM]#q_\u000eDg)\u001b7f\u0007\u0006\u001c\u0007.Z\u0001\u0015aJ|G-^2feN#\u0018\r^3NC:\fw-\u001a:\u0011\t\u0005\u0005\u0011\u0011M\u0005\u0005\u0003G\n\u0019A\u0001\u000bQe>$WoY3s'R\fG/Z'b]\u0006<WM]\u0001\u0015]Vl'+Z7bS:LgnZ*fO6,g\u000e^:\u0002!\rDWmY6tk6\u001cFo\u001c:f\u001fB$\bCBA6\u0003[\n\t(D\u0001K\u0013\r\tyG\u0013\u0002\t\u001fB$\u0018n\u001c8bYB!\u00111OAB\u001b\t\t)H\u0003\u0003\u0002x\u0005e\u0014\u0001C2iK\u000e\\7/^7\u000b\t\u0005-\u00111\u0010\u0006\u0004I\u0005u$\u0002BA@\u0003\u0003\u000b\u0011bY8oM2,XM\u001c;\u000b\u0003=LA!!\"\u0002v\t\u0001RIM#DQ\u0016\u001c7n];n'R|'/Z\u0001\u0013SN\u0014V-\\8uK2{w-\u00128bE2,G\r\u0006\u0011\u0002\f\u00065\u0015qRAI\u0003'\u000b)*a&\u0002\u001a\u0006m\u0015QTAP\u0003C\u000b\u0019+!*\u0002(\u0006%\u0006CA\u0014\b\u0011\u0015Yw\u00031\u0001m\u0011\u0015\u0011x\u00031\u0001t\u0011\u0015qx\u00031\u0001\u0000\u0011\u001d\t\tb\u0006a\u0001\u0003'Aq!!\t\u0018\u0001\u0004\t\u0019\u0003C\u0004\u0002.]\u0001\r!a\f\t\r\u0005Ur\u00031\u0001h\u0011\u001d\t9d\u0006a\u0001\u0003sAq!a\u0010\u0018\u0001\u0004\t\t\u0005C\u0004\u0002H]\u0001\r!!\u0011\t\u000f\u0005%s\u00031\u0001\u0002L!9\u0011QL\fA\u0002\u0005}\u0003\u0002CA3/A\u0005\t\u0019\u0001$\t\u000f\u0005\u001dt\u00031\u0001\u0002j!A\u0011qQ\f\u0011\u0002\u0003\u0007q-\u0001\u0003m_\u0006$GCAAX!\u0011\t\t!!-\n\t\u0005M\u00161\u0001\u0002\u0011\u0019>\fG-\u001a3M_\u001e|eMZ:fiN\f!E]3n_Z,G+Z7q\r&dWm]!oI\u000e{G\u000e\\3diN;\u0018\r\u001d$jY\u0016\u001cHCAA]!\u0015\tY,!1m\u001b\t\tiLC\u0002\u0002@2\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\u0019-!0\u0003\u0007M+G/A\u000bsKR\u0014\u0018p\u00148PM\u001a\u001cX\r^(wKJ4Gn\\<\u0016\t\u0005%\u0017q\u001a\u000b\u0005\u0003\u0017\f\t\u000f\u0005\u0003\u0002N\u0006=G\u0002\u0001\u0003\b\u0003#T\"\u0019AAj\u0005\u0005!\u0016\u0003BAk\u00037\u00042aKAl\u0013\r\tI\u000e\f\u0002\b\u001d>$\b.\u001b8h!\rY\u0013Q\\\u0005\u0004\u0003?d#aA!os\"9\u00111\u001d\u000eA\u0002\u0005\u0015\u0018A\u00014o!\u0015Y\u0013q]Af\u0013\r\tI\u000f\f\u0002\n\rVt7\r^5p]B\n\u0001\u0003\\8bIN+w-\\3oi\u001aKG.Z:\u0015\u0005\u0005=\bcA\u0016\u0002r&\u0019\u00111\u001f\u0017\u0003\tUs\u0017\u000e^\u0001\u000fe\u0016\u001cwN^3s'\u0016<W.\u001a8u)\rA\u0016\u0011 \u0005\b\u0003wd\u0002\u0019AA\u007f\u0003\u001d\u0019XmZ7f]R\u00042aJA\u0000\u0013\r\u0011\t!\t\u0002\u000b\u0019><7+Z4nK:$\u0018A\u0003:fG>4XM\u001d'pOR\u0011!q\u0001\t\bW\t%\u0011\u0011IA!\u0013\r\u0011Y\u0001\f\u0002\u0007)V\u0004H.\u001a\u001a\u00029I,Wn\u001c<f\u0003:$G)\u001a7fi\u0016\u001cVmZ7f]R\u001c\u0018i]=oGR!\u0011q\u001eB\t\u0011\u001d\u0011\u0019B\ba\u0001\u0005+\t\u0001c]3h[\u0016tGo\u001d+p\t\u0016dW\r^3\u0011\r\t]!\u0011EA\u007f\u001d\u0011\u0011IB!\b\u000f\u0007E\u0013Y\"C\u0001.\u0013\r\u0011y\u0002L\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011\u0019C!\n\u0003\u0011%#XM]1cY\u0016T1Aa\b-\u0003q!W\r\\3uKB\u0013x\u000eZ;dKJ\u001cf.\u00199tQ>$8/Q:z]\u000e$B!a<\u0003,!9\u0011qG\u0010A\u0002\tU\u0001")
public class LogLoader
implements Logging {
    private final File dir;
    private final TopicPartition topicPartition;
    private final LogConfig config;
    private final Scheduler scheduler;
    private final Time time;
    private final LogDirFailureChannel logDirFailureChannel;
    private final boolean hadCleanShutdown;
    private final LogSegments segments;
    private final long logStartOffsetCheckpoint;
    private final long recoveryPointCheckpoint;
    private final Option<LeaderEpochFileCache> leaderEpochCache;
    private final ProducerStateManager producerStateManager;
    private final ConcurrentMap<String, Object> numRemainingSegments;
    private final Optional<E2EChecksumStore> checksumStoreOpt;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$15() {
        return false;
    }

    public static ConcurrentMap<String, Object> $lessinit$greater$default$13() {
        return new ConcurrentHashMap<String, Object>();
    }

    public static String CleanShutdownFile() {
        return LogLoader$.MODULE$.CleanShutdownFile();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public LoadedLogOffsets load() {
        long l;
        long l2;
        Object var20_7;
        LogSegments logSegments;
        File file2;
        TopicPartition topicPartition;
        LogConfig logConfig;
        Scheduler scheduler;
        LogDirFailureChannel logDirFailureChannel;
        String string;
        Optional<E2EChecksumStore> optional;
        Set<File> swapFiles = this.removeTempFilesAndCollectSwapFiles();
        LongRef minSwapFileOffset = LongRef.create((long)Long.MAX_VALUE);
        LongRef maxSwapFileOffset = LongRef.create((long)Long.MIN_VALUE);
        ((IterableOnceOps)swapFiles.filter((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)LogLoader.$anonfun$load$1(f)))).foreach((Function1 & Serializable)f -> {
            LogLoader.$anonfun$load$2(this, minSwapFileOffset, maxSwapFileOffset, f);
            return BoxedUnit.UNIT;
        });
        ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])this.dir.listFiles()), (Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)file.isFile())).foreach((Function1 & Serializable)file -> {
            Object object;
            block6: {
                try {
                    if (!file.getName().endsWith(MergedLog$.MODULE$.SwapFileSuffix())) {
                        long offset = Predef$.MODULE$.Long2long(LogFileUtils.offsetFromFile((File)file));
                        if (offset >= minSwapFileOffset$1.elem && offset < maxSwapFileOffset$1.elem) {
                            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(71).append("Deleting segment files ").append(file.getName()).append(" that is compacted but has not been deleted yet.").toString());
                            object = BoxesRunTime.boxToBoolean((boolean)file.delete());
                        } else {
                            object = BoxedUnit.UNIT;
                        }
                        break block6;
                    }
                    return BoxedUnit.UNIT;
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    return BoxedUnit.UNIT;
                }
                catch (NumberFormatException numberFormatException) {
                    object = BoxedUnit.UNIT;
                }
            }
            return object;
        });
        ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])this.dir.listFiles()), (Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)file.isFile())).foreach((Function1 & Serializable)file -> {
            if (file.getName().endsWith(MergedLog$.MODULE$.SwapFileSuffix())) {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(41).append("Recovering file ").append(file.getName()).append(" by renaming from ").append(MergedLog$.MODULE$.SwapFileSuffix()).append(" files.").toString());
                return BoxesRunTime.boxToBoolean((boolean)file.renameTo(new File(Utils.replaceSuffix((String)file.getPath(), (String)MergedLog$.MODULE$.SwapFileSuffix(), (String)""))));
            }
            return BoxedUnit.UNIT;
        });
        while (true) {
            try {
                LogLoader.$anonfun$load$10(this);
            }
            catch (LogSegmentOffsetOverflowException retryOnOffsetOverflow_e) {
                void retryOnOffsetOverflow_splitOverflowedSegment_checksumStoreOpt;
                void retryOnOffsetOverflow_splitOverflowedSegment_logPrefix;
                void retryOnOffsetOverflow_splitOverflowedSegment_logDirFailureChannel;
                void retryOnOffsetOverflow_splitOverflowedSegment_scheduler;
                void retryOnOffsetOverflow_splitOverflowedSegment_config;
                void retryOnOffsetOverflow_splitOverflowedSegment_topicPartition;
                void retryOnOffsetOverflow_splitOverflowedSegment_dir;
                void retryOnOffsetOverflow_splitOverflowedSegment_existingSegments;
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(57).append("Caught segment overflow error: ").append(retryOnOffsetOverflow_e.getMessage()).append(". Split segment and retry.").toString());
                optional = this.checksumStoreOpt;
                string = this.logIdent();
                logDirFailureChannel = this.logDirFailureChannel;
                scheduler = this.scheduler;
                logConfig = this.config;
                topicPartition = this.topicPartition;
                file2 = this.dir;
                logSegments = this.segments;
                LogSegment retryOnOffsetOverflow_splitOverflowedSegment_segment = retryOnOffsetOverflow_e.segment();
                var20_7 = null;
                logSegments = null;
                file2 = null;
                topicPartition = null;
                logConfig = null;
                scheduler = null;
                logDirFailureChannel = null;
                string = null;
                optional = null;
                SplitSegmentResult retryOnOffsetOverflow_result = LocalLog$.MODULE$.splitOverflowedSegment(retryOnOffsetOverflow_splitOverflowedSegment_segment, (LogSegments)retryOnOffsetOverflow_splitOverflowedSegment_existingSegments, (File)retryOnOffsetOverflow_splitOverflowedSegment_dir, (TopicPartition)retryOnOffsetOverflow_splitOverflowedSegment_topicPartition, (LogConfig)retryOnOffsetOverflow_splitOverflowedSegment_config, (Scheduler)retryOnOffsetOverflow_splitOverflowedSegment_scheduler, (LogDirFailureChannel)retryOnOffsetOverflow_splitOverflowedSegment_logDirFailureChannel, (String)retryOnOffsetOverflow_splitOverflowedSegment_logPrefix, (Optional<E2EChecksumStore>)retryOnOffsetOverflow_splitOverflowedSegment_checksumStoreOpt);
                this.deleteProducerSnapshotsAsync(retryOnOffsetOverflow_result.deletedSegments());
                continue;
            }
            break;
        }
        Object var18_5 = null;
        Object var19_6 = null;
        var20_7 = null;
        logSegments = null;
        file2 = null;
        topicPartition = null;
        logConfig = null;
        scheduler = null;
        logDirFailureChannel = null;
        string = null;
        optional = null;
        if (!this.dir.getAbsolutePath().endsWith(MergedLog$.MODULE$.DeleteDirSuffix())) {
            void var7_30;
            void var5_29;
            Object var31_19;
            LogSegments logSegments2;
            File file3;
            TopicPartition topicPartition2;
            LogConfig logConfig2;
            Scheduler scheduler2;
            LogDirFailureChannel logDirFailureChannel2;
            String string2;
            Optional<E2EChecksumStore> optional2;
            Tuple2<Object, Object> tuple2;
            while (true) {
                try {
                    tuple2 = this.recoverLog();
                }
                catch (LogSegmentOffsetOverflowException retryOnOffsetOverflow_e) {
                    void retryOnOffsetOverflow_splitOverflowedSegment_checksumStoreOpt;
                    void retryOnOffsetOverflow_splitOverflowedSegment_logPrefix;
                    void retryOnOffsetOverflow_splitOverflowedSegment_logDirFailureChannel;
                    void retryOnOffsetOverflow_splitOverflowedSegment_scheduler;
                    void retryOnOffsetOverflow_splitOverflowedSegment_config;
                    void retryOnOffsetOverflow_splitOverflowedSegment_topicPartition;
                    void retryOnOffsetOverflow_splitOverflowedSegment_dir;
                    void retryOnOffsetOverflow_splitOverflowedSegment_existingSegments;
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(57).append("Caught segment overflow error: ").append(retryOnOffsetOverflow_e.getMessage()).append(". Split segment and retry.").toString());
                    optional2 = this.checksumStoreOpt;
                    string2 = this.logIdent();
                    logDirFailureChannel2 = this.logDirFailureChannel;
                    scheduler2 = this.scheduler;
                    logConfig2 = this.config;
                    topicPartition2 = this.topicPartition;
                    file3 = this.dir;
                    logSegments2 = this.segments;
                    LogSegment retryOnOffsetOverflow_splitOverflowedSegment_segment = retryOnOffsetOverflow_e.segment();
                    var31_19 = null;
                    logSegments2 = null;
                    file3 = null;
                    topicPartition2 = null;
                    logConfig2 = null;
                    scheduler2 = null;
                    logDirFailureChannel2 = null;
                    string2 = null;
                    optional2 = null;
                    SplitSegmentResult retryOnOffsetOverflow_result = LocalLog$.MODULE$.splitOverflowedSegment(retryOnOffsetOverflow_splitOverflowedSegment_segment, (LogSegments)retryOnOffsetOverflow_splitOverflowedSegment_existingSegments, (File)retryOnOffsetOverflow_splitOverflowedSegment_dir, (TopicPartition)retryOnOffsetOverflow_splitOverflowedSegment_topicPartition, (LogConfig)retryOnOffsetOverflow_splitOverflowedSegment_config, (Scheduler)retryOnOffsetOverflow_splitOverflowedSegment_scheduler, (LogDirFailureChannel)retryOnOffsetOverflow_splitOverflowedSegment_logDirFailureChannel, (String)retryOnOffsetOverflow_splitOverflowedSegment_logPrefix, (Optional<E2EChecksumStore>)retryOnOffsetOverflow_splitOverflowedSegment_checksumStoreOpt);
                    this.deleteProducerSnapshotsAsync(retryOnOffsetOverflow_result.deletedSegments());
                    continue;
                }
                break;
            }
            Object var29_17 = null;
            Object var30_18 = null;
            var31_19 = null;
            logSegments2 = null;
            file3 = null;
            topicPartition2 = null;
            logConfig2 = null;
            scheduler2 = null;
            logDirFailureChannel2 = null;
            string2 = null;
            optional2 = null;
            Tuple2<Object, Object> tuple22 = tuple2;
            if (tuple22 == null) {
                throw new MatchError(null);
            }
            long newRecoveryPoint = tuple22._1$mcJ$sp();
            long nextOffset = tuple22._2$mcJ$sp();
            ((LogSegment)this.segments.lastSegment().get()).resizeIndexes(this.config.maxIndexSize);
            l2 = var5_29;
            l = var7_30;
        } else {
            if (this.segments.isEmpty()) {
                File x$10 = this.dir;
                LogConfig x$12 = this.config;
                Time x$13 = this.time;
                int x$14 = this.config.initFileSize();
                Optional<E2EChecksumStore> x$15 = this.checksumStoreOpt;
                boolean x$16 = false;
                boolean x$17 = false;
                String x$18 = "";
                this.segments.add(LogSegment$.MODULE$.open(x$10, 0L, x$12, x$13, x$16, x$14, x$17, x$18, x$15));
            }
            l2 = 0L;
            l = 0L;
        }
        long l3 = l;
        long l4 = l2;
        this.leaderEpochCache.foreach((Function1 & Serializable)x$3 -> {
            x$3.truncateFromEnd(l3);
            return BoxedUnit.UNIT;
        });
        this.leaderEpochCache.foreach((Function1 & Serializable)x$4 -> {
            x$4.truncateFromStart(this.logStartOffsetCheckpoint, true);
            return BoxedUnit.UNIT;
        });
        this.producerStateManager.removeStraySnapshots(CollectionConverters$.MODULE$.IterableHasAsJava((Iterable)this.segments.baseOffsets().map((Function1 & Serializable)x -> LogLoader.$anonfun$load$14(BoxesRunTime.unboxToLong((Object)x)))).asJavaCollection());
        LogSegment activeSegment = (LogSegment)this.segments.lastSegment().get();
        return new LoadedLogOffsets(l4, new LogOffsetMetadata(l3, activeSegment.baseOffset(), activeSegment.size()));
    }

    /*
     * WARNING - void declaration
     */
    private Set<File> removeTempFilesAndCollectSwapFiles() {
        void var6_6;
        void var5_5;
        scala.collection.mutable.Set swapFiles = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        scala.collection.mutable.Set cleanedFiles = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        LongRef minCleanedFileOffset = LongRef.create((long)Long.MAX_VALUE);
        ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])this.dir.listFiles()), (Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)file.isFile())).foreach((Function1 & Serializable)file -> {
            if (!file.canRead()) {
                throw new IOException(new StringBuilder(20).append("Could not read file ").append(file).toString());
            }
            String filename = file.getName();
            if (filename.endsWith(".deleted") && !filename.endsWith(Snapshots.DELETE_SUFFIX)) {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("Deleting stray temporary file ").append(file.getAbsolutePath()).toString());
                return BoxesRunTime.boxToBoolean((boolean)FilesWrapper.deleteIfExists((Path)file.toPath()));
            }
            if (filename.endsWith(MergedLog$.MODULE$.CleanedFileSuffix())) {
                minCleanedFileOffset$1.elem = Math.min(Predef$.MODULE$.Long2long(LogFileUtils.offsetFromFile((File)file)), minCleanedFileOffset$1.elem);
                return cleanedFiles.$plus$eq(file);
            }
            if (filename.endsWith(MergedLog$.MODULE$.TierCleanedFileSuffix())) {
                return cleanedFiles.$plus$eq(file);
            }
            if (filename.endsWith(MergedLog$.MODULE$.SwapFileSuffix())) {
                return swapFiles.$plus$eq(file);
            }
            return BoxedUnit.UNIT;
        });
        Tuple2 tuple2 = swapFiles.partition((Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoader.$anonfun$removeTempFilesAndCollectSwapFiles$4(minCleanedFileOffset, file)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        scala.collection.mutable.Set invalidSwapFiles = (scala.collection.mutable.Set)tuple2._1();
        scala.collection.mutable.Set validSwapFiles = (scala.collection.mutable.Set)tuple2._2();
        var5_5.foreach((Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoader.$anonfun$removeTempFilesAndCollectSwapFiles$5(this, minCleanedFileOffset, file)));
        cleanedFiles.foreach((Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogLoader.$anonfun$removeTempFilesAndCollectSwapFiles$7(this, file)));
        return var6_6;
    }

    /*
     * WARNING - void declaration
     */
    private <T> T retryOnOffsetOverflow(Function0<T> fn) {
        while (true) {
            try {
                return (T)fn.apply();
            }
            catch (LogSegmentOffsetOverflowException e) {
                void splitOverflowedSegment_checksumStoreOpt;
                void splitOverflowedSegment_logPrefix;
                void splitOverflowedSegment_logDirFailureChannel;
                void splitOverflowedSegment_scheduler;
                void splitOverflowedSegment_config;
                void splitOverflowedSegment_topicPartition;
                void splitOverflowedSegment_dir;
                void splitOverflowedSegment_existingSegments;
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(57).append("Caught segment overflow error: ").append(retryOnOffsetOverflow_e.getMessage()).append(". Split segment and retry.").toString());
                Optional<E2EChecksumStore> optional = this.checksumStoreOpt;
                String string = this.logIdent();
                LogDirFailureChannel logDirFailureChannel = this.logDirFailureChannel;
                Scheduler scheduler = this.scheduler;
                LogConfig logConfig = this.config;
                TopicPartition topicPartition = this.topicPartition;
                File file = this.dir;
                LogSegments logSegments = this.segments;
                LogSegment splitOverflowedSegment_segment = e.segment();
                Object var4_4 = null;
                logSegments = null;
                file = null;
                topicPartition = null;
                logConfig = null;
                scheduler = null;
                logDirFailureChannel = null;
                string = null;
                optional = null;
                SplitSegmentResult result = LocalLog$.MODULE$.splitOverflowedSegment(splitOverflowedSegment_segment, (LogSegments)splitOverflowedSegment_existingSegments, (File)splitOverflowedSegment_dir, (TopicPartition)splitOverflowedSegment_topicPartition, (LogConfig)splitOverflowedSegment_config, (Scheduler)splitOverflowedSegment_scheduler, (LogDirFailureChannel)splitOverflowedSegment_logDirFailureChannel, (String)splitOverflowedSegment_logPrefix, (Optional<E2EChecksumStore>)splitOverflowedSegment_checksumStoreOpt);
                this.deleteProducerSnapshotsAsync(result.deletedSegments());
                continue;
            }
            break;
        }
    }

    private void loadSegmentFiles() {
        ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.sortBy$extension(Predef$.MODULE$.refArrayOps((Object[])this.dir.listFiles()), (Function1 & Serializable)x$6 -> x$6.getName(), (Ordering)Ordering.String$.MODULE$)), (Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)file.isFile())).foreach((Function1 & Serializable)file -> {
            if (LocalLog$.MODULE$.isIndexFile((File)file)) {
                long offset = Predef$.MODULE$.Long2long(LogFileUtils.offsetFromFile((File)file));
                String logFile_suffix = "";
                Object var16_3 = null;
                if (!LogFileUtils.logFile((File)$this.dir, (long)offset, (String)logFile_suffix).exists()) {
                    this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(62).append("Found an orphaned index file ").append(file.getAbsolutePath()).append(", with no corresponding log file.").toString());
                    return BoxesRunTime.boxToBoolean((boolean)FilesWrapper.deleteIfExists((Path)file.toPath()));
                }
                return BoxedUnit.UNIT;
            }
            if (LocalLog$.MODULE$.isLogFile((File)file)) {
                long baseOffset = Predef$.MODULE$.Long2long(LogFileUtils.offsetFromFile((File)file));
                String timeIndexFile_suffix = "";
                Object var17_5 = null;
                boolean timeIndexFileNewlyCreated = !LogFileUtils.timeIndexFile((File)$this.dir, (long)baseOffset, (String)timeIndexFile_suffix).exists();
                File x$1 = $this.dir;
                LogConfig x$3 = $this.config;
                Time x$4 = $this.time;
                Optional<E2EChecksumStore> x$6 = $this.checksumStoreOpt;
                int x$7 = 0;
                boolean x$8 = false;
                String x$9 = "";
                LogSegment segment = LogSegment$.MODULE$.open(x$1, baseOffset, x$3, x$4, true, x$7, x$8, x$9, x$6);
                try {
                    segment.sanityCheck(timeIndexFileNewlyCreated);
                }
                catch (NoSuchFileException noSuchFileException) {
                    if ($this.hadCleanShutdown || segment.baseOffset() < $this.recoveryPointCheckpoint) {
                        this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(109).append("Could not find offset index file corresponding to log file").append(" ").append(segment.log().file().getAbsolutePath()).append(", recovering segment and rebuilding index files...").toString());
                    }
                    this.recoverSegment(segment);
                }
                catch (CorruptIndexException e) {
                    this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(114).append("Found a corrupted index file corresponding to log file").append(" ").append(segment.log().file().getAbsolutePath()).append(" due to ").append(e.getMessage()).append("}, recovering segment and").append(" rebuilding index files...").toString());
                    this.recoverSegment(segment);
                }
                return $this.segments.add(segment);
            }
            return BoxedUnit.UNIT;
        });
    }

    private int recoverSegment(LogSegment segment) {
        ProducerStateManager producerStateManager = new ProducerStateManager(this.topicPartition, this.dir, this.producerStateManager.maxTransactionTimeoutMs(), this.producerStateManager.producerStateManagerConfig(), this.time, this.producerStateManager.producerIdQuotaRecorder());
        MergedLog$.MODULE$.rebuildProducerState(producerStateManager, this.segments, this.logStartOffsetCheckpoint, segment.baseOffset(), this.config.recordVersion(), this.time, false, this.logIdent());
        boolean isInternalTopic = Topic.isInternal((String)this.topicPartition.topic());
        int bytesTruncated = segment.recover(producerStateManager, this.leaderEpochCache, !isInternalTopic);
        producerStateManager.takeSnapshot();
        return bytesTruncated;
    }

    public Tuple2<Object, Object> recoverLog() {
        boolean bl;
        if (!this.hadCleanShutdown) {
            Iterable<LogSegment> unflushed = this.segments.values(this.recoveryPointCheckpoint, Long.MAX_VALUE);
            int numUnflushed = unflushed.size();
            Iterator unflushedIter = unflushed.iterator();
            boolean truncated = false;
            IntRef numFlushed = IntRef.create((int)0);
            String threadName = Thread.currentThread().getName();
            this.numRemainingSegments.put(threadName, BoxesRunTime.boxToInteger((int)numUnflushed));
            while (unflushedIter.hasNext() && !truncated) {
                int n;
                LogSegment segment = (LogSegment)unflushedIter.next();
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("Recovering unflushed segment ").append(segment.baseOffset()).append(". ").append(numFlushed$1.elem).append("/").append(numUnflushed).append(" recovered for ").append($this.topicPartition).append(".").toString());
                try {
                    n = this.recoverSegment(segment);
                }
                catch (InvalidOffsetException invalidOffsetException) {
                    long startOffset = segment.baseOffset();
                    this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(114).append("Found invalid offset during recovery. Deleting the").append(" corrupt segment and creating an empty one with starting offset ").append(startOffset).toString());
                    n = segment.truncateTo(startOffset);
                }
                if (n > 0) {
                    this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(51).append("Corruption found in segment ").append(segment.baseOffset()).append(",").append(" truncating to offset ").append(segment.readNextOffset()).toString());
                    this.removeAndDeleteSegmentsAsync((Iterable<LogSegment>)unflushedIter.toList());
                    truncated = true;
                    this.numRemainingSegments.put(threadName, BoxesRunTime.boxToInteger((int)0));
                    continue;
                }
                ++numFlushed.elem;
                this.numRemainingSegments.put(threadName, BoxesRunTime.boxToInteger((int)(numUnflushed - numFlushed.elem)));
            }
        }
        Option logEndOffsetOption = this.deleteSegmentsIfLogStartGreaterThanLogEnd$1();
        if (this.segments.isEmpty()) {
            File x$1 = this.dir;
            long x$2 = this.logStartOffsetCheckpoint;
            LogConfig x$3 = this.config;
            Time x$4 = this.time;
            int x$5 = this.config.initFileSize();
            boolean x$6 = this.config.preallocate;
            Optional<E2EChecksumStore> x$7 = this.checksumStoreOpt;
            boolean x$8 = false;
            String x$9 = "";
            LogSegment segment = LogSegment$.MODULE$.open(x$1, x$2, x$3, x$4, x$8, x$5, x$6, x$9, x$7);
            this.segments.add(segment);
            this.checksumStoreOpt.ifPresent(checksumStore -> LocalLog$.MODULE$.mayInitializeChecksumStoreEntry((E2EChecksumStore)checksumStore, segment, $this.topicPartition, true, $this.config));
        }
        if ((bl = this.hadCleanShutdown) && logEndOffsetOption instanceof Some) {
            long logEndOffset = BoxesRunTime.unboxToLong((Object)((Some)logEndOffsetOption).value());
            return new Tuple2.mcJJ.sp(logEndOffset, logEndOffset);
        }
        long logEndOffset = BoxesRunTime.unboxToLong((Object)logEndOffsetOption.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> ((LogSegment)$this.segments.lastSegment().get()).readNextOffset()));
        return new Tuple2.mcJJ.sp(Math.min(this.recoveryPointCheckpoint, logEndOffset), logEndOffset);
    }

    /*
     * WARNING - void declaration
     */
    private void removeAndDeleteSegmentsAsync(Iterable<LogSegment> segmentsToDelete) {
        if (segmentsToDelete.nonEmpty()) {
            void deleteSegmentFiles_logPrefix;
            void deleteSegmentFiles_logDirFailureChannel;
            void deleteSegmentFiles_scheduler;
            void deleteSegmentFiles_config;
            void deleteSegmentFiles_topicPartition;
            void deleteSegmentFiles_dir;
            List toDelete = segmentsToDelete.toList();
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(43).append("Deleting segments as part of log recovery: ").append(toDelete.mkString(",")).toString());
            toDelete.foreach((Function1 & Serializable)segment -> {
                this.segments.remove(segment.baseOffset());
                return BoxedUnit.UNIT;
            });
            String string = this.logIdent();
            LogDirFailureChannel logDirFailureChannel = this.logDirFailureChannel;
            Scheduler scheduler = this.scheduler;
            LogConfig logConfig = this.config;
            TopicPartition topicPartition = this.topicPartition;
            File file = this.dir;
            boolean deleteSegmentFiles_asyncDelete = true;
            LocalLog$.MODULE$.deleteSegmentFiles((scala.collection.immutable.Iterable<LogSegment>)toDelete, deleteSegmentFiles_asyncDelete, (File)deleteSegmentFiles_dir, (TopicPartition)deleteSegmentFiles_topicPartition, (LogConfig)deleteSegmentFiles_config, (Scheduler)deleteSegmentFiles_scheduler, (LogDirFailureChannel)deleteSegmentFiles_logDirFailureChannel, (String)deleteSegmentFiles_logPrefix);
            file = null;
            topicPartition = null;
            logConfig = null;
            scheduler = null;
            logDirFailureChannel = null;
            string = null;
            this.deleteProducerSnapshotsAsync(segmentsToDelete);
            return;
        }
    }

    private void deleteProducerSnapshotsAsync(Iterable<LogSegment> segments) {
        MergedLog$.MODULE$.deleteProducerSnapshots(segments, this.producerStateManager, true, this.scheduler, this.config, this.logDirFailureChannel, this.dir.getParent(), this.topicPartition);
    }

    public static final /* synthetic */ boolean $anonfun$load$1(File f) {
        File isLogFile_file = new File(Utils.replaceSuffix((String)f.getPath(), (String)MergedLog$.MODULE$.SwapFileSuffix(), (String)""));
        return LocalLog$.MODULE$.isLogFile(isLogFile_file);
    }

    public static final /* synthetic */ void $anonfun$load$2(LogLoader $this, LongRef minSwapFileOffset$1, LongRef maxSwapFileOffset$1, File f) {
        long baseOffset = Predef$.MODULE$.Long2long(LogFileUtils.offsetFromFile((File)f));
        File x$1 = f.getParentFile();
        LogConfig x$3 = $this.config;
        Time x$4 = $this.time;
        String x$6 = MergedLog$.MODULE$.SwapFileSuffix();
        Optional<E2EChecksumStore> x$7 = $this.checksumStoreOpt;
        int x$8 = 0;
        boolean x$9 = false;
        LogSegment segment = LogSegment$.MODULE$.open(x$1, baseOffset, x$3, x$4, true, x$8, x$9, x$6, x$7);
        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(94).append("Found log file ").append(f.getPath()).append(" from interrupted swap operation, which is recoverable from ").append(MergedLog$.MODULE$.SwapFileSuffix()).append(" files by renaming.").toString());
        minSwapFileOffset$1.elem = Math.min(segment.baseOffset(), minSwapFileOffset$1.elem);
        maxSwapFileOffset$1.elem = Math.max(segment.readNextOffset(), maxSwapFileOffset$1.elem);
    }

    public static final /* synthetic */ void $anonfun$load$10(LogLoader $this) {
        $this.segments.close();
        $this.segments.clear();
        $this.loadSegmentFiles();
    }

    public static final /* synthetic */ Tuple2 $anonfun$load$11(LogLoader $this) {
        return $this.recoverLog();
    }

    public static final /* synthetic */ Long $anonfun$load$14(long x) {
        return BoxesRunTime.boxToLong((long)x);
    }

    public static final /* synthetic */ boolean $anonfun$removeTempFilesAndCollectSwapFiles$4(LongRef minCleanedFileOffset$1, File file) {
        return Predef$.MODULE$.Long2long(LogFileUtils.offsetFromFile((File)file)) >= minCleanedFileOffset$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$removeTempFilesAndCollectSwapFiles$5(LogLoader $this, LongRef minCleanedFileOffset$1, File file) {
        $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(50).append("Deleting invalid swap file ").append(file.getAbsoluteFile()).append(" minCleanedFileOffset: ").append(minCleanedFileOffset$1.elem).toString());
        return FilesWrapper.deleteIfExists((Path)file.toPath());
    }

    public static final /* synthetic */ boolean $anonfun$removeTempFilesAndCollectSwapFiles$7(LogLoader $this, File file) {
        $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(27).append("Deleting stray .clean file ").append(file.getAbsolutePath()).toString());
        return FilesWrapper.deleteIfExists((Path)file.toPath());
    }

    private final Option deleteSegmentsIfLogStartGreaterThanLogEnd$1() {
        if (this.segments.nonEmpty()) {
            long logEndOffset = ((LogSegment)this.segments.lastSegment().get()).readNextOffset();
            if (logEndOffset >= this.logStartOffsetCheckpoint) {
                return new Some((Object)BoxesRunTime.boxToLong((long)logEndOffset));
            }
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(148).append("Deleting all segments because logEndOffset (").append(logEndOffset).append(") ").append("is smaller than logStartOffset ").append($this.logStartOffsetCheckpoint).append(". ").append("This could happen if segment files were deleted from the file system.").toString());
            this.removeAndDeleteSegmentsAsync(this.segments.values());
            this.leaderEpochCache.foreach((Function1 & Serializable)x$7 -> {
                x$7.clearAndFlush();
                return BoxedUnit.UNIT;
            });
            this.producerStateManager.truncateFullyAndStartAt(this.logStartOffsetCheckpoint);
            return None$.MODULE$;
        }
        return None$.MODULE$;
    }

    public LogLoader(File dir, TopicPartition topicPartition, LogConfig config, Scheduler scheduler, Time time, LogDirFailureChannel logDirFailureChannel, boolean hadCleanShutdown, LogSegments segments, long logStartOffsetCheckpoint, long recoveryPointCheckpoint, Option<LeaderEpochFileCache> leaderEpochCache, ProducerStateManager producerStateManager, ConcurrentMap<String, Object> numRemainingSegments, Optional<E2EChecksumStore> checksumStoreOpt, boolean isRemoteLogEnabled) {
        this.dir = dir;
        this.topicPartition = topicPartition;
        this.config = config;
        this.scheduler = scheduler;
        this.time = time;
        this.logDirFailureChannel = logDirFailureChannel;
        this.hadCleanShutdown = hadCleanShutdown;
        this.segments = segments;
        this.logStartOffsetCheckpoint = logStartOffsetCheckpoint;
        this.recoveryPointCheckpoint = recoveryPointCheckpoint;
        this.leaderEpochCache = leaderEpochCache;
        this.producerStateManager = producerStateManager;
        this.numRemainingSegments = numRemainingSegments;
        this.checksumStoreOpt = checksumStoreOpt;
        this.logIdent_$eq(new StringBuilder(29).append("[LogLoader partition=").append(topicPartition).append(", dir=").append(dir.getParent()).append("] ").toString());
    }
}

