/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.schedulers;

import kafka.restore.messages.MessageRequest;
import kafka.restore.messages.MessageResponse;
import kafka.restore.messages.MessageStatusCode;
import kafka.restore.messages.ObjectStoreRequest;
import kafka.restore.messages.ObjectStoreResponse;
import kafka.restore.schedulers.AbstractAsyncServiceScheduler;
import kafka.restore.schedulers.AsyncServiceSchedulerResultsReceiver;
import kafka.restore.schedulers.ObjectStorePool;

public class ObjectStoreManager
extends AbstractAsyncServiceScheduler
implements AsyncServiceSchedulerResultsReceiver {
    private static final int DEFAULT_REQUEST_QUEUE_CAPACITY = 50000;
    private static final int OBJECTS_PER_SEGMENT = 5;
    private static final int MAX_OBJECTS_PER_BATCH = 1000;
    protected static final int MAX_SEGMENTS_PER_BATCH = 200;
    private final ObjectStorePool objectStorePool;

    public ObjectStoreManager(AsyncServiceSchedulerResultsReceiver resultsReceiver, ObjectStorePool objectStorePool, int requestQueueSize) {
        super(resultsReceiver, requestQueueSize);
        this.objectStorePool = objectStorePool;
    }

    public ObjectStoreManager(AsyncServiceSchedulerResultsReceiver resultsReceiver, ObjectStorePool objectStorePool) {
        this(resultsReceiver, objectStorePool, 50000);
    }

    @Override
    public synchronized boolean startUp() {
        boolean success = super.startUp();
        if (success) {
            this.objectStorePool.startUp();
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean shutdown() {
        boolean success = super.shutdown();
        this.objectStorePool.shutdown();
        return success;
    }

    @Override
    public synchronized boolean pause() {
        boolean success = super.pause();
        if (success) {
            this.objectStorePool.shutdown();
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean resume() {
        boolean success = super.resume();
        if (success) {
            this.objectStorePool.startUp();
            return true;
        }
        return false;
    }

    @Override
    public synchronized MessageStatusCode submitRequest(MessageRequest request) {
        if (request instanceof ObjectStoreRequest) {
            return super.submitRequest(request);
        }
        throw new UnsupportedOperationException("Request must be of a valid ObjectStoreRequest type.");
    }

    @Override
    protected synchronized void processRequestFromRequestQueue(MessageRequest request) {
        if (!(request instanceof ObjectStoreRequest)) {
            throw new RuntimeException("Illegal request type " + request.getClass() + " was added to request queue");
        }
        ObjectStoreRequest objectStoreRequest = (ObjectStoreRequest)request;
        this.objectStorePool.submitObjectStoreRequest(objectStoreRequest);
    }

    @Override
    public synchronized void reportServiceSchedulerResponse(MessageResponse response) {
        if (!(response instanceof ObjectStoreResponse)) {
            throw new IllegalArgumentException("Only ObjectStoreResponses should be being submitted to ObjectStoreManager, since ObjectStoreManager only makes ObjectStoreRequests.");
        }
        this.getResultsReceiver().reportServiceSchedulerResponse(response);
        this.getResultsReceiver().reportServiceSchedulerResponse(response);
    }
}

