/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import kafka.cluster.Partition;
import kafka.common.FetchedTimestampAndOffset;
import kafka.common.FetchedTimestampAndOffset$;
import kafka.server.DelayedOperation;
import kafka.server.ReplicaManager;
import kafka.tier.fetcher.PendingOffsetForTimestamp;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u00154Aa\u0003\u0007\u0001#!Aa\u0003\u0001B\u0001B\u0003%q\u0003\u0003\u0005\u001e\u0001\t\u0005\t\u0015!\u0003\u001f\u0011!\t\u0003A!A!\u0002\u0013\u0011\u0003\u0002C\u001f\u0001\u0005\u0003\u0005\u000b\u0011\u0002 \t\u0011\u0019\u0003!\u0011!Q\u0001\n\u001dC\u0001B\u0013\u0001\u0003\u0002\u0003\u0006Ia\u0013\u0005\u0006/\u0002!\t\u0001\u0017\u0005\u0006A\u0002!\t%\u0019\u0005\u0006E\u0002!\te\u0019\u0005\u0006I\u0002!\te\u0019\u0002\u0013\t\u0016d\u0017-_3e\u0019&\u001cHo\u00144gg\u0016$8O\u0003\u0002\u000e\u001d\u000511/\u001a:wKJT\u0011aD\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u0014)5\tA\"\u0003\u0002\u0016\u0019\t\u0001B)\u001a7bs\u0016$w\n]3sCRLwN\\\u0001\bI\u0016d\u0017-_'t!\tA2$D\u0001\u001a\u0015\u0005Q\u0012!B:dC2\f\u0017B\u0001\u000f\u001a\u0005\u0011auN\\4\u0002'\u0019,Go\u00195P]2LhI]8n\u0019\u0016\fG-\u001a:\u0011\u0005ay\u0012B\u0001\u0011\u001a\u0005\u001d\u0011un\u001c7fC:\f!\u0002\\8dC2d\u0015n\u001d;t!\u0011\u0019\u0003FK\u001b\u000e\u0003\u0011R!!\n\u0014\u0002\tU$\u0018\u000e\u001c\u0006\u0002O\u0005!!.\u0019<b\u0013\tICEA\u0004ICNDW*\u00199\u0011\u0005-\u001aT\"\u0001\u0017\u000b\u00055r\u0013AB2p[6|gN\u0003\u0002\u0010_)\u0011\u0001'M\u0001\u0007CB\f7\r[3\u000b\u0003I\n1a\u001c:h\u0013\t!DF\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0011\u0007a1\u0004(\u0003\u000283\t1q\n\u001d;j_:\u0004\"!O\u001e\u000e\u0003iR!!\f\b\n\u0005qR$!\u0007$fi\u000eDW\r\u001a+j[\u0016\u001cH/Y7q\u0003:$wJ\u001a4tKR\fq\u0001]3oI&tw\r\u0005\u0002@\t6\t\u0001I\u0003\u0002B\u0005\u00069a-\u001a;dQ\u0016\u0014(BA\"\u000f\u0003\u0011!\u0018.\u001a:\n\u0005\u0015\u0003%!\u0007)f]\u0012LgnZ(gMN,GOR8s)&lWm\u001d;b[B\faB]3qY&\u001c\u0017-T1oC\u001e,'\u000f\u0005\u0002\u0014\u0011&\u0011\u0011\n\u0004\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003A\u0011Xm\u001d9p]N,7)\u00197mE\u0006\u001c7\u000e\u0005\u0003\u0019\u0019:#\u0016BA'\u001a\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003P%**T\"\u0001)\u000b\u0005EK\u0012AC2pY2,7\r^5p]&\u00111\u000b\u0015\u0002\u0004\u001b\u0006\u0004\bC\u0001\rV\u0013\t1\u0016D\u0001\u0003V]&$\u0018A\u0002\u001fj]&$h\bF\u0004Z5ncVLX0\u0011\u0005M\u0001\u0001\"\u0002\f\b\u0001\u00049\u0002\"B\u000f\b\u0001\u0004q\u0002\"B\u0011\b\u0001\u0004\u0011\u0003\"B\u001f\b\u0001\u0004q\u0004\"\u0002$\b\u0001\u00049\u0005\"\u0002&\b\u0001\u0004Y\u0015a\u0003;ss\u000e{W\u000e\u001d7fi\u0016$\u0012AH\u0001\r_:,\u0005\u0010]5sCRLwN\u001c\u000b\u0002)\u0006QqN\\\"p[BdW\r^3")
public class DelayedListOffsets
extends DelayedOperation {
    private final boolean fetchOnlyFromLeader;
    private final HashMap<TopicPartition, Option<FetchedTimestampAndOffset>> localLists;
    private final PendingOffsetForTimestamp pending;
    private final ReplicaManager replicaManager;
    private final Function1<Map<TopicPartition, Option<FetchedTimestampAndOffset>>, BoxedUnit> responseCallback;

    @Override
    public boolean tryComplete() {
        CollectionConverters$.MODULE$.MapHasAsScala(this.localLists).asScala().withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)DelayedListOffsets.$anonfun$tryComplete$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$1 -> {
            if (x$1 != null) {
                TopicPartition tp = (TopicPartition)x$1._1();
                Option v = (Option)x$1._2();
                try {
                    Partition partition = $this.replicaManager.getPartitionOrException(tp);
                    Option<Object> leaderEpoch = ((FetchedTimestampAndOffset)v.get()).leaderEpoch();
                    return partition.localLogWithEpochOrThrow(OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(leaderEpoch.map((Function1 & Serializable)x -> Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)x))))), $this.fetchOnlyFromLeader);
                }
                catch (Exception e) {
                    $this.pending.completeExceptionally(tp, e);
                    return BoxedUnit.UNIT;
                }
            }
            throw new MatchError(null);
        });
        if (this.pending.isDone()) {
            return this.forceComplete();
        }
        return false;
    }

    @Override
    public void onExpiration() {
        this.pending.cancel();
    }

    @Override
    public void onComplete() {
        scala.collection.mutable.Map tierResponses = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(this.pending.tierTimestampAndOffsets()).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition topicPartition = (TopicPartition)x0$1._1();
                Option timestampAndOffset = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric($this.pending.results().getOrDefault(topicPartition, Optional.of(FetchedTimestampAndOffset$.MODULE$.apply((Exception)((Object)Errors.REQUEST_TIMED_OUT.exception()))))));
                return new Tuple2((Object)topicPartition, (Object)timestampAndOffset);
            }
            throw new MatchError(null);
        });
        this.responseCallback.apply((Object)CollectionConverters$.MODULE$.MapHasAsScala(this.localLists).asScala().$plus$plus((IterableOnce)tierResponses));
    }

    public static final /* synthetic */ boolean $anonfun$tryComplete$1(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public DelayedListOffsets(long delayMs, boolean fetchOnlyFromLeader, HashMap<TopicPartition, Option<FetchedTimestampAndOffset>> localLists, PendingOffsetForTimestamp pending, ReplicaManager replicaManager, Function1<Map<TopicPartition, Option<FetchedTimestampAndOffset>>, BoxedUnit> responseCallback) {
        this.fetchOnlyFromLeader = fetchOnlyFromLeader;
        this.localLists = localLists;
        this.pending = pending;
        this.replicaManager = replicaManager;
        this.responseCallback = responseCallback;
        super(delayMs, (Option<Lock>)None$.MODULE$);
    }
}

