/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerTopicStats;
import kafka.server.FailedPartitions;
import kafka.server.InitialFetchState;
import kafka.server.LeaderEndPoint;
import kafka.server.OffsetTruncationState;
import kafka.server.PausedPartitions;
import kafka.server.ReplicaAlterLogDirsTierStateMachine;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005ud\u0001\u0002\u000b\u0016\u0001iA\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\t[\u0001\u0011\t\u0011)A\u0005]!A\u0011\u0007\u0001B\u0001B\u0003%!\u0007\u0003\u00056\u0001\t\u0005\t\u0015!\u00037\u0011!I\u0004A!A!\u0002\u0013Q\u0004\u0002C$\u0001\u0005\u0003\u0005\u000b\u0011\u0002%\t\u0011-\u0003!\u0011!Q\u0001\n1C\u0001b\u0014\u0001\u0003\u0002\u0003\u0006I\u0001\u0015\u0005\u0006'\u0002!\t\u0001\u0016\u0005\u0006=\u0002!\tf\u0018\u0005\u0006[\u0002!\tF\u001c\u0005\u0006g\u0002!\t\u0006\u001e\u0005\u0006m\u0002!\tf\u001e\u0005\b\u0003\u000b\u0001A\u0011IA\u0004\u0011\u001d\t\t\u0004\u0001C!\u0003gA\u0011\"!\u0015\u0001\u0005\u0004%\t&a\u0015\t\u0011\u0005m\u0003\u0001)A\u0005\u0003+Bq!!\u0018\u0001\t\u0003\ny\u0006C\u0004\u0002n\u0001!\t&a\u001c\u00033I+\u0007\u000f\\5dC\u0006cG/\u001a:M_\u001e$\u0015N]:UQJ,\u0017\r\u001a\u0006\u0003-]\taa]3sm\u0016\u0014(\"\u0001\r\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\u0007\t\u00039ui\u0011!F\u0005\u0003=U\u0011Q#\u00112tiJ\f7\r\u001e$fi\u000eDWM\u001d+ie\u0016\fG-\u0001\u0003oC6,\u0007CA\u0011+\u001d\t\u0011\u0003\u0006\u0005\u0002$M5\tAE\u0003\u0002&3\u00051AH]8pizR\u0011aJ\u0001\u0006g\u000e\fG.Y\u0005\u0003S\u0019\na\u0001\u0015:fI\u00164\u0017BA\u0016-\u0005\u0019\u0019FO]5oO*\u0011\u0011FJ\u0001\u0007Y\u0016\fG-\u001a:\u0011\u0005qy\u0013B\u0001\u0019\u0016\u00059aU-\u00193fe\u0016sG\rU8j]R\f\u0001CZ1jY\u0016$\u0007+\u0019:uSRLwN\\:\u0011\u0005q\u0019\u0014B\u0001\u001b\u0016\u0005A1\u0015-\u001b7fIB\u000b'\u000f^5uS>t7/\u0001\tqCV\u001cX\r\u001a)beRLG/[8ogB\u0011AdN\u0005\u0003qU\u0011\u0001\u0003U1vg\u0016$\u0007+\u0019:uSRLwN\\:\u0002%\u0015D\bo\u001c8f]RL\u0017\r\u001c\"bG.|gM\u001a\t\u0003w\u0015k\u0011\u0001\u0010\u0006\u0003{y\nQ!\u001e;jYNT!a\u0010!\u0002\r\r|W.\\8o\u0015\tA\u0012I\u0003\u0002C\u0007\u00061\u0011\r]1dQ\u0016T\u0011\u0001R\u0001\u0004_J<\u0017B\u0001$=\u0005I)\u0005\u0010]8oK:$\u0018.\u00197CC\u000e\\wN\u001a4\u0002\u0015I,\u0007\u000f\\5dC6;'\u000f\u0005\u0002\u001d\u0013&\u0011!*\u0006\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003\u0015\tXo\u001c;b!\taR*\u0003\u0002O+\t9\"+\u001a9mS\u000e\fG/[8o#V|G/Y'b]\u0006<WM]\u0001\u0011EJ|7.\u001a:U_BL7m\u0015;biN\u0004\"\u0001H)\n\u0005I+\"\u0001\u0005\"s_.,'\u000fV8qS\u000e\u001cF/\u0019;t\u0003\u0019a\u0014N\\5u}QIQKV,Y3j[F,\u0018\t\u00039\u0001AQaH\u0005A\u0002\u0001BQ!L\u0005A\u00029BQ!M\u0005A\u0002IBQ!N\u0005A\u0002YBQ!O\u0005A\u0002iBQaR\u0005A\u0002!CQaS\u0005A\u00021CQaT\u0005A\u0002A\u000b1\u0002\\1uKN$X\t]8dQR\u0011\u0001m\u001a\t\u0004C\n$W\"\u0001\u0014\n\u0005\r4#AB(qi&|g\u000e\u0005\u0002bK&\u0011aM\n\u0002\u0004\u0013:$\b\"\u00025\u000b\u0001\u0004I\u0017A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0003U.l\u0011AP\u0005\u0003Yz\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0001\bm_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;\u0015\u0005=\u0014\bCA1q\u0013\t\thE\u0001\u0003M_:<\u0007\"\u00025\f\u0001\u0004I\u0017\u0001\u00047pO\u0016sGm\u00144gg\u0016$HCA8v\u0011\u0015AG\u00021\u0001j\u0003E)g\u000eZ(gMN,GOR8s\u000bB|7\r\u001b\u000b\u0005q~\f\t\u0001E\u0002bEf\u0004\"A_?\u000e\u0003mT!a\u0010?\u000b\u0005Y\u0001\u0015B\u0001@|\u00059yeMZ:fi\u0006sG-\u00129pG\"DQ\u0001[\u0007A\u0002%Da!a\u0001\u000e\u0001\u0004!\u0017!B3q_\u000eD\u0017\u0001\u00069s_\u000e,7o\u001d)beRLG/[8o\t\u0006$\u0018\r\u0006\u0005\u0002\n\u0005}\u0011\u0011EA\u0013!\u0011\t'-a\u0003\u0011\t\u00055\u00111D\u0007\u0003\u0003\u001fQA!!\u0005\u0002\u0014\u0005\u0019An\\4\u000b\t\u0005U\u0011qC\u0001\nS:$XM\u001d8bYNT1!!\u0007A\u0003\u001d\u0019Ho\u001c:bO\u0016LA!!\b\u0002\u0010\tiAj\\4BaB,g\u000eZ%oM>DQ\u0001\u001b\bA\u0002%Da!a\t\u000f\u0001\u0004y\u0017a\u00034fi\u000eDwJ\u001a4tKRDq!a\n\u000f\u0001\u0004\tI#A\u0007qCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\t\u0005\u0003W\ti#D\u0001\u0001\u0013\r\ty#\b\u0002\n\r\u0016$8\r\u001b#bi\u0006\fQ\"\u00193e!\u0006\u0014H/\u001b;j_:\u001cH\u0003BA\u001b\u0003\u0003\u0002R!a\u000e\u0002>%l!!!\u000f\u000b\u0007\u0005mb%\u0001\u0006d_2dWm\u0019;j_:LA!a\u0010\u0002:\t\u00191+\u001a;\t\u000f\u0005\rs\u00021\u0001\u0002F\u0005\u0011\u0012N\\5uS\u0006dg)\u001a;dQN#\u0018\r^3t!\u001d\t9$a\u0012j\u0003\u0017JA!!\u0013\u0002:\t\u0019Q*\u00199\u0011\u0007q\ti%C\u0002\u0002PU\u0011\u0011#\u00138ji&\fGNR3uG\"\u001cF/\u0019;f\u0003}I7o\u00144gg\u0016$hi\u001c:MK\u0006$WM]#q_\u000eD7+\u001e9q_J$X\rZ\u000b\u0003\u0003+\u00022!YA,\u0013\r\tIF\n\u0002\b\u0005>|G.Z1o\u0003\u0001J7o\u00144gg\u0016$hi\u001c:MK\u0006$WM]#q_\u000eD7+\u001e9q_J$X\r\u001a\u0011\u0002\u0011Q\u0014XO\\2bi\u0016$b!!\u0016\u0002b\u0005\r\u0004\"\u00025\u0013\u0001\u0004I\u0007bBA3%\u0001\u0007\u0011qM\u0001\u0010iJ,hnY1uS>t7\u000b^1uKB\u0019A$!\u001b\n\u0007\u0005-TCA\u000bPM\u001a\u001cX\r\u001e+sk:\u001c\u0017\r^5p]N#\u0018\r^3\u0002/Q\u0014XO\\2bi\u00164U\u000f\u001c7z\u0003:$7\u000b^1si\u0006#HCBA9\u0003o\nI\bE\u0002b\u0003gJ1!!\u001e'\u0005\u0011)f.\u001b;\t\u000b!\u001c\u0002\u0019A5\t\r\u0005m4\u00031\u0001p\u0003\u0019ygMZ:fi\u0002")
public class ReplicaAlterLogDirsThread
extends AbstractFetcherThread {
    private final ReplicaManager replicaMgr;
    private final ReplicationQuotaManager quota;
    private final boolean isOffsetForLeaderEpochSupported;

    @Override
    public Option<Object> latestEpoch(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).latestEpoch();
    }

    @Override
    public long logStartOffset(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).logStartOffset();
    }

    @Override
    public long logEndOffset(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).logEndOffset();
    }

    @Override
    public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).endOffsetForEpoch(epoch);
    }

    @Override
    public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponseData.PartitionData partitionData) {
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition);
        AbstractLog futureLog = partition.futureLocalLogOrException();
        MemoryRecords records = this.toMemoryRecords(FetchResponse.recordsOrFail((FetchResponseData.PartitionData)partitionData));
        if (fetchOffset != futureLog.logEndOffset()) {
            throw new IllegalStateException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Offset mismatch for the future replica %s: fetched offset = %d, log end offset = %d."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, BoxesRunTime.boxToLong((long)fetchOffset), BoxesRunTime.boxToLong((long)futureLog.logEndOffset())})));
        }
        Option<LogAppendInfo> logAppendInfo = records.sizeInBytes() > 0 ? partition.appendRecordsToFollowerOrFutureReplica(records, true) : None$.MODULE$;
        futureLog.updateHighWatermark(partitionData.highWatermark());
        futureLog.maybeIncrementLogStartOffset(partitionData.logStartOffset(), LogStartOffsetIncrementReason.LeaderOffsetIncremented);
        if (partition.maybeReplaceCurrentWithFutureReplica()) {
            this.removePartitions((Set<TopicPartition>)((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
        }
        this.quota.record(records.sizeInBytes());
        return logAppendInfo;
    }

    @Override
    public Set<TopicPartition> addPartitions(Map<TopicPartition, InitialFetchState> initialFetchStates) {
        Set<TopicPartition> set;
        this.partitionMapLock().lockInterruptibly();
        try {
            Map filteredFetchStates = (Map)initialFetchStates.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ReplicaAlterLogDirsThread.$anonfun$addPartitions$1(this, x0$1)));
            set = super.addPartitions((Map<TopicPartition, InitialFetchState>)filteredFetchStates);
        }
        finally {
            this.partitionMapLock().unlock();
        }
        return set;
    }

    @Override
    public boolean isOffsetForLeaderEpochSupported() {
        return this.isOffsetForLeaderEpochSupported;
    }

    @Override
    public boolean truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
        this.replicaMgr.getPartitionOrException(topicPartition).truncateTo(truncationState.offset(), true);
        return true;
    }

    @Override
    public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition);
        partition.truncateFullyAndStartAt(offset, true, partition.truncateFullyAndStartAt$default$3());
    }

    public static final /* synthetic */ boolean $anonfun$addPartitions$1(ReplicaAlterLogDirsThread $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            return $this.replicaMgr.futureLogExists(tp);
        }
        throw new MatchError(null);
    }

    public ReplicaAlterLogDirsThread(String name, LeaderEndPoint leader, FailedPartitions failedPartitions, PausedPartitions pausedPartitions, ExponentialBackoff exponentialBackoff, ReplicaManager replicaMgr, ReplicationQuotaManager quota, BrokerTopicStats brokerTopicStats) {
        this.replicaMgr = replicaMgr;
        this.quota = quota;
        ReplicaAlterLogDirsTierStateMachine x$4 = new ReplicaAlterLogDirsTierStateMachine();
        Map x$10 = (Map)Map$.MODULE$.empty();
        super(name, name, leader, failedPartitions, pausedPartitions, exponentialBackoff, x$4, false, brokerTopicStats, (Map<String, String>)x$10);
        this.isOffsetForLeaderEpochSupported = true;
    }
}

