/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import io.confluent.kafka.link.ClusterLinkConfig;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.link.ActiveClusterLink$;
import kafka.server.link.AuthenticationTaskErrorCode$;
import kafka.server.link.AuthorizationTaskErrorCode$;
import kafka.server.link.ClusterLinkCheckAvailabilityTaskType$;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConnectionChecker$;
import kafka.server.link.ClusterLinkConnectionCheckerResult;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTask$;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.ConnectionMode$Outbound$;
import kafka.server.link.FailedLinkReason;
import kafka.server.link.InternalTaskErrorCode$;
import kafka.server.link.InvalidBootstrapInternalEndpointUnavailableLinkReason$;
import kafka.server.link.LinkState;
import kafka.server.link.RemoteLinkState;
import kafka.server.link.TaskDescription;
import kafka.server.link.TaskErrorCodeAndMsg;
import kafka.server.link.UnauthorizedBootstrapFailedLinkReason$;
import kafka.server.link.UnavailableLinkReason;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ClusterLinkDescription;
import org.apache.kafka.clients.admin.ClusterLinkListing;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.clients.admin.ListClusterLinksOptions;
import org.apache.kafka.common.ClusterLinkError;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\t\u001da\u0001\u0002\u0012$\u0001)B\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\to\u0001\u0011\t\u0011)A\u0005q!A1\b\u0001B\u0001B\u0003%A\bC\u0005@\u0001\t\u0005\t\u0015!\u0003A\r\"A\u0001\n\u0001BC\u0002\u0013\u0005\u0011\nC\u0005N\u0001\t\u0005\t\u0015!\u0003K\u001d\"A\u0001\u000b\u0001BC\u0002\u0013\u0005\u0011\u000b\u0003\u0005^\u0001\t\u0005\t\u0015!\u0003S\u0011!q\u0006A!b\u0001\n\u0003y\u0006\u0002\u00039\u0001\u0005\u0003\u0005\u000b\u0011\u00021\t\u0013E\u0004!\u0011!Q\u0001\nIT\bBC>\u0001\u0005\u0003\u0005\u000b\u0011\u0002?\u0002\u0002!9\u00111\u0001\u0001\u0005\u0002\u0005\u0015\u0001\"CA\u000e\u0001\t\u0007I\u0011BA\u000f\u0011!\t)\u0003\u0001Q\u0001\n\u0005}\u0001\"CA\u0014\u0001\t\u0007I\u0011BA\u0015\u0011!\t\t\u0004\u0001Q\u0001\n\u0005-\u0002\"CA\u001a\u0001\u0001\u0007I\u0011AA\u001b\u0011%\ti\u0004\u0001a\u0001\n\u0003\ty\u0004\u0003\u0005\u0002L\u0001\u0001\u000b\u0015BA\u001c\u0011%\t)\u0006\u0001a\u0001\n\u0013\t9\u0006C\u0005\u0002Z\u0001\u0001\r\u0011\"\u0003\u0002\\!9\u0011q\f\u0001!B\u0013\u0001\u0005\"CA1\u0001\u0001\u0007I\u0011BA2\u0011%\t\t\b\u0001a\u0001\n\u0013\t\u0019\b\u0003\u0005\u0002x\u0001\u0001\u000b\u0015BA3\u0011\u001d\tY\b\u0001C)\u0003{Bq!a%\u0001\t\u0013\t)\nC\u0004\u0002.\u0002!\t&a,\t\u000f\u0005m\u0006\u0001\"\u0001\u0002>\"9\u0011q\u0018\u0001\u0005\n\u0005\u0005\u0007bBAc\u0001\u0011%\u0011q\u0019\u0005\b\u0003[\u0004A\u0011BAx\u0005q\u0019E.^:uKJd\u0015N\\6DQ\u0016\u001c7.\u0011<bS2\f'-\u001b7jifT!\u0001J\u0013\u0002\t1Lgn\u001b\u0006\u0003M\u001d\naa]3sm\u0016\u0014(\"\u0001\u0015\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\u000b\t\u0003YAr!!\f\u0018\u000e\u0003\rJ!aL\u0012\u0002)\rcWo\u001d;fe2Kgn[*dQ\u0016$W\u000f\\3s\u0013\t\t$G\u0001\u0007QKJLw\u000eZ5d)\u0006\u001c8N\u0003\u00020G\u000511m\u001c8gS\u001e\u0004\"!L\u001b\n\u0005Y\u001a#!E\"mkN$XM\u001d'j].\u001cuN\u001c4jO\u00069Q.\u001a;sS\u000e\u001c\bCA\u0017:\u0013\tQ4E\u0001\nDYV\u001cH/\u001a:MS:\\W*\u001a;sS\u000e\u001c\u0018AE2mkN$XM\u001d'j].l\u0015M\\1hKJ\u0004\"!L\u001f\n\u0005y\u001a#AE\"mkN$XM\u001d'j].l\u0015M\\1hKJ\f!\"\u001b8uKJ4\u0018\r\\'t!\t\tE)D\u0001C\u0015\u0005\u0019\u0015!B:dC2\f\u0017BA#C\u0005\rIe\u000e^\u0005\u0003\u000fB\n\u0011C]3tG\",G-\u001e7f\t\u0016d\u0017-_'t\u0003-\u0019GnU2iK\u0012,H.\u001a:\u0016\u0003)\u0003\"!L&\n\u00051\u001b#\u0001F\"mkN$XM\u001d'j].\u001c6\r[3ek2,'/\u0001\u0007dYN\u001b\u0007.\u001a3vY\u0016\u0014\b%\u0003\u0002Pa\u0005I1o\u00195fIVdWM]\u0001\tY&t7NT1nKV\t!\u000b\u0005\u0002T5:\u0011A\u000b\u0017\t\u0003+\nk\u0011A\u0016\u0006\u0003/&\na\u0001\u0010:p_Rt\u0014BA-C\u0003\u0019\u0001&/\u001a3fM&\u00111\f\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005e\u0013\u0015!\u00037j].t\u0015-\\3!\u0003I\u0011X-\\8uK\u0006#W.\u001b8GC\u000e$xN]=\u0016\u0003\u0001\u00042!Q1d\u0013\t\u0011'IA\u0005Gk:\u001cG/[8oaA\u0011AM\\\u0007\u0002K*\u0011amZ\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0003Q&\fqa\u00197jK:$8O\u0003\u0002)U*\u00111\u000e\\\u0001\u0007CB\f7\r[3\u000b\u00035\f1a\u001c:h\u0013\tyWM\u0001\bD_:4G.^3oi\u0006#W.\u001b8\u0002'I,Wn\u001c;f\u0003\u0012l\u0017N\u001c$bGR|'/\u001f\u0011\u0002\tQLW.\u001a\t\u0003gbl\u0011\u0001\u001e\u0006\u0003kZ\fQ!\u001e;jYNT!a^5\u0002\r\r|W.\\8o\u0013\tIHO\u0001\u0003US6,\u0017BA91\u0003\u0015\tXo\u001c;b!\tih0D\u0001&\u0013\tyXEA\fDYV\u001cH/\u001a:MS:\\'+Z9vKN$\u0018+^8uC&\u00111\u0010M\u0001\u0007y%t\u0017\u000e\u001e \u0015)\u0005\u001d\u0011\u0011BA\u0006\u0003\u001b\ty!!\u0005\u0002\u0014\u0005U\u0011qCA\r!\ti\u0003\u0001C\u00034\u001b\u0001\u0007A\u0007C\u00038\u001b\u0001\u0007\u0001\bC\u0003<\u001b\u0001\u0007A\bC\u0003@\u001b\u0001\u0007\u0001\tC\u0003I\u001b\u0001\u0007!\nC\u0003Q\u001b\u0001\u0007!\u000bC\u0003_\u001b\u0001\u0007\u0001\rC\u0003r\u001b\u0001\u0007!\u000fC\u0003|\u001b\u0001\u0007A0A\tsK6|G/Z%t+:l\u0017M\\1hK\u0012,\"!a\b\u0011\u0007\u0005\u000b\t#C\u0002\u0002$\t\u0013qAQ8pY\u0016\fg.\u0001\nsK6|G/Z%t+:l\u0017M\\1hK\u0012\u0004\u0013a\u00047jgRd\u0015N\\6PaRLwN\\:\u0016\u0005\u0005-\u0002c\u00013\u0002.%\u0019\u0011qF3\u0003/1K7\u000f^\"mkN$XM\u001d'j].\u001cx\n\u001d;j_:\u001c\u0018\u0001\u00057jgRd\u0015N\\6PaRLwN\\:!\u0003=\u0011X-\\8uK2Kgn[*uCR,WCAA\u001c!\ri\u0013\u0011H\u0005\u0004\u0003w\u0019#a\u0004*f[>$X\rT5oWN#\u0018\r^3\u0002'I,Wn\u001c;f\u0019&t7n\u0015;bi\u0016|F%Z9\u0015\t\u0005\u0005\u0013q\t\t\u0004\u0003\u0006\r\u0013bAA#\u0005\n!QK\\5u\u0011%\tIeEA\u0001\u0002\u0004\t9$A\u0002yIE\n\u0001C]3n_R,G*\u001b8l'R\fG/\u001a\u0011)\u0007Q\ty\u0005E\u0002B\u0003#J1!a\u0015C\u0005!1x\u000e\\1uS2,\u0017!\u00034bS2\u001cu.\u001e8u+\u0005\u0001\u0015!\u00044bS2\u001cu.\u001e8u?\u0012*\u0017\u000f\u0006\u0003\u0002B\u0005u\u0003\u0002CA%-\u0005\u0005\t\u0019\u0001!\u0002\u0015\u0019\f\u0017\u000e\\\"pk:$\b%\u0001\u0005uCN\\G)Z:d+\t\t)\u0007E\u0003B\u0003O\nY'C\u0002\u0002j\t\u0013aa\u00149uS>t\u0007cA\u0017\u0002n%\u0019\u0011qN\u0012\u0003\u001fQ\u000b7o\u001b#fg\u000e\u0014\u0018\u000e\u001d;j_:\fA\u0002^1tW\u0012+7oY0%KF$B!!\u0011\u0002v!I\u0011\u0011J\r\u0002\u0002\u0003\u0007\u0011QM\u0001\ni\u0006\u001c8\u000eR3tG\u0002B3AGA(\u0003\r\u0011XO\u001c\u000b\u0003\u0003\u007f\u0002B!!!\u0002\u0010:\u0019\u00111\u0011\u0018\u000f\t\u0005\u0015\u0015Q\u0012\b\u0005\u0003\u000f\u000bYID\u0002V\u0003\u0013K\u0011\u0001K\u0005\u0003M\u001dJ!\u0001J\u0013\n\u0007\u0005E%G\u0001\u0006UCN\\'+Z:vYR\f1\u0004[1oI2,G)Z:de&\u0014Wm\u00117vgR,'OU3tk2$HCBA@\u0003/\u000b\t\u000bC\u0004\u0002\u001ar\u0001\r!a'\u0002\u0017Q\f7o[\"p]R,\u0007\u0010\u001e\t\u0005\u0003\u0003\u000bi*C\u0002\u0002 J\u00121\u0002V1tW\u000e{g\u000e^3yi\"9\u00111\u0015\u000fA\u0002\u0005\u0015\u0016aJ7bs\n,7\t\\;ti\u0016\u0014H*\u001b8l\u0007>tg.Z2uS>t7\t[3dW\u0016\u0014(+Z:vYR\u0004R!QA4\u0003O\u00032!LAU\u0013\r\tYk\t\u0002#\u00072,8\u000f^3s\u0019&t7nQ8o]\u0016\u001cG/[8o\u0007\",7m[3s%\u0016\u001cX\u000f\u001c;\u0002\u0019=t7i\\7qY\u0016$\u0018n\u001c8\u0015\t\u0005\u0005\u0013\u0011\u0017\u0005\b\u0003gk\u0002\u0019AA[\u0003\u0019\u0011Xm];miB\u0019A&a.\n\u0007\u0005e&GA\nD_6\u0004H.\u001a;fIR\u000b7o\u001b*fgVdG/A\buCN\\G)Z:de&\u0004H/[8o)\t\t)'A\u000bmSN$(+Z7pi\u0016\u001cE.^:uKJd\u0015N\\6\u0015\t\u0005}\u00141\u0019\u0005\b\u00033{\u0002\u0019AAN\u0003QA\u0017M\u001c3mK2K7\u000f\u001e'j].\u0014Vm];miR1\u0011qPAe\u0003\u0017Dq!!'!\u0001\u0004\tY\nC\u0004\u0002N\u0002\u0002\r!a4\u0002\r\u0019,H/\u001e:f!\u0019\t\t.a5\u0002X6\ta/C\u0002\u0002VZ\u00141bS1gW\u00064U\u000f^;sKB1\u0011\u0011\\Ar\u0003Ol!!a7\u000b\t\u0005u\u0017q\\\u0001\u0005kRLGN\u0003\u0002\u0002b\u0006!!.\u0019<b\u0013\u0011\t)/a7\u0003\u0015\r{G\u000e\\3di&|g\u000eE\u0002e\u0003SL1!a;f\u0005I\u0019E.^:uKJd\u0015N\\6MSN$\u0018N\\4\u000251|wMU3n_R,G*\u001b8l\t\u0016\u001c8M]5cK\u0016\u0013(o\u001c:\u0015\t\u0005\u0005\u0013\u0011\u001f\u0005\b\u0003g\f\u0003\u0019AA{\u0003\u0005)\u0007\u0003BA|\u0005\u0003qA!!?\u0002~:\u0019Q+a?\n\u0003\rK1!a@C\u0003\u001d\u0001\u0018mY6bO\u0016LAAa\u0001\u0003\u0006\tIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u0003\u007f\u0014\u0005")
public class ClusterLinkCheckAvailability
extends ClusterLinkScheduler.PeriodicTask {
    private final ClusterLinkConfig config;
    private final ClusterLinkMetrics metrics;
    private final ClusterLinkManager clusterLinkManager;
    private final String linkName;
    private final Function0<ConfluentAdmin> remoteAdminFactory;
    private final boolean remoteIsUnmanaged;
    private final ListClusterLinksOptions listLinkOptions;
    private volatile RemoteLinkState remoteLinkState;
    private int failCount;
    private volatile Option<TaskDescription> taskDesc;

    public ClusterLinkScheduler clScheduler() {
        return super.scheduler();
    }

    public String linkName() {
        return this.linkName;
    }

    public Function0<ConfluentAdmin> remoteAdminFactory() {
        return this.remoteAdminFactory;
    }

    private boolean remoteIsUnmanaged() {
        return this.remoteIsUnmanaged;
    }

    private ListClusterLinksOptions listLinkOptions() {
        return this.listLinkOptions;
    }

    public RemoteLinkState remoteLinkState() {
        return this.remoteLinkState;
    }

    public void remoteLinkState_$eq(RemoteLinkState x$1) {
        this.remoteLinkState = x$1;
    }

    private int failCount() {
        return this.failCount;
    }

    private void failCount_$eq(int x$1) {
        this.failCount = x$1;
    }

    private Option<TaskDescription> taskDesc() {
        return this.taskDesc;
    }

    private void taskDesc_$eq(Option<TaskDescription> x$1) {
        this.taskDesc = x$1;
    }

    @Override
    public ClusterLinkScheduler.TaskResult run() {
        DescribeClusterResult describeClusterResult = ClusterLinkConnectionChecker$.MODULE$.doBasicDescribeCluster((Admin)this.remoteAdminFactory().apply());
        ClusterLinkScheduler.TaskContext taskContext = new ClusterLinkScheduler.TaskContext((Seq<TaskErrorCodeAndMsg>)((Seq)package$.MODULE$.Seq().empty()));
        this.scheduleWhenComplete(describeClusterResult.clusterId(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleDescribeClusterResult((ClusterLinkScheduler.TaskContext)tc, ClusterLinkConnectionChecker$.MODULE$.check(describeClusterResult, $this.config)), new ClusterLinkScheduler.TaskContext((Seq<TaskErrorCodeAndMsg>)((Seq)package$.MODULE$.Seq().empty()))));
        Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
        return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
    }

    private ClusterLinkScheduler.TaskResult handleDescribeClusterResult(ClusterLinkScheduler.TaskContext taskContext, Option<ClusterLinkConnectionCheckerResult> maybeClusterLinkConnectionCheckerResult) {
        String linkName = this.metrics.linkName();
        if (None$.MODULE$.equals(maybeClusterLinkConnectionCheckerResult)) {
            this.failCount_$eq(0);
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(34).append("Link ").append(linkName).append(" availability check succeeded").toString());
            this.clusterLinkManager.reportAvailableLink(linkName);
        } else if (maybeClusterLinkConnectionCheckerResult instanceof Some) {
            ClusterLinkConnectionCheckerResult linkUnavailableResult = (ClusterLinkConnectionCheckerResult)((Some)maybeClusterLinkConnectionCheckerResult).value();
            this.failCount_$eq(this.failCount() + 1);
            this.metrics.linkUnavailableSensor().record();
            UnavailableLinkReason unavailableLinkReason = linkUnavailableResult.unavailableLinkReason();
            if (InvalidBootstrapInternalEndpointUnavailableLinkReason$.MODULE$.equals(unavailableLinkReason)) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(56).append("Link ").append(linkName).append(" availability check failed with authorization error").toString());
                this.clusterLinkManager.failClusterLink(linkName, linkUnavailableResult.throwable(), (FailedLinkReason)UnauthorizedBootstrapFailedLinkReason$.MODULE$);
            } else {
                LinkState linkState;
                if (this.failCount() >= Predef$.MODULE$.Integer2int(this.config.availabilityCheckConsecutiveFailureThreshold())) {
                    this.clusterLinkManager.reportUnavailableLink(linkName, linkUnavailableResult.throwable(), linkUnavailableResult.unavailableLinkReason());
                }
                LinkState linkState2 = linkState = this.clusterLinkManager.linkState(linkName);
                ActiveClusterLink$ activeClusterLink$ = ActiveClusterLink$.MODULE$;
                if (linkState2 != null && linkState2.equals(activeClusterLink$)) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("Link ").append(linkName).append(" availability check failed ").append(this.failCount()).append(" times").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> linkUnavailableResult.throwable());
                } else {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(81).append("Link ").append(linkName).append(" availability check in state ").append(linkState).append(" failed ").append(this.failCount()).append(" times with exception ").append(linkUnavailableResult.throwable().getCause()).append(" ").append("and reason code ").append(linkUnavailableResult.unavailableLinkReason()).toString());
                }
            }
        } else {
            throw new MatchError(maybeClusterLinkConnectionCheckerResult);
        }
        if (!this.remoteIsUnmanaged()) {
            if (this.failCount() == 0) {
                return this.listRemoteClusterLink(taskContext);
            }
            this.remoteLinkState_$eq(new RemoteLinkState(ClusterLinkDescription.LinkState.UNKNOWN, ClusterLinkError.UNKNOWN, (Option<String>)new Some((Object)"Failed to obtain remote link state since cluster link is unavailable"), super.time().milliseconds()));
            Seq<TaskErrorCodeAndMsg> completedTask_errs = taskContext.errs();
            return new ClusterLinkScheduler.TaskResult(true, completedTask_errs);
        }
        Seq<TaskErrorCodeAndMsg> completedTask_errs = taskContext.errs();
        return new ClusterLinkScheduler.TaskResult(true, completedTask_errs);
    }

    @Override
    public void onCompletion(ClusterLinkScheduler.CompletedTaskResult result) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(27).append("Completed with task result ").append(result).toString());
        this.taskDesc_$eq(ClusterLinkTask$.MODULE$.handleResult(result, this.metrics, ClusterLinkCheckAvailabilityTaskType$.MODULE$, "run the availability check task"));
    }

    public Option<TaskDescription> taskDescription() {
        return this.taskDesc();
    }

    private ClusterLinkScheduler.TaskResult listRemoteClusterLink(ClusterLinkScheduler.TaskContext taskContext) {
        KafkaFuture listLinkResult = ((ConfluentAdmin)this.remoteAdminFactory().apply()).listClusterLinks(this.listLinkOptions()).result();
        this.scheduleWhenComplete(listLinkResult, new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleListLinkResult((ClusterLinkScheduler.TaskContext)tc, (KafkaFuture<Collection<ClusterLinkListing>>)listLinkResult), taskContext));
        Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
        return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
    }

    private ClusterLinkScheduler.TaskResult handleListLinkResult(ClusterLinkScheduler.TaskContext taskContext, KafkaFuture<Collection<ClusterLinkListing>> future) {
        .colon.colon colon2;
        None$ none$;
        long now = super.time().milliseconds();
        try {
            Collection listing = (Collection)future.get();
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(23).append("handleListLinkResult ").append(this.linkName()).append(": ").append(listing).toString());
            if (listing.isEmpty()) {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Remote link state is empty for cluster link ").append(this.linkName()).toString());
                None$ x$4 = None$.MODULE$;
                this.remoteLinkState_$eq(new RemoteLinkState(ClusterLinkDescription.LinkState.REMOTE_LINK_NOT_FOUND, ClusterLinkError.NO_ERROR, (Option<String>)x$4, now));
            } else {
                ClusterLinkListing remoteLink = (ClusterLinkListing)listing.iterator().next();
                this.remoteLinkState_$eq(new RemoteLinkState(remoteLink.linkState(), remoteLink.clusterLinkError(), (Option<String>)Option$.MODULE$.apply((Object)remoteLink.linkErrorMessage()), now));
            }
            none$ = None$.MODULE$;
        }
        catch (Throwable ex) {
            ApiException e = ClusterLinkUtils$.MODULE$.apiException(ex, new StringBuilder(59).append("Remote link state could not be determined for cluster link ").append(this.linkName()).toString());
            this.logRemoteLinkDescribeError(e);
            if (e instanceof AuthenticationException) {
                String errMsg = "Failed to obtain remote link state due to authentication failure. This failure may impact functioning of this link until credentials are updated.";
                this.remoteLinkState_$eq(new RemoteLinkState(ClusterLinkDescription.LinkState.UNKNOWN, ClusterLinkError.AUTHENTICATION_ERROR, (Option<String>)new Some((Object)errMsg), now));
                none$ = new Some((Object)new TaskErrorCodeAndMsg(AuthenticationTaskErrorCode$.MODULE$, errMsg));
            }
            if (e instanceof ClusterAuthorizationException) {
                String errMsg = "Failed to obtain remote link state due to Describe:Cluster authorization failure. This failure may impact functioning of this link until appropriate access is granted.";
                this.remoteLinkState_$eq(new RemoteLinkState(ClusterLinkDescription.LinkState.UNKNOWN, ClusterLinkError.AUTHORIZATION_ERROR, (Option<String>)new Some((Object)errMsg), now));
                none$ = new Some((Object)new TaskErrorCodeAndMsg(AuthorizationTaskErrorCode$.MODULE$, errMsg));
            }
            if (e != null) {
                this.remoteLinkState_$eq(new RemoteLinkState(ClusterLinkDescription.LinkState.UNKNOWN, ClusterLinkError.UNKNOWN, (Option<String>)new Some((Object)new StringBuilder(42).append("Failed to obtain remote link state due to ").append(e.getMessage()).toString()), now));
                none$ = new Some((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, "Failed to obtain remote link state for an unknown reason."));
            }
            throw new MatchError(null);
        }
        None$ errOpt = none$;
        if (errOpt instanceof Some) {
            TaskErrorCodeAndMsg err = (TaskErrorCodeAndMsg)((Some)errOpt).value();
            colon2 = new .colon.colon((Object)err, (List)Nil$.MODULE$);
        } else if (None$.MODULE$.equals(errOpt)) {
            colon2 = (Seq)package$.MODULE$.Seq().empty();
        } else {
            throw new MatchError((Object)errOpt);
        }
        .colon.colon errs = colon2;
        Seq completedTask_errs = (Seq)taskContext.errs().$plus$plus((IterableOnce)errs);
        return new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
    }

    private void logRemoteLinkDescribeError(Throwable e) {
        Throwable cause;
        Throwable throwable = cause = e.getCause() == null ? e : e.getCause();
        if (this.failCount() == 0 && !(cause instanceof RetriableException)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(59).append("Remote link state could not be determined for cluster link ").append(this.linkName()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
            return;
        }
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(59).append("Remote link state could not be determined for cluster link ").append(this.linkName()).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
    }

    /*
     * Unable to fully structure code
     */
    public ClusterLinkCheckAvailability(ClusterLinkConfig config, ClusterLinkMetrics metrics, ClusterLinkManager clusterLinkManager, int intervalMs, ClusterLinkScheduler clScheduler, String linkName, Function0<ConfluentAdmin> remoteAdminFactory, Time time, ClusterLinkRequestQuota quota) {
        this.config = config;
        this.metrics = metrics;
        this.clusterLinkManager = clusterLinkManager;
        this.linkName = linkName;
        this.remoteAdminFactory = remoteAdminFactory;
        super(clScheduler, "CheckAvailability", intervalMs, time, quota);
        v0 = config.linkMode();
        var10_10 = ClusterLinkConfig.LinkMode.DESTINATION;
        if (v0 != null ? v0.equals(var10_10) == false : var10_10 != null) ** GOTO lbl-1000
        v1 = config.connectionMode();
        var11_11 = ConnectionMode$Outbound$.MODULE$;
        if (v1 != null && v1.equals(var11_11)) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        this.remoteIsUnmanaged = v2;
        this.listLinkOptions = new ListClusterLinksOptions().linkNames(Optional.of(Collections.singleton(linkName)));
        this.remoteLinkState = !this.remoteIsUnmanaged() ? new RemoteLinkState(ClusterLinkDescription.LinkState.UNKNOWN, ClusterLinkError.NO_ERROR, (Option<String>)None$.MODULE$, -1L) : new RemoteLinkState(ClusterLinkDescription.LinkState.UNMANAGED_SOURCE, ClusterLinkError.NO_ERROR, (Option<String>)None$.MODULE$, -1L);
        this.failCount = 0;
        this.taskDesc = None$.MODULE$;
    }
}

