/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.nio.channels.SocketChannel;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import kafka.network.SocketServer;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.KafkaConfig;
import kafka.server.link.ClusterLinkClientType$OutboundConnectionAdmin$;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkConnectionManager;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkMetadata;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetadataThread;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkNetworkClient;
import kafka.server.link.ConnectionMode;
import kafka.server.link.ConnectionMode$Inbound$;
import kafka.server.link.CoordinatorListener;
import kafka.server.link.LazyResource;
import kafka.server.link.RemoteNetworkClient;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.ClientDnsLookup;
import org.apache.kafka.clients.ClientInterceptor;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.internals.AdminMetadataManager;
import org.apache.kafka.clients.admin.internals.ConfluentAdminUtils;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.NetworkException;
import org.apache.kafka.common.errors.NotControllerException;
import org.apache.kafka.common.message.InitiateReverseConnectionsRequestData;
import org.apache.kafka.common.message.ReverseConnectionRequestData;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.ReverseChannel;
import org.apache.kafka.common.network.ReverseNode;
import org.apache.kafka.common.requests.InitiateReverseConnectionsRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\r5e\u0001\u0002 @\u0001\u0019C\u0011\"\u0016\u0001\u0003\u0002\u0003\u0006IA\u0016/\t\u0011u\u0003!\u0011!Q\u0001\nyC\u0011\"\u0019\u0001\u0003\u0002\u0003\u0006IAY8\t\u0011A\u0004!\u0011!Q\u0001\nED!\"!\u0001\u0001\u0005\u0003\u0005\u000b\u0011BA\u0002\u0011)\tI\u0001\u0001B\u0001B\u0003%\u00111\u0002\u0005\u000b\u0003#\u0001!\u0011!Q\u0001\n\u0005M\u0001BCA\u0010\u0001\t\u0005\t\u0015!\u0003\u0002\"!Q\u0011\u0011\u0006\u0001\u0003\u0002\u0003\u0006I!a\u000b\t\u0015\u0005e\u0002A!A!\u0002\u0013\tY\u0004\u0003\u0006\u0002B\u0001\u0011\t\u0011)A\u0005\u0003\u0007B!\"a\u0015\u0001\u0005\u0003\u0005\u000b\u0011BA+\u0011\u001d\tY\u0006\u0001C\u0001\u0003;B\u0011\"!\u001f\u0001\u0005\u0004%I!a\u001f\t\u0011\u00055\u0005\u0001)A\u0005\u0003{B\u0011\"a$\u0001\u0005\u0004%I!!%\t\u0011\u0005M\u0006\u0001)A\u0005\u0003'C\u0011\"!.\u0001\u0005\u0004%I!!%\t\u0011\u0005]\u0006\u0001)A\u0005\u0003'C1\"!/\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002<\"Y\u0011Q\u0019\u0001A\u0002\u0003\u0007I\u0011BAd\u0011-\t\u0019\u000e\u0001a\u0001\u0002\u0003\u0006K!!0\t\u0017\u0005u\u0007\u00011AA\u0002\u0013%\u0011q\u001c\u0005\f\u0003O\u0004\u0001\u0019!a\u0001\n\u0013\tI\u000fC\u0006\u0002n\u0002\u0001\r\u0011!Q!\n\u0005\u0005\bbCAy\u0001\u0001\u0007\t\u0019!C\u0005\u0003gD1B!\u0001\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0003\u0004!Y!q\u0001\u0001A\u0002\u0003\u0005\u000b\u0015BA{\u0011%\u0011Y\u0001\u0001a\u0001\n\u0013\u0011i\u0001C\u0005\u0003\u0018\u0001\u0001\r\u0011\"\u0003\u0003\u001a!A!Q\u0004\u0001!B\u0013\u0011y\u0001C\u0004\u0003\"\u0001!\tEa\t\t\u0011\t\u0015\u0002\u0001\"\u0011@\u0005OAqA!\u0010\u0001\t\u0003\u0012\u0019\u0003C\u0004\u0003@\u0001!\tE!\u0011\t\u000f\tu\u0003\u0001\"\u0011\u0003`!9!\u0011\u0014\u0001\u0005B\tm\u0005b\u0002BY\u0001\u0011%!1\u0017\u0005\b\u0005#\u0004A\u0011\u0002Bj\u0011\u001d\u0011I\u000f\u0001C\u0005\u0005WDqAa=\u0001\t\u0003\u0012)\u0010C\u0004\u0004\u0002\u0001!\tea\u0001\t\u000f\r%\u0001\u0001\"\u0011\u0003$!911\u0002\u0001\u0005\n\t\r\u0002bBB\u0007\u0001\u0011E#1\u0005\u0005\b\u0007\u001f\u0001A\u0011\u000bB\u0012\u0011!\u0019\t\u0002\u0001C\u0001\u007f\rM\u0001\u0002CB\u000b\u0001\u0011\u0005qha\u0006\t\u000f\re\u0001\u0001\"\u0003\u0004\u001c!91\u0011\u0005\u0001\u0005\n\r\r\u0002bBB\u0016\u0001\u0011%!1\u0005\u0005\b\u0007W\u0001A\u0011BB\u0017\u0011\u001d\u0019\t\u0004\u0001C\u0005\u0005GAqaa\r\u0001\t\u0013\u0011\u0019\u0003C\u0004\u00046\u0001!IAa\t\t\u000f\r]\u0002\u0001\"\u0003\u0004:!91q\n\u0001\u0005\u0012\rE\u0003\u0002CB,\u0001\u0011\u0005qh!\u0017\t\u000f\r\r\u0004\u0001\"\u0011\u0004f!91q\r\u0001\u0005B\r\u0015\u0004bBB5\u0001\u0011\u000531\u000e\u0002%\u00072,8\u000f^3s\u0019&t7nT;uE>,h\u000eZ\"p]:,7\r^5p]6\u000bg.Y4fe*\u0011\u0001)Q\u0001\u0005Y&t7N\u0003\u0002C\u0007\u000611/\u001a:wKJT\u0011\u0001R\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001qi\u0013*\u0011\u0005!KU\"A \n\u0005){$\u0001H\"mkN$XM\u001d'j].\u001cuN\u001c8fGRLwN\\'b]\u0006<WM\u001d\t\u0003\u0019>s!\u0001S'\n\u00059{\u0014AE\"mkN$XM\u001d'j].4\u0015m\u0019;pefL!\u0001U)\u00033=+HOY8v]\u0012\u001cuN\u001c8fGRLwN\\'b]\u0006<WM\u001d\u0006\u0003\u001d~\u0002\"\u0001S*\n\u0005Q{$aE\"p_J$\u0017N\\1u_Jd\u0015n\u001d;f]\u0016\u0014\u0018\u0001\u00037j].$\u0015\r^1\u0011\u0005]SV\"\u0001-\u000b\u0005e\u001b\u0015A\u0001>l\u0013\tY\u0006LA\bDYV\u001cH/\u001a:MS:\\G)\u0019;b\u0013\t)\u0016*A\u0007j]&$\u0018.\u00197D_:4\u0017n\u001a\t\u0003\u0011~K!\u0001Y \u0003#\rcWo\u001d;fe2Kgn[\"p]\u001aLw-A\nm_\u000e\fG\u000eT8hS\u000e\fGn\u00117vgR,'\u000f\u0005\u0002dY:\u0011AM\u001b\t\u0003K\"l\u0011A\u001a\u0006\u0003O\u0016\u000ba\u0001\u0010:p_Rt$\"A5\u0002\u000bM\u001c\u0017\r\\1\n\u0005-D\u0017A\u0002)sK\u0012,g-\u0003\u0002n]\n11\u000b\u001e:j]\u001eT!a\u001b5\n\u0005\u0005L\u0015!E2mS\u0016tG/\u00138uKJ\u001cW\r\u001d;peB\u0019!o];\u000e\u0003!L!\u0001\u001e5\u0003\r=\u0003H/[8o!\t1h0D\u0001x\u0015\tA\u00180A\u0004dY&,g\u000e^:\u000b\u0005\u0011S(BA>}\u0003\u0019\t\u0007/Y2iK*\tQ0A\u0002pe\u001eL!a`<\u0003#\rc\u0017.\u001a8u\u0013:$XM]2faR|'/A\u0004nKR\u0014\u0018nY:\u0011\u0007!\u000b)!C\u0002\u0002\b}\u0012!c\u00117vgR,'\u000fT5oW6+GO]5dg\u0006yQ.\u001a;bI\u0006$\u0018-T1oC\u001e,'\u000fE\u0002I\u0003\u001bI1!a\u0004@\u0005i\u0019E.^:uKJd\u0015N\\6NKR\fG-\u0019;b\u001b\u0006t\u0017mZ3s\u00031\u0019xnY6fiN+'O^3s!\u0011\t)\"a\u0007\u000e\u0005\u0005]!bAA\r\u0007\u00069a.\u001a;x_J\\\u0017\u0002BA\u000f\u0003/\u0011AbU8dW\u0016$8+\u001a:wKJ\fAB\u0019:pW\u0016\u00148i\u001c8gS\u001e\u0004B!a\t\u0002&5\t\u0011)C\u0002\u0002(\u0005\u00131bS1gW\u0006\u001cuN\u001c4jO\u0006Q1/\u001a:wKJLeNZ8\u0011\t\u00055\u0012QG\u0007\u0003\u0003_QA!!\r\u00024\u0005Q\u0011-\u001e;i_JL'0\u001a:\u000b\u0005\tK\u0018\u0002BA\u001c\u0003_\u0011A#Q;uQ>\u0014\u0018N_3s'\u0016\u0014h/\u001a:J]\u001a|\u0017!B9v_R\f\u0007\u0003BA\u0012\u0003{I1!a\u0010B\u0005]\u0019E.^:uKJd\u0015N\\6SKF,Xm\u001d;Rk>$\u0018-\u0001\u0003uS6,\u0007\u0003BA#\u0003\u001fj!!a\u0012\u000b\t\u0005%\u00131J\u0001\u0006kRLGn\u001d\u0006\u0004\u0003\u001bJ\u0018AB2p[6|g.\u0003\u0003\u0002R\u0005\u001d#\u0001\u0002+j[\u0016\f\u0001$\u001a8bE2,'+\u001a<feN,7i\u001c8oK\u000e$\u0018n\u001c8t!\r\u0011\u0018qK\u0005\u0004\u00033B'a\u0002\"p_2,\u0017M\\\u0001\u0007y%t\u0017\u000e\u001e \u00155\u0005}\u0013\u0011MA2\u0003K\n9'!\u001b\u0002l\u00055\u0014qNA9\u0003g\n)(a\u001e\u0011\u0005!\u0003\u0001\"B+\u000e\u0001\u00041\u0006\"B/\u000e\u0001\u0004q\u0006\"B1\u000e\u0001\u0004\u0011\u0007\"\u00029\u000e\u0001\u0004\t\bbBA\u0001\u001b\u0001\u0007\u00111\u0001\u0005\b\u0003\u0013i\u0001\u0019AA\u0006\u0011\u001d\t\t\"\u0004a\u0001\u0003'Aq!a\b\u000e\u0001\u0004\t\t\u0003C\u0004\u0002*5\u0001\r!a\u000b\t\u000f\u0005eR\u00021\u0001\u0002<!9\u0011\u0011I\u0007A\u0002\u0005\r\u0003bBA*\u001b\u0001\u0007\u0011QK\u0001\u0015G>tg.Z2uS>tW\u000b\u001d3bi\u0016dunY6\u0016\u0005\u0005u\u0004\u0003BA@\u0003\u0013k!!!!\u000b\t\u0005\r\u0015QQ\u0001\u0005Y\u0006twM\u0003\u0002\u0002\b\u0006!!.\u0019<b\u0013\u0011\tY)!!\u0003\r=\u0013'.Z2u\u0003U\u0019wN\u001c8fGRLwN\\+qI\u0006$X\rT8dW\u0002\nQ\u0003]3sg&\u001cH/\u001a8u\u0007>tg.Z2uS>t7/\u0006\u0002\u0002\u0014BA\u0011QSAP\u0003G\u000bI+\u0004\u0002\u0002\u0018*!\u0011\u0011TAN\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0003;\u000b))\u0001\u0003vi&d\u0017\u0002BAQ\u0003/\u0013\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1q!\r\u0011\u0018QU\u0005\u0004\u0003OC'aA%oiB!\u00111VAX\u001b\t\tiK\u0003\u0003\u0002\u001a\u0005-\u0013\u0002BAY\u0003[\u0013aBU3wKJ\u001cXm\u00115b]:,G.\u0001\fqKJ\u001c\u0018n\u001d;f]R\u001cuN\u001c8fGRLwN\\:!\u0003a\t7\r^5wKJ+g/\u001a:tK\u000e{gN\\3di&|gn]\u0001\u001aC\u000e$\u0018N^3SKZ,'o]3D_:tWm\u0019;j_:\u001c\b%\u0001\u000bmS:\\G*[:uK:,'/\u00128ea>Lg\u000e^\u000b\u0003\u0003{\u0003B!a0\u0002B6\u0011\u00111J\u0005\u0005\u0003\u0007\fYE\u0001\u0005F]\u0012\u0004x.\u001b8u\u0003aa\u0017N\\6MSN$XM\\3s\u000b:$\u0007o\\5oi~#S-\u001d\u000b\u0005\u0003\u0013\fy\rE\u0002s\u0003\u0017L1!!4i\u0005\u0011)f.\u001b;\t\u0013\u0005EW#!AA\u0002\u0005u\u0016a\u0001=%c\u0005)B.\u001b8l\u0019&\u001cH/\u001a8fe\u0016sG\r]8j]R\u0004\u0003f\u0001\f\u0002XB\u0019!/!7\n\u0007\u0005m\u0007N\u0001\u0005w_2\fG/\u001b7f\u0003Aa\u0017N\\6MSN$XM\\3s\u001d\u0006lW-\u0006\u0002\u0002bB!\u00111VAr\u0013\u0011\t)/!,\u0003\u00191K7\u000f^3oKJt\u0015-\\3\u0002)1Lgn\u001b'jgR,g.\u001a:OC6,w\fJ3r)\u0011\tI-a;\t\u0013\u0005E\u0007$!AA\u0002\u0005\u0005\u0018!\u00057j].d\u0015n\u001d;f]\u0016\u0014h*Y7fA!\u001a\u0011$a6\u0002\u00151|7-\u00197BI6Lg.\u0006\u0002\u0002vB!\u0011q_A\u007f\u001b\t\tIPC\u0002\u0002|^\fQ!\u00193nS:LA!a@\u0002z\nq1i\u001c8gYV,g\u000e^!e[&t\u0017A\u00047pG\u0006d\u0017\tZ7j]~#S-\u001d\u000b\u0005\u0003\u0013\u0014)\u0001C\u0005\u0002Rn\t\t\u00111\u0001\u0002v\u0006YAn\\2bY\u0006#W.\u001b8!Q\ra\u0012q[\u0001\u0014e\u0016lw\u000e^3OKR<xN]6DY&,g\u000e^\u000b\u0003\u0005\u001f\u0001BA]:\u0003\u0012A\u0019\u0001Ja\u0005\n\u0007\tUqHA\nSK6|G/\u001a(fi^|'o[\"mS\u0016tG/A\fsK6|G/\u001a(fi^|'o[\"mS\u0016tGo\u0018\u0013fcR!\u0011\u0011\u001aB\u000e\u0011%\t\tNHA\u0001\u0002\u0004\u0011y!\u0001\u000bsK6|G/\u001a(fi^|'o[\"mS\u0016tG\u000f\t\u0015\u0004?\u0005]\u0017aB:uCJ$X\u000f\u001d\u000b\u0003\u0003\u0013\f1B]3d_:4\u0017nZ;sKR1\u0011\u0011\u001aB\u0015\u0005[AaAa\u000b\"\u0001\u0004q\u0016!\u00038fo\u000e{gNZ5h\u0011\u001d\u0011y#\ta\u0001\u0005c\t1\"\u001e9eCR,GmS3zgB)!1\u0007B\u001dE6\u0011!Q\u0007\u0006\u0004\u0005oA\u0017AC2pY2,7\r^5p]&!!1\bB\u001b\u0005\r\u0019V\r^\u0001\rG2|7/Z\"mS\u0016tGo]\u0001\u0012K:\f'\r\\3DYV\u001cH/\u001a:MS:\\GCBAe\u0005\u0007\u0012i\u0005C\u0004\u0003F\r\u0002\rAa\u0012\u0002\u001b9,Go^8sW\u000ec\u0017.\u001a8u!\rA%\u0011J\u0005\u0004\u0005\u0017z$\u0001G\"mkN$XM\u001d'j].tU\r^<pe.\u001cE.[3oi\"9\u0011\u0011B\u0012A\u0002\t=\u0003\u0003\u0002:t\u0005#\u0002BAa\u0015\u0003Z5\u0011!Q\u000b\u0006\u0005\u0005/\nI0A\u0005j]R,'O\\1mg&!!1\fB+\u0005Q\tE-\\5o\u001b\u0016$\u0018\rZ1uC6\u000bg.Y4fe\u0006Q\u0012N\\5uS\u0006$XMU3wKJ\u001cXmQ8o]\u0016\u001cG/[8ogR1!\u0011\rB@\u0005\u001f\u0003bAa\u0019\u0003n\tMd\u0002\u0002B3\u0005Sr1!\u001aB4\u0013\u0005I\u0017b\u0001B6Q\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002B8\u0005c\u00121aU3r\u0015\r\u0011Y\u0007\u001b\t\u0007\u0003+\u0013)H!\u001f\n\t\t]\u0014q\u0013\u0002\u0012\u0007>l\u0007\u000f\\3uC\ndWMR;ukJ,\u0007\u0003BA@\u0005wJAA! \u0002\u0002\n!ak\\5e\u0011\u001d\u0011\t\t\na\u0001\u0005\u0007\u000b\u0011$\u001b8ji&\fG/Z\"p]:,7\r^5p]J+\u0017/^3tiB!!Q\u0011BF\u001b\t\u00119I\u0003\u0003\u0003\n\u0006-\u0013\u0001\u0003:fcV,7\u000f^:\n\t\t5%q\u0011\u0002\"\u0013:LG/[1uKJ+g/\u001a:tK\u000e{gN\\3di&|gn\u001d*fcV,7\u000f\u001e\u0005\b\u0005##\u0003\u0019\u0001BJ\u00039\u0011X-];fgR\u001cuN\u001c;fqR\u0004BA!\"\u0003\u0016&!!q\u0013BD\u00059\u0011V-];fgR\u001cuN\u001c;fqR\f1c\u001c8SKZ,'o]3D_:tWm\u0019;j_:$b!!3\u0003\u001e\n\u001d\u0006b\u0002BPK\u0001\u0007!\u0011U\u0001\bG\"\fgN\\3m!\u0011\tYKa)\n\t\t\u0015\u0016Q\u0016\u0002\r\u0017\u000647.Y\"iC:tW\r\u001c\u0005\b\u0005S+\u0003\u0019\u0001BV\u0003-\u0011XM^3sg\u0016tu\u000eZ3\u0011\t\u0005-&QV\u0005\u0005\u0005_\u000biKA\u0006SKZ,'o]3O_\u0012,\u0017!E8o\u0007>tg.Z2uS>t7\t\\8tKRQ\u0011\u0011\u001aB[\u0005o\u0013IM!4\t\u000f\t}e\u00051\u0001\u0003\"\"9!\u0011\u0018\u0014A\u0002\tm\u0016!\u0003:fcV,7\u000f^%e!\u0019\u0011iLa0\u0003D6\u0011\u00111T\u0005\u0005\u0005\u0003\fYJ\u0001\u0005PaRLwN\\1m!\u0011\tyH!2\n\t\t\u001d\u0017\u0011\u0011\u0002\b\u0013:$XmZ3s\u0011\u001d\u0011YM\na\u0001\u0003G\u000baB]3n_R,'I]8lKJLE\rC\u0004\u0003P\u001a\u0002\r!!\u0016\u00025U\u0004H-\u0019;f\u001b\u0016$\u0018\rZ1uC&3\u0007+\u001a:tSN$XM\u001c;\u0002-\u0019|'o^1sIR{7k\\;sG\u0016\u0014%o\\6feN$b!!3\u0003V\n\u0015\bb\u0002BlO\u0001\u0007!\u0011\\\u0001\fe\u0016\fX/Z:u\t\u0006$\u0018\r\u0005\u0003\u0003\\\n\u0005XB\u0001Bo\u0015\u0011\u0011y.a\u0013\u0002\u000f5,7o]1hK&!!1\u001dBo\u0005\u0015Je.\u001b;jCR,'+\u001a<feN,7i\u001c8oK\u000e$\u0018n\u001c8t%\u0016\fX/Z:u\t\u0006$\u0018\rC\u0004\u0003h\u001e\u0002\rA!\u0019\u0002\u000f\u0019,H/\u001e:fg\u0006A2M]3bi\u0016\u0014VM^3sg\u0016\u001cuN\u001c8fGRLwN\\:\u0015\u0011\u0005%'Q\u001eBx\u0005cDqAa6)\u0001\u0004\u0011I\u000eC\u0004\u0003\u0012\"\u0002\rAa%\t\u000f\t\u001d\b\u00061\u0001\u0003b\u0005QrN\u001c(foJ+Wn\u001c;f\u0019&t7nQ8pe\u0012Lg.\u0019;peR!\u0011\u0011\u001aB|\u0011\u001d\u0011I0\u000ba\u0001\u0005w\f1bY8pe\u0012Lg.\u0019;peB!\u0011q\u0018B\u007f\u0013\u0011\u0011y0a\u0013\u0003\t9{G-Z\u0001\u0013_:\u001cuN\u001c;s_2dWM]\"iC:<W\r\u0006\u0003\u0002J\u000e\u0015\u0001bBB\u0004U\u0001\u0007\u0011QK\u0001\tSN\f5\r^5wK\u0006\u0019sN\u001c'j].lU\r^1eCR\f\u0007+\u0019:uSRLwN\u001c'fC\u0012,'o\u00115b]\u001e,\u0017!H7bs\n,\u0007K]8dKN\u001c8i\\8sI&t\u0017\r^8s\u0007\"\fgnZ3\u00027\rdwn]3SKZ,'o]3D_:tWm\u0019;j_:\fE-\\5o\u0003q\u0019'/Z1uKJ+g/\u001a:tK\u000e{gN\\3di&|g.\u00113nS:\f\u0011c\u0019:fCR,'+Z7pi\u0016\fE-\\5o)\t\u0011\t\"\u0001\tde\u0016\fG/\u001a'pG\u0006d\u0017\tZ7j]R\u0011\u0011Q_\u0001\u0013kB$\u0017\r^3MS:\\G*[:uK:,'\u000f\u0006\u0003\u0002J\u000eu\u0001BBB\u0010c\u0001\u0007a,\u0001\u0004d_:4\u0017nZ\u0001\re\u00164XM]:bY\u0012\u000bG/Y\u000b\u0003\u0007K\u0001BAa7\u0004(%!1\u0011\u0006Bo\u0005q\u0011VM^3sg\u0016\u001cuN\u001c8fGRLwN\u001c*fcV,7\u000f\u001e#bi\u0006\fq$\\1zE\u0016\u001c%/Z1uKB+'o]5ti\u0016tGoQ8o]\u0016\u001cG/[8o)\u0011\tIma\f\t\u000f\teH\u00071\u0001\u0003|\u0006)\"/Z9vKN$X*\u001a;bI\u0006$\u0018-\u00169eCR,\u0017AG2m_N,\u0007+\u001a:tSN$XM\u001c;D_:tWm\u0019;j_:\u001c\u0018!H2m_N,\u0017i\u0019;jm\u0016\u0014VM^3sg\u0016\u001cuN\u001c8fGRLwN\\:\u0002!M|7m[3u\u0007\"\fgN\\3m\u0017\u0016LH\u0003BAR\u0007wAqa!\u00109\u0001\u0004\u0019y$A\u0007t_\u000e\\W\r^\"iC:tW\r\u001c\t\u0005\u0007\u0003\u001aY%\u0004\u0002\u0004D)!1QIB$\u0003!\u0019\u0007.\u00198oK2\u001c(\u0002BB%\u0003\u000b\u000b1A\\5p\u0013\u0011\u0019iea\u0011\u0003\u001bM{7m[3u\u0007\"\fgN\\3m\u0003M\u0019Gn\\:f%\u00164XM]:f\u0007\"\fgN\\3m)\u0011\t)fa\u0015\t\u000f\rU\u0013\b1\u0001\u0002*\u0006q!/\u001a<feN,7\t[1o]\u0016d\u0017AD7fi\u0006$\u0017\r^1UQJ,\u0017\rZ\u000b\u0003\u00077\u0002BA]:\u0004^A\u0019\u0001ja\u0018\n\u0007\r\u0005tHA\rDYV\u001cH/\u001a:MS:\\W*\u001a;bI\u0006$\u0018\r\u00165sK\u0006$\u0017!\u00079feNL7\u000f^3oi\u000e{gN\\3di&|gnQ8v]R,\"!a)\u0002-I,g/\u001a:tK\u000e{gN\\3di&|gnQ8v]R\fQ\u0002\\1{sJ+7o\\;sG\u0016\u001cXCAB7!\u0019\u0011\u0019G!\u001c\u0004pA\"1\u0011OB>!\u0015A51OB<\u0013\r\u0019)h\u0010\u0002\r\u0019\u0006T\u0018PU3t_V\u00148-\u001a\t\u0005\u0007s\u001aY\b\u0004\u0001\u0005\u0017\ruT(!A\u0001\u0002\u000b\u00051q\u0010\u0002\u0004?\u0012\n\u0014\u0003BBA\u0007\u000f\u00032A]BB\u0013\r\u0019)\t\u001b\u0002\b\u001d>$\b.\u001b8h!\r\u00118\u0011R\u0005\u0004\u0007\u0017C'aA!os\u0002")
public class ClusterLinkOutboundConnectionManager
extends ClusterLinkConnectionManager
implements ClusterLinkFactory.OutboundConnectionManager,
CoordinatorListener {
    private final ClusterLinkConfig initialConfig;
    private final Option<ClientInterceptor> clientInterceptor;
    private final ClusterLinkMetrics metrics;
    private final ClusterLinkMetadataManager metadataManager;
    private final SocketServer socketServer;
    private final KafkaConfig brokerConfig;
    private final AuthorizerServerInfo serverInfo;
    private final ClusterLinkRequestQuota quota;
    private final Time time;
    private final boolean enableReverseConnections;
    private final Object connectionUpdateLock;
    private final ConcurrentHashMap<Object, ReverseChannel> persistentConnections;
    private final ConcurrentHashMap<Object, ReverseChannel> activeReverseConnections;
    private volatile Endpoint linkListenerEndpoint;
    private volatile ListenerName linkListenerName;
    private volatile ConfluentAdmin localAdmin;
    private volatile Option<RemoteNetworkClient> remoteNetworkClient;

    private Object connectionUpdateLock() {
        return this.connectionUpdateLock;
    }

    private ConcurrentHashMap<Object, ReverseChannel> persistentConnections() {
        return this.persistentConnections;
    }

    private ConcurrentHashMap<Object, ReverseChannel> activeReverseConnections() {
        return this.activeReverseConnections;
    }

    private Endpoint linkListenerEndpoint() {
        return this.linkListenerEndpoint;
    }

    private void linkListenerEndpoint_$eq(Endpoint x$1) {
        this.linkListenerEndpoint = x$1;
    }

    private ListenerName linkListenerName() {
        return this.linkListenerName;
    }

    private void linkListenerName_$eq(ListenerName x$1) {
        this.linkListenerName = x$1;
    }

    private ConfluentAdmin localAdmin() {
        return this.localAdmin;
    }

    private void localAdmin_$eq(ConfluentAdmin x$1) {
        this.localAdmin = x$1;
    }

    private Option<RemoteNetworkClient> remoteNetworkClient() {
        return this.remoteNetworkClient;
    }

    private void remoteNetworkClient_$eq(Option<RemoteNetworkClient> x$1) {
        this.remoteNetworkClient = x$1;
    }

    @Override
    public void startup() {
        ConnectionMode connectionMode = this.initialConfig.connectionMode();
        ConnectionMode$Inbound$ connectionMode$Inbound$ = ConnectionMode$Inbound$.MODULE$;
        if (connectionMode != null && connectionMode.equals(connectionMode$Inbound$)) {
            throw new IllegalStateException("Outbound connection manager created in inbound connection mode");
        }
        super.startup();
    }

    @Override
    public void reconfigure(ClusterLinkConfig newConfig, Set<String> updatedKeys) {
        if (updatedKeys.contains((Object)ClusterLinkConfig$.MODULE$.LocalListenerNameProp())) {
            this.updateLinkListener(this.currentConfig());
        }
        super.reconfigure(newConfig, updatedKeys);
        if (updatedKeys.exists((Function1 & Serializable)configName -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkConfig$.MODULE$.needsConnectionResetOnUpdate(configName)))) {
            this.closeActiveReverseConnections();
            return;
        }
    }

    @Override
    public void closeClients() {
        super.closeClients();
        this.closeActiveReverseConnections();
    }

    @Override
    public void enableClusterLink(ClusterLinkNetworkClient networkClient, Option<AdminMetadataManager> metadataManager) {
        KafkaClient kafkaClient = networkClient.networkClient();
        if (kafkaClient instanceof NetworkClient) {
            ((NetworkClient)kafkaClient).enableClusterLinkRequests(super.linkData().linkId(), (ClientInterceptor)this.clientInterceptor.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), null);
            return;
        }
    }

    public Seq<CompletableFuture<Void>> initiateReverseConnections(InitiateReverseConnectionsRequest initiateConnectionRequest, RequestContext requestContext) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("Initiate or forward reverse connection request: ").append(initiateConnectionRequest).toString());
        this.ensureReverseConnectionsEnabled();
        InitiateReverseConnectionsRequestData connData = initiateConnectionRequest.data();
        List futures = (List)package$.MODULE$.List().fill(connData.entries().size(), (Function0 & Serializable)() -> new CompletableFuture());
        try {
            String string = connData.sourceClusterId();
            String string2 = super.localLogicalCluster();
            if (string == null ? string2 != null : !string.equals(string2)) {
                throw new InvalidRequestException(new StringBuilder(67).append("Initiate reverse request for cluster ").append(connData.sourceClusterId()).append(" sent to wrong source cluster ").append(super.localLogicalCluster()).toString());
            }
            if (connData.forwardToBroker()) {
                this.forwardToSourceBrokers(connData, (Seq<CompletableFuture<Void>>)futures);
            } else {
                this.createReverseConnections(connData, requestContext, (Seq<CompletableFuture<Void>>)futures);
            }
        }
        catch (Throwable e) {
            this.error((Function0<String>)(Function0 & Serializable)() -> "Failing reverse connection request", (Function0<Throwable>)(Function0 & Serializable)() -> e);
            futures.foreach((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.completeExceptionally(e)));
        }
        return futures;
    }

    public void onReverseConnection(KafkaChannel channel2, ReverseNode reverseNode) {
        Optional requestId = reverseNode.requestId();
        int remoteBrokerId = reverseNode.remoteBrokerId();
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(78).append("Destination has successfully reversed channel ").append(channel2).append(" with requestId ").append(requestId).append(" remoteBrokerId ").append(remoteBrokerId).toString());
        this.ensureReverseConnectionsEnabled();
        if (!requestId.isPresent() && !this.isLinkCoordinator()) {
            String errorMessage = new StringBuilder(88).append("Discarding persistent reverse connection since broker ").append(this.brokerConfig.brokerId()).append(" is no longer the link coordinator").toString();
            this.debug((Function0<String>)(Function0 & Serializable)() -> errorMessage);
            throw new NotControllerException(errorMessage);
        }
        SocketChannel socketChannel = channel2.socketChannel();
        ReverseChannel reverseChannel = new ReverseChannel(channel2, reverseNode, channel -> this.onConnectionClose((KafkaChannel)channel, reverseNode.requestId(), reverseNode.remoteBrokerId(), true));
        Object object = this.connectionUpdateLock();
        synchronized (object) {
            this.activeReverseConnections().put(BoxesRunTime.boxToInteger((int)System.identityHashCode(socketChannel)), reverseChannel);
            if (!requestId.isPresent()) {
                if (Option$.MODULE$.apply((Object)this.persistentConnections().get(BoxesRunTime.boxToInteger((int)remoteBrokerId))).exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkOutboundConnectionManager.$anonfun$onReverseConnection$4(x$5)))) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(71).append("Ignoring persistent connection because a connection already exists for ").append(remoteBrokerId).toString());
                    throw new IllegalStateException(new StringBuilder(41).append("A persistent connection is available for ").append(remoteBrokerId).toString());
                }
                this.persistentConnections().put(BoxesRunTime.boxToInteger((int)remoteBrokerId), reverseChannel);
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(43).append("Created persistent connection to ").append(remoteBrokerId).append(", channel=").append(channel2).toString());
            }
        }
        this.metrics.reverseConnectionCreatedSensor().record();
        this.metrics.deprecatedReverseConnectionCreatedSensor().record();
        this.socketServer.reverseAndAdd(this.linkListenerName(), reverseChannel);
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(61).append("Added reverse connection ").append(channel2).append(" to source socket server, requestId=").append(requestId).toString());
    }

    private void onConnectionClose(KafkaChannel channel, Optional<Integer> requestId, int remoteBrokerId, boolean updateMetadataIfPersistent) {
        boolean bl;
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("Reverse channel ").append(channel).append(" has been disconnected").toString());
        Object object = this.connectionUpdateLock();
        synchronized (object) {
            boolean bl2;
            if (this.activeReverseConnections().remove(BoxesRunTime.boxToInteger((int)System.identityHashCode(channel.socketChannel()))) != null) {
                this.metrics.reverseConnectionClosedSensor().record();
                this.metrics.deprecatedReverseConnectionClosedSensor().record();
            }
            if (!requestId.isPresent() && this.persistentConnections().remove(BoxesRunTime.boxToInteger((int)remoteBrokerId)) != null) {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(62).append("Removed persistent connection for ").append(remoteBrokerId).append(" because channel ").append(channel.id()).append(" was closed").toString());
                bl2 = true;
            } else {
                bl2 = false;
            }
            bl = bl2;
        }
        if (updateMetadataIfPersistent && bl) {
            this.requestMetadataUpdate();
            return;
        }
    }

    private void forwardToSourceBrokers(InitiateReverseConnectionsRequestData requestData, Seq<CompletableFuture<Void>> futures) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(92).append("Forward initiate reverse connection request from source link coordinator to source brokers: ").append(requestData).toString());
        ConfluentAdmin admin = this.localAdmin();
        scala.collection.immutable.Map resultFutures = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(requestData.entries()).asScala().zip(futures)).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                InitiateReverseConnectionsRequestData.EntryData entry = (InitiateReverseConnectionsRequestData.EntryData)x0$1._1();
                CompletableFuture future = (CompletableFuture)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)entry.initiateRequestId())), (Object)future);
            }
            throw new MatchError(null);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        CollectionConverters$.MODULE$.ListHasAsScala(requestData.entries()).asScala().groupBy((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.sourceBrokerId())).foreach((Function1 & Serializable)x0$2 -> {
            ClusterLinkOutboundConnectionManager.$anonfun$forwardToSourceBrokers$4(this, requestData, admin, resultFutures, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    private void createReverseConnections(InitiateReverseConnectionsRequestData requestData, RequestContext requestContext, Seq<CompletableFuture<Void>> futures) {
        NetworkClient networkClient = ((RemoteNetworkClient)this.remoteNetworkClient().getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException("Remote client connection manager not available");
        })).networkClient();
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(71).append("Create reverse connections from source brokers to destination brokers: ").append(requestData).toString());
        ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(requestData.entries()).asScala().zip(futures)).foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                Object object;
                block5: {
                    InitiateReverseConnectionsRequestData.EntryData entry = (InitiateReverseConnectionsRequestData.EntryData)x0$1._1();
                    CompletableFuture future = (CompletableFuture)x0$1._2();
                    try {
                        if (entry.initiateRequestId() == -1 && Option$.MODULE$.apply((Object)this.persistentConnections().get(BoxesRunTime.boxToInteger((int)entry.targetBrokerId()))).exists((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkOutboundConnectionManager.$anonfun$createReverseConnections$4(x$7)))) {
                            object = BoxesRunTime.boxToBoolean((boolean)future.complete(null));
                            break block5;
                        }
                        if (entry.sourceBrokerId() == $this.brokerConfig.brokerId() || entry.sourceBrokerId() == -1) {
                            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(68).append("Create reverse connection from source broker to destination broker: ").append(entry).toString());
                            ReverseNode reverseNode = networkClient.reverseConnectionManager().createReversibleConnection(entry.initiateRequestId(), entry.targetBrokerId(), requestContext$1.listenerName, requestContext$1.principal, requestContext$1.principalSerde, requestContext$1.authenticationContext, $this.time.milliseconds());
                            object = reverseNode.future().whenComplete((x0$2, x1$1) -> {
                                if (x1$1 != null) {
                                    $this.metrics.outboundReverseConnectionFailedSensor().record();
                                    $this.metrics.deprecatedSourceReverseConnectionFailedSensor().record();
                                    networkClient.requestClusterLinkMetadataUpdate();
                                    future.completeExceptionally((Throwable)x1$1);
                                    this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Failed to reverse connection for ").append(reverseNode).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> x1$1);
                                    return;
                                }
                                future.complete(x0$2);
                                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(34).append("Completed connection reversal for ").append(reverseNode).toString());
                            });
                            break block5;
                        }
                        return BoxesRunTime.boxToBoolean((boolean)future.completeExceptionally(new InvalidRequestException(new StringBuilder(49).append("Incorrect source broker id, expected ").append($this.brokerConfig.brokerId()).append(", requested ").append(entry.sourceBrokerId()).toString())));
                    }
                    catch (Throwable e) {
                        future.completeExceptionally(e);
                        this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(41).append("Failed to reverse connection for request ").append(requestData).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                        object = BoxedUnit.UNIT;
                    }
                }
                return object;
            }
            throw new MatchError(null);
        });
    }

    @Override
    public void onNewRemoteLinkCoordinator(Node coordinator) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(63).append("Process remote metadata: isLocalCoordinator=").append(this.isLinkCoordinator()).append(" remoteCoordinator=").append(coordinator).toString());
        if (!this.enableReverseConnections) {
            return;
        }
        this.maybeCreatePersistentConnection();
        this.updateActiveLinkCount();
    }

    @Override
    public void onControllerChange(boolean isActive) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(52).append("Process local controller change, isActiveController=").append(isActive).toString());
        this.maybeProcessCoordinatorChange();
    }

    @Override
    public void onLinkMetadataPartitionLeaderChange() {
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Process metadata partition leader change");
        this.maybeProcessCoordinatorChange();
    }

    private void maybeProcessCoordinatorChange() {
        Object object = this.stateChangeLock();
        synchronized (object) {
            boolean isCoordinator = this.isLinkCoordinator();
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(51).append("Process link coordinator change isLocalCoordinator=").append(isCoordinator).toString());
            if (this.enableReverseConnections) {
                if (!isCoordinator) {
                    this.closePersistentConnections();
                } else {
                    this.maybeCreatePersistentConnection();
                }
                return;
            }
            return;
        }
    }

    @Override
    public void closeReverseConnectionAdmin() {
        this.remoteNetworkClient().foreach((Function1 & Serializable)x$8 -> {
            x$8.shutdown();
            return BoxedUnit.UNIT;
        });
        if (this.localAdmin() != null) {
            this.localAdmin().close(Duration.ZERO);
            return;
        }
    }

    @Override
    public void createReverseConnectionAdmin() {
        if (!this.enableReverseConnections) {
            return;
        }
        this.localAdmin_$eq(this.createLocalAdmin());
        this.remoteNetworkClient_$eq((Option<RemoteNetworkClient>)new Some((Object)this.createRemoteAdmin()));
        this.maybeCreatePersistentConnection();
    }

    public RemoteNetworkClient createRemoteAdmin() {
        ClusterLinkConfig config = this.currentConfig();
        ClusterLinkMetadata metadata = new ClusterLinkMetadata(this.brokerConfig, super.linkData().linkName(), super.linkData().linkId(), config.linkMode(), Predef$.MODULE$.Long2long(config.metadataRefreshBackoffMs()), Predef$.MODULE$.Long2long(config.metadataMaxAgeMs()));
        java.util.List addresses = ClientUtils.parseAndValidateAddresses(config.bootstrapServers(), (ClientDnsLookup)config.dnsLookup());
        metadata.bootstrap(addresses);
        ClusterLinkMetadataThread metadataRefreshThread = new ClusterLinkMetadataThread(this.brokerConfig, config, (Option<ClusterLinkConnectionManager>)None$.MODULE$, metadata, this.metrics.metrics(), ClusterLinkClientType$OutboundConnectionAdmin$.MODULE$, this.quota, this.time);
        metadataRefreshThread.addCoordinatorListener(this);
        metadataRefreshThread.start();
        NetworkClient networkClient = (NetworkClient)metadataRefreshThread.clusterLinkClient().networkClient();
        networkClient.enableClusterLinkReverseConnectionAdmin(super.linkData().linkId(), (ClientInterceptor)this.clientInterceptor.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), this.reversalData(), (ReverseNode.ReverseCallback)this);
        return new RemoteNetworkClient(networkClient, metadataRefreshThread);
    }

    public ConfluentAdmin createLocalAdmin() {
        ClusterLinkConfig config = this.currentConfig();
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(77).append("Creating local admin for reverse connections from source cluster on listener ").append(this.linkListenerEndpoint()).toString());
        Map<String, Object> adminConfigs = config.localLinkClientConfigs(this.brokerConfig, this.linkListenerEndpoint(), super.linkData().tenantPrefix().nonEmpty());
        adminConfigs.put("client.id", new StringBuilder(38).append("cluster-link-").append(super.linkData().linkName()).append("-local-source-conn-admin-").append(this.brokerConfig.brokerId()).toString());
        return (ConfluentAdmin)Admin.create(adminConfigs);
    }

    private void updateLinkListener(ClusterLinkConfig config) {
        this.linkListenerEndpoint_$eq(this.serverInfo.endpoints().stream().filter(x$9 -> {
            Optional optional = x$9.listenerName();
            Optional<String> optional2 = Optional.of(config.localListenerName());
            return !(optional != null ? !((Object)optional).equals(optional2) : optional2 != null);
        }).findFirst().orElseThrow(() -> new InvalidRequestException(new StringBuilder(19).append("Listener ").append(config.localListenerName()).append(" not found").toString())));
        this.linkListenerName_$eq(new ListenerName((String)this.linkListenerEndpoint().listenerName().orElseThrow(() -> new IllegalStateException("Listener name not set"))));
    }

    private ReverseConnectionRequestData reversalData() {
        Endpoint endpoint = this.linkListenerEndpoint();
        return new ReverseConnectionRequestData().setClusterLinkId(this.linkId()).setTargetClusterId((String)super.linkData().clusterId().getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException("Remote cluster id not known");
        })).setSourceClusterId(super.localLogicalCluster()).setSourceBrokerId(this.brokerConfig.brokerId()).setSourceHost(endpoint.host()).setSourcePort(endpoint.port());
    }

    private void maybeCreatePersistentConnection() {
        if (this.isLinkCoordinator()) {
            this.remoteNetworkClient().foreach((Function1 & Serializable)client -> {
                ClusterLinkOutboundConnectionManager.$anonfun$maybeCreatePersistentConnection$1(this, client);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private void maybeCreatePersistentConnection(Node coordinator) {
        if (!Option$.MODULE$.apply((Object)this.persistentConnections().get(BoxesRunTime.boxToInteger((int)coordinator.id()))).exists((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkOutboundConnectionManager.$anonfun$maybeCreatePersistentConnection$3(x$10)))) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(58).append("Creating persistent connection to remote link coordinator ").append(coordinator).toString());
            InitiateReverseConnectionsRequestData requestData = new InitiateReverseConnectionsRequestData().setClusterLinkId(new Uuid(super.linkData().linkId().getMostSignificantBits(), super.linkData().linkId().getLeastSignificantBits())).setForwardToBroker(false).setTimeoutMs(Predef$.MODULE$.Integer2int(this.currentConfig().reverseConnectionSetupTimeoutMs())).setSourceClusterId(super.localLogicalCluster()).setTargetClusterId((String)super.linkData().clusterId().getOrElse((Function0 & Serializable)() -> {
                throw new IllegalStateException("Remote cluster id not known");
            })).setEntries(Collections.singletonList(new InitiateReverseConnectionsRequestData.EntryData().setInitiateRequestId(-1).setSourceBrokerId(this.brokerConfig.brokerId()).setTargetBrokerId(coordinator.id())));
            CompletableFuture future = new CompletableFuture();
            this.forwardToSourceBrokers(requestData, (Seq<CompletableFuture<Void>>)new .colon.colon(future, (List)Nil$.MODULE$));
            future.whenComplete((x0$1, x1$1) -> {
                if (x1$1 != null) {
                    this.warn((Function0<String>)(Function0 & Serializable)() -> "Failed to create persistent reverse connection", (Function0<Throwable>)(Function0 & Serializable)() -> x1$1);
                    this.requestMetadataUpdate();
                    return;
                }
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(52).append("Successfully created persistent connection to ").append(coordinator).append("  for ").append(requestData).toString());
            });
            return;
        }
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(77).append("Not creating persistent connection, remoteController=").append(coordinator).append(", persistentConnections=").append(this.persistentConnections()).toString());
    }

    private void requestMetadataUpdate() {
        if (this.isActive()) {
            try {
                this.remoteNetworkClient().foreach((Function1 & Serializable)x$11 -> BoxesRunTime.boxToInteger((int)ClusterLinkOutboundConnectionManager.$anonfun$requestMetadataUpdate$1(x$11)));
                return;
            }
            catch (Exception e) {
                this.error((Function0<String>)(Function0 & Serializable)() -> "Failed to request metadata refresh", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                return;
            }
        }
    }

    private void closePersistentConnections() {
        Object object = this.connectionUpdateLock();
        synchronized (object) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "Closing persistent connections");
            ((IterableOnceOps)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.persistentConnections()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkOutboundConnectionManager.$anonfun$closePersistentConnections$2(this, x0$1)))).foreach((Function1 & Serializable)x0$2 -> {
                ClusterLinkOutboundConnectionManager.$anonfun$closePersistentConnections$3(this, x0$2);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private void closeActiveReverseConnections() {
        Object object = this.connectionUpdateLock();
        synchronized (object) {
            this.info((Function0<String>)(Function0 & Serializable)() -> "Closing active reverse connections");
            ((IterableOnceOps)CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.activeReverseConnections()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkOutboundConnectionManager.$anonfun$closeActiveReverseConnections$2(this, x0$1)))).foreach((Function1 & Serializable)x0$2 -> {
                ClusterLinkOutboundConnectionManager.$anonfun$closeActiveReverseConnections$3(this, x0$2);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    private int socketChannelKey(SocketChannel socketChannel) {
        return System.identityHashCode(socketChannel);
    }

    public boolean closeReverseChannel(ReverseChannel reverseChannel) {
        if (!reverseChannel.maybeClose()) {
            SocketChannel socketChannel = reverseChannel.socketChannel();
            try {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(122).append("Runnable to close reverse channel '").append(reverseChannel).append("' not set. Channel may not have been added to SocketServer yet, closing socket channel.").toString());
                reverseChannel.socketChannel().close();
            }
            catch (Exception e) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(31).append("Failed to close socket channel ").append(socketChannel).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
            }
            return true;
        }
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(83).append("Close initiated for reverse channel '").append(reverseChannel).append("', the channel will be closed by SocketServer.").toString());
        return false;
    }

    public Option<ClusterLinkMetadataThread> metadataThread() {
        return this.remoteNetworkClient().map((Function1 & Serializable)x$12 -> x$12.metadataRefreshThread());
    }

    @Override
    public int persistentConnectionCount() {
        return this.persistentConnections().size();
    }

    @Override
    public int reverseConnectionCount() {
        return this.activeReverseConnections().size();
    }

    public Seq<LazyResource<?>> lazyResources() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public static final /* synthetic */ boolean $anonfun$onReverseConnection$4(ReverseChannel x$5) {
        return x$5.socketChannel().isConnected();
    }

    public static final /* synthetic */ boolean $anonfun$forwardToSourceBrokers$10(int brokerId$1, scala.collection.immutable.Map resultFutures$1, InitiateReverseConnectionsRequestData.EntryData entry) {
        NetworkException e = new NetworkException(new StringBuilder(39).append("Source broker with id ").append(brokerId$1).append(" is not available").toString());
        return ((CompletableFuture)resultFutures$1.apply((Object)BoxesRunTime.boxToInteger((int)entry.initiateRequestId()))).completeExceptionally((Throwable)e);
    }

    public static final /* synthetic */ void $anonfun$forwardToSourceBrokers$4(ClusterLinkOutboundConnectionManager $this, InitiateReverseConnectionsRequestData requestData$1, ConfluentAdmin admin$1, scala.collection.immutable.Map resultFutures$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            int brokerId = x0$2._1$mcI$sp();
            Buffer entries = (Buffer)x0$2._2();
            if (brokerId == -1 || $this.brokerConfig.brokerId() == brokerId || $this.metadataManager.isBrokerOnline(brokerId)) {
                InitiateReverseConnectionsRequestData brokerRequest = new InitiateReverseConnectionsRequestData().setClusterLinkId(requestData$1.clusterLinkId()).setSourceClusterId(requestData$1.sourceClusterId()).setTargetClusterId(requestData$1.targetClusterId()).setForwardToBroker(false).setEntries(CollectionConverters$.MODULE$.BufferHasAsJava(entries).asJava());
                ConfluentAdminUtils.initiateReverseConnections((ConfluentAdmin)admin$1, (InitiateReverseConnectionsRequestData)brokerRequest, (Integer)Predef$.MODULE$.int2Integer(brokerId)).forEach((x0$3, x1$1) -> x1$1.whenComplete((x0$4, x1$2) -> {
                    if (x1$2 != null) {
                        ((CompletableFuture)resultFutures$1.apply((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x0$3)))).completeExceptionally((Throwable)x1$2);
                        $this.metrics.outboundReverseConnectionFailedSensor().record();
                        $this.metrics.deprecatedSourceReverseConnectionFailedSensor().record();
                        $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(65).append("Connection reversal request to local broker failed for requestId=").append(x0$3).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> x1$2);
                        return;
                    }
                    ((CompletableFuture)resultFutures$1.apply((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x0$3)))).complete(x0$4);
                    $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(50).append("Completed initiate reversal request for requestId=").append(x0$3).toString());
                }));
                return;
            }
            entries.foreach((Function1 & Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkOutboundConnectionManager.$anonfun$forwardToSourceBrokers$10(brokerId, resultFutures$1, entry)));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$createReverseConnections$4(ReverseChannel x$7) {
        return x$7.socketChannel().isConnected();
    }

    public static final /* synthetic */ void $anonfun$maybeCreatePersistentConnection$1(ClusterLinkOutboundConnectionManager $this, RemoteNetworkClient client) {
        Option<Node> option = client.metadataRefreshThread().remoteLinkCoordinator();
        if (option instanceof Some) {
            Node coordinator = (Node)((Some)option).value();
            $this.maybeCreatePersistentConnection(coordinator);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            $this.debug((Function0<String>)(Function0 & Serializable)() -> "Remote coordinator not known, request metadata");
            $this.requestMetadataUpdate();
            return;
        }
        throw new MatchError(option);
    }

    public static final /* synthetic */ boolean $anonfun$maybeCreatePersistentConnection$3(ReverseChannel x$10) {
        return x$10.socketChannel().isConnected();
    }

    public static final /* synthetic */ int $anonfun$requestMetadataUpdate$1(RemoteNetworkClient x$11) {
        return x$11.metadataRefreshThread().clusterLinkMetadata().requestUpdate();
    }

    public static final /* synthetic */ boolean $anonfun$closePersistentConnections$2(ClusterLinkOutboundConnectionManager $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            ReverseChannel reverseChannel = (ReverseChannel)x0$1._2();
            return $this.closeReverseChannel(reverseChannel);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$closePersistentConnections$3(ClusterLinkOutboundConnectionManager $this, Tuple2 x0$2) {
        if (x0$2 != null) {
            ReverseChannel reverseChannel = (ReverseChannel)x0$2._2();
            $this.onConnectionClose(reverseChannel.channel(), reverseChannel.reverseNode().requestId(), reverseChannel.reverseNode().remoteBrokerId(), false);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$closeActiveReverseConnections$2(ClusterLinkOutboundConnectionManager $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            ReverseChannel reverseChannel = (ReverseChannel)x0$1._2();
            return $this.closeReverseChannel(reverseChannel);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$closeActiveReverseConnections$3(ClusterLinkOutboundConnectionManager $this, Tuple2 x0$2) {
        if (x0$2 != null) {
            ReverseChannel reverseChannel = (ReverseChannel)x0$2._2();
            $this.onConnectionClose(reverseChannel.channel(), reverseChannel.reverseNode().requestId(), reverseChannel.reverseNode().remoteBrokerId(), false);
            return;
        }
        throw new MatchError(null);
    }

    public ClusterLinkOutboundConnectionManager(ClusterLinkData linkData, ClusterLinkConfig initialConfig, String localLogicalCluster, Option<ClientInterceptor> clientInterceptor, ClusterLinkMetrics metrics, ClusterLinkMetadataManager metadataManager, SocketServer socketServer, KafkaConfig brokerConfig, AuthorizerServerInfo serverInfo, ClusterLinkRequestQuota quota, Time time, boolean enableReverseConnections) {
        this.initialConfig = initialConfig;
        this.clientInterceptor = clientInterceptor;
        this.metrics = metrics;
        this.metadataManager = metadataManager;
        this.socketServer = socketServer;
        this.brokerConfig = brokerConfig;
        this.serverInfo = serverInfo;
        this.quota = quota;
        this.time = time;
        this.enableReverseConnections = enableReverseConnections;
        super(linkData, initialConfig, localLogicalCluster, metadataManager, metrics, brokerConfig);
        this.connectionUpdateLock = new Object();
        this.persistentConnections = new ConcurrentHashMap();
        this.activeReverseConnections = new ConcurrentHashMap();
        this.remoteNetworkClient = None$.MODULE$;
        this.logIdent_$eq(new StringBuilder(48).append("[ClusterLinkOutboundConnectionManager-").append(super.linkData().linkName()).append("-broker-").append(brokerConfig.brokerId()).append("] ").toString());
        if (enableReverseConnections) {
            this.updateLinkListener(initialConfig);
        }
    }
}

