/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Optional;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkRepairMirrorsTaskType$;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTask$;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ExcessiveLoggingHandler;
import kafka.server.link.InternalTaskErrorCode$;
import kafka.server.link.TaskDescription;
import kafka.server.link.TaskErrorCodeAndMsg;
import kafka.server.link.TopicLinkPendingRepairMirror$;
import kafka.server.link.TopicLinkState;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.AlterMirrorsOptions;
import org.apache.kafka.clients.admin.AlterMirrorsResult;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.PartitionResult;
import org.apache.kafka.clients.admin.ReplicaStatusOptions;
import org.apache.kafka.clients.admin.ReplicaStatusResult;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.utils.Time;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Set;
import scala.collection.SetOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Iterable;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0005\t\u0005f\u0001B\u0016-\u0001MB\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!\u0010\u0005\n\u0007\u0002\u0011\t\u0011)A\u0005\t\u001eC\u0001\u0002\u0013\u0001\u0003\u0002\u0003\u0006I!\u0013\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\u001b\"I\u0001\r\u0001B\u0001B\u0003%\u0011-\u001b\u0005\nU\u0002\u0011\t\u0011)A\u0005W>D\u0001\u0002\u001d\u0001\u0003\u0002\u0003\u0006I!\u001d\u0005\ti\u0002\u0011\t\u0011)A\u0005k\"I\u0001\u0010\u0001B\u0001B\u0003%Q/\u001f\u0005\u0006w\u0002!\t\u0001 \u0005\n\u0003\u001f\u0001!\u0019!C\u0005\u0003#A\u0001\"a\u0012\u0001A\u0003%\u00111\u0003\u0005\n\u0003\u0013\u0002\u0001\u0019!C\u0005\u0003\u0017B\u0011\"a\u0018\u0001\u0001\u0004%I!!\u0019\t\u0011\u00055\u0004\u0001)Q\u0005\u0003\u001bB\u0011\"a\u001c\u0001\u0005\u0004%I!!\u001d\t\u0011\u0005e\u0004\u0001)A\u0005\u0003gB\u0011\"a\u001f\u0001\u0005\u0004%I!! \t\u0011\u0005\u0015\u0005\u0001)A\u0005\u0003\u007fB\u0011\"a\"\u0001\u0005\u0004%I!!#\t\u0011\u0005m\u0005\u0001)A\u0005\u0003\u0017C\u0011\"!(\u0001\u0001\u0004%I!a(\t\u0013\u00055\u0006\u00011A\u0005\n\u0005=\u0006\u0002CAZ\u0001\u0001\u0006K!!)\t\u0011\u0005u\u0006\u0001\"\u0015-\u0003\u007fC\u0001\"!6\u0001\t\u0003a\u0013q\u001b\u0005\t\u0003S\u0004A\u0011\u0001\u0017\u0002l\"A\u0011Q\u001e\u0001\u0005\u00021\ny\u000fC\u0004\u0002|\u0002!I!!@\t\u000f\t5\u0001\u0001\"\u0003\u0003\u0010!9!q\u0005\u0001\u0005\n\t%\u0002b\u0002B\u001c\u0001\u0011%!\u0011\b\u0005\b\u0005\u0017\u0002A\u0011\u0002B'\u0011\u001d\u0011I\u0006\u0001C\u0005\u00057B\u0001Ba\u0018\u0001\t\u0003a#\u0011\r\u0005\b\u0005O\u0002A\u0011\u000bB5\u0011\u001d\u0011)\b\u0001C\u0001\u0005o:\u0011B!\u001f-\u0003\u0003E\tAa\u001f\u0007\u0011-b\u0013\u0011!E\u0001\u0005{Baa_\u0014\u0005\u0002\t\u0015\u0005\"\u0003BDOE\u0005I\u0011\u0001BE\u0011%\u0011yjJI\u0001\n\u0003\u0011II\u0001\rDYV\u001cH/\u001a:MS:\\'+\u001a9bSJl\u0015N\u001d:peNT!!\f\u0018\u0002\t1Lgn\u001b\u0006\u0003_A\naa]3sm\u0016\u0014(\"A\u0019\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u000e\t\u0003ker!AN\u001c\u000e\u00031J!\u0001\u000f\u0017\u0002)\rcWo\u001d;fe2Kgn[*dQ\u0016$W\u000f\\3s\u0013\tQ4H\u0001\u0007QKJLw\u000eZ5d)\u0006\u001c8N\u0003\u00029Y\u0005AA.\u001b8l\t\u0006$\u0018\r\u0005\u0002?\u00036\tqH\u0003\u0002Aa\u0005\u0011!p[\u0005\u0003\u0005~\u0012qb\u00117vgR,'\u000fT5oW\u0012\u000bG/Y\u0001\ng\u000eDW\rZ;mKJ\u0004\"AN#\n\u0005\u0019c#\u0001F\"mkN$XM\u001d'j].\u001c6\r[3ek2,'/\u0003\u0002Ds\u0005yQ.\u001a;bI\u0006$\u0018-T1oC\u001e,'\u000f\u0005\u00027\u0015&\u00111\n\f\u0002\u001b\u00072,8\u000f^3s\u0019&t7.T3uC\u0012\fG/Y'b]\u0006<WM]\u0001\u0012Y>\u001c\u0017\r\\!e[&tg)Y2u_JL\bc\u0001(R'6\tqJC\u0001Q\u0003\u0015\u00198-\u00197b\u0013\t\u0011vJA\u0005Gk:\u001cG/[8oaA\u0011AKX\u0007\u0002+*\u0011akV\u0001\u0006C\u0012l\u0017N\u001c\u0006\u00031f\u000bqa\u00197jK:$8O\u0003\u000225*\u00111\fX\u0001\u0007CB\f7\r[3\u000b\u0003u\u000b1a\u001c:h\u0013\tyVK\u0001\bD_:4G.^3oi\u0006#W.\u001b8\u0002\tQLW.\u001a\t\u0003E\u001el\u0011a\u0019\u0006\u0003I\u0016\fQ!\u001e;jYNT!AZ-\u0002\r\r|W.\\8o\u0013\tA7M\u0001\u0003US6,\u0017B\u00011:\u0003\u0015\tXo\u001c;b!\taW.D\u0001/\u0013\tqgFA\fDYV\u001cH/\u001a:MS:\\'+Z9vKN$\u0018+^8uC&\u0011!.O\u0001\b[\u0016$(/[2t!\t1$/\u0003\u0002tY\t\u00112\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0016$(/[2t\u0003I\u0001\u0018M\u001d;ji&|gNQ1uG\"\u001c\u0016N_3\u0011\u000593\u0018BA<P\u0005\rIe\u000e^\u0001\u000bS:$XM\u001d<bY6\u001b\u0018B\u0001>:\u0003E\u0011Xm]2iK\u0012,H.\u001a#fY\u0006LXj]\u0001\u0007y%t\u0017\u000e\u001e \u0015#utx0!\u0001\u0002\u0004\u0005\u0015\u0011qAA\u0005\u0003\u0017\ti\u0001\u0005\u00027\u0001!)AH\u0003a\u0001{!)1I\u0003a\u0001\t\")\u0001J\u0003a\u0001\u0013\")AJ\u0003a\u0001\u001b\")\u0001M\u0003a\u0001C\")!N\u0003a\u0001W\")\u0001O\u0003a\u0001c\"9AO\u0003I\u0001\u0002\u0004)\bb\u0002=\u000b!\u0003\u0005\r!^\u0001\u0012a\u0006\u0014H/\u001b;j_:\u001c()\u001f+pa&\u001cWCAA\n!!\t)\"a\b\u0002$\u0005eRBAA\f\u0015\u0011\tI\"a\u0007\u0002\u000f5,H/\u00192mK*\u0019\u0011QD(\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\"\u0005]!aA'baB!\u0011QEA\u001a\u001d\u0011\t9#a\f\u0011\u0007\u0005%r*\u0004\u0002\u0002,)\u0019\u0011Q\u0006\u001a\u0002\rq\u0012xn\u001c;?\u0013\r\t\tdT\u0001\u0007!J,G-\u001a4\n\t\u0005U\u0012q\u0007\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005Er\n\u0005\u0004\u0002\u0016\u0005m\u0012qH\u0005\u0005\u0003{\t9BA\u0002TKR\u0004B!!\u0011\u0002D5\tQ-C\u0002\u0002F\u0015\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0001\nqCJ$\u0018\u000e^5p]N\u0014\u0015\u0010V8qS\u000e\u0004\u0013aH2veJ,g\u000e^%uKJ\fG/[8o%\u0016l\u0017-\u001b8j]\u001e$v\u000e]5dgV\u0011\u0011Q\n\t\u0007\u0003\u001f\nI&a\t\u000f\t\u0005E\u0013Q\u000b\b\u0005\u0003S\t\u0019&C\u0001Q\u0013\r\t9fT\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tY&!\u0018\u0003\u0007M+\u0017OC\u0002\u0002X=\u000b1eY;se\u0016tG/\u0013;fe\u0006$\u0018n\u001c8SK6\f\u0017N\\5oOR{\u0007/[2t?\u0012*\u0017\u000f\u0006\u0003\u0002d\u0005%\u0004c\u0001(\u0002f%\u0019\u0011qM(\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003Wr\u0011\u0011!a\u0001\u0003\u001b\n1\u0001\u001f\u00132\u0003\u0001\u001aWO\u001d:f]RLE/\u001a:bi&|gNU3nC&t\u0017N\\4U_BL7m\u001d\u0011\u0002#I,\u0007\u000f\\5dCN#\u0018\r^;t\u001fB$8/\u0006\u0002\u0002tA\u0019A+!\u001e\n\u0007\u0005]TK\u0001\u000bSKBd\u0017nY1Ti\u0006$Xo](qi&|gn]\u0001\u0013e\u0016\u0004H.[2b'R\fG/^:PaR\u001c\b%\u0001\tbYR,'/T5se>\u00148o\u00149ugV\u0011\u0011q\u0010\t\u0004)\u0006\u0005\u0015bAAB+\n\u0019\u0012\t\u001c;fe6K'O]8sg>\u0003H/[8og\u0006\t\u0012\r\u001c;fe6K'O]8sg>\u0003Ho\u001d\u0011\u0002\t1|7m[\u000b\u0003\u0003\u0017\u0003B!!$\u0002\u00186\u0011\u0011q\u0012\u0006\u0005\u0003#\u000b\u0019*\u0001\u0003mC:<'BAAK\u0003\u0011Q\u0017M^1\n\t\u0005e\u0015q\u0012\u0002\u0007\u001f\nTWm\u0019;\u0002\u000b1|7m\u001b\u0011\u0002\u0011Q\f7o\u001b#fg\u000e,\"!!)\u0011\u000b9\u000b\u0019+a*\n\u0007\u0005\u0015vJ\u0001\u0004PaRLwN\u001c\t\u0004m\u0005%\u0016bAAVY\tyA+Y:l\t\u0016\u001c8M]5qi&|g.\u0001\u0007uCN\\G)Z:d?\u0012*\u0017\u000f\u0006\u0003\u0002d\u0005E\u0006\"CA6/\u0005\u0005\t\u0019AAQ\u0003%!\u0018m]6EKN\u001c\u0007\u0005K\u0002\u0019\u0003o\u00032ATA]\u0013\r\tYl\u0014\u0002\tm>d\u0017\r^5mK\u0006\u0019!/\u001e8\u0015\u0005\u0005\u0005\u0007\u0003BAb\u0003#t1!!28\u001d\u0011\t9-a4\u000f\t\u0005%\u0017Q\u001a\b\u0005\u0003S\tY-C\u00012\u0013\ty\u0003'\u0003\u0002.]%\u0019\u00111[\u001e\u0003\u0015Q\u000b7o\u001b*fgVdG/\u0001\rqe>\u001cWm]:NSJ\u0014xN]*uCR,7\t[1oO\u0016$b!a\u0019\u0002Z\u0006u\u0007bBAn5\u0001\u0007\u00111E\u0001\u0006i>\u0004\u0018n\u0019\u0005\b\u0003?T\u0002\u0019AAq\u0003\u0015\u0019H/\u0019;f!\u0015q\u00151UAr!\r1\u0014Q]\u0005\u0004\u0003Od#!F\"mkN$XM\u001d'j].$v\u000e]5d'R\fG/Z\u0001\u001aaJ|7-Z:t\u001b&\u0014(o\u001c:Ti\u0006$Xm\u00115b]\u001e,7\u000f\u0006\u0002\u0002d\u0005\u0011b.\u001a=u!\u0006\u0014H/\u001b;j_:\u0014\u0015\r^2i)\t\t\t\u0010\u0005\u0004\u0002t\u0006e\u0018qH\u0007\u0003\u0003kTA!a>\u0002\u0014\u0006!Q\u000f^5m\u0013\u0011\ti$!>\u0002#A\u0014xnY3tgB\u000b'\u000f^5uS>t7\u000f\u0006\u0004\u0002B\u0006}(\u0011\u0002\u0005\b\u0005\u0003i\u0002\u0019\u0001B\u0002\u0003-!\u0018m]6D_:$X\r\u001f;\u0011\t\u0005\r'QA\u0005\u0004\u0005\u000fY$a\u0003+bg.\u001cuN\u001c;fqRDqAa\u0003\u001e\u0001\u0004\t\t0\u0001\u0006qCJ$\u0018\u000e^5p]N\f\u0011\u0004[1oI2,'+\u001a9mS\u000e\f7\u000b^1ukN\u0014Vm];miR1\u0011\u0011\u0019B\t\u0005'AqA!\u0001\u001f\u0001\u0004\u0011\u0019\u0001C\u0004\u0003\u0016y\u0001\rAa\u0006\u0002!A\f'\u000f^5uS>t'+Z:vYR\u001c\b\u0003CAz\u00053\tyDa\u0007\n\t\u0005\u0005\u0012Q\u001f\t\u0007\u0003\u0003\u0012iB!\t\n\u0007\t}QMA\u0006LC\u001a\\\u0017MR;ukJ,\u0007c\u0001+\u0003$%\u0019!QE+\u0003\u001fA\u000b'\u000f^5uS>t'+Z:vYR\fa\u0003\u001d:pG\u0016\u001c8oQ8na2,G/\u001a3U_BL7m\u001d\u000b\u0007\u0003\u0003\u0014YC!\f\t\u000f\t\u0005q\u00041\u0001\u0003\u0004!9!qF\u0010A\u0002\tE\u0012aD2p[BdW\r^3e)>\u0004\u0018nY:\u0011\r\tM\"QGA\u0012\u001b\t\tY\"\u0003\u0003\u0002>\u0005m\u0011\u0001\u00075b]\u0012dW-\u00117uKJl\u0015N\u001d:peN\u0014Vm];miR1\u0011\u0011\u0019B\u001e\u0005{AqA!\u0001!\u0001\u0004\u0011\u0019\u0001C\u0004\u0003@\u0001\u0002\rA!\u0011\u0002\u0019Q|\u0007/[2SKN,H\u000e^:\u0011\u0011\u0005M(\u0011DA\u0012\u0005\u0007\u0002b!!\u0011\u0003\u001e\t\u0015\u0003\u0003BAG\u0005\u000fJAA!\u0013\u0002\u0010\n!ak\\5e\u0003UI7\u000fU3oI&twMU3qC&\u0014X*\u001b:s_J$BAa\u0014\u0003VA\u0019aJ!\u0015\n\u0007\tMsJA\u0004C_>dW-\u00198\t\u000f\t]\u0013\u00051\u0001\u0002d\u0006YQ.\u001b:s_J\u001cF/\u0019;f\u0003-\u0011X-\\8wKR{\u0007/[2\u0015\t\t=#Q\f\u0005\b\u00037\u0014\u0003\u0019AA\u0012\u0003AIgnY8na2,G/\u001a+pa&\u001c7/\u0006\u0002\u0003dA1\u0011Q\u0005B3\u0003GIA!!\u0010\u00028\u0005aqN\\\"p[BdW\r^5p]R!\u00111\rB6\u0011\u001d\u0011i\u0007\na\u0001\u0005_\naA]3tk2$\bcA\u001b\u0003r%\u0019!1O\u001e\u0003'\r{W\u000e\u001d7fi\u0016$G+Y:l%\u0016\u001cX\u000f\u001c;\u0002\u001fQ\f7o\u001b#fg\u000e\u0014\u0018\u000e\u001d;j_:$\"!!)\u00021\rcWo\u001d;fe2Kgn\u001b*fa\u0006L'/T5se>\u00148\u000f\u0005\u00027OM\u0019qEa \u0011\u00079\u0013\t)C\u0002\u0003\u0004>\u0013a!\u00118z%\u00164GC\u0001B>\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%qU\u0011!1\u0012\u0016\u0004k\n55F\u0001BH!\u0011\u0011\tJa'\u000e\u0005\tM%\u0002\u0002BK\u0005/\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\teu*\u0001\u0006b]:|G/\u0019;j_:LAA!(\u0003\u0014\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u0013:\u0001")
public class ClusterLinkRepairMirrors
extends ClusterLinkScheduler.PeriodicTask {
    private final ClusterLinkData linkData;
    private final ClusterLinkMetadataManager metadataManager;
    private final Function0<ConfluentAdmin> localAdminFactory;
    private final ClusterLinkMetrics metrics;
    private final int partitionBatchSize;
    private final scala.collection.mutable.Map<String, scala.collection.mutable.Set<TopicPartition>> partitionsByTopic;
    private Seq<String> currentIterationRemainingTopics;
    private final ReplicaStatusOptions replicaStatusOpts;
    private final AlterMirrorsOptions alterMirrorsOpts;
    private final Object lock;
    private volatile Option<TaskDescription> taskDesc;

    public static int $lessinit$greater$default$9() {
        return 1000;
    }

    public static int $lessinit$greater$default$8() {
        return 1000;
    }

    private scala.collection.mutable.Map<String, scala.collection.mutable.Set<TopicPartition>> partitionsByTopic() {
        return this.partitionsByTopic;
    }

    private Seq<String> currentIterationRemainingTopics() {
        return this.currentIterationRemainingTopics;
    }

    private void currentIterationRemainingTopics_$eq(Seq<String> x$1) {
        this.currentIterationRemainingTopics = x$1;
    }

    private ReplicaStatusOptions replicaStatusOpts() {
        return this.replicaStatusOpts;
    }

    private AlterMirrorsOptions alterMirrorsOpts() {
        return this.alterMirrorsOpts;
    }

    private Object lock() {
        return this.lock;
    }

    private Option<TaskDescription> taskDesc() {
        return this.taskDesc;
    }

    private void taskDesc_$eq(Option<TaskDescription> x$1) {
        this.taskDesc = x$1;
    }

    @Override
    public ClusterLinkScheduler.TaskResult run() {
        if (!this.metadataManager.isLinkCoordinator(this.linkData.linkName())) {
            Seq completedTask_errs = (Seq)package$.MODULE$.Seq().empty();
            return new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
        }
        Set completedTopics = ((MapOps)this.partitionsByTopic().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkRepairMirrors.$anonfun$run$1(x$1)))).keySet();
        ClusterLinkScheduler.TaskContext taskContext = new ClusterLinkScheduler.TaskContext((Seq<TaskErrorCodeAndMsg>)((Seq)package$.MODULE$.Seq().empty()));
        if (completedTopics.nonEmpty()) {
            return this.processCompletedTopics(taskContext, (Set<String>)completedTopics);
        }
        java.util.Set<TopicPartition> partitions = this.nextPartitionBatch();
        if (!partitions.isEmpty()) {
            return this.processPartitions(taskContext, partitions);
        }
        Seq completedTask_errs = (Seq)package$.MODULE$.Seq().empty();
        return new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
    }

    public void processMirrorStateChange(String topic, Option<ClusterLinkTopicState> state) {
        Object object = this.lock();
        synchronized (object) {
            ClusterLinkTopicState topicState;
            if (state instanceof Some && this.isPendingRepairMirror(topicState = (ClusterLinkTopicState)((Some)state).value())) {
                scala.collection.immutable.Set<TopicPartition> partitions;
                if (!this.partitionsByTopic().contains((Object)topic) && (partitions = this.metadataManager.topicPartitions(topic)).nonEmpty()) {
                    this.partitionsByTopic().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)((SetOps)Set$.MODULE$.apply((Seq)Nil$.MODULE$)).$plus$plus(partitions)));
                }
            } else if (this.removeTopic(topic)) {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(67).append("Removing topic ").append(topic).append(" with state ").append(state).append(" since topic is no longer pending repair").toString());
            }
            return;
        }
    }

    public void processMirrorStateChanges() {
        Object object = this.lock();
        synchronized (object) {
            this.metadataManager.mirrorTopicStatesFromMetadataCache(this.linkData.linkId()).foreach((Function1 & Serializable)x0$1 -> {
                ClusterLinkRepairMirrors.$anonfun$processMirrorStateChanges$1(this, x0$1);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public java.util.Set<TopicPartition> nextPartitionBatch() {
        Object object = this.lock();
        synchronized (object) {
            void var2_2;
            int topicIndex;
            HashSet partitions = new HashSet();
            scala.collection.immutable.Set mirrorTopics = this.partitionsByTopic().keySet().toSet();
            Set pendingRepairMirrors = ((MapOps)this.metadataManager.mirrorTopicStatesFromMetadataCache((scala.collection.immutable.Set<String>)mirrorTopics).filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkRepairMirrors.$anonfun$nextPartitionBatch$1(this, x0$1)))).keySet();
            mirrorTopics.diff(pendingRepairMirrors).foreach((Function1 & Serializable)topic -> BoxesRunTime.boxToBoolean((boolean)this.removeTopic(topic)));
            this.currentIterationRemainingTopics_$eq((Seq<String>)((Seq)this.currentIterationRemainingTopics().filter((Function1 & Serializable)key -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkRepairMirrors.$anonfun$nextPartitionBatch$3(this, key)))));
            if (this.currentIterationRemainingTopics().isEmpty() && this.partitionsByTopic().nonEmpty()) {
                this.currentIterationRemainingTopics_$eq((Seq<String>)this.partitionsByTopic().keys().toSeq());
            }
            for (topicIndex = 0; partitions.size() < this.partitionBatchSize && topicIndex < this.currentIterationRemainingTopics().size(); ++topicIndex) {
                String topic2 = (String)this.currentIterationRemainingTopics().apply(topicIndex);
                ((IterableOnceOps)this.partitionsByTopic().apply((Object)topic2)).foreach((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)partitions.add(x$1)));
            }
            if (topicIndex > 0) {
                this.currentIterationRemainingTopics_$eq((Seq<String>)((Seq)this.currentIterationRemainingTopics().drop(topicIndex)));
            }
            return var2_2;
        }
    }

    private ClusterLinkScheduler.TaskResult processPartitions(ClusterLinkScheduler.TaskContext taskContext, java.util.Set<TopicPartition> partitions) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(37).append("Processing failed mirror partitions: ").append(partitions).toString());
        try {
            ReplicaStatusResult result = ((ConfluentAdmin)this.localAdminFactory.apply()).replicaStatus(partitions, this.replicaStatusOpts());
            this.scheduleWhenComplete(result.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleReplicaStatusResult((ClusterLinkScheduler.TaskContext)tc, result.partitionResults()), taskContext));
            Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
            return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
        }
        catch (Exception e) {
            String errMsg = new StringBuilder(38).append("Failed to retrieve replica status for ").append(partitions).toString();
            this.warn((Function0<String>)(Function0 & Serializable)() -> errMsg, (Function0<Throwable>)(Function0 & Serializable)() -> e);
            Seq completedTask_errs = (Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg), (List)Nil$.MODULE$));
            return new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
        }
    }

    private ClusterLinkScheduler.TaskResult handleReplicaStatusResult(ClusterLinkScheduler.TaskContext taskContext, java.util.Map<TopicPartition, KafkaFuture<PartitionResult>> partitionResults) {
        ExcessiveLoggingHandler excessiveLoggingHandler = new ExcessiveLoggingHandler(1000);
        IntRef nonRetriableErrors = IntRef.create((int)0);
        scala.collection.mutable.Set completedTopics = (scala.collection.mutable.Set)Set$.MODULE$.empty();
        Iterable errs = (Iterable)CollectionConverters$.MODULE$.MapHasAsScala(partitionResults).asScala().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition tp = (TopicPartition)x0$1._1();
                KafkaFuture future = (KafkaFuture)x0$1._2();
                try {
                    Object object = this.lock();
                    synchronized (object) {
                        Optional<ReplicaStatus> leaderReplica;
                        scala.collection.mutable.Set partitions;
                        Option topicPartitions = this.partitionsByTopic().get((Object)tp.topic());
                        if (topicPartitions instanceof Some && (partitions = (scala.collection.mutable.Set)((Some)topicPartitions).value()).contains((Object)tp) && (leaderReplica = ((PartitionResult)future.get()).replicas().stream().filter(x$2 -> x$2.isLeader()).findAny()).isPresent() && leaderReplica.get().mirrorInfo().filter(x$3 -> {
                            ReplicaStatus.MirrorInfo.State state = x$3.state();
                            ReplicaStatus.MirrorInfo.State state2 = ReplicaStatus.MirrorInfo.State.FAILED;
                            return state == null ? state2 != null : !state.equals(state2);
                        }).isPresent()) {
                            partitions.remove((Object)tp);
                            if (partitions.isEmpty()) {
                                completedTopics.$plus$eq((Object)tp.topic());
                            }
                        }
                    }
                    return None$.MODULE$;
                }
                catch (RetriableException e) {
                    String errMsg = new StringBuilder(43).append("Failed to get replica status for partition ").append(tp).toString();
                    this.debug((Function0<String>)(Function0 & Serializable)() -> errMsg, (Function0<Throwable>)(Function0 & Serializable)() -> e);
                    return new Some((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg));
                }
                catch (Exception e) {
                    String errMsg = new StringBuilder(43).append("Failed to get replica status for partition ").append(tp).toString();
                    excessiveLoggingHandler.handle(e, this, errMsg);
                    ++nonRetriableErrors$1.elem;
                    return new Some((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg));
                }
            }
            throw new MatchError(null);
        });
        if (nonRetriableErrors.elem > 0) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(111).append("Failed to get replica status for ").append(nonRetriableErrors$1.elem).append(" partitions. Did not log the errors for ").append(excessiveLoggingHandler.ignoredWarnLogCount()).append(" of them to prevent excessive logging.").toString());
        }
        ClusterLinkScheduler.TaskContext newTaskContext = new ClusterLinkScheduler.TaskContext((Seq<TaskErrorCodeAndMsg>)((Seq)taskContext.errs().$plus$plus((IterableOnce)errs)));
        if (completedTopics.nonEmpty()) {
            return this.processCompletedTopics(newTaskContext, (Set<String>)completedTopics);
        }
        Seq<TaskErrorCodeAndMsg> completedTask_errs = newTaskContext.errs();
        return new ClusterLinkScheduler.TaskResult(true, completedTask_errs);
    }

    private ClusterLinkScheduler.TaskResult processCompletedTopics(ClusterLinkScheduler.TaskContext taskContext, Set<String> completedTopics) {
        try {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("Resuming failed mirrors after repair: ").append(completedTopics).toString());
            AlterMirrorsResult result = ((ConfluentAdmin)this.localAdminFactory.apply()).alterMirrors(CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)completedTopics.map((Function1 & Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(t), (Object)AlterMirrorOp.COMPLETE_REPAIR))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava(), this.alterMirrorsOpts());
            this.scheduleWhenComplete(result.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleAlterMirrorsResult((ClusterLinkScheduler.TaskContext)tc, result.values()), taskContext));
            Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
            return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
        }
        catch (Exception e) {
            String errMsg = new StringBuilder(50).append("Failed to complete repair of failed mirror topics ").append(completedTopics).toString();
            this.warn((Function0<String>)(Function0 & Serializable)() -> errMsg, (Function0<Throwable>)(Function0 & Serializable)() -> e);
            Seq completedTask_errs = (Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg), (List)Nil$.MODULE$));
            return new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
        }
    }

    private ClusterLinkScheduler.TaskResult handleAlterMirrorsResult(ClusterLinkScheduler.TaskContext taskContext, java.util.Map<String, KafkaFuture<Void>> topicResults) {
        ExcessiveLoggingHandler excessiveLoggingHandler = new ExcessiveLoggingHandler(1000);
        scala.collection.mutable.Set nonRetriableErrorTopics = (scala.collection.mutable.Set)Set$.MODULE$.empty();
        Iterable errs = (Iterable)CollectionConverters$.MODULE$.MapHasAsScala(topicResults).asScala().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String topic = (String)x0$1._1();
                try {
                    ((KafkaFuture)x0$1._2()).get();
                    this.removeTopic(topic);
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("Removed topic ").append(topic).append(" after completing repair").toString());
                    return None$.MODULE$;
                }
                catch (RetriableException e) {
                    String errMsg = new StringBuilder(49).append("Failed to complete repair of failed mirror topic ").append(topic).toString();
                    this.debug((Function0<String>)(Function0 & Serializable)() -> errMsg, (Function0<Throwable>)(Function0 & Serializable)() -> e);
                    return new Some((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg));
                }
                catch (Exception e) {
                    String errMsg = new StringBuilder(49).append("Failed to complete repair of failed mirror topic ").append(topic).toString();
                    excessiveLoggingHandler.handle(e, this, errMsg);
                    nonRetriableErrorTopics.$plus$eq((Object)topic);
                    return new Some((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg));
                }
            }
            throw new MatchError(null);
        });
        if (nonRetriableErrorTopics.nonEmpty()) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(117).append("Failed to complete repair of failed mirror topics ").append(nonRetriableErrorTopics).append(". Did not log the errors for ").append(excessiveLoggingHandler.ignoredWarnLogCount()).append(" of them to prevent excessive logging.").toString());
        }
        Seq completedTask_errs = (Seq)taskContext.errs().$plus$plus((IterableOnce)errs);
        return new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
    }

    private boolean isPendingRepairMirror(ClusterLinkTopicState mirrorState) {
        TopicLinkState topicLinkState = mirrorState.state();
        TopicLinkPendingRepairMirror$ topicLinkPendingRepairMirror$ = TopicLinkPendingRepairMirror$.MODULE$;
        return topicLinkState != null && topicLinkState.equals(topicLinkPendingRepairMirror$);
    }

    private boolean removeTopic(String topic) {
        Object object = this.lock();
        synchronized (object) {
            boolean bl = this.partitionsByTopic().remove((Object)topic).nonEmpty();
            return bl;
        }
    }

    public scala.collection.immutable.Set<String> incompleteTopics() {
        return this.partitionsByTopic().keys().toSet();
    }

    @Override
    public void onCompletion(ClusterLinkScheduler.CompletedTaskResult result) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(27).append("Completed with task result ").append(result).toString());
        if (this.metadataManager.isLinkCoordinator(this.linkData.linkName())) {
            this.taskDesc_$eq(ClusterLinkTask$.MODULE$.handleResult(result, this.metrics, ClusterLinkRepairMirrorsTaskType$.MODULE$, "repair the failed mirror"));
            return;
        }
        this.taskDesc_$eq((Option<TaskDescription>)None$.MODULE$);
    }

    public Option<TaskDescription> taskDescription() {
        return this.taskDesc();
    }

    public static final /* synthetic */ boolean $anonfun$run$1(Tuple2 x$1) {
        return ((IterableOnceOps)x$1._2()).isEmpty();
    }

    public static final /* synthetic */ void $anonfun$processMirrorStateChanges$1(ClusterLinkRepairMirrors $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            String topic = (String)x0$1._1();
            ClusterLinkTopicState state = (ClusterLinkTopicState)x0$1._2();
            $this.processMirrorStateChange(topic, (Option<ClusterLinkTopicState>)new Some((Object)state));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$nextPartitionBatch$1(ClusterLinkRepairMirrors $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            ClusterLinkTopicState state = (ClusterLinkTopicState)x0$1._2();
            return $this.isPendingRepairMirror(state);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$nextPartitionBatch$3(ClusterLinkRepairMirrors $this, String key) {
        return $this.partitionsByTopic().contains((Object)key);
    }

    public ClusterLinkRepairMirrors(ClusterLinkData linkData, ClusterLinkScheduler scheduler, ClusterLinkMetadataManager metadataManager, Function0<ConfluentAdmin> localAdminFactory, Time time, ClusterLinkRequestQuota quota, ClusterLinkMetrics metrics, int partitionBatchSize, int intervalMs) {
        this.linkData = linkData;
        this.metadataManager = metadataManager;
        this.localAdminFactory = localAdminFactory;
        this.metrics = metrics;
        this.partitionBatchSize = partitionBatchSize;
        super(scheduler, "ClusterLinkRepairMirrors", intervalMs, time, quota);
        this.partitionsByTopic = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        this.currentIterationRemainingTopics = (Seq)package$.MODULE$.Seq().empty();
        this.replicaStatusOpts = new ReplicaStatusOptions().includeLinkedReplicas(false);
        this.alterMirrorsOpts = new AlterMirrorsOptions();
        this.lock = new Object();
        this.taskDesc = None$.MODULE$;
    }
}

