/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.state;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import java.util.Objects;

public final class CompactStats {
    private final long bytesRead;
    private final long bytesWritten;
    private final long dirtyBytesRead;
    public static final CompactStats EMPTY = new CompactStats(0L, 0L, 0L);
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();

    @JsonCreator
    public CompactStats(@JsonProperty(value="bytesRead") long bytesRead, @JsonProperty(value="bytesWritten") long bytesWritten, @JsonProperty(value="dirtyBytesRead") long dirtyBytesRead) {
        this.bytesRead = bytesRead;
        this.bytesWritten = bytesWritten;
        this.dirtyBytesRead = dirtyBytesRead;
    }

    public CompactStats(kafka.tier.serdes.CompactStats stats) {
        this(stats.bytesRead(), stats.bytesWritten(), stats.dirtyBytesRead());
    }

    public CompactStats accumulate(CompactStats other) {
        return new CompactStats(this.bytesRead + other.bytesRead(), this.bytesWritten + other.bytesWritten(), this.dirtyBytesRead + other.dirtyBytesRead());
    }

    @JsonProperty(value="bytesRead", required=true)
    public long bytesRead() {
        return this.bytesRead;
    }

    @JsonProperty(value="bytesWritten", required=true)
    public long bytesWritten() {
        return this.bytesWritten;
    }

    @JsonProperty(value="dirtyBytesRead", required=true)
    public long dirtyBytesRead() {
        return this.dirtyBytesRead;
    }

    public double retainRatio() {
        if (this.bytesRead <= 0L) {
            return -1.0;
        }
        return (double)this.bytesWritten / (double)this.bytesRead;
    }

    public double reduceRatio() {
        if (this.dirtyBytesRead <= 0L) {
            return -1.0;
        }
        return (double)(this.bytesRead - this.bytesWritten) / (double)this.dirtyBytesRead;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompactStats that = (CompactStats)o;
        return this.bytesRead == that.bytesRead && this.bytesWritten == that.bytesWritten && this.dirtyBytesRead == that.dirtyBytesRead;
    }

    public int hashCode() {
        return Objects.hash(this.bytesRead, this.bytesWritten, this.dirtyBytesRead);
    }

    public String toString() {
        return "CompactStats(bytesRead=" + this.bytesRead + ", " + "bytesWritten" + "=" + this.bytesWritten + ", " + "dirtyBytesRead" + "=" + this.dirtyBytesRead + ')';
    }

    public String toJson() {
        try {
            return JSON_MAPPER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        JSON_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
        JSON_MAPPER.registerModule((Module)new Jdk8Module());
    }
}

