/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils.cloud;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import kafka.utils.cloud.EpochAndSeqNumber;
import kafka.utils.cloud.SequencedObject;

public class LinkedCloudObject {
    public static List<SequencedObject> getOptimalChain(List<SequencedObject> objects) {
        if (objects.isEmpty()) {
            return new ArrayList<SequencedObject>();
        }
        Collections.sort(objects);
        ArrayList<SequencedObject> filteredList = new ArrayList<SequencedObject>();
        SequencedObject latestObject = objects.get(objects.size() - 1);
        filteredList.add(latestObject);
        EpochAndSeqNumber previous = latestObject.previousEpochAndSeqNumber();
        for (int i = objects.size() - 2; i >= 0; --i) {
            SequencedObject object = objects.get(i);
            if (!object.currentEpochAndSeqNumber().equals(previous)) continue;
            filteredList.add(object);
            previous = object.previousEpochAndSeqNumber();
        }
        Collections.reverse(filteredList);
        return filteredList;
    }

    public static Optional<SequencedObject> latestCommittedObject(List<SequencedObject> objects) {
        Collections.sort(objects);
        return objects.size() > 0 ? Optional.of(objects.get(objects.size() - 1)) : Optional.empty();
    }
}

