/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.command.kafka;

import io.confluent.command.kafka.FilteredKeyValueIterator;
import org.apache.kafka.streams.kstream.Predicate;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.ReadOnlyKeyValueStore;

public class FilteredReadOnlyKeyValueStore<K, V>
implements ReadOnlyKeyValueStore<K, V> {
    private ReadOnlyKeyValueStore<K, V> delegate;
    private Predicate<? super K, ? super V> predicate;

    public FilteredReadOnlyKeyValueStore(ReadOnlyKeyValueStore<K, V> delegate, Predicate<? super K, ? super V> predicate) {
        this.delegate = delegate;
        this.predicate = predicate;
    }

    public V get(K key) {
        Object value = this.delegate.get(key);
        if (this.predicate.test(key, value)) {
            return (V)value;
        }
        return null;
    }

    public KeyValueIterator<K, V> range(K k, K k1) {
        return new FilteredKeyValueIterator<K, V>(this.delegate.range(k, k1), this.predicate);
    }

    public KeyValueIterator<K, V> all() {
        return new FilteredKeyValueIterator<K, V>(this.delegate.all(), this.predicate);
    }

    public long approximateNumEntries() {
        return this.delegate.approximateNumEntries();
    }
}

