/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.cruisecontrol.monitor.sampling.aggregator;

import com.linkedin.cruisecontrol.common.LongGenerationed;
import com.linkedin.cruisecontrol.exception.NotEnoughValidWindowsException;
import com.linkedin.cruisecontrol.metricdef.MetricDef;
import com.linkedin.cruisecontrol.model.Entity;
import com.linkedin.cruisecontrol.monitor.sampling.MetricSample;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.AggregationOptions;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.MetricSampleAggregationResult;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.MetricSampleAggregatorState;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.MetricSampleCompleteness;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.RawMetricValues;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.ValuesAndExtrapolations;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.WindowState;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.SamplingUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricSampleAggregator<E extends Entity>
extends LongGenerationed {
    private static final Logger LOG = LoggerFactory.getLogger(MetricSampleAggregator.class);
    private static final long INITIAL_WINDOW_ID = 0L;
    private final ConcurrentMap<E, RawMetricValues> rawMetrics;
    private final MetricSampleAggregatorState<E> aggregatorState;
    private final ReentrantLock windowRollingLock;
    private final ConcurrentMap<E, E> identityEntityMap = new ConcurrentHashMap<E, E>();
    protected final int numWindows;
    protected final byte minSamplesPerWindow;
    protected final int numWindowsToKeep;
    protected final long windowMs;
    protected final long monitoringPeriodMs;
    protected final MetricDef metricDef;
    protected SampleType sampleType;
    private volatile long currentWindowIndex;
    private volatile long oldestWindowIndex;
    protected volatile long latestInvalidWindowIndex;

    public MetricSampleAggregator(int numWindows, long windowMs, byte minSamplesPerWindow, int completenessCacheSize, MetricDef metricDef) {
        super(0L);
        this.rawMetrics = new ConcurrentHashMap<E, RawMetricValues>();
        this.numWindows = numWindows;
        this.windowMs = windowMs;
        this.monitoringPeriodMs = (long)this.numWindows * this.windowMs;
        this.numWindowsToKeep = this.numWindows + 1;
        this.minSamplesPerWindow = minSamplesPerWindow;
        this.windowRollingLock = new ReentrantLock();
        this.metricDef = metricDef;
        this.aggregatorState = new MetricSampleAggregatorState(numWindows, this.windowMs, completenessCacheSize);
        this.oldestWindowIndex = 0L;
        this.currentWindowIndex = 0L;
        this.latestInvalidWindowIndex = 0L;
    }

    public boolean addSample(MetricSample<E> sample) {
        if (!sample.isValid(this.metricDef)) {
            LOG.debug("The metric sample is discarded due to missing metrics. Sample: {}", sample);
            return false;
        }
        long oldestMetricWindowIndex = this.windowIndex(sample.sampleOpenTime());
        if (oldestMetricWindowIndex < this.oldestWindowIndex || oldestMetricWindowIndex <= this.latestInvalidWindowIndex) {
            LOG.debug("The metric sample is discarded due to holding old or invalid metrics. Oldest window index: {}. Latest invalid window index: {}. Current window index: {}. Oldest metric window index for this sample: {}. Sample: {}.", new Object[]{this.oldestWindowIndex, this.latestInvalidWindowIndex, this.currentWindowIndex, oldestMetricWindowIndex, sample});
            return false;
        }
        long windowIndex = this.windowIndex(sample.sampleCloseTime());
        this.maybeRollOutNewWindow(windowIndex);
        RawMetricValues rawMetricValues = this.rawMetrics.computeIfAbsent(this.identity(sample.entity()), k -> {
            this.windowRollingLock.lock();
            try {
                RawMetricValues rawValues = new RawMetricValues(this.numWindowsToKeep, this.minSamplesPerWindow, this.metricDef.size());
                rawValues.updateOldestWindowIndex(this.oldestWindowIndex);
                RawMetricValues rawMetricValues = rawValues;
                return rawMetricValues;
            }
            finally {
                this.windowRollingLock.unlock();
            }
        });
        LOG.trace("Adding sample {} to window index {}", sample, (Object)windowIndex);
        rawMetricValues.addSample(sample, windowIndex, this.metricDef);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetricSampleAggregationResult<E> aggregate(long from, long to, AggregationOptions<E> options, Set<Integer> failedBrokers) throws NotEnoughValidWindowsException {
        this.windowRollingLock.lock();
        try {
            long fromWindowIndex = Math.max(this.windowIndex(from), this.oldestWindowIndex);
            long toWindowIndex = Math.min(this.windowIndex(to), this.currentWindowIndex - 1L);
            LOG.debug("Aggregating metrics from timestamps {} (index: {}) to {} (index: {}) and indices from {} to {} (currentWindowIndex {})", new Object[]{KafkaCruiseControlUtils.toTimeStringOrNonePlaceholder(from), this.windowIndex(from), KafkaCruiseControlUtils.toTimeStringOrNonePlaceholder(to), this.windowIndex(to), fromWindowIndex, toWindowIndex, this.currentWindowIndex});
            if (fromWindowIndex > this.currentWindowIndex || toWindowIndex < this.oldestWindowIndex) {
                String errMsg = String.format("There is no window available in range [%d, %d] (%s - %s) (currentWindowIndex: %d, oldestWindowIndex: %d)", from, to, KafkaCruiseControlUtils.toTimeStringOrNonePlaceholder(from), KafkaCruiseControlUtils.toTimeStringOrNonePlaceholder(to), this.currentWindowIndex, this.oldestWindowIndex);
                throw new NotEnoughValidWindowsException(errMsg);
            }
            this.maybeUpdateAggregatorState();
            AggregationOptions<E> interpretedOptions = this.interpretAggregationOptions(options);
            MetricSampleCompleteness<E> completeness = this.aggregatorState.completeness(fromWindowIndex, toWindowIndex, interpretedOptions, this.generation(), failedBrokers);
            this.validateCompleteness(from, to, completeness, interpretedOptions);
            List<Long> windows = this.toWindows(completeness.validWindowIndices());
            MetricSampleAggregationResult<Entity> result = new MetricSampleAggregationResult<Entity>(this.generation(), completeness);
            Set<E> entitiesToInclude = interpretedOptions.includeInvalidEntities() ? interpretedOptions.interestedEntities() : completeness.validEntities();
            for (Entity entity : entitiesToInclude) {
                ValuesAndExtrapolations valuesAndExtrapolations;
                RawMetricValues rawValues = (RawMetricValues)this.rawMetrics.get(entity);
                if (rawValues == null) {
                    valuesAndExtrapolations = ValuesAndExtrapolations.empty(completeness.validWindowIndices().size(), this.metricDef);
                    valuesAndExtrapolations.setWindows(windows);
                    result.addResult(entity, valuesAndExtrapolations);
                    result.recordInvalidEntity(entity);
                    continue;
                }
                valuesAndExtrapolations = rawValues.aggregate(completeness.validWindowIndices(), this.metricDef);
                valuesAndExtrapolations.setWindows(windows);
                result.addResult(entity, valuesAndExtrapolations);
                if (rawValues.isValid(options.maxAllowedExtrapolationsPerEntity())) continue;
                result.recordInvalidEntity(entity);
            }
            MetricSampleAggregationResult<Entity> metricSampleAggregationResult = result;
            return metricSampleAggregationResult;
        }
        finally {
            this.windowRollingLock.unlock();
        }
    }

    public MetricSampleAggregationResult<E> aggregate(long from, long to, AggregationOptions<E> options) throws NotEnoughValidWindowsException {
        return this.aggregate(from, to, options, Collections.emptySet());
    }

    public Map<E, ValuesAndExtrapolations> peekCurrentWindow() {
        this.windowRollingLock.lock();
        try {
            HashMap result = new HashMap();
            this.rawMetrics.forEach((entity, rawMetric) -> {
                ValuesAndExtrapolations vae = rawMetric.peekCurrentWindow(this.currentWindowIndex, this.metricDef);
                TreeSet<Long> currentWindows = new TreeSet<Long>(Collections.singleton(this.currentWindowIndex));
                vae.setWindows(this.toWindows(currentWindows));
                result.put(entity, vae);
            });
            HashMap hashMap = result;
            return hashMap;
        }
        finally {
            this.windowRollingLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetricSampleCompleteness<E> completeness(long from, long to, AggregationOptions<E> options, Set<Integer> failedBrokerIds) {
        this.windowRollingLock.lock();
        try {
            long fromWindowIndex = Math.max(this.windowIndex(from), this.oldestWindowIndex);
            long toWindowIndex = Math.min(this.windowIndex(to), this.currentWindowIndex - 1L);
            if (fromWindowIndex > this.currentWindowIndex || toWindowIndex < this.oldestWindowIndex) {
                LOG.debug("Returning an empty metric sample completeness result because the indices don't align (fromWindow: {}, toWindow: {}, currentWindow: {} oldestWindow: {})", new Object[]{fromWindowIndex, toWindowIndex, this.currentWindowIndex, this.oldestWindowIndex});
                MetricSampleCompleteness metricSampleCompleteness = new MetricSampleCompleteness(this.generation(), this.windowMs);
                return metricSampleCompleteness;
            }
            this.maybeUpdateAggregatorState();
            MetricSampleCompleteness<E> metricSampleCompleteness = this.aggregatorState.completeness(fromWindowIndex, toWindowIndex, this.interpretAggregationOptions(options), this.generation(), failedBrokerIds);
            return metricSampleCompleteness;
        }
        finally {
            this.windowRollingLock.unlock();
        }
    }

    public MetricSampleCompleteness<E> completeness(long from, long to, AggregationOptions<E> options) {
        return this.completeness(from, to, options, Collections.emptySet());
    }

    public List<Long> availableWindows() {
        return this.getWindowList(this.oldestWindowIndex, this.currentWindowIndex - 1L);
    }

    public int numAvailableWindows() {
        return this.numAvailableWindows(-1L, Long.MAX_VALUE);
    }

    public int numAvailableWindows(long from, long to) {
        long fromWindowIndex = Math.max(this.windowIndex(from), this.oldestWindowIndex);
        long toWindowIndex = Math.min(this.windowIndex(to), this.currentWindowIndex - 1L);
        return Math.max(0, (int)(toWindowIndex - fromWindowIndex + 1L));
    }

    public List<Long> allWindows() {
        return this.getWindowList(this.oldestWindowIndex, this.currentWindowIndex);
    }

    Long earliestWindowTimestamp() {
        return this.rawMetrics.isEmpty() ? null : Long.valueOf(this.oldestWindowIndex * this.windowMs);
    }

    Long latestWindowTimestamp() {
        return this.rawMetrics.isEmpty() ? null : Long.valueOf(this.currentWindowIndex * this.windowMs);
    }

    public boolean maybeInvalidateWindowsBeforeTime(long from) {
        long indexToInvalidate = this.windowIndex(from);
        return this.maybeInvalidateWindowsBefore(indexToInvalidate);
    }

    public int numSamples() {
        return this.rawMetrics.values().stream().mapToInt(RawMetricValues::numSamples).sum();
    }

    public void retainEntityGroup(Set<String> entityGroups) {
        boolean anyElementsRemoved = this.rawMetrics.entrySet().removeIf(entry -> !entityGroups.contains(((Entity)entry.getKey()).group()));
        if (anyElementsRemoved) {
            this.generation.incrementAndGet();
        }
    }

    MetricSampleAggregatorState<E> aggregatorState() {
        this.maybeUpdateAggregatorState();
        return this.aggregatorState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Long> getWindowList(long fromWindowIndex, long toWindowIndex) {
        this.windowRollingLock.lock();
        try {
            if (this.rawMetrics.isEmpty()) {
                List<Long> list = Collections.emptyList();
                return list;
            }
            ArrayList<Long> windows = new ArrayList<Long>((int)(toWindowIndex - fromWindowIndex + 1L));
            for (long i = fromWindowIndex; i <= toWindowIndex; ++i) {
                windows.add(i * this.windowMs);
            }
            ArrayList<Long> arrayList = windows;
            return arrayList;
        }
        finally {
            this.windowRollingLock.unlock();
        }
    }

    private void maybeUpdateAggregatorState() {
        long currentGeneration = this.generation();
        for (long windowIndex : this.aggregatorState.windowIndicesToUpdate(this.oldestWindowIndex, this.currentWindowIndex)) {
            this.aggregatorState.updateWindowState(windowIndex, this.getWindowState(windowIndex, currentGeneration));
        }
    }

    private WindowState<E> getWindowState(long windowIndex, long currentGeneration) {
        WindowState<Entity> windowState = new WindowState<Entity>(currentGeneration);
        for (Map.Entry entry : this.rawMetrics.entrySet()) {
            Entity entity = (Entity)entry.getKey();
            RawMetricValues rawValues = (RawMetricValues)entry.getValue();
            rawValues.sanityCheckWindowIndex(windowIndex);
            if (rawValues.isExtrapolatedAtWindowIndex(windowIndex)) {
                windowState.addExtrapolatedEntities(entity);
            }
            if (!rawValues.isValidAtWindowIndex(windowIndex)) continue;
            windowState.addValidEntities(entity);
        }
        return windowState;
    }

    public synchronized boolean onSamplingFinish(long endMs) {
        long currentWindow = this.windowIndex(endMs);
        return this.maybeRollOutNewWindow(currentWindow + 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean maybeRollOutNewWindow(long windowIndex) {
        if (this.currentWindowIndex < windowIndex) {
            this.windowRollingLock.lock();
            try {
                if (this.currentWindowIndex < windowIndex) {
                    int numWindowsToRollOut = this.currentWindowIndex == 0L ? 1 : (int)(windowIndex - this.currentWindowIndex);
                    long prevOldestWindowIndex = this.oldestWindowIndex;
                    this.oldestWindowIndex = Math.max(1L, Math.max(this.latestInvalidWindowIndex, windowIndex - (long)this.numWindows));
                    int numOldWindowIndicesToReset = (int)Math.min((long)this.numWindowsToKeep, this.oldestWindowIndex - prevOldestWindowIndex);
                    int numAbandonedSamples = 0;
                    if (numOldWindowIndicesToReset > 0) {
                        numAbandonedSamples = this.resetIndices(prevOldestWindowIndex, numOldWindowIndicesToReset);
                    }
                    long oldGeneration = this.generation();
                    this.aggregatorState.updateWindowGeneration(this.currentWindowIndex, oldGeneration);
                    this.currentWindowIndex = windowIndex;
                    long newGeneration = this.generation.incrementAndGet();
                    this.aggregatorState.updateWindowGeneration(windowIndex, newGeneration);
                    LOG.info("{} Aggregator rolled out {}, reset {} windows and bumped generation from {}->{}, current window range [{}, {}, {} to {}], abandon {} samples.", new Object[]{this.sampleType, numWindowsToRollOut == 1 ? "a new window" : String.format("%d new windows", numWindowsToRollOut), oldGeneration, newGeneration, numOldWindowIndicesToReset, this.oldestWindowIndex * this.windowMs, this.currentWindowIndex * this.windowMs, KafkaCruiseControlUtils.toTimeStringOrNonePlaceholder(this.oldestWindowIndex * this.windowMs), KafkaCruiseControlUtils.toTimeStringOrNonePlaceholder(this.currentWindowIndex * this.windowMs), numAbandonedSamples});
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.windowRollingLock.unlock();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean maybeInvalidateWindowsBefore(long invalidWindowIndex) {
        LOG.info("Invalidating metric windows up to window ID {} (current window ID {}, oldest window ID {})", new Object[]{invalidWindowIndex, this.currentWindowIndex, this.oldestWindowIndex});
        this.windowRollingLock.lock();
        try {
            if (invalidWindowIndex <= this.latestInvalidWindowIndex) {
                LOG.info("Trying to invalidate a window ID {} that has already been invalidated because latest invalidated window ID is {}", (Object)invalidWindowIndex, (Object)this.latestInvalidWindowIndex);
                boolean bl = false;
                return bl;
            }
            this.latestInvalidWindowIndex = invalidWindowIndex;
            if (this.oldestWindowIndex <= invalidWindowIndex) {
                if (this.currentWindowIndex <= invalidWindowIndex) {
                    this.currentWindowIndex = 0L;
                    this.oldestWindowIndex = 0L;
                    LOG.info("All metric windows invalidated.");
                } else {
                    this.oldestWindowIndex = invalidWindowIndex + 1L;
                    LOG.info("Some windows invalidated -- now at current window ID {}, oldest window ID {}", (Object)this.currentWindowIndex, (Object)this.oldestWindowIndex);
                }
                boolean bl = true;
                return bl;
            }
            LOG.info("No metric windows currently invalidated -- no windows at validation index {} (current window ID {}, oldest window ID {})", new Object[]{invalidWindowIndex, this.currentWindowIndex, this.oldestWindowIndex});
            boolean bl = false;
            return bl;
        }
        finally {
            this.windowRollingLock.unlock();
        }
    }

    private int resetRawValueIndices(long prevOldestWindowIndex, int numIndicesToReset, long currentOldestWindowIndex) {
        RawMetricValues rawValues;
        int numAbandonedSamples = 0;
        Iterator iterator = this.rawMetrics.values().iterator();
        if (iterator.hasNext()) {
            rawValues = (RawMetricValues)iterator.next();
            rawValues.updateOldestWindowIndex(currentOldestWindowIndex);
            rawValues.sanityCheckWindowRangeReset(prevOldestWindowIndex, numIndicesToReset);
            numAbandonedSamples += rawValues.resetWindowIndices(prevOldestWindowIndex, numIndicesToReset);
        }
        while (iterator.hasNext()) {
            rawValues = (RawMetricValues)iterator.next();
            rawValues.updateOldestWindowIndex(currentOldestWindowIndex);
            numAbandonedSamples += rawValues.resetWindowIndices(prevOldestWindowIndex, numIndicesToReset);
        }
        return numAbandonedSamples;
    }

    private int resetIndices(long prevOldestWindowIndex, int numIndicesToReset) {
        long currentOldestWindowIndex = this.oldestWindowIndex;
        int numAbandonedSamples = this.resetRawValueIndices(prevOldestWindowIndex, numIndicesToReset, currentOldestWindowIndex);
        this.aggregatorState.updateOldestWindowIndex(currentOldestWindowIndex);
        this.aggregatorState.resetWindowIndices(prevOldestWindowIndex, numIndicesToReset);
        return numAbandonedSamples;
    }

    private void validateCompleteness(long from, long to, MetricSampleCompleteness completeness, AggregationOptions<E> options) throws NotEnoughValidWindowsException {
        if (completeness.validWindowIndices().size() < options.minValidWindows()) {
            throw new NotEnoughValidWindowsException(String.format("There are only %d valid windows when aggregating in range [%d, %d] for aggregation options %s", completeness.validWindowIndices().size(), from, to, options));
        }
        if ((double)completeness.validEntityRatio() < options.minValidEntityRatio()) {
            throw new IllegalStateException(String.format("The entity coverage %.3f in range [%d, %d] for option %s does not meet requirement.", Float.valueOf(completeness.validEntityRatio()), from, to, options));
        }
        if ((double)completeness.validEntityGroupRatio() < options.minValidEntityGroupRatio()) {
            throw new IllegalStateException(String.format("The entity group coverage %.3f in range [%d, %d] for option %s does not meet requirement.", Float.valueOf(completeness.validEntityGroupRatio()), from, to, options));
        }
    }

    private List<Long> toWindows(SortedSet<Long> windowIndices) {
        ArrayList<Long> windows = new ArrayList<Long>(windowIndices.size());
        windowIndices.forEach(i -> windows.add(i * this.windowMs));
        return windows;
    }

    private long windowIndex(long time) {
        return SamplingUtils.windowIndex(time, this.windowMs);
    }

    private AggregationOptions<E> interpretAggregationOptions(AggregationOptions<E> options) {
        HashSet<Object> entitiesToInclude = new HashSet<Object>();
        if (options.interestedEntities().isEmpty()) {
            entitiesToInclude.addAll(this.rawMetrics.keySet());
        } else {
            for (Entity entity : options.interestedEntities()) {
                entitiesToInclude.add(this.identity(entity));
            }
        }
        return new AggregationOptions(options.minValidEntityRatio(), options.minValidEntityGroupRatio(), options.minValidWindows(), options.maxAllowedExtrapolationsPerEntity(), entitiesToInclude, options.granularity(), options.includeInvalidEntities());
    }

    protected E identity(E entity) {
        if (this.numWindows <= 1) {
            return entity;
        }
        return (E)this.identityEntityMap.computeIfAbsent(entity, e -> entity);
    }

    protected Set<Long> windowIndicesToWindows(Set<Long> original, long windowMs) {
        TreeSet<Long> result = new TreeSet<Long>(Collections.reverseOrder());
        original.forEach(idx -> result.add(idx * windowMs));
        return result;
    }

    protected Map<Long, Float> windowIndicesToWindows(Map<Long, Float> original, long windowMs) {
        TreeMap<Long, Float> result = new TreeMap<Long, Float>(Collections.reverseOrder());
        original.forEach((key, value) -> result.put(key * windowMs, (Float)value));
        return result;
    }

    protected static enum SampleType {
        BROKER,
        PARTITION,
        REPLICA;

    }
}

