/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.cruisecontrol.monitor.sampling.aggregator;

import com.linkedin.cruisecontrol.common.WindowIndexedArrays;
import com.linkedin.cruisecontrol.metricdef.MetricDef;
import com.linkedin.cruisecontrol.metricdef.MetricInfo;
import com.linkedin.cruisecontrol.monitor.sampling.MetricSample;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.AggregatedMetricValues;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.Extrapolation;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.MetricValues;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.ValuesAndExtrapolations;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawMetricValues
extends WindowIndexedArrays {
    private static final Logger LOG = LoggerFactory.getLogger(RawMetricValues.class);
    private final byte minSamplesPerWindow;
    private final byte halfMinRequiredSamples;
    private final Map<Short, float[]> windowValuesByMetricId;
    private final byte[] counts;
    private final BitSet extrapolations;
    private final BitSet validity;

    @Override
    protected int length() {
        return this.counts.length;
    }

    public RawMetricValues(int numWindowsToKeep, byte minSamplesPerWindow, int numMetricTypesInSample) {
        this(numWindowsToKeep, minSamplesPerWindow, new byte[numWindowsToKeep], new HashMap<Short, float[]>(numMetricTypesInSample), (byte)Math.max(1, minSamplesPerWindow / 2));
    }

    RawMetricValues(int numWindowsToKeep, byte minSamplesPerWindow, byte[] counts, Map<Short, float[]> windowValuesByMetricId, byte halfMinRequiredSamples) {
        if (numWindowsToKeep <= 1) {
            throw new IllegalArgumentException("The number of windows should be at least 2 because at least one available window and one current window are needed.");
        }
        this.extrapolations = new BitSet(numWindowsToKeep);
        this.validity = new BitSet(numWindowsToKeep);
        this.oldestWindowIndex = Long.MAX_VALUE;
        this.counts = counts;
        this.minSamplesPerWindow = minSamplesPerWindow;
        this.windowValuesByMetricId = windowValuesByMetricId;
        this.halfMinRequiredSamples = halfMinRequiredSamples;
    }

    private void maybeUpdateValidityAndExtrapolationOfPrevAndNextFor(int arrayIndex) {
        if (this.counts[arrayIndex] >= this.minSamplesPerWindow) {
            int nextArrayIndex;
            int prevArrayIndex;
            if (arrayIndex != this.arrayIndex(this.currentWindowIndex()) && this.hasTwoLeftNeighbours(arrayIndex) && this.counts[prevArrayIndex = this.prevArrayIndex(arrayIndex)] == 0) {
                this.updateAvgAdjacent(prevArrayIndex);
            }
            if (this.hasTwoRightNeighbours(arrayIndex) && this.counts[nextArrayIndex = this.nextArrayIndex(arrayIndex)] == 0) {
                this.updateAvgAdjacent(nextArrayIndex);
            }
        }
    }

    private int updateWindowValueAndCount(MetricSample<?> sample, long windowIndex, MetricDef metricDef) {
        int arrayIndex = this.arrayIndex(windowIndex);
        for (Map.Entry<Short, Double> entry : sample.allMetricValues().entrySet()) {
            this.windowValuesByMetricId.computeIfAbsent(entry.getKey(), k -> new float[this.counts.length]);
            this.updateWindowValueForMetric(entry.getValue(), metricDef.metricInfo(entry.getKey()), arrayIndex);
        }
        int n = arrayIndex;
        this.counts[n] = (byte)(this.counts[n] + 1);
        return arrayIndex;
    }

    public synchronized void addSample(MetricSample<?> sample, long windowIndex, MetricDef metricDef) {
        if (windowIndex < this.oldestWindowIndex) {
            return;
        }
        if (windowIndex > this.currentWindowIndex()) {
            throw new IllegalArgumentException("Cannot add sample to window index " + windowIndex + ", which is larger than the current window index " + this.currentWindowIndex());
        }
        int arrayIndex = this.updateWindowValueAndCount(sample, windowIndex, metricDef);
        this.maybeUpdateValidityAndExtrapolationFor(arrayIndex);
        this.maybeUpdateValidityAndExtrapolationOfPrevAndNextFor(arrayIndex);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Added metric sample {} to window index {}, array index is {}, current count : {}", new Object[]{sample, windowIndex, arrayIndex, this.counts[arrayIndex]});
        }
    }

    @Override
    public synchronized void updateOldestWindowIndex(long newOldestWindowIndex) {
        long prevLastWindowIndex = this.lastWindowIndex();
        this.oldestWindowIndex = newOldestWindowIndex;
        if (prevLastWindowIndex >= this.oldestWindowIndex) {
            this.maybeUpdateValidityAndExtrapolationFor(this.arrayIndex(prevLastWindowIndex));
        }
    }

    public synchronized boolean isValid(int maxAllowedWindowsWithExtrapolation) {
        int currentArrayIndex = this.arrayIndex(this.currentWindowIndex());
        int numValidIndicesAdjustment = this.validity.get(currentArrayIndex) ? 1 : 0;
        boolean allIndicesValid = this.validity.cardinality() - numValidIndicesAdjustment == this.counts.length - 1;
        return allIndicesValid && this.numWindowsWithExtrapolation() <= maxAllowedWindowsWithExtrapolation;
    }

    public synchronized int numWindowsWithExtrapolation() {
        int currentArrayIndex = this.arrayIndex(this.currentWindowIndex());
        int numExtrapolationAdjustment = this.extrapolations.get(currentArrayIndex) ? 1 : 0;
        return this.extrapolations.cardinality() - numExtrapolationAdjustment;
    }

    public synchronized boolean isValidAtWindowIndex(long windowIndex) {
        return this.validity.get(this.arrayIndex(windowIndex));
    }

    public synchronized boolean isExtrapolatedAtWindowIndex(long windowIndex) {
        return this.extrapolations.get(this.arrayIndex(windowIndex));
    }

    public synchronized byte sampleCountsAtWindowIndex(long windowIndex) {
        return this.counts[this.arrayIndex(windowIndex)];
    }

    public synchronized void sanityCheckWindowIndex(long windowIndex) {
        this.validateWindowIndex(windowIndex);
    }

    public synchronized void sanityCheckWindowRangeReset(long startingWindowIndex, int numWindowIndicesToReset) {
        if (this.inValidWindowRange(startingWindowIndex) || this.inValidWindowRange(startingWindowIndex + (long)numWindowIndicesToReset - 1L)) {
            throw new IllegalStateException("Should never reset a window index that is in the valid range");
        }
    }

    public synchronized int resetWindowIndices(long startingWindowIndex, int numWindowIndicesToReset) {
        int numAbandonedSamples = 0;
        for (long i = startingWindowIndex; i < startingWindowIndex + (long)numWindowIndicesToReset; ++i) {
            int arrayIndex = this.arrayIndex(i);
            numAbandonedSamples += this.counts[arrayIndex];
            this.counts[arrayIndex] = 0;
            this.resetValidityAndExtrapolation(arrayIndex);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Resetting window index [{}, {}], abandon {} samples.", new Object[]{startingWindowIndex, startingWindowIndex + (long)numWindowIndicesToReset - 1L, numAbandonedSamples});
        }
        return numAbandonedSamples;
    }

    public synchronized ValuesAndExtrapolations aggregate(SortedSet<Long> windowIndices, MetricDef metricDef) {
        return this.aggregate(windowIndices, metricDef, true);
    }

    public synchronized ValuesAndExtrapolations peekCurrentWindow(long currentWindowIndex, MetricDef metricDef) {
        TreeSet<Long> window = new TreeSet<Long>();
        window.add(currentWindowIndex);
        return this.aggregate(window, metricDef, false);
    }

    private ValuesAndExtrapolations aggregate(SortedSet<Long> windowIndices, MetricDef metricDef, boolean checkWindow) {
        if (this.windowValuesByMetricId.isEmpty()) {
            return ValuesAndExtrapolations.empty(windowIndices.size(), metricDef);
        }
        HashMap<Short, MetricValues> aggValues = new HashMap<Short, MetricValues>(this.windowValuesByMetricId.size());
        TreeMap<Integer, Extrapolation> extrapolations = new TreeMap<Integer, Extrapolation>();
        for (Map.Entry<Short, float[]> entry : this.windowValuesByMetricId.entrySet()) {
            short metricId = entry.getKey();
            float[] values = entry.getValue();
            MetricInfo info = metricDef.metricInfo(metricId);
            MetricValues aggValuesForMetric = new MetricValues(windowIndices.size());
            aggValues.put(metricId, aggValuesForMetric);
            int resultWindowIndex = 0;
            Iterator iterator = windowIndices.iterator();
            while (iterator.hasNext()) {
                long windowIndex = (Long)iterator.next();
                if (checkWindow) {
                    this.validateWindowIndex(windowIndex);
                }
                int arrayIndex = this.arrayIndex(windowIndex);
                MetricAggregationResult result = this.aggregateMetric(metricId, arrayIndex, info, values);
                aggValuesForMetric.set(resultWindowIndex, result.value);
                if (result.extrapolationOptional.isPresent()) {
                    extrapolations.putIfAbsent(resultWindowIndex, result.extrapolationOptional.get());
                }
                ++resultWindowIndex;
            }
        }
        return new ValuesAndExtrapolations(new AggregatedMetricValues(aggValues), extrapolations);
    }

    MetricAggregationResult aggregateMetric(short metricId, int arrayIndex, MetricInfo info, float[] values) {
        if (this.counts[arrayIndex] >= this.halfMinRequiredSamples) {
            Optional<Extrapolation> extrapolationOptional = Optional.empty();
            float value = this.getValue(info, arrayIndex, values);
            if (this.counts[arrayIndex] < this.minSamplesPerWindow) {
                extrapolationOptional = Optional.of(Extrapolation.AVG_AVAILABLE);
            }
            return new MetricAggregationResult(value, extrapolationOptional);
        }
        if (arrayIndex != this.firstArrayIndex() && arrayIndex != this.lastArrayIndex() && this.counts[this.prevArrayIndex(arrayIndex)] >= this.minSamplesPerWindow && this.counts[this.nextArrayIndex(arrayIndex)] >= this.minSamplesPerWindow) {
            double value;
            Optional<Extrapolation> extrapolationOptional = Optional.of(Extrapolation.AVG_ADJACENT);
            int prevArrayIndex = this.prevArrayIndex(arrayIndex);
            int nextArrayIndex = this.nextArrayIndex(arrayIndex);
            float previousValue = this.windowValuesByMetricId.get(metricId)[prevArrayIndex];
            float currentValue = this.counts[arrayIndex] == 0 ? 0.0f : this.windowValuesByMetricId.get(metricId)[arrayIndex];
            float nextValue = this.windowValuesByMetricId.get(metricId)[nextArrayIndex];
            double total = previousValue + currentValue + nextValue;
            switch (info.aggregationFunction()) {
                case AVG: {
                    value = total / (double)(this.counts[prevArrayIndex] + this.counts[arrayIndex] + this.counts[nextArrayIndex]);
                    break;
                }
                case LATEST: {
                    value = total / (double)(this.counts[arrayIndex] > 0 ? 3 : 2);
                    break;
                }
                default: {
                    throw new IllegalStateException("Should never be here.");
                }
            }
            return new MetricAggregationResult(value, extrapolationOptional);
        }
        if (this.counts[arrayIndex] > 0) {
            return new MetricAggregationResult(this.getValue(info, arrayIndex, values), Optional.of(Extrapolation.FORCED_INSUFFICIENT));
        }
        return new MetricAggregationResult(0.0, Optional.of(Extrapolation.NO_VALID_EXTRAPOLATION));
    }

    public synchronized int numSamples() {
        int count = 0;
        for (byte i : this.counts) {
            count += i;
        }
        return count;
    }

    private float getValue(MetricInfo info, int index, float[] values) {
        if (this.counts[index] == 0) {
            return 0.0f;
        }
        switch (info.aggregationFunction()) {
            case AVG: {
                return values[index] / (float)this.counts[index];
            }
            case LATEST: {
                return values[index];
            }
        }
        throw new IllegalStateException("Should never be here.");
    }

    private void updateWindowValueForMetric(double newValue, MetricInfo info, int arrayIndex) {
        switch (info.aggregationFunction()) {
            case AVG: {
                this.add(newValue, info.id(), arrayIndex);
                break;
            }
            case LATEST: {
                this.latest(newValue, info.id(), arrayIndex);
                break;
            }
            default: {
                throw new IllegalStateException("Should never be here");
            }
        }
    }

    private void add(double newValue, short metricId, int index) {
        this.windowValuesByMetricId.get((Object)Short.valueOf((short)metricId))[index] = (float)(this.counts[index] == 0 ? newValue : (double)this.windowValuesByMetricId.get(metricId)[index] + newValue);
    }

    private void latest(double newValue, short metricId, int index) {
        this.windowValuesByMetricId.get((Object)Short.valueOf((short)metricId))[index] = (float)newValue;
    }

    private void maybeUpdateValidityAndExtrapolationFor(int arrayIndex) {
        if (!(this.updateEnoughSamples(arrayIndex) || this.extrapolations.get(arrayIndex) || this.updateForcedInsufficient(arrayIndex) || this.updateAvgAdjacent(arrayIndex))) {
            this.resetValidityAndExtrapolation(arrayIndex);
        }
    }

    private void resetValidityAndExtrapolation(int arrayIndex) {
        this.validity.clear(arrayIndex);
        this.extrapolations.clear(arrayIndex);
    }

    private boolean updateEnoughSamples(int arrayIndex) {
        if (this.counts[arrayIndex] == this.minSamplesPerWindow) {
            this.validity.set(arrayIndex);
            this.extrapolations.clear(arrayIndex);
            return true;
        }
        return this.counts[arrayIndex] >= this.minSamplesPerWindow;
    }

    private boolean updateAvgAdjacent(int arrayIndex) {
        int prevArrayIndex = this.prevArrayIndex(arrayIndex);
        int nextArrayIndex = this.nextArrayIndex(arrayIndex);
        if (prevArrayIndex == -1 || nextArrayIndex == -1) {
            return false;
        }
        if (this.counts[prevArrayIndex] >= this.minSamplesPerWindow && this.counts[nextArrayIndex] >= this.minSamplesPerWindow) {
            this.validity.set(arrayIndex);
            this.extrapolations.set(arrayIndex);
            return true;
        }
        return false;
    }

    private boolean updateForcedInsufficient(int arrayIndex) {
        if (this.counts[arrayIndex] > 0) {
            this.validity.set(arrayIndex);
            this.extrapolations.set(arrayIndex);
            return true;
        }
        return false;
    }

    private boolean hasTwoLeftNeighbours(int arrayIndex) {
        int prevIdx = this.prevArrayIndex(arrayIndex);
        return prevIdx != -1 && this.prevArrayIndex(prevIdx) != -1;
    }

    private boolean hasTwoRightNeighbours(int arrayIndex) {
        int nextIdx = this.nextArrayIndex(arrayIndex);
        return nextIdx != -1 && this.nextArrayIndex(nextIdx) != -1;
    }

    private static class MetricAggregationResult {
        public final double value;
        public final Optional<Extrapolation> extrapolationOptional;

        public MetricAggregationResult(double value, Optional<Extrapolation> extrapolationOptional) {
            this.value = value;
            this.extrapolationOptional = extrapolationOptional;
        }

        public String toString() {
            return "MetricAggregationResult{value=" + this.value + ", extrapolationOptional=" + this.extrapolationOptional + "}";
        }
    }
}

