/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol;

import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlContext;
import com.linkedin.kafka.cruisecontrol.analyzer.GoalOptimizationHistoryOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizationOptions;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizerResult;
import com.linkedin.kafka.cruisecontrol.config.GoalsConfig;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.exception.KafkaCruiseControlException;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import io.confluent.cruisecontrol.analyzer.history.GoalOptimizationHistoryListener;
import io.confluent.cruisecontrol.analyzer.history.SuspendedTopicPartition;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProposalGenerator
implements GoalOptimizationHistoryListener<SuspendedTopicPartition> {
    private static final Logger LOG = LoggerFactory.getLogger(ProposalGenerator.class);
    private final long topicPartitionMovementsExpirationMs;
    @GuardedBy(value="this")
    private final Map<Long, Map<TopicPartition, Long>> suspendedTopicPartition;
    @GuardedBy(value="this")
    private long epoch;

    public ProposalGenerator(KafkaCruiseControlConfig config) {
        this.topicPartitionMovementsExpirationMs = config.getLong("topic.partition.movement.expiration.ms");
        this.suspendedTopicPartition = new HashMap<Long, Map<TopicPartition, Long>>();
        this.epoch = 0L;
    }

    @Override
    public synchronized void onNewHistory(SuspendedTopicPartition newSuspension) {
        long newDeadlineMs;
        TopicPartition tp = newSuspension.topicPartition();
        long tpEpoch = newSuspension.epoch();
        if (this.epoch > tpEpoch) {
            return;
        }
        Map<TopicPartition, Long> suspendedTopicPartitionForCurrentEpoch = this.suspendedTopicPartition(tpEpoch);
        long currentDeadlineMs = suspendedTopicPartitionForCurrentEpoch.getOrDefault(tp, Long.MIN_VALUE);
        if (currentDeadlineMs < (newDeadlineMs = newSuspension.deadlineMs())) {
            suspendedTopicPartitionForCurrentEpoch.put(tp, newDeadlineMs);
        }
    }

    @Override
    public synchronized void onExpiredHistory(SuspendedTopicPartition expiredSuspension) {
        long expiredSuspensionDeadlineMs;
        TopicPartition tp = expiredSuspension.topicPartition();
        long tpEpoch = expiredSuspension.epoch();
        if (this.epoch > tpEpoch) {
            return;
        }
        Map<TopicPartition, Long> suspendedTopicPartitionForCurrentEpoch = this.suspendedTopicPartition(tpEpoch);
        long currentSuspensionDeadlineMs = suspendedTopicPartitionForCurrentEpoch.getOrDefault(tp, Long.MIN_VALUE);
        if (currentSuspensionDeadlineMs <= (expiredSuspensionDeadlineMs = expiredSuspension.deadlineMs())) {
            suspendedTopicPartitionForCurrentEpoch.remove(tp);
        }
    }

    @Override
    public synchronized void onUpdatedEpoch(long newEpoch) {
        if (this.epoch >= newEpoch) {
            return;
        }
        long oldEpoch = this.epoch;
        this.epoch = newEpoch;
        this.suspendedTopicPartition.remove(oldEpoch);
        LOG.info("Cleaned suspended topic partitions for self-healing since history epoch is updated from {} to {}", (Object)oldEpoch, (Object)newEpoch);
    }

    private Map<TopicPartition, Long> suspendedTopicPartition(long epoch) {
        return this.suspendedTopicPartition.computeIfAbsent(epoch, e -> new HashMap());
    }

    public static Set<Integer> recentlyRemovedBrokers(KafkaCruiseControlContext context) {
        return context.executor().recentlyRemovedBrokers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OptimizerResult getProposals(ClusterModel clusterModel, GoalsConfig goalsConfig, boolean excludeRecentlyRemovedBrokers, boolean isTriggeredByGoalViolation, KafkaCruiseControlContext context) throws KafkaCruiseControlException {
        OptimizationOptions.Builder builder = new OptimizationOptions.Builder();
        if (excludeRecentlyRemovedBrokers) {
            builder = builder.excludedBrokersForReplicaMove(ProposalGenerator.recentlyRemovedBrokers(context));
        }
        Pattern excludedTopicsPattern = context.excludedTopicsPattern();
        Set<String> excludedTopics = clusterModel.topics().stream().filter(topic -> excludedTopicsPattern.matcher((CharSequence)topic).matches()).collect(Collectors.toSet());
        builder = builder.triggeredByGoalViolation(isTriggeredByGoalViolation).excludedTopics(excludedTopics);
        LOG.debug("Topics excluded from partition movement: {}", excludedTopics);
        if (isTriggeredByGoalViolation) {
            HashSet<TopicPartition> suspendedTopicPartition;
            long epoch;
            ProposalGenerator proposalGenerator = this;
            synchronized (proposalGenerator) {
                epoch = this.epoch;
                suspendedTopicPartition = new HashSet<TopicPartition>(this.suspendedTopicPartition(epoch).keySet());
            }
            builder.goalOptimizationHistoryOptions(GoalOptimizationHistoryOptions.of(epoch, this.topicPartitionMovementsExpirationMs, suspendedTopicPartition));
            LOG.debug("TopicPartition(s) suspended for movement: {}", suspendedTopicPartition);
        }
        return context.goalOptimizer().optimizations(clusterModel, goalsConfig, builder.build());
    }

    synchronized Optional<Map<TopicPartition, Long>> maybeGetSuspendedTopicPartitionForSelfHealing(long epoch) {
        Map<TopicPartition, Long> suspendedTopicPartitions = this.suspendedTopicPartition.get(epoch);
        return suspendedTopicPartitions == null || suspendedTopicPartitions.isEmpty() ? Optional.empty() : Optional.of(new HashMap<TopicPartition, Long>(suspendedTopicPartitions));
    }
}

